<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Order;
use App\User;

class ViewsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware(['auth', '2fa', 'verify.ip']);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('back.dashboard');
    }

    public function email()
    {
        $user = Auth::user();
        return view('auth.verify.email')->with([
            'email' => $user->email,
        ]);
    }

    public function users()
    {

        return view('back.users');

    }

    public function kycUsers()
    {

        return view('back.kycUser');

    }

    public function balance()
    {

        return view('back.balance');

    }

    public function transactions()
    {

        return view('back.transactions');

    }

    //Return Currencies View
    public function currencies()
    {

        return view('back.currencies');

    }
    //Return Newsletter View
    public function newsletter()
    {

        return view('back.newsletter');

    }

    //Return Account View
    public function account()
    {

        return view('back.account');

    }

    //Return Account View
    public function setaccount()
    {

        return view('back.setaccount');

    }

    //Return orders View
    public function orders()
    {

        return view('back.orders');

    }

    public function markets()
    {
        return view('back.market');
    }

    //Return Profile View
    public function profile()
    {
        //Select Authenticated User
        $user = Auth::User();
        $level = $user->level;
        $level = $level ? $level->code : '';

        $data = $user->data;
        $verified = $data->secret_status ? $data->secret_status : $data->verify_via_email;

        $devices = $user->session;

        return view('back.profile', ['level' => $level, 'verified' => $verified, 'devices' => $devices]);
    }

    public function fastway()
    {

        return view('back.fastway');

    }

    public function fastex()
    {
        return response()->json(['view' => view('back.fastEx')->render()], 202);
    }
    public function coincard()
    {
        return response()->json(['view' => view('back.card')->render()], 202);
    }

    public function activity()
    {
        return response()->json(['view' => view('back.activity')->render()], 202);
    }
}
