<?php

namespace App\Http\Controllers\First;

use App\Config;
use App\Currency;
use App\Document;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Mail\VerifyEmail;
use App\Language;
use App\Profile;
use App\Role;
use App\Setting;
use App\Theme;
use App\User;
use App\UserData;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validate;

class OptionsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private function get_client_ip_server()
    {
        $ipaddress = '';

        if ($_SERVER['REMOTE_ADDR']) {

            $ipaddress = $_SERVER['REMOTE_ADDR'];

        } else {

            $ipaddress = 'UNKNOWN';

        }
        return $ipaddress;
    }

    private function RandomString($num)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randstring = '';
        $chlength = strlen($characters);

        for ($i = 0; $i < $num; $i++) {
            $randstring .= $characters[rand(0, $chlength - 1)];
        }

        return $randstring;
    }

    public function currencies()
    {
        $currencies = Currency::Where('type', 'FIAT')->get();

        return response()->json(['result' => $currencies], 202);
    }

    public function language()
    {

        $language = Language::All();

        return response()->json(['result' => $language], 202);
    }

    public function theme()
    {

        $theme = Theme::All();

        return response()->json(['result' => $theme], 202);
    }

    public function chlanguage(Request $request)
    {

        $id = $request->language;

        $languages = Language::all();

        foreach ($languages as $lang) {
            $lang->selected = false;
            $lang->save();
        }

        $language = Language::find($id);
        $language->selected = true;
        $language->save();

        return response()->json(['result' => 'success'], 202);
    }

    public function chtheme(Request $request)
    {

        $id = $request->theme;

        $languages = Theme::all();

        foreach ($languages as $lang) {
            $lang->selected = false;
            $lang->save();
        }

        $language = Theme::find($id);
        $language->selected = true;
        $language->save();

        return response()->json(['result' => 'success'], 202);
    }

    public function createAdmin(Request $request)
    {
        $request->validate([
            'fname' => 'required|string|max:255',
            'sname' => 'string|max:255',
            'flastname' => 'required|string|max:255',
            'slastname' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6',
        ]);

        $string = $this->RandomString(10);
        $hash = Hash::make($string);
        $ip = $this->get_client_ip_server();
        $time = Carbon::now();

        $theme = Theme::Selected();
        $language = Language::Selected();
        $role = Role::where('slug', 'Administrator')->first();

        $user = new User;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->save();

        $profile = new Profile;
        $profile->fname = $request->fname;
        if (!($request->sname == '')) {
            $profile->sname = $request->sname;
        }
        
        $profile->flastname = $request->flastname;

        if (!($request->slastname == '')) {
            
            $profile->slastname = $request->slastname;

        }
        
        $profile->user()->associate($user);
        $profile->save();

        $data = new UserData;
        $data->user()->associate($user);
        $data->save();

        $document = new Document;
        $document->user()->associate($user);
        $document->save();

        $option = new Config;
        $option->user()->associate($user);
        $option->theme()->associate($theme);
        $option->language()->associate($language);
        $option->withdraw_max_limit = 1;
        $option->daily_withdraw = 0;
        $option->save();

        $string = $this->RandomString(10);

        do {
            $hash = Hash::make($string);
            $verifyHash = strpos($hash, '/');
        } while ($verifyHash == true);

        do {
            $id_token = $this->RandomString(23);
            $consult = User::Where('id_token', $id_token)->exists();
            if ($consult) {
                $exists = true;
            } else {
                $user->id_token = $id_token;
                $exists = false;
            }

        } while ($exists == true);

        $ip = $this->get_client_ip_server();
        $time = Carbon::now();

        $user->verification_token = $hash;
        $user->verification_expire = $time;
        $user->roles()->attach($role);
        $user->save();

        $link = url('/email/' . $user->email . '/' . $hash);

        $data = ['ip' => $ip, 'link' => $link, 'time' => $time];

        Mail::to($user->email)->send(new VerifyEmail($data));

        return response()->json(['result' => 'success'], 202);
    }

    public function finalStep(Request $request)
    {
        $request->validate([
            'logo' => 'required',
            'favicon' => 'required',
            'cname' => 'required|string|max:255',
            'currency' => 'required|string|max:255',
            'maxW' => 'required|string|max:255',
            'feectc' => 'required|string|max:255',
            'feectf' => 'required|string|max:255',
            'feeftc' => 'required|string|max:255',
        ]);

        $theme = Theme::Selected();
        $language = Language::Selected();

        $setting = new Setting;
        $setting->app_name = $request->cname;
        $setting->ico = $request->favicon;
        $setting->logo = $request->logo;
        $setting->withdraw_max_limit = $request->maxW;
        $setting->fee_crypto_crypto = $request->feectc;
        $setting->fee_crypto_fiat = $request->feectf;
        $setting->fee_fiat_crypto = $request->feeftc;
        $setting->currency()->associate($request->currency);
        $setting->theme()->associate($theme);
        $setting->language()->associate($language);
        $setting->save();

        return response()->json(['result' => 'success'], 202);
    }

}
