<?php

namespace App\Http\Controllers;

use App\Config;
use App\Http\Controllers\Mail\VerifyEmail;
use App\Language;
use App\Profile;
use App\Role;
use App\Setting;
use App\Theme;
use App\User;
use App\UserData;
use App\Document;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validate;

class RegisterController extends Controller
{
    //
    private function get_client_ip_server()
    {
        $ipaddress = '';

        if ($_SERVER['REMOTE_ADDR']) {

            $ipaddress = $_SERVER['REMOTE_ADDR'];

        } else {

            $ipaddress = 'UNKNOWN';

        }
        return $ipaddress;
    }

    private function RandomString($num)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randstring = '';
        $chlength = strlen($characters);

        for ($i = 0; $i < $num; $i++) {
            $randstring .= $characters[rand(0, $chlength - 1)];
        }

        return $randstring;
    }

    public function terms()
    {
        return view('auth.terms');
    }

    public function contract()
    {
        $user = User::join('role_user', 'role_user.user_id', 'users.id')
            ->where('role_id', 4)
            ->groupBy('users.id')
            ->first();
        $corp = Setting::with('currency')->first();

        return view('auth.contract', ['user' => $user, 'company' => $corp]);
    }

    public function acceptContract(Request $request)
    {
        $data = UserData::where('user_id', Auth::user()->id)->first();
        $data->accept_contract = $request->accept;
        $data->save();
        return response()->json(['status' => 'success'], 200);
    }

    public function downloadContract(Request $request)
    {

        return view('auth.downloadcontract');
    }

    public function register(Request $request)
    {
        $request->validate([
            'fname' => 'required|string|max:255',
            'sname' => 'max:255',
            'flastname' => 'required|string|max:255',
            'slastname' => 'max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6',
            'g-recaptcha-response' => 'required|captcha',
        ]);

        $string = $this->RandomString(10);
        $hash = Hash::make($string);
        $ip = $this->get_client_ip_server();
        $time = Carbon::now();

        $theme = Theme::Selected();
        $language = Language::Selected();

        $user = new User;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->save();

        $profile = new Profile;
        $profile->fname = $request->fname;
        if (!($request->sname == '')) {
            $profile->sname = $request->sname;
        }
        $profile->flastname = $request->flastname;
        $profile->slastname = $request->slastname;
        $profile->user()->associate($user);
        $profile->save();

        $data = new UserData;
        $data->user()->associate($user);
        $data->save();

        $document = new Document;
        $document->user()->associate($user);
        $document->save();

        $option = new Config;
        $option->user()->associate($user);
        $option->theme()->associate($theme);
        $option->language()->associate($language);
        $option->withdraw_max_limit = 1;
        $option->daily_withdraw = 0;
        $option->save();

        $string = $this->RandomString(10);

        do {
            $hash = Hash::make($string);
            $verifyHash = strpos($hash, '/');
        } while ($verifyHash == true);

        do{
            $id_token = $this->RandomString(23);
            $consult = User::Where('id_token', $id_token)->exists();
            if($consult){
                $exists = true;
            }else{
                $user->id_token = $id_token;
                $exists = false;
            }

        } while($exists == true);


        $ip = $this->get_client_ip_server();
        $time = Carbon::now();

        $user->verification_token = $hash;
        $user->verification_expire = $time;
        $role = Role::where('code', 10)->first()->id;
        $user->roles()->attach($role);
        $user->save();

        $link = url('/email/' . $user->email . '/' . $hash);

        $data = ['ip' => $ip, 'link' => $link, 'time' => $time];

        Mail::to($user->email)->send(new VerifyEmail($data));


        return view('auth.verify.email')->with([
            'email' => $user->email,
        ]);
    }

    public function sendmail(Request $request)
    {

        $user = Auth::user();
        $string = $this->RandomString(10);
        do {
            $hash = Hash::make($string);
            $verifyHash = strpos($hash, '/');
        } while ($verifyHash == true);

        $ip = $this->get_client_ip_server();
        $time = Carbon::now();

        $user->verification_token = $hash;
        $user->verification_expire = $time;
        $user->save();

        $link = url('/email/' . $user->email . '/' . $hash);

        $data = ['ip' => $ip, 'link' => $link, 'time' => $time];

        Mail::to($user->email)->send(new VerifyEmail($data));

        return response()->json(['message' => 'success'], 202);
    }

    public function usermail()
    {

        $user = Auth::user();

        $email = $user->email;

        //Return Response in Json dataType
        return response()->json(['email' => $email], 202);
    }

}
