<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class BlockVerify
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next, $flat = '')
    {
        $user = Auth::user();

        if($flat == 'ip'){
            $ip = $user->session->where('ip_address', $request->ip())->first();
            if($ip){
                if($ip->verified){
                    return redirect()->route('dashboard');
                }
            }
            return $next($request);
        }

        if($flat == '2fa'){
            $fa = $user->data->secret_status;
            $efa = $user->data->verify_via_email;
            if($fa || $efa){
                return redirect()->route('dashboard');
            }
            return $next($request);
        }

        if($user->two_verified){
            return redirect()->route('dashboard');
        }
        return $next($request);
    }
}
