<?php

namespace App\Http\Middleware;

use App\Session;
use Closure;
use Illuminate\Support\Facades\Auth;

class VerifyIP
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user_id = Auth::user()->id;
        $sessions = Session::where('user_id', $user_id)->get();
        $ip = $sessions->where('ip_address', $request->ip())->first();
        if ($ip) {
            if ($ip->verified == 0) {
                return redirect()->route('validate-ip');
            }
        } else {
            return redirect()->route('validate-ip');
        }

        return $next($request);
    }
}
