<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model
{
    //
    use SoftDeletes;

    protected $table = 'orders';

    public function outCurrencyOrder(){
        return $this->belongsTo('App\Currency', 'out_currency');
    }

    public function inCurrencyOrder(){
        return $this->belongsTo('App\Currency', 'in_currency');
    }
    public function user(){
        return $this->belongsTo('App\User');
    }

    public function account(){
        return $this->belongsTo('App\Account');
    }

    public function Operation(){
        return $this->hasMany('App\Operation');
    }
}
