/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 48);
/******/ })
/************************************************************************/
/******/ ({

/***/ 48:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(49);


/***/ }),

/***/ 49:
/***/ (function(module, exports) {

/*Tooltip*/
$(function () {
	$('[data-toggle="tooltip"]').tooltip();
});
/* Finish Tooltip */
/**VARIABLES GLOBALES DEFINIDAS JR**/
var pathname = window.location.pathname;

function pathverify(path){
    if(pathname.toString() == path || (pathname.indexOf(path)>0)){
        return true;
    }else{
        return false;
    }
}


if(pathverify('index.php') || pathverify('server.php')){
    var globalImgUrl = "../img/";
    var globalUrl = ".";
}else if(pathverify('/ts') || pathverify('/public')){
    var globalImgUrl = "./img/";
    var globalUrl = ".";
}else{
    var globalImgUrl = "/img/";
    var globalUrl = "";
}

/* Image Base 64 */
function toDataUrl(img) {
	var canvasCopy = document.createElement('canvas');
	var canvas = document.createElement('canvas');
	var ratio = 1,
	    base64 = void 0;

	if (img.width > 768) {
		ratio = 768 / img.width;
	} else if (img.height > 9999) {
		ratio = 9999 / img.height;
	}

	canvasCopy.width = img.width;
	canvasCopy.height = img.height;
	var copyContext = canvasCopy.getContext('2d');
	copyContext.drawImage(img, 0, 0);

	canvas.width = img.width * ratio;
	canvas.height = img.height * ratio;
	var ctx = canvas.getContext('2d');
	ctx.drawImage(canvasCopy, 0, 0, canvasCopy.width, canvasCopy.height, 0, 0, canvas.width, canvas.height);

	base64 = ctx.canvas.toDataURL(null, 0.5);
	return base64;
}
/* Finish Base 64 */

/* Image Blob */
function toDataBlob(img, filename) {
	var ext = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

	var canvasCopy = document.createElement('canvas');
	var canvas = document.createElement('canvas');
	var ratio = 1,
	    newBlob = void 0;

	if (ext) {
		ext = 'image/' + ext;
		ext = ext.replace("jpg", "jpeg");
	}
	if (img.width > 700) {
		ratio = 700 / img.width;
	} else if (img.height > 1024) {
		ratio = 1024 / img.height;
	}
	// img.width and img.height will give the original dimensions
	canvasCopy.width = img.width;
	canvasCopy.height = img.height;
	var copyContext = canvasCopy.getContext('2d');
	copyContext.drawImage(img, 0, 0);

	canvas.width = img.width * ratio;
	canvas.height = img.height * ratio;
	var ctx = canvas.getContext('2d');
	ctx.drawImage(canvasCopy, 0, 0, canvasCopy.width, canvasCopy.height, 0, 0, canvas.width, canvas.height);

	return new Promise(function (resolve, reject) {
		ctx.canvas.toBlob(function (blob) {
			newBlob = new File([blob], filename, { type: blob.type, lastModified: Date.now() });
			resolve(newBlob);
		}, ext, 0.5);
	});
}
/* Finish image blob */

/* Function scroll */
function finishScroll(div, button) {
	$(div).scroll(function () {
		if ($(div).scrollTop() >= 10000) {
			return $(button).removeAttr('disabled');
		}
	});
}
/* End function scroll */

function activeTooltip() {
	$('[data-toggle="tooltip"]').tooltip();
}

/*Function for global pagination*/

function pagination(pagination_id, result_id) {
	var page = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
	var total = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
	var addPage = arguments[4];


	$(pagination_id).html("");

	page = parseInt(page);

	var total = total;
	var resultPage = $(result_id).val();
	var totalPages = Math.ceil(total / resultPage);

	switch (page) {
		case 1:

			maxPage = page + 4;
			totalPages = maxPage < totalPages ? maxPage : totalPages;

			var pageList = $('<ul class="pagination"></ul>');

			for (i = page; i <= totalPages; i++) {
				pagebutton = $('<li class="page_deposit page-item"><a class="page-link" href="#">' + i + '</a></li>');
				pageList.append(pagebutton);
				addPage(pagebutton);
			}

			$(pagination_id).append(pageList);
			break;
		case totalPages:

			page = page - 2;
			page = page < 1 ? 1 : page;
			totalPages = page + 4 < totalPages ? page + 4 : totalPages;

			var pageList = $('<ul class="pagination"></ul>');

			for (i = page; i <= totalPages; i++) {
				pagebutton = $('<li class="page_deposit page-item"><a class="page-link" href="#">' + i + '</a></li>');
				pageList.append(pagebutton);
				addPage(pagebutton);
			}

			$(pagination_id).append(pageList);

			break;
		default:
			page -= 2;
			page = page < 1 ? 1 : page;
			totalPages = page + 4 < totalPages ? page + 4 : totalPages;

			var pageList = $('<ul class="pagination"></ul>');

			for (i = page; i <= totalPages; i++) {
				pagebutton = $('<li class="page_deposit page-item"><a class="page-link" href="#">' + i + '</a></li>');
				pageList.append(pagebutton);
				addPage(pagebutton);
			}

			$(pagination_id).append(pageList);
			break;
	}
}

/*End function for global pagination*/

/*Begin Profile Functions*/
$(document).ready(function () {

	var pathname = window.location.pathname;

	/* Alter Formulary for verification Process */
	function alterForm(form, change) {
		$(form + ' input, ' + form + ' select, ' + form + ' textarea').each(function (index) {
			input = $(this);
			if (change == true) {
				input.attr('disabled', change);
			} else {
				input.removeAttr('disabled');
			}
		});
	}

	/* Back Button For Rewrite Data Storage */
	function backButton(backBut, form, target) {
		backBut.click(function () {
			alterForm(form, false);
			$('#' + target + 'Conf').remove();
			$('#' + target + 'Back').remove();
			$('#' + target + 'Cont').show();
			$('#' + target + 'Pass').show();
		});
	}

	/* Format Number For Amounts*/
	var formatNumber = {
		separador: ".", // separador para los miles
		sepDecimal: ',', // separador para los decimales
		formatear: function formatear(num) {
			num += '';
			var splitStr = num.split('.');
			var splitLeft = splitStr[0];
			var splitRight = splitStr.length > 1 ? this.sepDecimal + splitStr[1] : '';

			splitRight = splitRight.substring(0, 8);

			var regx = /(\d+)(\d{8})/;
			while (regx.test(splitLeft)) {
				splitLeft = splitLeft.replace(regx, '$1' + this.separador + '$2');
			}
			return this.simbol + splitLeft + splitRight;
		},
		num: function num(_num, simbol) {
			this.simbol = simbol || '';
			return this.formatear(_num);
		}
	};

	var formatNumber2 = {
		separador: ".", // separador para los miles
		sepDecimal: ',', // separador para los decimales
		formatear: function formatear(num) {
			num += '';
			var splitStr = num.split('.');
			var splitLeft = splitStr[0];
			var splitRight = splitStr.length > 1 ? this.sepDecimal + splitStr[1] : '';

			splitRight = splitRight.substring(0, 3);

			var regx = /(\d+)(\d{3})/;
			while (regx.test(splitLeft)) {
				splitLeft = splitLeft.replace(regx, '$1' + this.separador + '$2');
			}
			return this.simbol + splitLeft + splitRight;
		},
		num: function num(_num2, simbol) {
			this.simbol = simbol || '';
			return this.formatear(_num2);
		}

		/* Applicate format number function to an input */
	};function formatInput(input) {
		$(input).change(function () {
			value = $(this).val();
			val = formatNumber.num(value);
			$(this).val(val);
		});
	}

	function cutText(text) {
		text1 = text.substr(0, 30);
		text1 = text1 + '...';
		return text1;
	}

	//chart plugin
	Chart.pluginService.register({
		beforeDraw: function beforeDraw(chart) {
			if (chart.config.options.elements.center) {
				//Get ctx from string
				var ctx = chart.chart.ctx;

				//Get options from the center object in options
				var centerConfig = chart.config.options.elements.center;
				var fontStyle = centerConfig.fontStyle || 'Poppins';
				var txt = centerConfig.text;
				var color = centerConfig.color || '#000';
				var sidePadding = centerConfig.sidePadding || 20;
				var sidePaddingCalculated = sidePadding / 100 * (chart.innerRadius * 2);
				//Start with a base font of 30px
				ctx.font = "30px " + fontStyle;

				//Get the width of the string and also the width of the element minus 10 to give it 5px side padding
				var stringWidth = ctx.measureText(txt).width;
				var elementWidth = chart.innerRadius * 2 - sidePaddingCalculated;

				// Find out how much the font can grow in width.
				var widthRatio = elementWidth / stringWidth;
				var newFontSize = Math.floor(30 * widthRatio);
				var elementHeight = chart.innerRadius * 2;

				// Pick a new font size so it will not be larger than the height of label.
				var fontSizeToUse = Math.min(newFontSize, elementHeight);

				//Set font settings to draw it correctly.
				ctx.textAlign = 'center';
				ctx.textBaseline = 'middle';
				var centerX = (chart.chartArea.left + chart.chartArea.right) / 2;
				var centerY = (chart.chartArea.top + chart.chartArea.bottom) / 2;
				ctx.font = fontSizeToUse + "px " + fontStyle;
				ctx.fillStyle = color;

				//Draw text in center
				ctx.fillText(txt, centerX, centerY);
			}
		}
	});

	//Country list
	function country() {
		var val = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			url: globalUrl+"/country",
			type: 'post',
			success: function success(data) {

				countries = data.result;

				for (i = 0; i < countries.length; i++) {
					country = countries[i];
					if (val == country.id || val == country.name) {
						$("#country").append('<option value="' + country.id + '" selected>' + country.name + '</option>');
					} else {
						$("#country").append('<option value="' + country.id + '">' + country.name + '</option>');
					}
				};
			}
		});
	}

	//Country Select list
	function countryS(select) {
		var val = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			url: globalUrl+"/country",
			type: 'post',
			success: function success(data) {

				countries = data.result;

				for (i = 0; i < countries.length; i++) {

					country = countries[i];
					if (val == country.id || val == country.name) {
						$(select).append('<option value="' + country.id + '" selected>' + country.name + '</option>');
					} else {
						$(select).append('<option value="' + country.id + '">' + country.name + '</option>');
					}
				};
			}
		});
	}

	//Born Country List
	function bornCountry() {
		var val = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;


		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			url: globalUrl+"/country",
			type: 'post',
			success: function success(data) {

				countries = data.result;

				for (i = 0; i < countries.length; i++) {
					country = countries[i];
					if (val == country.id || val == country.name) {
						$('#bornCity').append("<option value='" + country.id + "' selected>" + country.name + "</option>");
					} else {
						$('#bornCity').append("<option value='" + country.id + "'>" + country.name + "</option>");
					}
				};
			}
		});
	}

	//Country Phone Prefix
	function phonePrefix(country) {
		$(country).change(function () {
			countrys = document.getElementById("country").value;

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				data: { country: countrys },
				url: globalUrl+"/phone",
				type: 'post',
				success: function success(data) {

					phone = data.result;

					$(".phoneinput").html('<input type="text" name="phone" id="phone" class="form-control input-medium bfh-phone" data-format="' + phone.phone_prefix + ' (ddd) ddd-dddd" value="' + phone.phone_prefix + '">');
				}
			});
		});
	}

	//States List
	function states(country) {
		var val = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

		$(country).change(function () {
			countrys = document.getElementById("country").value;

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/states",
				data: { country: countrys },
				type: 'post',
				success: function success(data) {
					states = data.result;
					$('#state').html('');
					for (i = 0; i < states.length; i++) {
						state = states[i];
						if (val == state.id || val == state.name) {
							$('#state').append("<option value='" + state.id + "' selected>" + state.name + "</option>");
						} else {
							$('#state').append("<option value='" + state.id + "'>" + state.name + "</option>");
						}
					};
				}
			});
		});
	}

	//States List
	function statesS(select, country) {
		var val = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

		$(country).change(function () {
			countrys = document.getElementById("country").value;

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/states",
				data: { country: countrys },
				type: 'post',
				success: function success(data) {
					states = data.result;
					$(select).html('');
					for (i = 0; i < states.length; i++) {
						state = states[i];
						if (val == state.id || val.toLowerCase() == state.name.toLowerCase()) {
							$(select).append("<option value='" + state.id + "' selected>" + state.name + "</option>");
						} else {
							$(select).append("<option value='" + state.id + "'>" + state.name + "</option>");
						}
					};
				}
			});
		});
	}

	//cities list
	function cities(state) {
		var val = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

		$(state).change(function () {
			states = document.getElementById("state").value;

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/cities",
				data: { state: states },
				type: 'post',
				success: function success(data) {
					$('#city').html('');
					cities = data.result;
					for (i = 0; i < cities.length; i++) {
						city = cities[i];
						if (val == city.id || val == city.name) {
							$('#city').append("<option value='" + city.id + "' selected>" + city.name + "</option>");
						} else {
							$('#city').append("<option value='" + city.id + "'>" + city.name + "</option>");
						}
					};
				}
			});
		});
	}

	// Google2FA Code
	function sendCode(code) {
		$.ajax({
			headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
			url: globalUrl+'/verify-secret',
			type: 'POST',
			dataType: "json",
			data: { one_time_password: code },
			success: function success(data) {
				if (data.google2fa === 1) {
					window.location.replace(globalUrl+'/dashboard');
				}
			},
			error: function error(_error) {
				$(this).removeClass('disabled');
				$(this).prop('disabled', false);
				$('.text-alert').empty();
				$('.text-alert').append('An error has ocurred');
				$('.alert').removeClass('alert-success');
				$('.alert').removeClass('alert-danger');
				$('.alert').addClass('alert-warning');
				$('#fundsAlertMod').modal('show');
			}
		});
	}

	/* Cropt */
	function cropt() {
		$('#image-cropper').cropit({ imageBackground: true });
		// When user clicks select image button,
		// open select file dialog programmatically
		$('.btn-select-image').click(function () {
			$('.cropit-image-input').click();
		});

		// Handle rotation
		$('.rotate-cw-btn').click(function () {
			$('#image-cropper').cropit('rotateCW');
		});
		$('.rotate-ccw-btn').click(function () {
			$('#image-cropper').cropit('rotateCCW');
		});
	}

	/* Function Get Level */
	function level() {
		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			url: globalUrl+'/get-level',
			type: 'get',
			success: function success(data) {
				var level = data.user.kyc_verified;
				var auth = data.user.data.secret_status;
				if (!level) {
					return $("#modalLevelOne").modal('show');
				} else if (level === 1) {
					if (auth) {
						return $("#modalLevelTwo").modal('show');
					}
				} else if (level === 2) {
					return $("#modalLevelThree").modal('show');
				}
				return false;
			}
		});
	}
	/* End function get level */

	/* End Common Functions */

	/*Begin DashBoard Functions*/

	if (pathverify("/email")) {
		var sendMail = function sendMail(email) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				data: { email: email },
				url: globalUrl+"/sendmail",
				type: 'post',
				success: function success(data) {
					$('.alert').toggle();
				}
			});
		};

		$('#resend').click(function () {
			email = $('#email').text();
			sendMail(email);
		});

		//usermail();
	}
	if (pathverify("/login")) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
	}

	if (pathverify("/password")) {
		$("#body").css("background-image", 'url("'+globalImgUrl+'background/generalBackground.png")');
	}

	if (pathverify("/register")) {
		country();
		states('#country');
		phonePrefix('#country');
		cities('#state');
		bornCountry();
	}

	if (pathverify("/dashboard")) {

		//Show Balances and charts
		var _balance = function _balance() {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/dashboard/balance",
				type: 'post',
				success: function success(data) {
					var balances = data.result;
					var usd = data.usd;
					var btc = data.btc;
					var chart = data.chart;
					var colors = ['#F3B204', '#444343', '#929292', '#167CC2', '#DDC200', '#099A47', '#9BDEE3', '#FA8072', '#FFA500', '#FFD700', '#FFFF00', '#FFE4B5', '#FFDAB9', '#EEE8AA', '#E6E6FA', '#D8BFD8', '#DDA0DD', '#9370DB', '#9966CC', '#8B008B', '#6A5ACD', '#7B68EE', '#98FB98', '#66CDAA', '#8FBC8F', '#DB7093', '#008B8B', '#E0FFFF', '#AFEEEE', '#7FFFD4', '#40E0D0', '#FFC0CB', '#B0E0E6', '#ADD8E6', '#F0FFF0', '#F5FFFA', '#F0FFFF', '#FFB6C1', '#C0C0C0'];

					for (i = 0; i < balances.length; i++) {

						var balance = balances[i];
						var amount = chart['amount'][i];
						var symbol = chart['symbol'][i];
						switch (symbol) {
							case 'BTC':
								color = 'background-color: rgb(243, 178, 4);';
								break;

							case 'LTC':
								color = 'background-color: rgb(146, 146, 146);';
								break;

							case 'ETH':
								color = 'background-color: rgb(68, 67, 67);';
								break;

							case 'DASH':
								color = 'background-color: rgb(22, 124, 194);';
								break;

							case 'PTR':
								color = 'background-color: rgb(243, 178, 4);';
								break;
							case 'VES':
								color = 'background-color: rgb(7,80,130);';
								break;

						}
						list = '<div class="col-sm-12" style="padding:0px; margin-bottom: 6px;"><div class="col-sm-12" style="padding:0px;"><div class="col-sm-3 colorChart" style="padding:0px;" id="colorChart' + i + '"><div class="color"></div></div><div class="col-sm-9" style="padding:0px;"><h5 class="list-group-item-heading text-center">' + symbol + '</h5></div></div><div class="col-sm-12 text-center" style="padding:0px;"><p class="small">Amount: ' + formatNumber2.num(amount) + '</p><p class="small">percent: ' + formatNumber2.num(balance.percent) + '%</p></div></div>';
						list2 = $('<div class="row portfolioList"></div>');

						symbol = $('<div class="col-sm-3"><img src="'+globalImgUrl+'icons/minicoin/' + balance.symbol + '.png" height="30px" width="auto"/></div>');
						percents = parseInt(balance.percent);
						progress = $('<div class="col-sm-2 divPro text-center"><div class="progress"><div class="progress-bar progress-bar-striped" id="progress' + i + '" role="progressbar" aria-valuenow="' + percents + '" aria-valuemin="0" aria-valuemax="100" style="width:' + percents + ' ' + color + '%"></div></div></div>');
						percent = $('<div class="col-sm-1">' + percents + '%</div>');
						amount = $('<div class="col-sm-3 text-center"><h5>' + formatNumber2.num(balance.amount) + ' ' + balance.symbol + '</h5></div>');
						va = $('<div class="col-sm-3 text-center"><h5>$ ' + formatNumber2.num(balance.equivalent) + '</h5></div>');

						list2.append(symbol);
						list2.append(progress);
						list2.append(percent);
						list2.append(amount);
						list2.append(va);

						$('.myPortfolio').append(list2);
						$('.list-gr').append(list);
						$('#colorChart' + i).css('background-color', colors[i]);
						$('#progress' + i).css('background-color', colors[i]);
					}

					color = '#9370DB';

					$('#usdAmount').append(formatNumber2.num(usd));

					$('#btcAmount').append(formatNumber.num(btc));

					var arraych = new Array();

					for (a = 0; a < chart['amount'].length; a++) {
						var colunm = { y: chart['amount'][a], label: chart['symbol'][a] };
						arraych.push(colunm);
					}

					var chart = new CanvasJS.Chart("chartContainer", {
						// theme: "light1", // "light1", "light2", "dark1", "dark2"
						animationEnabled: true,
						backgroundColor: "transparent",
						data: [{
							type: "doughnut",
							dataPoints: arraych,
							cutoutPercentage: 0
						}],
						options: {}
						// toolTipContent: "<b>{label}</b>: ${y} - #percent%",
						// showInLegend: "true",
						// legendText: "{label}",
						// indexLabelFontSize: 16,
						// indexLabel: "{label} - #percent%",
					});

					chart.render();
					chart.legend.set("fontColor", "black");
				}
			});
		};

		//Show Newsletter


		var newsletter = function newsletter(button) {
			$(button).click(function () {
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					url: globalUrl+"/dashboard/newsletter",
					type: 'post',
					success: function success(data) {
						newsletters = data.result;
						if (newsletters.length == 0) {

							$('#newsBody').empty();

							cardBox = $('<div class="border-left"></div>');
							card = $('<div class="card"></div>');
							cardBody = $('<div class="card-body"></div>');
							cardTitle = $('<h5 class="card-title">Sin comunicaciones por los momentos</h5>');

							cardBody.append(cardTitle);
							card.append(cardBody);
							cardBox.append(card);

							$('#newsBody').append(cardBox);
						} else {
							$('#newsBody').empty();
							var _iteratorNormalCompletion = true;
							var _didIteratorError = false;
							var _iteratorError = undefined;

							try {
								for (var _iterator = newsletters[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
									var _newsletter = _step.value;


									cardBox = $('<div class="border-left"></div>');
									card = $('<div class="card"></div>');
									cardBody = $('<div class="card-body"></div>');
									cardTitle = $('<h5 class="card-title">' + _newsletter.title + '</h5>');
									cardText = $('<h5 class="card-text">' + _newsletter.message + '</h5>');

									cardFooter = $('<div class="card-footer text-muted">' + _newsletter.created_at + '</div>');

									cardBody.append(cardTitle);
									cardBody.append(cardText);
									card.append(cardBody);
									card.append(cardFooter);
									cardBox.append(card);

									$('#newsBody').append(cardBox);
								}
							} catch (err) {
								_didIteratorError = true;
								_iteratorError = err;
							} finally {
								try {
									if (!_iteratorNormalCompletion && _iterator.return) {
										_iterator.return();
									}
								} finally {
									if (_didIteratorError) {
										throw _iteratorError;
									}
								}
							}
						}
					}
				});
			});
		};

		//view of newsletter


		var viewNews = function viewNews(but, news) {
			but.click(function () {
				title = $('<h4>' + news.title + '</h4>');
				message = $('<p>' + news.message + '</p>');
				textby = $('<p id="created by">Created By ' + news.name + '</p>');
				$('.modal-header').empty();
				$('.modal-body').empty();
				$('.modal-header').append(title);
				$('.modal-body').append(message);
				$('.modal-body').append(textby);
			});
		};

		//Slide Function


		var slide = function slide(prev, next) {
			var slideIndex = 1;

			showSlides(slideIndex);

			// Next/previous controls
			prev.click(function () {
				showSlides(slideIndex += -1);
			});
			next.click(function () {
				showSlides(slideIndex += 1);
			});

			// Thumbnail image controls
			function currentSlide(n) {
				showSlides(slideIndex = n);
			}

			function showSlides(n) {
				var i;
				var slides = document.getElementsByClassName("messageSlides");

				if (n > slides.length) {
					slideIndex = 1;
				}

				if (n < 1) {
					slideIndex = slides.length;
				}

				for (i = 0; i < slides.length; i++) {
					slides[i].style.display = "none";
				}
				slides[slideIndex - 1].style.display = "block";
			}
		};

		//Slide Date Function


		var slideD = function slideD(prev, next) {
			var slideIndex = 1;

			showSlidesD(slideIndex);

			// Next/previous controls
			prev.click(function () {
				showSlidesD(slideIndex += -1);
			});
			next.click(function () {
				showSlidesD(slideIndex += 1);
			});

			// Thumbnail image controls
			function currentSlideD(n) {
				showSlidesD(slideIndex = n);
			}

			function showSlidesD(n) {
				var i;
				var slides = document.getElementsByClassName("dateSlides");

				if (n > slides.length) {
					slideIndex = 1;
				}

				if (n < 1) {
					slideIndex = slides.length;
				}

				for (i = 0; i < slides.length; i++) {
					slides[i].style.display = "none";
				}
				slides[slideIndex - 1].style.display = "block";
			}
		};

		//Slide Text Function


		var slideR = function slideR(prev, next) {
			var slideIndex = 1;

			showSlidesR(slideIndex);

			// Next/previous controls
			prev.click(function () {
				showSlidesR(slideIndex += -1);
			});

			next.click(function () {
				showSlidesR(slideIndex += 1);
			});

			// Thumbnail image controls
			function currentSlideR(n) {
				showSlidesR(slideIndex = n);
			}

			function showSlidesR(n) {
				var i;
				var slides = document.getElementsByClassName("readSlides");

				if (n > slides.length) {
					slideIndex = 1;
				}
				if (n < 1) {
					slideIndex = slides.length;
				}

				for (i = 0; i < slides.length; i++) {
					slides[i].style.display = "none";
				}

				slides[slideIndex - 1].style.display = "block";
			}
		};

		//Line Chart Function


		var lineChart = function lineChart(but, type) {
			$(but).click(function () {
				$('.btn-chart').removeClass('active');
				$(this).addClass('active');

				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					data: { type: type },
					url: globalUrl+"/dashboard/charts",
					type: 'post',
					success: function success(data) {
						chartD = data.result;
						var arraych = new Array();

						for (a = 0; a < chartD.length; a++) {
							chart = chartD[a];
							var colunm = { y: chart.amount, label: chart.register };
							arraych.push(colunm);
						}

						var charts = new CanvasJS.Chart("historicalChart", {
							animationEnabled: true,
							backgroundColor: "transparent",
							axisX: {
								labelFontColor: "black"
							},
							axisY: {
								title: "USD",
								titleFontColor: "#4F81BC",
								labelFontColor: "black",
								suffix: "$"
							},
							data: [{
								name: "views",
								type: "area",
								yValueFormatString: "#,##0.0$",
								dataPoints: arraych
							}]
						});

						charts.render();
						charts.legend.set("fontColor", "black");
					}
				});
			});
		};

		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');

		level();

		Chart.defaults.global.defaultFontColor = 'white';
		Chart.defaults.global.defaultFontFamily = 'florence';

		lineChart('#daily', 'daily');

		lineChart('#weekly', 'weekly');

		lineChart('#monthly', 'monthly');

		$('#daily').trigger('click');

		newsletter('#newsButton');
		_balance();
	}

	/*End DashBoard Functions*/

	/*Start Profile Functions */

	if (pathverify('/profile')) {

		//Get Profile Data
		var profile = function profile() {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/users/profile",
				type: 'post',
				success: function success(data) {

					user = data.user;
					firstname = user.fname;

					secondname = user.sname ? user.sname : '';
					flastname = user.flastname;
					slastname = user.slastname;
					email = user.email;
					address = user.address;

					if (user.profile_image !== null) {
						image = user.profile_image;
						$('#profilePic').attr("src", image);
					}

					$('#name').empty();
					$('#lastname').empty();

					$('#email').empty();
					$('#address').empty();

					$('.username').empty();
					$('#idU').empty();

					$('#name').append(firstname + ' ' + secondname);
					$('#lastname').append(flastname + ' ' + slastname);
					$('#email').append(email);
					$('#idU').val(user.id);
					$('#address').append(address);

					var names = firstname + ' ' + flastname;
					$('.username').append(names);

					if (user.secret_status || user.sms_verify || user.verify_via_email) {
						$('#authenticator1').hide();
						$('#authenticator2').show();
					}
				}
			});
		};

		var addMakeprofileButton = function addMakeprofileButton(makeBut) {
			jQuery.validator.addMethod("password", function (value, element) {
				return this.optional(element) || /^(?=(?:.*\d){1})(?=(?:.*[A-Z]){1})(?=(?:.*[a-z]){1})\S{6,}$/i.test(value);
			}, "Introduzca al menos una letra mayúscula, una letra minusculas y un número, con un mínimo de 6 caracteres");

			$('#UserForm').validate({
				rules: {
					old_password: {
						password: true,
						required: true
					},
					new_password: {
						password: true,
						required: true

					},
					confirm_new_password: {
						password: true,
						required: true,
						equalTo: "#new_password"
					}
				},
				messages: {}

			});
			$(makeBut).click(function (e) {
				if ($('#UserForm').valid()) {
					alterForm('#UserForm', true);
					$('#confirm').modal('show');
					$('.modal-body').html('Estas seguro de modificar la contrasena?');
					confirmEuserButton('#yes');
					$('#no').click(function () {
						alterForm('#UserForm', false);
					});
				}
			});
		};

		/* Confirm Button For Editing User */


		var confirmEuserButton = function confirmEuserButton(confirmBut) {
			$(confirmBut).click(function () {

				$(this).addClass('disabled');
				$(this).prop('disabled', true);

				old_password = $('#old_password').val();
				password = $('#new_password').val();
				confirm = $('#confirm_new_password').val();
				id = $('#idU').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/users/profile/update',
					type: 'POST',
					dataType: "json",
					data: { id: id, old_password: old_password, password: password, password_confirmation: confirm },
					success: function success(data) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('#confirm').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(data.respond);
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#AlertMod').modal('show');
					},
					error: function error(_error3) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append('ha Ocurrido un error');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#profileAlertMod').modal('show');
					}
				});
			});
		};

		var orderTableAccountBy = function orderTableAccountBy(by) {
			if (orderAccountBy === by) {
				if (orderAccountDirection === "") {
					orderAccountDirection = "DESC";
				} else {
					orderAccountDirection = "";
				}
			} else {
				orderAccountBy = by;
				orderAccountDirection = "";
			}
			searchAccount(1);
		};

		var searchAccount = function searchAccount(page) {

			resultPage = $("#result_newsletter_page").val();

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/account",
				type: 'post',
				data: { searchvalue: "", page: page, orderBy: orderAccountBy, orderDirection: orderAccountDirection, resultPage: resultPage },
				success: function success(data) {

					//Inicio
					var accounts = data.result;

					if (accounts.length == 0) {
						$("#table_account_content").html("");
						$('#table_account_content').append('<tr><td colspan="6">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						$("#table_account_content").html("");

						for (i = 0; i < accounts.length; i++) {

							var account = accounts[i];

							var rowResult = $('<tr></tr>');

							var colvalue_1 = $('<td>' + account.type + '</td>');
							var colvalue_2 = $('<td>' + account.coin + '</td>');
							var colvalue_3 = $('<td>' + account.address + '</td>');
							var colvalue_4 = $('<td>' + account.entity + '</td>');
							var colvalue_5 = $('<td>' + account.created_at + '</td>');
							var colvalue_6 = $('<td>' + account.updated_at + '</td>');

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);

							$("#table_account_content").append(rowResult);
						}
						pagination("#table_account_pagination", "#result_account_page", data.page, data.total, addPageACButton);
					}
					// Put the data into the element you care about.
				},
				// Fin
				error: function error(_error4) {
					ReadError(_error4);
				}
			});
		};

		var addPageACButton = function addPageACButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				searchAccount(page);
			});
		};

		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
		level();

		/* Disable 2FA */
		$('#disable2fa').click(function (e) {
			$('#text-content').empty();
			$('#text-content').append('Realmente desea desactivar la autenticación de dos factores?');
			$('#confirm').modal('show');
			$(this).addClass('disabled');
			$(this).prop('disabled', true);
			$('#yes').click(function (e) {
				$('#confirm').modal('hide');
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					url: globalUrl+'/disable-2fa',
					type: 'post',
					success: function success(data) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						window.location.replace(globalUrl+'/profile');
					},
					error: function error(_error2) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append('An error has ocurred');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#profileAlertMod').modal('show');
					}
				});
			});
		});

		$('.listprofile').addClass('active');

		profile();
		addMakeprofileButton('#changePass');

		$('#table_account_header_type').click(function (e) {
			orderTableAccountBy('type');
		});

		$('#table_account_header_address').click(function (e) {
			orderTableAccountBy('address');
		});

		$('#table_account_header_entity').click(function (e) {
			orderTableAccountBy('entity');
		});

		$('#table_account_header_date').click(function (e) {
			orderTableAccountBy('created_at');
		});

		$('#table_account_header_update').click(function (e) {
			orderTableAccountBy('updated_at');
		});

		var orderAccountBy = "";
		var orderAccountDirection = "";
		var searchAccountValue = "";

		searchAccount(1);
	}

	/*End Profile Functions*/

	/*User Functions*/

	if (pathverify('/users')) {
		var orderTableUserBy = function orderTableUserBy(by) {
			if (orderUserBy === by) {
				if (orderUserDirection === "") {
					orderUserDirection = "DESC";
				} else {
					orderUserDirection = "";
				}
			} else {
				orderUserBy = by;
				orderUserDirection = "";
			}
			searchUser(1);
		};

		//Get User Data

		var searchUser = function searchUser(page) {
			resultPage = $("#result_user_page").val();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/users",
				type: 'post',
				data: { searchvalue: searchUserValue, page: page, orderBy: orderUserBy, orderDirection: orderUserDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var users = data.result.data;

					if (users.length == 0) {
						$("#table_user_content").html("");
						$('#table_user_content').append('<tr><td colspan="7" style="text-align:center">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						$("#table_user_content").html("");

						var _iteratorNormalCompletion2 = true;
						var _didIteratorError2 = false;
						var _iteratorError2 = undefined;

						try {
							for (var _iterator2 = users[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
								var _user = _step2.value;


								var rowResult = $('<tr></tr>');

								var colvalue_1 = $('<td>' + _user.profile.fname + ' ' + _user.profile.flastname + '</td>');
								var colvalue_3 = $('<td>' + _user.email + '</td>');

								var colvalue_4 = $('<td></td>');

								var _iteratorNormalCompletion3 = true;
								var _didIteratorError3 = false;
								var _iteratorError3 = undefined;

								try {
									for (var _iterator3 = _user.roles[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
										var _rol = _step3.value;

										colvalue_4.append(_rol.name + '<br/>');
									}
								} catch (err) {
									_didIteratorError3 = true;
									_iteratorError3 = err;
								} finally {
									try {
										if (!_iteratorNormalCompletion3 && _iterator3.return) {
											_iterator3.return();
										}
									} finally {
										if (_didIteratorError3) {
											throw _iteratorError3;
										}
									}
								}

								editBut = $('<button type="button" class="btn btn-alternative btn-sm" data-toggle="modal" data-target="#userMod" id="editBut">' + Lang.get('messages.edit') + '</button>');

								delBut = $('<button type="button" data-toggle="modal" data-target="#userMod" class="btn btn-alternative-danger btn-alternative btn-sm" id="delBut">' + Lang.get('messages.delete') + '</button>');

								infoBut = $('<button type="button" class="btn btn-alternative btn-sm" data-toggle="modal" data-target="#userMod" id="editBut">' + Lang.get('messages.info') + '</button>');

								// we have to make in steps to add the onclick event
								addEditUserClick(editBut, _user, _user.roles);
								addMakeDuserButton(delBut, _user);
								addInfoUserButton(infoBut, _user);

								var colvalue_5 = $('<td>' + _user.created_at + '</td>');
								var colvalue_6 = $('<td>' + _user.updated_at + '</td>');
								var colvalue_7 = $('<td class="text-center" style="display:grid;"></td>');

								colvalue_7.append(editBut);
								colvalue_7.append(delBut);
								colvalue_7.append(infoBut);

								rowResult.append(colvalue_1);
								rowResult.append(colvalue_3);
								rowResult.append(colvalue_4);
								rowResult.append(colvalue_5);
								rowResult.append(colvalue_6);
								rowResult.append(colvalue_7);

								$("#table_user_content").append(rowResult);
							}
						} catch (err) {
							_didIteratorError2 = true;
							_iteratorError2 = err;
						} finally {
							try {
								if (!_iteratorNormalCompletion2 && _iterator2.return) {
									_iterator2.return();
								}
							} finally {
								if (_didIteratorError2) {
									throw _iteratorError2;
								}
							}
						}

						pagination("#table_user_pagination", "#result_user_page", data.result.current_page, data.result.total, addPageUButton);
					}
					// Put the data into the element you care about.
				},
				// Fin
				error: function error(_error5) {
					ReadError(_error5);
				}
			});
		};

		var addInfoUserButton = function addInfoUserButton(button, user) {
			button.click(function () {
				box = $('<div class="row"></div>');

				pInfoBox = $('<div class="col-sm-12"></div>');
				pInfoT = $('<h3>Perfil</h3>');
				pInfo1 = $('<p>Nombres: ' + user.profile.fname + ' ' + user.profile.sname + '</p>');
				pInfo2 = $('<p>Apellidos: ' + user.profile.flastname + ' ' + user.profile.slastname + '</p>');

				if (user.profile.gender) {
					pInfo3 = $('<p>Genero: ' + user.profile.gender + '</p>');
				} else {
					pInfo3 = $('<p>Genero no sumistrado.</p>');
				}

				if (user.profile.city) {
					pInfo4 = $('<p>Dirección: ' + user.profile.city.region.country.name + ', ' + user.profile.city.region.name + ', ' + user.profile.city.name + ', ' + user.profile.address + '</p>');
				} else {
					pInfo4 = $('<p>Dirección no suministrada.</p>');
				}

				if (user.profile.phonenumber) {
					pInfo5 = $('<p>Telefono: ' + user.profile.phonenumber + '</p>');
				} else {
					pInfo5 = $('<p>Telefono no suministrada.</p>');
				}

				if (user.profile.level1_confirmed) {
					pInfo6 = $('<p>KYC: Nivel 1 Confirmado</p>');
				} else if (user.profile.level2_confirmed) {
					pInfo6 = $('<p>KYC: Nivel 2 Confirmado</p>');
				} else if (user.profile.level3_confirmed) {
					pInfo6 = $('<p>KYC: Nivel 3 Confirmado</p>');
				} else {
					pInfo6 = $('<p>KYC: Sin Confirmar</p>');
				}

				pInfoBox.append(pInfoT);
				pInfoBox.append(pInfo1);
				pInfoBox.append(pInfo2);
				pInfoBox.append(pInfo3);
				pInfoBox.append(pInfo4);
				pInfoBox.append(pInfo5);
				pInfoBox.append(pInfo6);

				pBalanceBox = $('<div class="col-sm-12" style="max-height: 150px;overflow-y: auto;"></div>');
				pBalanceTable = $('<table class="table table-hover"></table>');
				pBalanceHeader = $('<thead><tr><th>Moneda</th><th>Monto</th><th>Monto Pendiente</th><th>Equivalente USD</th></tr></thead>');
				pBalanceBody = $('<tbody></tbody>');

				var _iteratorNormalCompletion4 = true;
				var _didIteratorError4 = false;
				var _iteratorError4 = undefined;

				try {
					for (var _iterator4 = user.balances[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
						var _balance2 = _step4.value;


						pBalanceRow = $('<tr></tr>');
						pBalancedata1 = $('<td>' + _balance2.currency.name + '</td>');
						pBalancedata2 = $('<td>' + _balance2.amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
						pBalancedata3 = $('<td>' + _balance2.pending_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
						pBalancedata4 = $('<td>' + (_balance2.currency.price * _balance2.amount).toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');

						pBalanceRow.append(pBalancedata1);
						pBalanceRow.append(pBalancedata2);
						pBalanceRow.append(pBalancedata3);
						pBalanceRow.append(pBalancedata4);

						pBalanceBody.append(pBalanceRow);
					}
				} catch (err) {
					_didIteratorError4 = true;
					_iteratorError4 = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion4 && _iterator4.return) {
							_iterator4.return();
						}
					} finally {
						if (_didIteratorError4) {
							throw _iteratorError4;
						}
					}
				}

				pBalanceTable.append(pBalanceHeader);
				pBalanceTable.append(pBalanceBody);
				pBalanceBox.append(pBalanceTable);

				pDepositBox = $('<div class="col-sm-12" style="max-height: 150px;overflow-y: auto;"></div>');
				pDepositTable = $('<table class="table table-hover"></table>');
				pDepositHeader = $('<thead><tr><th>Moneda</th><th>Monto</th><th>Fecha</th><th>Estado</th></tr></thead>');
				pDepositBody = $('<tbody></tbody>');

				pWithdrawBox = $('<div class="col-sm-12" style="max-height: 150px;overflow-y: auto;"></div>');
				pWithdrawTable = $('<table class="table table-hover"></table>');
				pWithdrawHeader = $('<thead><tr><th>Moneda</th><th>Monto</th><th>Fecha</th><th>Estado</th></tr></thead>');
				pWithdrawBody = $('<tbody></tbody>');

				pOrderBox = $('<div class="col-sm-12" style="max-height: 150px;overflow-y: auto;"></div>');
				pOrderTable = $('<table class="table table-hover"></table>');
				pOrderHeader = $('<thead><tr><th>Moneda Saliente</th><th>Monto Saliente</th><th>Moneda Entrante</th><th>Monto Entrante</th><th>Fecha</th><th></th><th>Estado</th></tr></thead>');
				pOrderBody = $('<tbody></tbody>');

				var _iteratorNormalCompletion5 = true;
				var _didIteratorError5 = false;
				var _iteratorError5 = undefined;

				try {
					for (var _iterator5 = user.orders[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
						var order = _step5.value;

						if (order.type == 'deposit') {
							pDepositRow = $('<tr></tr>');
							pDepositdata1 = $('<td>' + order.in_currency_order.name + '</td>');
							pDepositdata2 = $('<td>' + order.in_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							pDepositdata3 = $('<td>' + order.created_at + '</td>');
							pDepositdata4 = $('<td>' + order.status + '</td>');

							pDepositRow.append(pDepositdata1);
							pDepositRow.append(pDepositdata2);
							pDepositRow.append(pDepositdata3);
							pDepositRow.append(pDepositdata4);

							pDepositBody.append(pDepositRow);
						}

						if (order.type == 'withdraw') {
							console.log(order);
							pWithdrawRow = $('<tr></tr>');
							pWithdrawdata1 = $('<td>' + order.out_currency_order.name + '</td>');
							pWithdrawdata2 = $('<td>' + order.out_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							pWithdrawdata3 = $('<td>' + order.created_at + '</td>');
							pWithdrawdata4 = $('<td>' + order.status + '</td>');

							pWithdrawRow.append(pWithdrawdata1);
							pWithdrawRow.append(pWithdrawdata2);
							pWithdrawRow.append(pWithdrawdata3);
							pWithdrawRow.append(pWithdrawdata4);

							pWithdrawBody.append(pWithdrawRow);
						}

						if (order.type == 'market') {
							pOrderRow = $('<tr></tr>');
							pOrderdata1 = $('<td>' + order.out_currency_order.name + '</td>');
							pOrderdata2 = $('<td>' + order.out_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							pOrderdata3 = $('<td>' + order.in_currency_order.name + '</td>');
							pOrderdata4 = $('<td>' + order.in_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							pOrderdata5 = $('<td>' + order.created_at + '</td>');
							pOrderdata6 = $('<td>' + order.status + '</td>');

							pOrderRow.append(pOrderdata1);
							pOrderRow.append(pOrderdata2);
							pOrderRow.append(pOrderdata3);
							pOrderRow.append(pOrderdata4);
							pOrderRow.append(pOrderdata5);
							pOrderRow.append(pOrderdata6);

							pOrderBody.append(pOrderRow);
						}
					}
				} catch (err) {
					_didIteratorError5 = true;
					_iteratorError5 = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion5 && _iterator5.return) {
							_iterator5.return();
						}
					} finally {
						if (_didIteratorError5) {
							throw _iteratorError5;
						}
					}
				}

				pDepositTable.append(pDepositHeader);
				pDepositTable.append(pDepositBody);
				pDepositBox.append(pDepositTable);

				pWithdrawTable.append(pWithdrawHeader);
				pWithdrawTable.append(pWithdrawBody);
				pWithdrawBox.append(pWithdrawTable);

				pOrderTable.append(pOrderHeader);
				pOrderTable.append(pOrderBody);
				pOrderBox.append(pOrderTable);

				box.append(pInfoBox);

				box.append('<h3>Balances</h3>');
				box.append(pBalanceBox);

				box.append('<h3>Depositos</h3>');
				box.append(pDepositBox);

				box.append('<h3>Retiros</h3>');
				box.append(pWithdrawBox);

				box.append('<h3>Ordenes</h3>');
				box.append(pOrderBox);

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append(Lang.get('messages.user') + ' ' + Lang.get('messages.profile'));
				$('.modal-body').append(box);
			});
		};

		var addPageUButton = function addPageUButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				searchUser(page);
			});
		};

		/* Modal Create User */

		/*List Users for Clients*/
		/*function userClient(location) {
      location.click(function () {
          if ($(this).hasClass('selected')) {
              $(this).removeClass('selected');
              $('#clientBox').hide();
          } else {
              $('#client').html('');
              role = $(this).val();
              $(this).addClass('selected');
              if (role == 4 || role == 5) {
                  var rtoken = 0;
                  (role == 4) ? rtoken = 3 : rtoken = 6;
                  $.ajax({
                      headers: {
                          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                      },
                      url: globalUrl+"/users/clients",
                      type: 'post',
                      data: { role: rtoken },
                      datatype: 'json',
                      success: function (data) {
                          //Inicio
                          clients = data.data;
                          for (i = 0; i < clients.length; i++) {
                              var client = clients[i];
                              $('#client').append('<option class="clients" value="' + client.id + '">' + client.name + '</option>');
                           }
                          $('#clientBox').show();
                      },
                      // Fin
                      error: function (error) {
                          ReadError(error);
                      }
                  })
              }
          }
       });
  }*/

		/*Make Button For Create User*/
		var addMakeuserButton = function addMakeuserButton(makeBut) {
			jQuery.validator.addMethod("lettersonly", function (value, element) {
				return this.optional(element) || /^[a-z\s]+$/i.test(value);
			}, Lang.get('validation.alpha'));

			jQuery.validator.addMethod("username", function (value, element) {
				return this.optional(element) || /^[a-z\s\d]+$/i.test(value);
			}, Lang.get('validation.alpha_num'));

			jQuery.validator.addMethod("password", function (value, element) {
				return this.optional(element) || /^(?=(?:.*\d){1})(?=(?:.*[A-Z]){1})(?=(?:.*[a-z]){1})\S{6,}$/i.test(value);
			}, Lang.get('validation.alpha_pass'));

			$('#UserForm').validate({
				rules: {
					fname: {
						required: true,
						minlength: 2,
						lettersonly: true
					},
					sname: {
						minlength: 2,
						lettersonly: true
					},
					flastname: {
						required: true,
						minlength: 2,
						lettersonly: true
					},
					slastname: {
						required: true,
						minlength: 2,
						lettersonly: true
					},
					email: {
						required: true,
						email: true
					},
					// country: {
					//     required: true,
					// },
					// state: {
					//     required: true,
					// },
					// city: {
					//     required: true,
					// },
					// street: {
					//     required: true,
					// },
					// house: {
					//     required: true,
					// },
					// postal: {
					//     required: true,
					//     number: true,
					//     minlength: 4,
					// },
					// phone: {
					//     required: true,
					// },
					// bornDate: {
					//     required: true,
					// },
					// bornCity: {
					//     required: true,
					// },
					password: {
						required: true,
						password: true
					},
					passwordConf: {
						required: true,
						password: true,
						equalTo: "#password"
					},
					role: {
						required: true
					}
				},
				messages: {
					role: Lang.get('validation.role')
				}

			});

			makeBut.click(function (e) {
				if ($('#UserForm').valid()) {

					alterForm('#UserForm', true);

					$('#userCont').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' name='button' class='btn btn-alternative-success btn-alternative' id='userConf'>" + Lang.get('messages.confirm') + "</button>");
					backBut = $("<button type='button' name='button' class='btn btn-alternative' id='userBack'>" + Lang.get('messages.back') + "</button>");
					backButton(backBut, '#UserForm', 'user');
					confirmuserButton(confirmBut);
					$('#userButts').prepend(backBut);
					$('#userButts').prepend(confirmBut);
				}
			});
		};

		/* Confirm User For Creation */


		var confirmuserButton = function confirmuserButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				fname = $('#fname').val();
				sname = $('#sname').val();
				flastname = $('#flastname').val();
				slastname = $('#slastname').val();
				email = $('#email').val();
				country = $('#country').val();
				state = $('#state').val();
				city = $('#city').val();
				street = $('#street').val();
				house = $('#house').val();
				postal = $('#postal').val();
				phone = $('#phone').val();
				birthDate = $('#bornDate').val();
				bornCity = $('#bornCity').val();
				password = $('#password').val();
				confirm = $('#passwordConf').val();
				client = $('#client').val();
				var role = [];

				$('input[name="role"]').each(function () {
					if ($(this).is(':checked')) {
						role.push($(this).val());
					}
				});

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/users/create',
					type: 'POST',
					dataType: "json",
					data: {
						fname: fname, sname: sname, flastname: flastname, slastname: slastname, email: email,
						country: country, state: state, city: city, street: street, house: house, postal: postal,
						phone: phone, birthDate: birthDate, bornCity: bornCity, password: password,
						password_confirmation: confirm, roles: role, client: client
					},
					success: function success(data) {

						$('#form_user_search').trigger("submit");
						$('#userMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.user') + ' ' + Lang.get('messages.created') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#userAlertMod').modal('show');
					},
					error: function error(_error7) {

						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));

						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');

						$('#userAlertMod').modal('show');
					}
				});
			});
		};

		/*Edit Button With Modal edition for Users*/


		var addEditUserClick = function addEditUserClick(buttonEdit, user, rols) {
			buttonEdit.click(function () {

				box = $("<form class='UserForm' id='UserForm' enctype='multipart/form-data' ></form>");
				box1 = $('<div class="row"></div>');
				box2 = $('<div class="row"></div>');
				box3 = $('<div class="row"></div>');

				box8 = $('<div class="row PasswordBox" style="display:none;"></div>');
				box9 = $('<div class="row"></div>');
				box0 = $('<div class="row"></div>');

				alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 0) + ' ' + Lang.get('messages.user') + '</strong></div>');

				inputfN = $('<div class="form-group col-sm-6"><label for="fname">' + Lang.get('messages.first') + ' ' + Lang.get('messages.name') + '</label><input id="fname" name="fname" type="text" value="' + user.profile.fname + '" class="form-control" placeholder="' + Lang.get('messages.first') + ' ' + Lang.get('messages.name') + '" required></div>');
				inputsN = $('<div class="form-group col-sm-6"><label for="sname">' + Lang.get('messages.second') + ' ' + Lang.get('messages.name') + '</label><input id="sname" name="sname" type="text" value="' + user.profile.sname + '" class="form-control" placeholder="' + Lang.get('messages.second') + ' ' + Lang.get('messages.name') + '"></div>');

				inputfL = $('<div class="form-group col-sm-6"><label for="flastname">' + Lang.get('messages.first') + ' ' + Lang.get('messages.lastname') + '</label><input id="flastname" name="flastname" value="' + user.profile.flastname + '" type="text" class="form-control" placeholder="' + Lang.get('messages.first') + ' ' + Lang.get('messages.lastname') + '" required></div>');
				inputsL = $('<div class="form-group col-sm-6"><label for="slastname">' + Lang.get('messages.second') + ' ' + Lang.get('messages.lastname') + '</label><input id="slastname" name="slastname" value="' + user.profile.slastname + '" type="text" class="form-control" placeholder="' + Lang.get('messages.second') + ' ' + Lang.get('messages.lastname') + '" required></div>');

				inputE = $('<div class="form-group col-sm-6"><label for="email">' + Lang.get('messages.email') + '</label><input id="email" name="email" type="text" class="form-control" value="' + user.email + '" placeholder="' + Lang.get('messages.email') + '" required></div>');

				inputP = $('<div class="form-group col-sm-6"><label for="password">' + Lang.get('messages.password') + '</label><input id="password" name="password" type="password" class="form-control" placeholder="' + Lang.get('messages.password') + '" required></div>');
				inputPC = $('<div class="form-group col-sm-6"><label for="passwordConf">' + Lang.get('messages.confirm') + ' ' + Lang.get('messages.password') + '</label><input id="passwordConf" name="passwordConf" type="password" class="form-control" placeholder="' + Lang.get('messages.confirm') + ' ' + Lang.get('messages.password') + '" required></div>');

				selectR = $('<div class="form-group col-sm-6"><label for="role" >' + Lang.get('messages.roles') + '</label><div id="roles" style="height:fit-content;" class="form-control"></div>');
				selectC = $('<div class="form-group col-sm-6" id="clientBox" style="display:none;"><label for="selectc" >' + Lang.get('messages.client') + '</label><div><select id="client" class="form-control" name="selectc"></select></div>');

				id = $('<div class="form-group col-sm-6"><input id="id" name="id" type="hidden" value="' + user.id + '" class="form-control"></div>');

				box1.append(inputfN);
				box1.append(inputsN);

				box2.append(inputfL);
				box2.append(inputsL);

				box3.append(inputE);

				box8.append(inputP);
				box8.append(inputPC);

				box9.append(selectR);
				box9.append(selectC);

				box0.append(id);

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append(Lang.get('messages.update') + ' ' + Lang.get('messages.user'));
				$('.modal-body').append(box);

				$('#UserForm').append(alert);

				$('#UserForm').append(box1);
				$('#UserForm').append(box2);
				$('#UserForm').append(box3);
				$('#UserForm').append(box8);
				$('#UserForm').append(box9);
				$('#UserForm').append(box0);

				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					url: globalUrl+"/users/roles",
					type: 'post',
					datatype: 'json',
					success: function success(data) {

						//Inicio
						roles = data.data;

						for (i = 0; i < roles.length; i++) {

							var role = roles[i];
							var label = $('<label id="labelr' + i + '" class="RoleLabel" >' + role.name + '</label>');
							var input = $('<input class="roles" id="role' + i + '" type="checkbox" name="role" value="' + role.id + '"/>');

							$('#roles').append('<div class="checkRoles' + i + ' checkbox-inline" title="' + role.description + '"></div>');

							//userClient(input);
							$('.checkRoles' + i).append(label);
							$('#labelr' + i).prepend(input);

							for (a = 0; a < rols.length; a++) {
								rol = rols[a];
								if (role.name == rol.name) {
									$('#role' + i).trigger('click');
								}
							}
						}
					},
					// Fin
					error: function error(_error8) {
						ReadError(_error8);
					}
				});

				$('.modal-footer').append("<div id='userButts'></div>");

				closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');

				makeBut = $("<button type='button' name='button' class='btn btn-alternative' id='userCont'>" + Lang.get('messages.make') + "</button>");
				peBut = $("<button type='button' name='button' class='btn btn-alternative' id='userPass'>" + Lang.get('messages.change') + " " + Lang.get('messages.password') + "</button>");

				passwordEditUser(peBut);
				addMakeEuserButton(makeBut);

				country();
				states('#country');
				phonePrefix('#country');
				cities('#state');
				bornCountry();

				$('#userButts').append(makeBut);
				$('#userButts').append(peBut);
				$('#userButts').append(closebut);
			});
		};

		/*Password Edition For Users*/


		var passwordEditUser = function passwordEditUser(pebutton) {
			pebutton.click(function () {
				$('.PasswordBox').toggle('slow');
			});
		};
		/* Make User Button For editing */


		var addMakeEuserButton = function addMakeEuserButton(makeBut) {
			jQuery.validator.addMethod("lettersonly", function (value, element) {
				return this.optional(element) || /^[a-z\s]+$/i.test(value);
			}, Lang.get('validation.alpha'));

			jQuery.validator.addMethod("username", function (value, element) {
				return this.optional(element) || /^[a-z\s\d]+$/i.test(value);
			}, Lang.get('validation.alpha_num'));

			jQuery.validator.addMethod("password", function (value, element) {
				return this.optional(element) || /^(?=(?:.*\d){1})(?=(?:.*[A-Z]){1})(?=(?:.*[a-z]){1})\S{6,}$/i.test(value);
			}, Lang.get('validation.alpha_pass'));

			$('#UserForm').validate({
				rules: {
					fname: {
						required: true,
						minlength: 2,
						lettersonly: true
					},
					sname: {
						minlength: 2,
						lettersonly: true
					},
					flastname: {
						required: true,
						minlength: 2,
						lettersonly: true
					},
					slastname: {
						required: true,
						minlength: 2,
						lettersonly: true
					},
					email: {
						required: true,
						email: true
					},
					country: {
						required: true
					},
					state: {
						required: true
					},
					city: {
						required: true
					},
					street: {
						required: true
					},
					house: {
						required: true
					},
					postal: {
						required: true,
						number: true,
						minlength: 4
					},
					phone: {
						required: true
					},
					bornDate: {
						required: true
					},
					bornCity: {
						required: true
					},
					password: {
						password: true
					},
					passwordConf: {
						password: true,
						equalTo: "#password"
					},
					role: {
						required: true
					}
				},
				messages: {
					role: Lang.get('validation.role')
				}

			});

			makeBut.click(function (e) {

				if ($('#UserForm').valid()) {
					alterForm('#UserForm', true);
					$('#userCont').hide();
					$('#userPass').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' name='button' class='btn btn-alternative-success btn-alternative' id='userConf'>" + Lang.get('messages.confirm') + "</button>");
					backBut = $("<button type='button' name='button' class='btn btn-alternative' id='userBack'>" + Lang.get('messages.back') + "</button>");
					backButton(backBut, '#UserForm', 'user');
					_confirmEuserButton(confirmBut);
					$('#userButts').prepend(backBut);
					$('#userButts').prepend(confirmBut);
				}
			});
		};

		/* Confirm Button For Editing User */


		var _confirmEuserButton = function _confirmEuserButton(confirmBut) {
			confirmBut.click(function () {

				$(this).addClass('disabled');
				$(this).prop('disabled', true);

				fname = $('#fname').val();
				sname = $('#sname').val();
				flastname = $('#flastname').val();
				slastname = $('#slastname').val();
				email = $('#email').val();
				country = $('#country').val();
				state = $('#state').val();
				city = $('#city').val();
				street = $('#street').val();
				house = $('#house').val();
				postal = $('#postal').val();
				phone = $('#phone').val();
				birthDate = $('#bornDate').val();
				bornCity = $('#bornCity').val();
				password = $('#password').val();
				confirm = $('#passwordConf').val();
				client = $('#client').val();
				id = $('#id').val();

				var role = [];

				$('input[name="role"]').each(function () {
					if ($(this).is(':checked')) {
						role.push($(this).val());
					}
				});

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/users/update',
					type: 'POST',
					dataType: "json",
					data: {
						id: id, fname: fname, sname: sname, flastname: flastname, slastname: slastname, email: email,
						country: country, state: state, city: city, street: street, house: house, postal: postal,
						phone: phone, birthDate: birthDate, bornCity: bornCity, password: password,
						password_confirmation: confirm, roles: role, client: client
					},
					success: function success(data) {
						$('#form_user_search').trigger("submit");
						$('#userMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.user') + ' ' + Lang.get('messages.edited') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#userAlertMod').modal('show');
					},
					error: function error(_error9) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#userAlertMod').modal('show');
					}
				});
			});
		};

		/* Delete Function For User */


		var addMakeDuserButton = function addMakeDuserButton(delButt, user) {

			delButt.click(function () {

				box = $("<form class='UserForm' id='UserForm' enctype='multipart/form-data' ></form>");
				alert = $('<h4><strong>' + Lang.get('messages.sure') + ' ' + Lang.get('messages.delete') + ' ' + Lang.get('messages.this') + ' ' + user.fname + ' ' + user.flastname + ' ' + Lang.get('messages.user') + '?</strong></h4></div>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + user.id + '" required>');

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append(Lang.get('messages.delete') + ' ' + Lang.get('messages.user'));
				$('.modal-body').append(box);
				$('#UserForm').append(alert);
				$('#UserForm').append(inputI);

				$('.modal-footer').append("<div id='userButts'></div>");

				closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				makeBut = $("<button type='button' name='button' class='btn btn-alternative-danger btn-alternative' id='userCont'>" + Lang.get('messages.delete') + "</button>");

				DeleteUserButton(makeBut);

				$('#userButts').append(makeBut);
				$('#userButts').append(closebut);
			});
		};

		/* Confirmation Of User Deletion */


		var DeleteUserButton = function DeleteUserButton(delButt) {
			delButt.click(function () {

				$(this).addClass('disabled');
				$(this).prop('disabled', true);

				id = $('#id').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/users/delete',
					type: 'POST',
					dataType: "json",
					data: { id: id },
					success: function success(data) {

						$('#form_user_search').trigger("submit");
						$('#userMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.user') + ' ' + Lang.get('messages.deleted') + ' ' + Lang.get('messages.successfuly'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#userAlertMod').modal('show');
					},
					error: function error(_error10) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#userAlertMod').modal('show');
					}
				});
			});
		};

		/*Execute Script*/


		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$('.listuser').addClass('active');
		/*Search User Table*/

		$('#table_user_header_name').click(function (e) {
			orderTableUserBy('name');
		});

		$('#table_user_header_email').click(function (e) {
			orderTableUserBy('email');
		});

		$('#table_user_header_date').click(function (e) {
			orderTableUserBy('created_at');
		});

		$('#table_user_header_update').click(function (e) {
			orderTableUserBy('updated_at');
		});

		var orderUserBy = "";
		var orderUserDirection = "";
		var searchUserValue = "";

		$("#form_user_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchUserValue = $("#search_user_value").val();
			searchUser(1);
		});

		$('.btn-create').click(function () {

			box = $("<form class='UserForm' id='UserForm' enctype='multipart/form-data' ></form>");
			box1 = $('<div class="row"></div>');
			box2 = $('<div class="row"></div>');
			box3 = $('<div class="row"></div>');
			box8 = $('<div class="row"></div>');
			box9 = $('<div class="row"></div>');

			alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 0) + ' ' + Lang.get('messages.user') + '</strong></div>');

			inputfN = $('<div class="form-group col-sm-6"><label for="fname">' + Lang.get('messages.first') + ' ' + Lang.get('messages.name') + '</label><input id="fname" name="fname" type="text" class="form-control" placeholder="' + Lang.get('messages.first') + ' ' + Lang.get('messages.name') + '" required></div>');
			inputsN = $('<div class="form-group col-sm-6"><label for="sname">' + Lang.get('messages.second') + ' ' + Lang.get('messages.name') + '</label><input id="sname" name="sname" type="text" class="form-control" placeholder="' + Lang.get('messages.second') + ' ' + Lang.get('messages.name') + '"></div>');

			inputfL = $('<div class="form-group col-sm-6"><label for="flastname">' + Lang.get('messages.first') + ' ' + Lang.get('messages.lastname') + '</label><input id="flastname" name="flastname" type="text" class="form-control" placeholder="' + Lang.get('messages.first') + ' ' + Lang.get('messages.lastname') + '" required></div>');
			inputsL = $('<div class="form-group col-sm-6"><label for="slastname">' + Lang.get('messages.second') + ' ' + Lang.get('messages.lastname') + '</label><input id="slastname" name="slastname" type="text" class="form-control" placeholder="' + Lang.get('messages.second') + ' ' + Lang.get('messages.lastname') + '"></div>');

			inputE = $('<div class="form-group col-sm-6"><label for="email">' + Lang.get('messages.email') + '</label><input id="email" name="email" type="text" class="form-control" placeholder="' + Lang.get('messages.email') + '" required></div>');

			inputP = $('<div class="form-group col-sm-6"><label for="password">' + Lang.get('messages.password') + '</label><input id="password" name="password" type="password" class="form-control" placeholder="' + Lang.get('messages.password') + '" required></div>');
			inputPC = $('<div class="form-group col-sm-6"><label for="passwordConf">' + Lang.get('messages.confirm') + ' ' + Lang.get('messages.password') + '</label><input id="passwordConf" name="passwordConf" type="password" class="form-control" placeholder="' + Lang.get('messages.confirm') + ' ' + Lang.get('messages.password') + '" required></div>');

			selectR = $('<div class="form-group col-sm-12"><label for="role" >' + Lang.get('messages.roles') + '</label><div id="roles" style="height:fit-content;" class="form-control"></div>');
			//selectC = $('<div class="form-group col-sm-6" id="clientBox" style="display:none;"><label for="selectc" >' + Lang.get('messages.client') + '</label><div><select id="client" class="form-control" name="selectc"></select></div>');

			box1.append(inputfN);
			box1.append(inputsN);

			box2.append(inputfL);
			box2.append(inputsL);

			box3.append(inputE);

			box8.append(inputP);
			box8.append(inputPC);

			box9.append(selectR);
			// box9.append(selectC);

			$('.modal-title').empty();
			$('.modal-body').empty();
			$('.modal-footer').empty();
			$('.modal-title').append(Lang.get('messages.create') + ' ' + Lang.get('messages.user'));
			$('.modal-body').append(box);

			$('#UserForm').append(alert);

			$('#UserForm').append(box1);
			$('#UserForm').append(box2);
			$('#UserForm').append(box3);
			$('#UserForm').append(box8);
			$('#UserForm').append(box9);

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/users/roles",
				type: 'post',
				datatype: 'json',
				success: function success(data) {
					//Inicio
					roles = data.data;
					for (i = 0; i < roles.length; i++) {
						var role = roles[i];
						var label = $('<label id="labelr' + i + '" class="RoleLabel checkbox-inline" >' + role.name + '</label>');
						var input = $('<input class="roles" type="checkbox" name="role" value="' + role.id + '"/>');
						$('#roles').append('<div class="checkRoles' + i + ' checkbox-inline col-sm-auto" data-toggle="tooltip" data-placement="bottom" title="' + role.description + '"></div>');
						//userClient(input);
						$('.checkRoles' + i).append(label);
						$('#labelr' + i).prepend(input);
					}
				},
				// Fin
				error: function error(_error6) {
					ReadError(_error6);
				}
			});

			closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
			$('.modal-footer').prepend("<div id='userButts'></div>");

			makeBut = $("<button type='button' name='button' class='btn btn-alternative' id='userCont'>" + Lang.get('messages.make') + "</button>");
			addMakeuserButton(makeBut);

			country();
			states('#country');
			phonePrefix('#country');
			cities('#state');
			bornCountry();

			$('#userButts').append(makeBut);
			$('#userButts').append(closebut);
		});$('#result_user_page').change(function () {
			$('#form_user_search').trigger("submit");
		});

		$('#form_user_search').trigger("submit");
	}

	/*End User Functions*/

	/*Begin Currency Functions*/

	if (pathverify('/currencies')) {
		var orderTableCurrencyBy = function orderTableCurrencyBy(by) {
			if (orderCurrencyBy === by) {
				if (orderCurrencyDirection === "") {
					orderCurrencyDirection = "DESC";
				} else {
					orderCurrencyDirection = "";
				}
			} else {
				orderCurrencyBy = by;
				orderCurrencyDirection = "";
			}
			searchCurrency(1);
		};

		//Get Currency Data

		var searchCurrency = function searchCurrency(page) {
			resultPage = $("#result_currency_page").val();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/currencies",
				type: 'post',
				data: { searchvalue: searchCurrencyValue, page: page, orderBy: orderCurrencyBy, orderDirection: orderCurrencyDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var currencies = data.result;
					if (currencies.length == 0) {
						$("#table_currency_content").html("");
						$('#table_currency_content').append('<tr><td colspan="10">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						$("#table_currency_content").html("");
						for (i = 0; i < currencies.length; i++) {
							var currency = currencies[i];
							// we have to make in steps to add the onclick event
							var rowResult = $('<tr></tr>');
							var colvalue_1 = $('<td>' + currency.name + '</td>');
							var colvalue_2 = $('<td>' + currency.symbol + '</td>');
							var colvalue_3 = $('<td>' + currency.type + '</td>');
							if (currency.price != 0) {
								var colvalue_4 = $('<td>' + formatNumber.num(currency.price) + '</td>');
							} else {
								var colvalue_4 = $('<td>' + formatNumber.num(currency.value) + '</td>');
							}

							var colvalue_5 = $('<td>' + currency.created_at + '</td>');
							var colvalue_6 = $('<td>' + currency.updated_at + '</td>');

							if (currency.exchangeable == 1) {
								var colvalue_7 = $('<td>' + Lang.get('messages.exchangeable') + '</td>');
							} else {
								var colvalue_7 = $('<td>' + Lang.get('messages.no') + ' ' + Lang.get('messages.exchangeable') + '</td>');
							}

							if (currency.prima == 1) {
								var colvalue_8 = $('<td>' + Lang.get('messages.yes') + '</td>');
							} else {
								var colvalue_8 = $('<td>' + Lang.get('messages.no') + '</td>');
							}

							if (currency.active == 1) {
								var colvalue_11 = $('<td>' + Lang.get('messages.active') + '</td>');
							} else {
								var colvalue_11 = $('<td>' + Lang.get('messages.inactive') + '</td>');
							}

							var colvalue_9 = $('<td>' + currency.withdraw_fee + '</td>');
							var colvalue_10 = $('<td>' + currency.deposit_fee + '</td>');
							var colvalue_13 = $('<td>' + currency.min_withdraw + '</td>');
							var colvalue_12 = $('<td class="text-center"></td>');

							editBut = $('<button type="button" data-toggle="modal" data-target="#currencyMod" class="btn btn-alternative btn-sm mr-2" id="editBut">' + Lang.get('messages.edit') + '</button>');
							delBut = $('<button type="button" data-toggle="modal" data-target="#currencyMod" class="btn btn-alternative-danger btn-alternative btn-sm" id="delBut">' + Lang.get('messages.delete') + '</button>');
							addEditCurrencyClick(editBut, currency);
							addMakeDcurrencyButton(delBut, currency);

							colvalue_12.append(editBut);
							colvalue_12.append(delBut);

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);
							rowResult.append(colvalue_7);
							rowResult.append(colvalue_8);
							rowResult.append(colvalue_9);
							rowResult.append(colvalue_10);
							rowResult.append(colvalue_13);
							rowResult.append(colvalue_11);
							rowResult.append(colvalue_12);

							$("#table_currency_content").append(rowResult);
						}

						pagination("#table_currency_pagination", "#result_currency_page", data.page, data.total, addPageCButton);
					}
					// Put the data into the element you care about.
				},
				// Fin
				error: function error(_error11) {
					ReadError(_error11);
				}
			});
		};

		var addPageCButton = function addPageCButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				searchCurrency(page);
			});
		};
		/*
  function viewToken(viewbut, type, name){
    viewbut.click(function(){
      if(type == 'Token'){
        $('#rightContent').html('<iframe width="100%" height="100%" src="https://icodrops.com/'+name.toLowerCase()+'"></iframe>');
      }
    })
  }
  */

		/* Create Modal Button for Creation of currency*/


		/*Change between Input or Selection Value*/
		var changeValueCurrency = function changeValueCurrency(checkbox) {
			$(checkbox).click(function () {
				if (!$(this).hasClass('selected')) {
					var value = $('<select id="value" class="form-control" name="selectv"></select>');
					var types = ['coinmarketcap'];
					for (i = 0; i < types.length; i++) {
						var type = types[i];
						option = $('<option value="' + type + '">' + type + '</option>');
						value.append(option);
					}
					$('#valuechange').html('');
					$('#valuechange').append(value);
					$(this).addClass('selected');
				} else {
					var value = $('<input id="value" name="value" type="text" class="form-control" placeholder="' + Lang.get('messages.value') + '" required>');
					$('#valuechange').html('');
					$('#valuechange').append(value);
					$(this).removeClass('selected');
				}
			});
		};

		/*Add Make Button for currency Creation*/


		var addMakeCurrencyButton = function addMakeCurrencyButton(makeBut) {
			jQuery.validator.addMethod("lettersonly", function (value, element) {
				return this.optional(element) || /^[a-z\S]+$/i.test(value);
			}, Lang.get('validation.alpha'));

			$('#CurrencyForm').validate({
				rules: {
					name: {
						required: true,
						minlength: 2,
						lettersonly: true
					},
					symbol: {
						required: true,
						minlength: 3,
						maxlength: 6,
						lettersonly: true
					},
					type: {
						required: true
					},
					value: {
						minlength: 1,
						number: true
					},
					withfee: {
						minlength: 1,
						number: true
					},
					depfee: {
						minlength: 1,
						number: true
					}
				},
				messages: {
					type: Lang.get('validation.type')
				}

			});
			makeBut.click(function (e) {
				if ($('#CurrencyForm').valid()) {
					alterForm('#CurrencyForm', true);
					$('#currnCont').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' name='button' class='btn btn-alternative-success btn-alternative' id='currnConf'>" + Lang.get('messages.confirm') + "</button>");
					backBut = $("<button type='button' name='button' class='btn btn-alternative' id='currnBack'>" + Lang.get('messages.back') + "</button>");
					backButton(backBut, '#CurrencyForm', 'currn');
					confirmcurrencyButton(confirmBut);
					$('#currnButts').prepend(backBut);
					$('#currnButts').prepend(confirmBut);
				}
			});
		};

		/*Add Confirm Button For Currency Creation*/


		var confirmcurrencyButton = function confirmcurrencyButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				name = $('#name').val();
				symbol = $('#symbol').val();
				type = $('#type').val();
				value = $('#value').val();
				withfee = $('#withfee').val();
				depfee = $('#depfee').val();
				minwith = $('#minwith').val();
				exch = $('#exch').is(":checked");
				active = $('#activ').is(":checked");
				prima = $('#prima').is(":checked");

				if (value != 'coinmarketcap') {
					value = value.replace(/,/g, '.');
					value = parseFloat(value);
				}
				$.ajax({
					headers: { 					
					    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     },
					url: globalUrl+'/currencies/create',
					type: 'POST',
					dataType: "json",
					data: { name: name, symbol: symbol, type: type, value: value, exch: exch, prima: prima, active: active, withfee: withfee, depfee: depfee, minwith: minwith },
					success: function success(data) {
						$('#form_currency_search').trigger("submit");
						$('#currencyMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.currency') + ' ' + Lang.get('messages.created') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#currencyAlertMod').modal('show');
					},
					error: function error(_error12) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#currencyAlertMod').modal('show');
					}
				});
			});
		};

		/*Add Edit Button With Modal For Editing Currency*/


		var addEditCurrencyClick = function addEditCurrencyClick(buttonEdit, currency) {
			buttonEdit.click(function () {

				box = $("<form class='CurrencyForm' id='CurrencyForm' enctype='multipart/form-data' ></form>");

				alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 1) + ' ' + Lang.get('messages.currency') + '</strong></div>');

				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + currency.id + '" required>');
				inputN = $('<div class="form-group"><label for="name">' + Lang.get('messages.name') + '</label><input id="name" name="name" type="text" class="form-control" placeholder="' + Lang.get('messages.name') + '" value="' + currency.name + '"  required></div>');
				inputS = $('<div class="form-group"><label for="symbol">' + Lang.get('messages.symbol') + '</label><input id="symbol" name="symbol" type="text" class="form-control" placeholder="' + Lang.get('messages.symbol') + '" value="' + currency.symbol + '"  required ></div>');
				selectT = $('<div class="form-group"><label for="type">' + Lang.get('messages.type') + '</label><select id="type" class="form-control" name="selectt"></select></div>');
				inputA = $('<div class="form-group"><label for="value">' + Lang.get('messages.value') + '</label><div id="valuechange"><input id="value" name="value" type="text" class="form-control" placeholder="' + Lang.get('messages.value') + '" value="' + currency.value + '" required></div></div>');
				inputWF = $('<div class="form-group"><label for="withfee">' + Lang.get('messages.withdraw') + ' ' + Lang.get('messages.fee') + '</label><input id="withfee" name="withfee" type="text" class="form-control" placeholder="' + Lang.get('messages.withdraw') + ' ' + Lang.get('messages.fee') + '" value="' + currency.withdraw_fee + '" required></div>');
				inputDF = $('<div class="form-group"><label for="depfee">' + Lang.get('messages.deposit') + ' ' + Lang.get('messages.fee') + '</label><input id="depfee" name="depfee" type="text" class="form-control" placeholder="' + Lang.get('messages.deposit') + ' ' + Lang.get('messages.fee') + '" value="' + currency.deposit_fee + '" required></div>');
				inputMW = $('<div class="form-group"><label for="minwith">min ' + Lang.get('messages.withdraw') + '</label><input id="minwith" name="minwith" type="text" class="form-control" placeholder="Min ' + Lang.get('messages.withdraw') + '" value="' + currency.min_withdraw + '" required></div>');
				inputC = '<div class="checkbox-inline" title="Change between manual value or an API value"><label id="labelch" ><input class="changevalue" id="valuechanges" type="checkbox" name="chnge" value=""/>' + Lang.get('messages.change') + ' ' + Lang.get('messages.value') + ' ' + Lang.get('messages.selection') + '</label></div>';
				inputCE = '<div class="checkbox-inline" title="Made Coin Exchangeable"><label id="labelce" ><input class="exch" id="exch" type="checkbox" name="exch" value="1"/> ' + Lang.get('messages.exchangeable') + '</label></div>';
				inputCP = '<div class="checkbox-inline" title="Made Coin Active"><label id="labelcp" ><input class="prima" id="prima" type="checkbox" name="prima" value="1"/> ' + Lang.get('messages.prima') + '</label></div>';
				inputCA = '<div class="checkbox-inline" title="Made Coin Active"><label id="labelca" ><input class="act" id="activ" type="checkbox" name="activ" value="1"/> ' + Lang.get('messages.active') + '</label></div>';

				types = ['FIAT', 'Cryptocurrency', 'Token'];

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append(Lang.get('messages.update') + ' ' + Lang.get('messages.currency'));
				$('.modal-body').append(box);

				$('#CurrencyForm').append(alert);
				$('#CurrencyForm').append(inputI);
				$('#CurrencyForm').append(inputN);
				$('#CurrencyForm').append(inputS);
				$('#CurrencyForm').append(selectT);
				$('#CurrencyForm').append(inputA);
				$('#CurrencyForm').append(inputWF);
				$('#CurrencyForm').append(inputDF);
				$('#CurrencyForm').append(inputMW);
				$('#CurrencyForm').append(inputC);
				$('#CurrencyForm').append(inputCE);
				$('#CurrencyForm').append(inputCP);
				$('#CurrencyForm').append(inputCA);

				$('#valuechanges').click(function () {
					if (!$(this).hasClass('selected')) {
						var value = $('<select id="value" class="form-control" name="selectv"></select>');
						var types2 = ['coinmarketcap'];
						for (i = 0; i < types2.length; i++) {
							var type2 = types2[i];
							if (currency.value == type2) {
								option = $('<option value="' + type2 + '" selected="selected" >' + type2 + '</option>');
								value.append(option);
							}
							option = $('<option value="' + type2 + '" >' + type2 + '</option>');
							value.append(option);
						}
						$('#valuechange').html('');
						$('#valuechange').append(value);
						$(this).addClass('selected');
					} else {
						var value = $('<input id="value" name="value" type="text" class="form-control" placeholder="' + Lang.get('messages.value') + '" required>');
						$('#valuechange').html('');
						$('#valuechange').append(value);
						$(this).removeClass('selected');
					}
				});

				if (!Number.isInteger(currency.value)) {
					$('#valuechanges').trigger('click');
				}

				for (i = 0; i < types.length; i++) {
					type = types[i];
					if (currency.type == type) {
						option = $('<option value="' + type + '" selected="selected">' + type + '</option>');
					} else {
						option = $('<option value="' + type + '">' + type + '</option>');
					}
					$('#type').append(option);
				}

				$('.modal-footer').append("<div id='currnButts'></div>");
				closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				makeBut = $("<button type='button' name='button' class='btn btn-alternative' id='currnCont'>" + Lang.get('messages.make') + "</button>");
				addMakeEcurrencyButton(makeBut);

				$('#currnButts').append(makeBut);
				$('#currnButts').append(closebut);

				if (currency.active == 1) {
					$('#activ').prop('checked', true);
				}

				if (currency.prima == 1) {
					$('#prima').prop('checked', true);
				}

				if (currency.exchangeable == 1) {
					$('#exch').prop('checked', true);
				}
			});
		};

		/*Add Make Button for Editing Currency*/


		var addMakeEcurrencyButton = function addMakeEcurrencyButton(makeBut) {
			jQuery.validator.addMethod("lettersonly", function (value, element) {
				return this.optional(element) || /^[a-z\S]+$/i.test(value);
			}, Lang.get('validation.alpha'));

			$('#CurrencyForm').validate({
				rules: {
					name: {
						required: true,
						minlength: 2,
						lettersonly: true
					},
					symbol: {
						required: true,
						minlength: 2,
						maxlength: 6,
						lettersonly: true
					},
					type: {
						required: true
					},
					value: {
						minlength: 1,
						number: true
					},
					withfee: {
						minlength: 1,
						number: true
					},
					depfee: {
						minlength: 1,
						number: true
					}
				},
				messages: {
					type: Lang.get('validation.type')
				}
			});

			makeBut.click(function (e) {
				if ($('#CurrencyForm').valid()) {
					alterForm('#CurrencyForm', true);
					$('#currnCont').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' class='btn btn-alternative-success btn-alternative' name='button' id='currnConf'>" + Lang.get('messages.confirm') + "</button>");
					backBut = $("<button type='button' name='button' class='btn btn-alternative' id='currnBack'>" + Lang.get('messages.back') + "</button>");
					backButton(backBut, '#CurrencyForm', 'currn');
					confirmEcurrencyButton(confirmBut);
					$('#currnButts').prepend(backBut);
					$('#currnButts').prepend(confirmBut);
				}
			});
		};

		/*Add Confirm Button for Editing Currency*/


		var confirmEcurrencyButton = function confirmEcurrencyButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();
				name = $('#name').val();
				symbol = $('#symbol').val();
				type = $('#type').val();
				value = $('#value').val();
				exch = $('#exch').is(":checked");
				active = $('#activ').is(":checked");
				prima = $('#prima').is(":checked");
				withfee = $('#withfee').val();
				depfee = $('#depfee').val();
				minwith = $('#minwith').val();

				if (value != 'coinmarketcap') {
					value = value.replace(/,/g, '.');
					value = parseFloat(value);
				}

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/currencies/update',
					type: 'POST',
					dataType: "json",
					data: { id: id, name: name, symbol: symbol, type: type, value: value, exch: exch, prima: prima, active: active, withfee: withfee, depfee: depfee, minwith: minwith },
					success: function success(data) {
						$('#form_currency_search').trigger("submit");
						$('#currencyMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.currency') + ' ' + Lang.get('messages.edited') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#currencyAlertMod').modal('show');
					},
					error: function error(_error13) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#currencyAlertMod').modal('show');
					}
				});
			});
		};

		/*Add Make Delete Button For Currency*/


		var addMakeDcurrencyButton = function addMakeDcurrencyButton(delButt, currency) {
			delButt.click(function () {

				box = $("<form class='CurrencyForm' id='CurrencyForm' enctype='multipart/form-data' ></form>");
				alert = $('<h4><strong>' + Lang.get('messages.sure') + ' ' + Lang.get('messages.delete') + ' ' + currency.name + ' ' + Lang.get('messages.currency') + '?</strong></h4>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + currency.id + '" required>');

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append(Lang.get('messages.delete') + ' ' + Lang.get('messages.currency'));
				$('.modal-body').append(box);

				$('#CurrencyForm').append(alert);
				$('#CurrencyForm').append(inputI);

				$('.modal-footer').append("<div id='currnButts'></div>");
				closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				makeBut = $("<button type='button' name='button' class='btn btn-alternative-danger btn-alternative' id='currnCont'>" + Lang.get('messages.delete') + "</button>");
				DeleteCurrencyButton(makeBut);

				$('#currnButts').append(makeBut);
				$('#currnButts').append(closebut);
			});
		};

		/*Delete Currency Confirm*/


		var DeleteCurrencyButton = function DeleteCurrencyButton(delButt) {
			delButt.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/currencies/delete',
					type: 'POST',
					dataType: "json",
					data: { id: id },
					success: function success(data) {
						$('#form_currency_search').trigger("submit");
						$('#currencyMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.currency') + ' ' + Lang.get('messages.deleted') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#currencyAlertMod').modal('show');
					},
					error: function error(_error14) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#currencyAlertMod').modal('show');
					}
				});
			});
		};

		/*Execute The Script*/


		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$('.listcurrency').addClass('active');
		/*Search Currencies Table*/

		$('#table_currency_header_name').click(function (e) {
			orderTableCurrencyBy('name');
		});

		$('#table_currency_header_symbol').click(function (e) {
			orderTableCurrencyBy('symbol');
		});

		$('#table_currency_header_type').click(function (e) {
			orderTableCurrencyBy('type');
		});

		$('#table_currency_header_value').click(function (e) {
			orderTableCurrencyBy('value');
		});

		$('#table_currency_header_date').click(function (e) {
			orderTableCurrencyBy('created_at');
		});

		$('#table_currency_header_update').click(function (e) {
			orderTableCurrencyBy('updated_at');
		});

		$('#table_currency_header_active').click(function (e) {
			orderTableCurrencyBy('active');
		});

		$('#table_currency_header_exchangeable').click(function (e) {
			orderTableCurrencyBy('exchangeable');
		});

		var orderCurrencyBy = "";
		var orderCurrencyDirection = "";
		var searchCurrencyValue = "";

		$("#form_currency_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchCurrencyValue = $("#search_currency_value").val();
			searchCurrency(1);
		});

		$('.btn-create-Cu').click(function () {

			box = $("<form class='CurrencyForm' id='CurrencyForm' enctype='multipart/form-data' ></form>");
			alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 1) + ' ' + Lang.get('messages.currency') + '</strong></div>');

			inputN = $('<div class="form-group"><label for="name">' + Lang.get('messages.name') + '</label><input id="name" name="name" type="text" class="form-control" placeholder="' + Lang.get('messages.name') + '" required></div>');
			inputS = $('<div class="form-group"><label for="symbol">' + Lang.get('messages.symbol') + '</label><input id="symbol" name="symbol" type="text" class="form-control" placeholder="' + Lang.get('messages.symbol') + '" required></div>');
			selectT = $('<div class="form-group"><label for="type">' + Lang.get('messages.type') + '</label><select id="type" class="form-control" name="type"></select></div>');
			inputA = $('<div class="form-group"><label for="value">' + Lang.get('messages.value') + '</label><div id="valuechange"><input id="value" name="value" type="text" class="form-control" placeholder="' + Lang.get('messages.value') + '" required></div></div>');
			inputWF = $('<div class="form-group"><label for="withfee">' + Lang.get('messages.withdraw') + ' ' + Lang.get('messages.fee') + '</label><input id="withfee" name="withfee" type="text" class="form-control" placeholder="' + Lang.get('messages.withdraw') + ' ' + Lang.get('messages.fee') + '" required></div>');
			inputDF = $('<div class="form-group"><label for="depfee">' + Lang.get('messages.deposit') + ' ' + Lang.get('messages.fee') + '</label><input id="depfee" name="depfee" type="text" class="form-control" placeholder="' + Lang.get('messages.deposit') + ' ' + Lang.get('messages.fee') + '" required></div>');
			inputMW = $('<div class="form-group"><label for="minwith">min ' + Lang.get('messages.withdraw') + '</label><input id="minwith" name="minwith" type="text" class="form-control" placeholder="Min ' + Lang.get('messages.withdraw') + '" required></div>');
			inputC = $('<div class="checkbox-inline" title="Change between manual value or an API value"><label id="labelch" ><input class="changevalue" id="valuechanges" type="checkbox" name="chnge" value=""/> ' + Lang.get('messages.change') + ' ' + Lang.get('messages.value') + ' ' + Lang.get('messages.selection') + '</label></div>');
			inputCE = $('<div class="checkbox-inline" title="Made Coin Exchangeable"><label id="labelce" ><input class="exch" id="exch" type="checkbox" name="exch" value="1"/> ' + Lang.get('messages.exchangeable') + '</label></div>');
			inputCA = $('<div class="checkbox-inline" title="Made Coin Active"><label id="labelca" ><input class="act" id="activ" type="checkbox" name="activ" value="1"/> ' + Lang.get('messages.active') + '</label></div>');
			inputCP = $('<div class="checkbox-inline" title="Made Coin Active"><label id="labelcp" ><input class="prima" id="prima" type="checkbox" name="prima" value="1"/> ' + Lang.get('messages.prima') + '</label></div>');

			types = ['FIAT', 'Cryptocurrency', 'Token'];

			$('.modal-title').empty();
			$('.modal-body').empty();
			$('.modal-footer').empty();
			$('.modal-title').append(Lang.get('messages.create') + ' ' + Lang.get('messages.currency'));
			$('.modal-body').append(box);

			$('#CurrencyForm').append(alert);
			$('#CurrencyForm').append(inputN);
			$('#CurrencyForm').append(inputS);
			$('#CurrencyForm').append(selectT);
			$('#CurrencyForm').append(inputA);
			$('#CurrencyForm').append(inputWF);
			$('#CurrencyForm').append(inputDF);
			$('#CurrencyForm').append(inputMW);
			$('#CurrencyForm').append(inputC);
			$('#CurrencyForm').append(inputCE);
			$('#CurrencyForm').append(inputCP);
			$('#CurrencyForm').append(inputCA);

			for (i = 0; i < types.length; i++) {
				type = types[i];
				option = $('<option value="' + type + '">' + type + '</option>');
				$('#type').append(option);
			}

			changeValueCurrency('#valuechanges');

			$('.modal-footer').append("<div id='currnButts'></div>");
			closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
			makeBut = $("<button type='button' class='btn btn-alternative' name='button' id='currnCont'>" + Lang.get('messages.make') + "</button>");
			addMakeCurrencyButton(makeBut);

			$('#currnButts').append(makeBut);
			$('#currnButts').append(closebut);
		});$('#result_currency_page').change(function () {
			$('#form_currency_search').trigger("submit");
		});

		$('#form_currency_search').trigger("submit");
	}

	/* END Currency Functions */

	/* Begin Funds Functions */

	if (pathverify("/balance")) {

		/* Verify transaction */
		var sendEmailCode = function sendEmailCode() {
			$.ajax({
				headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
				url: globalUrl+'/gen-code-mail',
				type: 'POST',
				success: function success(data) {
					console.log('success send');
				},
				error: function error(_error15) {
					return;
				}
			});
		};

		var confirmAuth = function confirmAuth(type, currency, address, reference, amount, flag) {

			$.ajax({
				headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
				url: globalUrl+'/detect-auth',
				type: 'GET',
				dataType: "json",
				success: function success(data) {
					console.log(amount);
					if (amount < 0) {
						$('.text-alert').empty();
						$('.text-alert').append('<p>El monto no puede ser negativo</p>');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#modal2fa').modal('hide');
						$('#fundsAlertMod').modal('show');
						return;
					}

					if (!data.data.secret_status && !data.data.verify_via_email) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						button = '<a href="'+globalUrl+'/profile"><button type="button">Perfil de usuario</button></a>';
						$('.text-alert').append('<p>Debe activar la autenticación de dos factores para poder continuar, dirijase a la pestana de seguridad en el perfil de usuario</p>' + button);
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#modal2fa').modal('hide');
						$('#fundsAlertMod').modal('show');
					}

					if (data.data.secret_status) {
						$('#message').empty();
						$('#message').append('Ingrese el código de verificación de dos pasos');
						$('#modal2fa').modal('show');
						$('#button-verify').click(function () {
							$('#button-verify').addClass('disabled');
							$('#button-verify').prop('disabled', true);
							secret = $('#secret').val();
							$.ajax({
								headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
								data: {
									secret: secret
								},
								url: globalUrl+'/v-code-google',
								type: 'POST',
								success: function success(data) {
									$('#modal2fa').modal('hide');
									if (flag == 'deposit') {
										if (!confirmationD) {
											sendDeposit(type, currency, address, reference, amount);
											confirmationD = true;
										}
									}

									if (flag == 'withdraw') {
										if (!confirmationW) {
											validWithdraw(type, currency, address, reference, amount);
											confirmationW = true;
										}
									}
								},
								error: function error(_error16) {
									$('#modal2fa').modal('hide');
									$(this).removeClass('disabled');
									$(this).prop('disabled', false);
									$('.text-alert').empty();
									$('.text-alert').append('Ocurrio un error, por favor intentelo de nuevo');
									$('.alert').removeClass('alert-success');
									$('.alert').removeClass('alert-danger');
									$('.alert').addClass('alert-warning');
									$('#fundsAlertMod').modal('show');
								}
							});
						});
					}

					if (data.data.verify_via_email) {
						sendEmailCode();
						$('#message').empty();
						$('#message').append('Ingrese el código enviado a su correo eletrónico');
						$('#modal2fa').modal('show');
						$('#button-verify').click(function () {
							$('#button-verify').addClass('disabled');
							$('#button-verify').prop('disabled', true);
							secret = $('#secret').val();
							$.ajax({
								headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
								data: {
									secret: secret
								},
								url: globalUrl+'/v-code-mail',
								type: 'POST',
								success: function success(data) {
									$('#modal2fa').modal('hide');
									if (flag == 'deposit') {
										sendDeposit(type, currency, address, reference, amount);
									}

									if (flag == 'withdraw'){
									    /*var number = document.getElement
									    if(){*/
										    validWithdraw(type, currency, address, reference, amount);
										/*}else{
										    $('.text-alert').empty();
                        					$('.text-alert').append('Ocurrio un error, por favor intente de nuevo');
                        					$('.alert').removeClass('alert-success');
                        					$('.alert').removeClass('alert-danger');
                        					$('.alert').addClass('alert-warning');
                        					$('#fundsAlertMod').modal('show');
                        					$('#button-verify').removeClass('disabled');
                        					$('#button-verify').prop('disabled', false);
										}*/
									}
								},
								error: function error(_error17) {
									$('#modal2fa').modal('hide');
									$(this).removeClass('disabled');
									$(this).prop('disabled', false);
									$('.text-alert').empty();
									$('.text-alert').append('Ocurrio un error, por favor intentelo de nuevo');
									$('.alert').removeClass('alert-success');
									$('.alert').removeClass('alert-danger');
									$('.alert').addClass('alert-warning');
									$('#fundsAlertMod').modal('show');
									$('#button-verify').removeClass('disabled');
									$('#button-verify').prop('disabled', false);
								}
							});
						});
					}
				},
				error: function error(_error18) {
					$('.text-alert').empty();
					$('.text-alert').append('Ocurrio un error, por favor intente de nuevo');
					$('.alert').removeClass('alert-success');
					$('.alert').removeClass('alert-danger');
					$('.alert').addClass('alert-warning');
					$('#fundsAlertMod').modal('show');
					$('#button-verify').removeClass('disabled');
					$('#button-verify').prop('disabled', false);
				}
			});
		};
		/* End Verify transaction */

		/*Funds Balances*/

		var _totalBalance = function _totalBalance() {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/balance/total",
				type: 'post',
				success: function success(data) {
					usd = data.usd;
					btc = data.btc;
					$('#usdtotal').html('');
					$('#usdtotal').append(usd.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 2 }));
					$('#btctotal').html('');
					$('#btctotal').append(btc.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }));
				}
			});
		};

		/*Search Balances Currency Table*/

		var orderTableBalanceBy = function orderTableBalanceBy(by) {
			if (orderBalanceBy === by) {
				if (orderBalanceDirection === "") {
					orderBalanceDirection = "DESC";
				} else {
					orderBalanceDirection = "";
				}
			} else {
				orderBalanceBy = by;
				orderBalanceDirection = "";
			}
			searchBalance(1);
		};

		//Get Balance Currency Data

		var searchBalance = function searchBalance(page) {

			resultPage = $("#result_balance_page").val();

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/balance",
				type: 'post',
				data: { searchvalue: searchBalanceValue, page: page, orderBy: orderBalanceBy, orderDirection: orderBalanceDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var balances = data.result;

					if (balances.length == 0) {
						$("#table_balance_content").html("");
						$('#table_balance_content').append('<tr><td colspan="3">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						// Put the data into the element you care about.
						$("#table_balance_content").html("");

						for (i = 0; i < balances.length; i++) {
							var balance = balances[i];

							// we have to make in steps to add the onclick event
							var rowResult = $('<tr></tr>');
							var colvalue_1 = $('<td> <img src="'+globalImgUrl+'icons/minicoin/' + balance.symbol + '.png" height="30px" width="auto"/></td>');
							var colvalue_2 = $('<td>' + balance.amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_3 = $('<td>' + balance.pending_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							if (balance.symbol == 'VES') {
								var colvalue_4 = $('<td>' + (balance.amount * balance.price).toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							} else {
								var colvalue_4 = $('<td>' + balance.equivalent.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							}

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);

							$("#table_balance_content").append(rowResult);
						}
						pagination("#table_balance_pagination", "#result_balance_currency_page", data.page, data.total, addPageBCButton);
					}
				},
				// Fin
				error: function error(error) {
					ReadError(error);
				}
			});
		};

		var addPageBCButton = function addPageBCButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				searchBalanceCurrency(page);
			});
		};

		/*End Funds Balances*/

		/*Deposit And Withdraw*/
		var DWtype = function DWtype(select) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/currencies/type",
				type: 'post',
				datatype: 'json',
				success: function success(data) {
					types = data.result;
					for (i = 0; i < types.length; i++) {
						type = types[i];
						if (type == 'Cryptocurrency') {
							$(select).append('<option value="' + type + '" selected>' + Lang.get('messages.' + type) + '</option>');
							DWcurrencies('#currency', type);
						} else {
							$(select).append('<option value="' + type + '">' + Lang.get('messages.' + type) + '</option>');
						}
					}
				},
				// Fin
				error: function error(_error19) {
					ReadError(_error19);
				}
			});
		};

		var DWcurrencies = function DWcurrencies(select, type) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/currencies/name",
				type: 'post',
				datatype: 'json',
				data: { type: type },
				success: function success(data) {
					currencies = data.result;
					$(select).empty();
					for (i = 0; i < currencies.length; i++) {
						currency = currencies[i];
						if (i == 0) {
							$(select).append('<option value="' + currency.symbol + '" selected>' + currency.name + '</option>');
							DWaddress('#address', currency.symbol);
							available(currency.symbol, '#availableW');
						} else {
							$(select).append('<option value="' + currency.symbol + '">' + currency.name + '</option>');
						}
					}
				},
				// Fin
				error: function error(_error20) {
					ReadError(_error20);
				}
			});
		};

		var DWaddress = function DWaddress(select, currency) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/account/address",
				type: 'post',
				data: { currency: currency, type: optype },
				datatype: 'json',
				success: function success(data) {
					addresses = data.result;
					$(select).html('');
					if (addresses.length == 0) {
						if (optype == 'deposit') {
							$(select).val(Lang.get('messages.no') + ' ' + Lang.get('messages.address'));
						} else {
							$(select).append('<option value="">' + Lang.get('messages.no') + ' ' + Lang.get('messages.address') + '</option>');
						}
					} else {
						if (optype == 'deposit') {
							for (i = 0; i < addresses.length; i++) {
								address = addresses[i];
								if (i == 0) {
									$(select).val(address.address);
									$('#bankaccount').append('<option value="' + address.address + '" selected>' + address.bank + '</option>');
								} else {
									$('#bankaccount').append('<option value="' + address.address + '">' + address.bank + '</option>');
								}
								$('#bankaccount').change(function () {
									value = $('#bankaccount').val();
									$(select).val(value);
								});
							}

							$('#data').val('Asesoria Financiera X CA - RIF: J302522030');
						} else {
							for (i = 0; i < addresses.length; i++) {
								address = addresses[i];
								$(select).append('<option value="' + address.key_account + '">' + address.address + '</option>');
							}
						}
					}
				},
				// Fin
				error: function error(_error21) {
					ReadError(_error21);
				}
			});
			$(select).html('');
			return true;
		};

		var available = function available(currency, target) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/balance/availableB",
				type: 'post',
				data: { currency: currency },
				datatype: 'json',
				success: function success(data) {
					amount = data.result;

					$(target).html(amount[0].amount);
				},
				// Fin
				error: function error(_error22) {
					ReadError(_error22);
				}
			});
		};

		var typeSelection = function typeSelection(select) {
			$(select).change(function () {
				var type = $(select).val();
				if (type == "FIAT") {
					$('#selectA').html('');
					$('#selectA').append('<input id="address" class="form-control form-control-modal" name="address" disabled />');
					$('#selectA').append('<select id="bankaccount" class="form-control form-control-modal" name="bank"> </select>');
					$('#selectA').append('<input id="data" class="form-control form-control-modal" name="data" disabled value="Asesoria Financiera X CA - RIF: J302522030" />');
				} else {
					$('#selectA').html('');
					$('#selectA').append('<input id="address" class="form-control form-control-modal" name="address" disabled />');
				}
			});
		};

		var addMakeDepButton = function addMakeDepButton(makeBut) {
			makeBut.click(function (e) {
				$('#DepositForm').validate({
					rules: {
						type: {
							required: true
						},
						currency: {
							required: true
						},
						address: {
							required: true
						},
						reference: {
							required: true
						},
						amount: {
							number: true,
							required: true
						}
					}
				});

				if ($('#DepositForm').valid()) {
					alterForm('#DepositForm', true);
					$('#depCont').hide();
					$('.alert').show();

					confirmBut = $("<button type='button' name='button' class='btn btn-alternative btn-alternative-operation' id='depConf'>Confirm</button>");
					backBut = $("<button type='button' class='btn btn-alternative btn-alternative-operation' name='button' id='depBack'>Back</button>");
					backButton(backBut, '#DepositForm', 'dep');
					confirmDepButton(confirmBut);

					$('#depButts').prepend(backBut);
					$('#depButts').prepend(confirmBut);
				}
			});
		};

		var confirmDepButton = function confirmDepButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);

				type = $('#type').val();
				currency = $('#currency').val();
				address = $('#address').val();
				reference = $('#reference').val();
				amount = $('#amount').val();

				confirmAuth(type, currency, address, reference, amount, 'deposit');
			});
		};

		var sendDeposit = function sendDeposit(type, currency, address, reference, amount) {
			$('#button-verify').addClass('disabled');
			$('#button-verify').prop('disabled', true);
			$.ajax({
				headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
				url: globalUrl+'/balance/deposit',
				type: 'POST',
				dataType: "json",
				data: { type: type, currency: currency, address: address, reference: reference, amount: amount },
				success: function success(data) {
					$('#modal2fa').modal('hide');
					$('#fundsMod').modal('hide');
					$('.text-alert').empty();
					$('.text-alert').append('Deposito realizado con exito');
					$('.alert').removeClass('alert-warning');
					$('.alert').removeClass('alert-danger');
					$('.alert').addClass('alert-success');
					$('#fundsAlertMod').modal('show');
					$('#button-verify').removeClass('disabled');
					$('#button-verify').prop('disabled', false);
					$('#form_balance_search').trigger("submit");
					$('#form_deposit_search').trigger("submit");
				},
				error: function error(_error23) {
					$('#modal2fa').modal('hide');
					$('#button-verify').removeClass('disabled');
					$('#button-verify').prop('disabled', false);
					$('.text-alert').empty();
					if (_error23.responseJSON.error) {
						$('.text-alert').append(_error23.responseJSON.error);
					} else {
						$('.text-alert').append("Ha ocurrido un error, por favor verifique que todos los campos esten completos, si no recargue nuevamente la pagina, en caso de seguir el problema contacte con atencion al cliente");
					}
					$('.alert').removeClass('alert-success');
					$('.alert').removeClass('alert-danger');
					$('.alert').addClass('alert-warning');
					$('#fundsAlertMod').modal('show');
				}
			});
		};

		var withdrawInfo = function withdrawInfo(input) {
			if (optype == 'withdraw') {
				$(input).change(function () {
					currency = $('#currency').val();
					address = $('#address').val();
					amount = $('#amount').val();
					$.ajax({
						headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
						url: globalUrl+'/balance/withinfo',
						type: 'POST',
						dataType: "json",
						data: { address: address, amount: amount, currency: currency },
						success: function success(data) {
							result = data.result;
							$('#minW').html(result['minimal']);
							$('#maxW').html(result['limit']);
							$('#feeW').html(result['fee']);
							$('#recW').html(result['amount']);
						},
						error: function error(_error24) {
							$(this).removeClass('disabled');
							$(this).prop('disabled', false);
							$('.text-alert').empty();
							$('.text-alert').append('An error has ocurred');
							$('.alert').removeClass('alert-success');
							$('.alert').removeClass('alert-danger');
							$('.alert').addClass('alert-warning');
							$('#fundsAlertMod').modal('show');
						}
					});
				});
			}
		};

		var addMakeWithButton = function addMakeWithButton(makeBut) {
			makeBut.click(function (e) {
				$('#WithdrawForm').validate({
					rules: {
						type: {
							required: true
						},
						currency: {
							required: true
						},
						address: {
							required: true
						},
						amount: {
							number: true,
							required: true
						}
					},
					messages: {
						amount: "Please introduce a valid amount, minimun 1 digits"
					}
				});

				if ($('#WithdrawForm').valid()) {

					var label = $('#maxW').html();
					var label2 = $('#minW').html();
					label = parseFloat(label);
					label2 = parseFloat(label2);

					amount = $('#amount').val();
					if (label < amount || label2 > amount) {

						$('.text-alert').empty();
						$('.text-alert').append('<p>El limite de la transacción no es valido, puede que su monto de retiro sea muy bajo o ha excedido su limite del día.</p>');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#modal2fa').modal('hide');
						return $('#fundsAlertMod').modal('show');
					}
					alterForm('#WithdrawForm', true);
					$('#withCont').hide();
					$('.alert').show();

					confirmBut = $("<button type='button' name='button' class='btn btn-alternative btn-alternative-operation' id='withConf'>" + Lang.get('messages.confirm') + "</button>");
					backBut = $("<button type='button' class='btn btn-alternative btn-alternative-operation' name='button' id='withBack'>" + Lang.get('messages.back') + "</button>");
					backButton(backBut, '#WithdrawForm', 'with');
					confirmWithButton(confirmBut);

					$('#withButts').prepend(backBut);
					$('#withButts').prepend(confirmBut);
				}
			});
		};

		var confirmWithButton = function confirmWithButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);

				type = $('#type').val();
				currency = $('#currency').val();
				address = $('#address').val();
				amount = $('#amount').val();
				fee = parseFloat(document.getElementById("feeW").innerHTML);

				confirmAuth(type, currency, address, amount, fee, 'withdraw');
			});
		};

		var validWithdraw = function validWithdraw(type, currency, address, amount, fee) {
			$.ajax({
				headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
				url: globalUrl+'/balance/withdraw',
				type: 'POST',
				dataType: "json",
				data: { type: type, currency: currency, address: address, amount: amount, fee: fee },
				success: function success(data) {
					$('#fundsMod').modal('hide');
					$('.text-alert').empty();
					$('.text-alert').append(data.respond);
					$('.alert').removeClass('alert-warning');
					$('.alert').removeClass('alert-danger');
					$('.alert').addClass('alert-success');
					$('#fundsAlertMod').modal('show');
					$('#button-verify').removeClass('disabled');
					$('#button-verify').prop('disabled', false);
					$('#form_balance_search').trigger("submit");
					$('#form_withdraw_search').trigger("submit");
				},
				error: function error(_error25) {
					$(this).removeClass('disabled');
					$(this).prop('disabled', false);
					$('.text-alert').empty();
					if (_error25.responseJSON.error) {
						$('.text-alert').append(_error25.responseJSON.error);
					} else {
						$('.text-alert').append("Ha ocurrido un error, por favor verifique que todos los campos esten completos, si no recargue nuevamente la pagina, en caso de seguir el problema contacte con atencion al cliente");
					}
					$('.alert').removeClass('alert-success');
					$('.alert').removeClass('alert-danger');
					$('.alert').addClass('alert-warning');
					$('#fundsAlertMod').modal('show');
				}
			});
		};

		/*END Deposit And Withdraw*/

		/*Deposit History*/

		var orderTableDepositBy = function orderTableDepositBy(by) {
			if (orderDepositBy === by) {
				if (orderDepositDirection === "") {
					orderDepositDirection = "DESC";
				} else {
					orderDepositDirection = "";
				}
			} else {
				orderDepositBy = by;
				orderDepositDirection = "";
			}
			searchDeposit(1);
		};

		//Get Deposit Data


		var searchDeposit = function searchDeposit(page) {

			resultPage = $("#result_deposit_page").val();

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/deposit",
				type: 'post',
				data: { searchvalue: searchDepositValue, page: page, orderBy: orderDepositBy, orderDirection: orderDepositDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var deposits = data.result;

					if (deposits.length == 0) {
						$("#table_deposit_content").html("");
						$('#table_deposit_content').append('<tr><td colspan="8">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						// Put the data into the element you care about.
						$("#table_deposit_content").html("");

						for (i = 0; i < deposits.length; i++) {
							var deposit = deposits[i];

							// we have to make in steps to add the onclick event
							var rowResult = $('<tr></tr>');
							var colvalue_1 = $('<td>' + deposit.symbol + '</td>');
							var colvalue_2 = $('<td>' + deposit.amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_3 = $('<td>' + deposit.rate.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_4 = $('<td>' + deposit.reference + '</td>');
							var colvalue_5 = $('<td>' + deposit.ip + '</td>');
							var colvalue_6 = $('<td>' + deposit.ubication + '</td>');
							var colvalue_7 = $('<td>' + deposit.created_at + '</td>');
							var colvalue_8 = $('<td>' + deposit.status + '</td>');

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);
							rowResult.append(colvalue_7);
							rowResult.append(colvalue_8);

							$("#table_deposit_content").append(rowResult);
						}

						pagination("#table_deposit_pagination", "#result_deposit_page", data.page, data.total, addPageDeButton);
					}
				},
				// Fin
				error: function error(_error26) {
					ReadError(_error26);
				}
			});
		};

		var addPageDeButton = function addPageDeButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				searchDeposit(page);
			});
		};

		var orderTableWithdrawBy = function orderTableWithdrawBy(by) {
			if (orderWithdrawBy === by) {
				if (orderWithdrawDirection === "") {
					orderWithdrawDirection = "DESC";
				} else {
					orderWithdrawDirection = "";
				}
			} else {
				orderWithdrawBy = by;
				orderWithdrawDirection = "";
			}
			searchWithdraw(1);
		};

		//Get Deposit Data


		var searchWithdraw = function searchWithdraw(page) {

			resultPage = $("#result_pending_transaction_page").val();

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/withdraw",
				type: 'post',
				data: { searchvalue: searchWithdrawValue, page: page, orderBy: orderWithdrawBy, orderDirection: orderWithdrawDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var withdraws = data.result;

					if (withdraws.length == 0) {
						$("#table_withdraw_content").html("");
						$('#table_withdraw_content').append('<tr><td colspan="8">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						// Put the data into the element you care about.
						$("#table_withdraw_content").html("");

						for (i = 0; i < withdraws.length; i++) {
							var withdraw = withdraws[i];

							// we have to make in steps to add the onclick event
							var rowResult = $('<tr></tr>');
							var colvalue_1 = $('<td>' + withdraw.symbol + '</td>');
							var colvalue_2 = $('<td>' + withdraw.amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_3 = $('<td>' + withdraw.rate.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_4 = $('<td>' + withdraw.reference + '</td>');
							var colvalue_5 = $('<td>' + withdraw.ip + '</td>');
							var colvalue_6 = $('<td>' + withdraw.ubication + '</td>');
							var colvalue_7 = $('<td>' + withdraw.created_at + '</td>');
							var colvalue_8 = $('<td>' + withdraw.status + '</td>');

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);
							rowResult.append(colvalue_7);
							rowResult.append(colvalue_8);

							$("#table_withdraw_content").append(rowResult);
						}

						pagination("#table_withdraw_pagination", "#result_withdraw_page", data.page, data.total, addPageWIButton);
					}
				},
				// Fin
				error: function error(_error27) {
					ReadError(_error27);
				}
			});
		};

		var addPageWIButton = function addPageWIButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				searchWithdraw(page);
			});
		};

		/* Delete Function For User */


		var addMakeDTxButton = function addMakeDTxButton(delButt, trans) {
			delButt.click(function () {
				box = $("<form class='TxForm' id='TxForm' enctype='multipart/form-data' ></form>");
				alert = $('<h4><strong>Are You Sure for delete transaction #' + trans.reference + '?</strong></h4>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + trans.id + '" required>');

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append('Delete Transaction');
				$('.modal-body').append(box);

				$('#TxForm').append(alert);
				$('#TxForm').append(inputI);

				$('.modal-footer').append("<div id='txButts'></div>");

				makeBut = $("<button type='button' class='btn btn-alternative-danger btn-alternative' name='button' id='txCont'>Delete</button>");
				closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">Close</button>');
				DeleteTxButton(makeBut);

				$('#txButts').append(makeBut);
				$('#txButts').append(closebut);
			});
		};

		/* Confirmation Of User Deletion */


		var DeleteTxButton = function DeleteTxButton(delButt) {
			delButt.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/balance/delete',
					type: 'POST',
					dataType: "json",
					data: { id: id },
					success: function success(data) {
						$('#fundsMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append('Transaction Deleted Sucessfully');
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#fundsAlertMod').modal('show');

						$('#form_balance_currency_search').trigger("submit");
						$('#form_balance_crypto_search').trigger("submit");
						$('#form_balance_token_search').trigger("submit");
						$('#form_transaction_search').trigger("submit");
						$('#form_pending_transaction_search').trigger("submit");
						_totalBalance();
					},
					error: function error(_error28) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append('An error has ocurred');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#fundsAlertMod').modal('show');
					}
				});
			});
		};
		/*End Transaction History*/

		var confirmationD = false;
		var confirmationW = false;

		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$('.listbalance').addClass('active');;;

		;

		var optype = '';

		$('.btn-deposit').click(function () {

			box = $("<form class='DepositForm' id='DepositForm' enctype='multipart/form-data' ></form>");

			alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>Por favor verifica la operacion y continua con el deposito</strong></div>');

			selectT = $('<div class="form-group"><label for="selectType" >' + Lang.get('messages.type') + '</label><select id="type" class="form-control form-control-modal" name="type"></select></div>');
			selectC = $('<div class="form-group" id="selectcu"><label for="selectcu" >' + Lang.get('messages.currency') + '</label><select id="currency" class="form-control form-control-modal" name="selectcu"></select></div>');

			selectA = $('<div class="form-group"><label for="Address">' + Lang.get('messages.address') + ' <a href="#" data-toggle="tooltip" data-placement="top" title="Cuenta a depositar la criptomoneda elegida"><i class="fas fa-info-circle"></i></a></label><div id="selectA"><input id="address" class="form-control form-control-modal" name="address" disabled /></div>');

			inputR = $('<div class="form-group"><label for="valueout">' + Lang.get('messages.reference') + ' ' + Lang.get('messages.or') + ' TXID <a href="#" data-toggle="tooltip" data-placement="top" title="N° de Referencia Bancaria o ID de transacción de criptomoneda"><i class="fas fa-info-circle"></i></a></label><input id="reference" name="reference" type="text" class="form-control form-control-modal" placeholder="' + Lang.get('messages.reference') + '" required></div>');

			inputA = $('<div class="form-group"><label for="amount">' + Lang.get('messages.amount') + '</label><input id="amount" name="amount" type="text" class="form-control form-control-modal" placeholder="' + Lang.get('messages.amount') + '" ></div>');
			optype = 'deposit';

			$('.modal-body').empty();
			$('.modal-footer').empty();
			$('.modal-body').append('<div class="modal-title"><h3>' + Lang.get('messages.deposit') + '</h3></div>');
			$('.modal-body').append(box);

			$('#DepositForm').append(alert);
			$('#DepositForm').append(selectT);
			$('#DepositForm').append(selectC);
			$('#DepositForm').append(selectA);
			$('#DepositForm').append(inputR);
			$('#DepositForm').append(inputA);

			DWtype('#type');

			$('#type').change(function () {
				type = $('#type').val();
				DWcurrencies('#currency', type);
			});

			$('#currency').change(function () {
				currency = $('#currency').val();
				DWaddress('#address', currency);
				available(currency, '#availableW');
			});

			$('.modal-footer').append("<div id='depButts'></div>");
			makeBut = $("<button type='button' class='btn btn-alternative btn-alternative-operation' name='button' id='depCont'>" + Lang.get('messages.make') + "</button>");
			addMakeDepButton(makeBut);
			closebut = $('<button type="button" class="btn btn-alternative btn-alternative-operation" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
			$('#depButts').append(makeBut);
			$('#depButts').append(closebut);
			activeTooltip();
			typeSelection('#type');
		});

		$('.btn-withdraw').click(function () {

			box = $("<form class='WithdrawForm' id='WithdrawForm' enctype='multipart/form-data' ></form>");

			alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>Please Check Your Information and Confirm the Withdraw</strong></div>');

			selectT = $('<div class="form-group"><label for="selectType" >' + Lang.get('messages.type') + '</label><select id="type" class="form-control form-control-modal" name="type"></select></div>');
			selectC = $('<div class="form-group" id="selectcu"><label for="selectcu" >' + Lang.get('messages.currency') + '</label><select id="currency" class="form-control form-control-modal" name="currency"></select></div>');
			labelA = $('<div class="form-group" ><label><span class="blue-letter">' + Lang.get('messages.available') + ':</span> <span id="availableW"></span></label></div>"');
			selectA = $('<div class="form-group"><label for="Address">' + Lang.get('messages.address') + '</label><div id="selectA"><select id="address" class="form-control form-control-modal" name="address"></select></div></div>');
			buttonA = $('<div class="form-group"><a href="'+globalUrl+'/account"><button type="button"  class="btn btn-alternative btn-alternative-operation" name="button">Agregar Cuenta</button></a></div>');
			inputA = $('<div class="form-group"><label for="amount">' + Lang.get('messages.amount') + '</label><input id="amount" name="amount" type="text" class="form-control form-control-modal" placeholder="' + Lang.get('messages.amount') + '" ></div>');
			labelE = $('<div class="form-group" ><label><span class="blue-letter">Min ' + Lang.get('messages.withdraw') + ':</span> <span id="minW">0</span></label></div>"');
			labelB = $('<div class="form-group" ><label><span class="blue-letter">Max ' + Lang.get('messages.withdraw') + ':</span> <span id="maxW">0</span></label></div>"');
			labelC = $('<div class="form-group" ><label><span class="blue-letter">' + Lang.get('messages.fee') + ':</span> <span id="feeW">0</span></label></div>"');
			labelD = $('<div class="form-group" ><label><span class="blue-letter">' + Lang.get('messages.receive') + ':</span> <span id="recW">0</span></label></div>"');
			optype = 'withdraw';

			$('.modal-body').empty();
			$('.modal-footer').empty();
			$('.modal-body').append('<div class="modal-title"><h3>' + Lang.get('messages.withdraw') + '</h3></div>');
			$('.modal-body').append(box);

			$('#WithdrawForm').append(alert);
			$('#WithdrawForm').append(selectT);
			$('#WithdrawForm').append(selectC);
			$('#WithdrawForm').append(labelA);
			$('#WithdrawForm').append(selectA);
			$('#WithdrawForm').append(buttonA);
			$('#WithdrawForm').append(inputA);
			$('#WithdrawForm').append(labelE);
			$('#WithdrawForm').append(labelB);
			$('#WithdrawForm').append(labelC);
			$('#WithdrawForm').append(labelD);

			DWtype('#type');

			$('#type').change(function () {
				type = $('#type').val();
				DWcurrencies('#currency', type);
			});

			$('#currency').change(function () {
				currency = $('#currency').val();
				DWaddress('#address', currency);
				available(currency, '#availableW');
			});
			$('.modal-footer').append("<div id='withButts'></div>");

			makeBut = $("<button type='button' class='btn btn-alternative btn-alternative-operation' name='button' id='withCont'>" + Lang.get('messages.make') + "</button>");
			addMakeWithButton(makeBut);
			closebut = $('<button type="button" class="btn btn-alternative btn-alternative-operation" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
			$('#withButts').append(makeBut);
			$('#withButts').append(closebut);
			withdrawInfo('#amount');
		});

		$('#table_deposit_header_currency').click(function (e) {
			orderTableDepositBy('symbol');
		});

		$('#table_deposit_header_amount').click(function (e) {
			orderTableDepositBy('in_amount');
		});

		$('#table_deposit_header_reference').click(function (e) {
			orderTableDepositBy('reference');
		});

		$('#table_deposit_header_rate').click(function (e) {
			orderTableDepositBy('rate');
		});

		$('#table_deposit_header_date').click(function (e) {
			orderTableDepositBy('created_at');
		});

		$('#table_deposit_header_status').click(function (e) {
			orderTableDepositBy('status');
		});

		var orderDepositBy = "";
		var orderDepositDirection = "";
		var searchDepositValue = "";

		$("#form_deposit_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchDepositValue = $("#search_deposit_value").val();
			searchDeposit(1);
		});

		$('#table_withdraw_header_currency').click(function (e) {
			orderTablePendingTransactionBy('symbol');
		});

		$('#table_withdraw_header_amount').click(function (e) {
			orderTableWithdrawBy('out_amount');
		});

		$('#table_withdraw_header_rate').click(function (e) {
			orderTableWithdrawBy('rate');
		});

		$('#table_withdraw_header_date').click(function (e) {
			orderTableWithdrawBy('created_at');
		});

		$('#table_withdraw_header_reference').click(function (e) {
			orderTableWithdrawBy('reference');
		});

		$('#table_withdraw_header_status').click(function (e) {
			orderTableWithdrawBy('status');
		});

		var orderWithdrawBy = "";
		var orderWithdrawDirection = "";
		var searchWithdrawValue = "";

		$("#form_withdraw_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchWithdrawValue = $("#search_withdraw_value").val();
			searchWithdraw(1);
		});

		$('#table_balance_header_symbol').click(function (e) {
			orderTableBalanceBy('currencies.symbol');
		});

		$('#table_balance_header_amount').click(function (e) {
			orderTableBalanceBy('amount');
		});

		$('#table_balance_header_equivalent').click(function (e) {
			orderTableBalanceBy('equivalent');
		});

		var orderBalanceBy = "equivalent";
		var orderBalanceDirection = "";
		var searchBalanceValue = "";

		$("#form_balance_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchBalanceValue = $("#search_balance_value").val();
			searchBalance(1);
		});

		$('#result_balance_page').change(function () {
			$('#form_balance_search').trigger("submit");
		});

		$('#result_deposit_page').change(function () {
			$('#form_deposit_search').trigger("submit");
		});
		$('#result_withdraw_page').change(function () {
			$('#form_withdraw_search').trigger("submit");
		});

		$('#form_balance_search').trigger("submit");

		_totalBalance();
		$('#form_deposit_search').trigger("submit");
		$('#form_withdraw_search').trigger("submit");
	}

	/* End Funds Functions */

	/* Begin Newsletter Functions */
	if (pathverify("/newslette")) {
		var orderTableNewsletterBy = function orderTableNewsletterBy(by) {
			if (orderNewsletterBy === by) {
				if (orderNewsletterDirection === "") {
					orderNewsletterDirection = "DESC";
				} else {
					orderNewsletterDirection = "";
				}
			} else {
				orderNewsletterBy = by;
				orderNewsletterDirection = "";
			}
			searchNewsletter(1);
		};

		//Get Newsletter Data

		var searchNewsletter = function searchNewsletter(page) {
			resultPage = $("#result_newsletter_page").val();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/newsletter",
				type: 'post',
				data: { searchvalue: searchNewsletterValue, page: page, orderBy: orderNewsletterBy, orderDirection: orderNewsletterDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var newsletters = data.result;

					if (newsletters.length == 0) {
						$("#table_newsletter_content").html("");
						$('#table_newsletter_content').append('<tr><td colspan="6">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						$("#table_newsletter_content").html("");
						for (i = 0; i < newsletters.length; i++) {
							var newsletter = newsletters[i];

							var rowResult = $('<tr></tr>');
							var colvalue_1 = $('<td>' + newsletter.title + '</td>');
							var colvalue_2 = $('<td>' + newsletter.name + '</td>');
							var colvalue_3 = $('<td>' + newsletter.message + '</td>');
							var colvalue_4 = $('<td></td>');

							editBut = $('<button type="button"  data-toggle="modal" data-target="#newsMod" id="editBut" class="btn btn-alternative btn-sm">' + Lang.get('messages.edit') + '</button>');
							delBut = $('<button type="button"  data-toggle="modal" data-target="#newsMod" id="delBut" class="btn btn-alternative-danger btn-alternative btn-sm">' + Lang.get('messages.delete') + '</button>');

							// we have to make in steps to add the onclick event
							addEditNewsletterClick(editBut, newsletter);
							addMakeDnewsButton(delBut, newsletter);
							var colvalue_4 = $('<td>' + newsletter.created_at + '</td>');
							var colvalue_5 = $('<td>' + newsletter.updated_at + '</td>');
							var colvalue_6 = $('<td></td>');

							colvalue_6.append(editBut);
							colvalue_6.append(delBut);

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);

							$("#table_newsletter_content").append(rowResult);
						}

						pagination("#table_newsletter_pagination", "#result_newsletter_page", data.page, data.total, addPageNButton);
					}
					// Put the data into the element you care about.
				},
				// Fin
				error: function error(_error29) {
					ReadError(_error29);
				}
			});
		};

		var addPageNButton = function addPageNButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				searchNewsletter(page);
			});
		};

		/* Modal Create Newsletter */

		/*Make Button For Create News*/
		var addMakeNewsButton = function addMakeNewsButton(makeBut) {

			$('#NewsForm').validate({
				rules: {
					title: {
						required: true,
						minlength: 2
					},
					message: {
						required: true,
						minlength: 2
					}
				}
			});

			makeBut.click(function (e) {
				if ($('#NewsForm').valid()) {

					alterForm('#NewsForm', true);

					$('#newsCont').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' name='button' class='btn btn-alternative-success btn-alternative' id='newsConf'>Confirm</button>");
					backBut = $("<button type='button' name='button' class='btn btn-alternative' id='newsBack'>Back</button>");
					backButton(backBut, '#NewsForm', 'news');
					confirmnewsButton(confirmBut);
					$('#newsButts').prepend(backBut);
					$('#newsButts').prepend(confirmBut);
				}
			});
		};

		/* Confirm User For Creation */


		var confirmnewsButton = function confirmnewsButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				title = $('#title').val();
				message = $('#message').val();

				$.ajax({

					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/newsletter/create',
					type: 'POST',
					dataType: "json",
					data: { title: title, message: message },
					success: function success(data) {
						$('#form_newsletter_search').trigger("submit");
						$('#newsMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append('Newsletter Created Sucessfully');
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#newsAlertMod').modal('show');
					},
					error: function error(_error30) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append('An error has ocurred');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#newsAlertMod').modal('show');
					}
				});
			});
		};

		/*Edit Button With Modal edition for Users*/


		var addEditNewsletterClick = function addEditNewsletterClick(buttonEdit, newsletter) {
			buttonEdit.click(function () {
				box = $("<form class='NewsForm' id='NewsForm' enctype='multipart/form-data' ></form>");
				alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>Please Check Your Information and Confirm the Newsletter</strong></div>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + newsletter.id + '" required>');
				inputN = $('<div class="form-group"><label for="title">Title</label><input id="title" name="title" type="text" class="form-control" placeholder="Title" value="' + newsletter.title + '" required></div>');
				inputL = $('<div class="form-group"><label for="message">Message</label><textarea id="message" class="form-control" name="message" rows="4" cols="50" placeholder="Message">' + newsletter.message + '</textarea></div>');

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();

				$('.modal-title').append('Edit Newsletter');
				$('.modal-body').append(box);

				$('#NewsForm').append(alert);
				$('#NewsForm').append(inputI);
				$('#NewsForm').append(inputN);
				$('#NewsForm').append(inputL);

				$('.modal-footer').append("<div id='newsButts'></div>");
				closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">Close</button>');
				makeBut = $("<button type='button' class='btn btn-alternative' name='button' id='newsCont'>Make</button>");
				addMakeENewsButton(makeBut);

				$('#newsButts').append(makeBut);
				$('#newsButts').append(closeBut);
			});
		};

		/* Make User Button For editing */


		var addMakeENewsButton = function addMakeENewsButton(makeBut) {

			$('#NewsForm').validate({
				rules: {
					title: {
						required: true,
						minlength: 2
					},
					message: {
						required: true,
						minlength: 2
					}
				}
			});
			makeBut.click(function (e) {
				if ($('#NewsForm').valid()) {

					alterForm('#NewsForm', true);

					$('#newsCont').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' class='btn btn-alternative-success btn-alternative' name='button' id='newsConf'>Confirm</button>");
					backBut = $("<button type='button' class='btn btn-alternative' name='button' id='newsBack'>Back</button>");
					backButton(backBut, '#NewsForm', 'news');
					confirmEnewsButton(confirmBut);
					$('#newsButts').prepend(backBut);
					$('#newsButts').prepend(confirmBut);
				}
			});
		};

		/* Confirm Button For Editing User */


		var confirmEnewsButton = function confirmEnewsButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();
				title = $('#title').val();
				message = $('#message').val();

				$.ajax({

					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/newsletter/update',
					type: 'POST',
					dataType: "json",
					data: { id: id, title: title, message: message },
					success: function success(data) {
						$('#form_newsletter_search').trigger("submit");
						$('#newsMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append('Newsletter Edited Sucessfully');
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#newsAlertMod').modal('show');
					},
					error: function error(_error31) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append('An error has ocurred');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#newsAlertMod').modal('show');
					}
				});
			});
		};

		/* Delete Function For User */


		var addMakeDnewsButton = function addMakeDnewsButton(delButt, news) {
			delButt.click(function () {
				box = $("<form class='NewsForm' id='NewsForm' enctype='multipart/form-data'></form>");
				alert = $('<h4><strong>Are You Sure for delete ' + news.title + ' Newsletter?</strong></h4>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + news.id + '" required>');

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append('Delete Newsletter');
				$('.modal-body').append(box);

				$('#NewsForm').append(alert);
				$('#NewsForm').append(inputI);

				$('.modal-footer').append("<div id='newsButts'></div>");

				closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">Close</button>');
				makeBut = $("<button type='button' name='button' class='btn btn-alternative-danger btn-alternative' id='newsCont'>Delete</button>");

				DeleteNewsButton(makeBut);

				$('#newsButts').append(makeBut);
				$('#newsButts').append(closeBut);
			});
		};

		/* Confirmation Of User Deletion */


		var DeleteNewsButton = function DeleteNewsButton(delButt) {
			delButt.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/newsletter/delete',
					type: 'POST',
					dataType: "json",
					data: { id: id },
					success: function success(data) {
						$('#form_newsletter_search').trigger("submit");
						$('#newsMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append('Newsletter Deleted Sucessfully');
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#newsAlertMod').modal('show');
					},
					error: function error(_error32) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append('An error has ocurred');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#newsAlertMod').modal('show');
					}
				});
			});
		};

		/*Execute Script*/


		/*Search User Table*/
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$('.listnews').addClass('active');

		$('#table_newsletter_header_title').click(function (e) {
			orderTableNewsletterBy('title');
		});

		$('#table_newsletter_header_username').click(function (e) {
			orderTableNewsletterBy('username');
		});

		$('#table_newsletter_header_message').click(function (e) {
			orderTableNewsletterBy('message');
		});

		$('#table_newsletter_header_date').click(function (e) {
			orderTableNewsletterBy('created_at');
		});

		$('#table_newsletter_header_update').click(function (e) {
			orderTableNewsletterBy('updated_at');
		});

		var orderNewsletterBy = "";
		var orderNewsletterDirection = "";
		var searchNewsletterValue = "";

		$("#form_newsletter_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchNewsletterValue = $("#search_newsletter_value").val();
			searchNewsletter(1);
		});

		$('.btn-create').click(function () {

			box = $("<form class='NewsForm' id='NewsForm' enctype='multipart/form-data' ></form>");
			alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 1) + ' ' + Lang.get('messages.newsletter') + '</strong></div>');
			inputN = $('<div class="form-group"><label for="title">Title</label><input id="title" name="title" type="text" class="form-control" placeholder="Title" required></div>');
			inputL = $('<div class="form-group"><label for="message">Message</label><textarea id="message" class="form-control" name="message" rows="4" cols="50" placeholder="Message"></textarea></div>');

			$('.modal-title').empty();
			$('.modal-body').empty();
			$('.modal-footer').empty();

			$('.modal-title').append('Create Newsletter');
			$('.modal-body').append(box);

			$('#NewsForm').append(alert);
			$('#NewsForm').append(inputN);
			$('#NewsForm').append(inputL);

			$('.modal-footer').append("<div id='newsButts'></div>");

			closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">Close</button>');
			makeBut = $("<button type='button' name='button' class='btn btn-alternative' id='newsCont'>Make</button>");
			addMakeNewsButton(makeBut);

			$('#newsButts').append(makeBut);
			$('#newsButts').append(closeBut);
		});$('#result_newsletter_page').change(function () {
			$('#form_newsletter_search').trigger("submit");
		});

		$('#form_newsletter_search').trigger("submit");
	}
	/* End Newsletter Functions */

	/* Begin Account Functions */
	if (pathverify('/account') && !pathverify('/settings')) {
		var _orderTableAccountBy = function _orderTableAccountBy(by) {
			if (orderAccountBy === by) {
				if (orderAccouDirection === "") {
					orderAccountDirection = "DESC";
				} else {
					orderAccountDirection = "";
				}
			} else {
				orderAccountBy = by;
				orderAccountDirection = "";
			}
			_searchAccount(1);
		};

		//Get Newsletter Data

		var _searchAccount = function _searchAccount(page) {
			resultPage = $("#result_newsletter_page").val();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/account",
				type: 'post',
				data: { searchvalue: searchAccountValue, page: page, orderBy: orderAccountBy, orderDirection: orderAccountDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var accounts = data.result;

					if (accounts.length == 0) {
						$("#table_account_content").html("");
						$('#table_account_content').append('<tr><td colspan="6">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						$("#table_account_content").html("");
						for (i = 0; i < accounts.length; i++) {
							var account = accounts[i];

							var rowResult = $('<tr></tr>');

							var colvalue_1 = $('<td>' + account.type + '</td>');
							var colvalue_2 = $('<td>' + account.coin + '</td>');
							var colvalue_2 = $('<td>' + account.address + '</td>');
							var colvalue_3 = $('<td>' + account.entity + '</td>');
							var colvalue_4 = $('<td>' + account.created_at + '</td>');
							var colvalue_5 = $('<td>' + account.updated_at + '</td>');
							var colvalue_6 = $('<td></td>');

							editBut = $('<button type="button"  data-toggle="modal" data-target="#accMod" id="editBut" class="btn btn-alternative btn-sm">' + Lang.get('messages.edit') + '</button>');
							delBut = $('<button type="button"  data-toggle="modal" data-target="#accMod" id="delBut" class="btn btn-alternative-danger btn-alternative btn-sm">' + Lang.get('messages.delete') + '</button>');

							// we have to make in steps to add the onclick event
							addEditAccountClick(editBut, account);
							addMakeDAccountButton(delBut, account);

							colvalue_6.append(editBut);
							colvalue_6.append(delBut);

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);

							$("#table_account_content").append(rowResult);
						}

						pagination("#table_account_pagination", "#result_account_page", data.page, data.total, _addPageACButton);
					}
					// Put the data into the element you care about.
				},
				// Fin
				error: function error(_error33) {
					ReadError(_error33);
				}
			});
		};

		var _addPageACButton = function _addPageACButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				_searchAccount(page);
			});
		};

		var _DWcurrencies = function _DWcurrencies(select, type) {
			var selected = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/currencies/name",
				type: 'post',
				datatype: 'json',
				data: { type: type },
				success: function success(data) {
					currencies = data.result;
					$(select).empty();
					for (i = 0; i < currencies.length; i++) {
						currency = currencies[i];
						console.log(currency);
						console.log(select);
						if (selected == currency.symbol) {
							$(select).append('<option value="' + currency.symbol + '" selected>' + currency.name + '</option>');
						} else {
							console.log('enter here');
							$(select).append('<option value="' + currency.symbol + '">' + currency.name + '</option>');
						}
					}
				},
				// Fin
				error: function error(_error34) {
					ReadError(_error34);
				}
			});
		};

		/* Modal Create Account */

		/*Make Button For Create News*/
		var addMakeAccButton = function addMakeAccButton(makeBut) {

			$('#AccountForm').validate({
				rules: {
					typeA: {
						required: true
					},
					entity: {
						required: true
					},
					address: {
						required: true,
						minlength: 7
					}
				}
			});

			makeBut.click(function (e) {
				if ($('#AccountForm').valid()) {

					alterForm('#AccountForm', true);

					$('#accCont').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' name='button' class='btn btn-alternative-success btn-alternative' id='accConf'>" + Lang.get('messages.confirm') + "</button>");
					backBut = $("<button type='button' name='button' class='btn btn-alternative' id='accBack'>" + Lang.get('messages.back') + "</button>");
					backButton(backBut, '#AccountForm', 'acc');
					confirmaccButton(confirmBut);
					$('#accButts').prepend(backBut);
					$('#accButts').prepend(confirmBut);
				}
			});
		};

		/* Confirm User For Creation */


		var confirmaccButton = function confirmaccButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				type1 = $('#typeA').val();
				entity = $('#entity').val();
				address = $('#address').val();
				coin = $('#coin').val();
				$.ajax({

					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/account/create',
					type: 'POST',
					dataType: "json",
					data: { type1: type1, entity: entity, address: address, symbol: coin },
					success: function success(data) {
						$('#form_account_search').trigger("submit");
						$('#accMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.account') + ' ' + Lang.get('messages.created') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#accAlertMod').modal('show');
					},
					error: function error(_error35) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						if (_error35.responseJSON.error) {
							$('.text-alert').append(_error35.responseJSON.error);
						} else {
							$('.text-alert').append(Lang.get('messages.error'));
						}
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#accAlertMod').modal('show');
					}
				});
			});
		};

		/*Edit Button With Modal edition for Users*/


		var addEditAccountClick = function addEditAccountClick(buttonEdit, account) {
			buttonEdit.click(function () {
				box = $("<form class='AccountForm' id='AccountForm' enctype='multipart/form-data' ></form>");
				alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 2) + ' ' + Lang.get('messages.account') + '</strong></div>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + account.id + '" required>');

				inputT = $('<div class="form-group"><label for="type">Type</label><select class="form-control" name="type" id="type"></select></div>');
				inputC = $('<div class="form-group" id="coinBox"><label for="coin">' + Lang.get('messages.currency') + '</label><select class="form-control" name="coin" id="coin"></select></div>');
				inputE = $('<div class="form-group" id="entitych"><label for="entity">' + Lang.get('messages.entity') + '</label><select id="entity" name="entity" type="text" class="form-control" placeholder="' + Lang.get('messages.entity') + '" value="' + account.entity + '" required></select></div>');
				inputA = $('<div class="form-group"><label for="address">' + Lang.get('messages.address') + ' de Moneda</label><input id="address" class="form-control" name="address" rows="4" cols="50"  value="' + account.address + '" placeholder="' + Lang.get('messages.address') + '"/></div>');

				options = [/*['bank', Lang.get('messages.bank') + ' ' + Lang.get('messages.account')],*/['crypto', Lang.get('messages.cryptocurrency')]];

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();

				$('.modal-title').append(Lang.get('messages.edit') + ' ' + Lang.get('messages.account'));
				$('.modal-body').append(box);

				$('#AccountForm').append(alert);
				$('#AccountForm').append(inputI);
				$('#AccountForm').append(inputT);
				//$('#AccountForm').append(inputC);
				$('#AccountForm').append(inputE);
				$('#AccountForm').append(inputA);

				for (i = 0; i < options.length; i++) {
					option = options[i];
					if (account.type == option[0]) {
						$('#type').append('<option value="' + option[0] + '" selected>' + option[1] + '</option>');
					} else {
						$('#type').append('<option value="' + option[0] + '">' + option[1] + '</option>');
					}
				}

				$('#type').change(function () {
					type = $('#type').val();
					if (type == 'bank') {
						$("#entitych").html('<input id="entity" name="entity" type="text" class="form-control" placeholder="' + Lang.get('messages.entity') + '" required>');
						$("#labelA").html(Lang.get('messages.account') + ' ' + Lang.get('messages.bank'));
						$('#coinBox').show();
						_DWcurrencies('#coin', 'FIAT');
					} else {
						$("#entitych").html('<select class="form-control" name="entity" id="entity"></select>');
						_DWcurrencies('#entity', 'Cryptocurrency');
						$("#labelA").html(Lang.get('messages.address'));
						$('#coinBox').hide();
					}
				});
				_DWcurrencies('#entity', 'Cryptocurrency');

				$('.modal-footer').append("<div id='accButts'></div>");
				closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				makeBut = $("<button type='button' class='btn btn-alternative' name='button' id='accCont'>" + Lang.get('messages.make') + "</button>");
				addMakeEaccButton(makeBut);

				$('#accButts').append(makeBut);
				$('#accButts').append(closeBut);
			});
		};

		/* Make User Button For editing */


		var addMakeEaccButton = function addMakeEaccButton(makeBut) {

			$('#AccountForm').validate({
				rules: {
					type: {
						required: true
					},
					entity: {
						required: true
					},
					address: {
						required: true,
						minlength: 7
					}
				}
			});
			makeBut.click(function (e) {
				if ($('#AccountForm').valid()) {

					alterForm('#AccountForm', true);

					$('#accCont').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' class='btn btn-alternative-success btn-alternative' name='button' id='accConf'>" + Lang.get('messages.confirm') + "</button>");
					backBut = $("<button type='button' class='btn btn-alternative' name='button' id='accBack'>" + Lang.get('messages.back') + "</button>");
					backButton(backBut, '#AccountForm', 'acc');
					confirmEaccButton(confirmBut);
					$('#accButts').prepend(backBut);
					$('#accButts').prepend(confirmBut);
				}
			});
		};

		/* Confirm Button For Editing User */


		var confirmEaccButton = function confirmEaccButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();
				type2 = $('#type').val();
				entity = $('#entity').val();
				address = $('#address').val();
				coin = $('#coin').val();
				$.ajax({

					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/account/update',
					type: 'POST',
					dataType: "json",
					data: { id: id, type: type2, entity: entity, address: address, symbol: coin },
					success: function success(data) {
						$('#form_account_search').trigger("submit");
						$('#accMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.account') + ' ' + Lang.get('messages.edited') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#accAlertMod').modal('show');
					},
					error: function error(_error36) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#accAlertMod').modal('show');
					}
				});
			});
		};

		/* Delete Function For User */


		var addMakeDAccountButton = function addMakeDAccountButton(delButt, acc) {
			delButt.click(function () {
				box = $("<form class='AccountForm' id='AccountForm' enctype='multipart/form-data'></form>");
				alert = $('<h4><strong>' + Lang.get('messages.sure') + ' ' + Lang.choice('messages.the', 2) + ' ' + Lang.get('messages.account') + '#' + acc.address + '?</strong></h4>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + acc.id + '" required>');

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append(Lang.get('messages.delete') + ' ' + Lang.get('messages.account'));
				$('.modal-body').append(box);

				$('#AccountForm').append(alert);
				$('#AccountForm').append(inputI);

				$('.modal-footer').append("<div id='accButts'></div>");

				closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				makeBut = $("<button type='button' name='button' class='btn btn-alternative-danger btn-alternative' id='accCont'>" + Lang.get('messages.delete') + "</button>");

				DeleteAccButton(makeBut);

				$('#accButts').append(makeBut);
				$('#accButts').append(closeBut);
			});
		};

		/* Confirmation Of User Deletion */


		var DeleteAccButton = function DeleteAccButton(delButt) {
			delButt.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/account/delete',
					type: 'POST',
					dataType: "json",
					data: { id: id },
					success: function success(data) {
						$('#form_account_search').trigger("submit");
						$('#accMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.account') + ' ' + Lang.get('messages.deleted') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#accAlertMod').modal('show');
					},
					error: function error(_error37) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#accAlertMod').modal('show');
					}
				});
			});
		};

		/*Execute Script*/


		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		/*Search Account Table*/

		$('.listaccount').addClass('active');

		$('#table_account_header_type').click(function (e) {
			_orderTableAccountBy('type');
		});

		$('#table_account_header_address').click(function (e) {
			_orderTableAccountBy('address');
		});

		$('#table_account_header_entity').click(function (e) {
			_orderTableAccountBy('entity');
		});

		$('#table_account_header_date').click(function (e) {
			_orderTableAccountBy('created_at');
		});

		$('#table_account_header_update').click(function (e) {
			_orderTableAccountBy('updated_at');
		});

		var orderAccountBy = "";
		var orderAccountDirection = "";
		var searchAccountValue = "";

		$("#form_account_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchAccountValue = $("#search_account_value").val();
			_searchAccount(1);
		});

		$('.btn-create').click(function () {

			box = $("<form class='AccountForm' id='AccountForm' enctype='multipart/form-data' ></form>");
			alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 2) + ' ' + Lang.get('messages.account') + '</strong></div>');
			inputT = $('<div class="form-group"><label for="type1">' + Lang.get('messages.type') + '</label><select class="form-control" name="typeA" id="typeA"></select></div>');
			inputC = $('<div class="form-group" id="coinBox"><label for="coin">' + Lang.get('messages.currency') + '</label><select class="form-control" name="coin" id="coin"></select></div>');
			inputE = $('<div class="form-group"><label for="entity">' + Lang.get('messages.entity') + '</label><div id="entitych"><select class="form-control" name="entity" id="entity"></select></div></div>');
			inputA = $('<div class="form-group"><label for="address" id="labelA">' + Lang.get('messages.address') + ' de Moneda</label><input id="address" class="form-control" name="address" rows="4" cols="50" placeholder="' + Lang.get('messages.address') + '"/></div>');

			options = [['crypto', Lang.get('messages.cryptocurrency')], ['bank', Lang.get('messages.bank') + ' ' + Lang.get('messages.account')]];

			$('.modal-title').empty();
			$('.modal-body').empty();
			$('.modal-footer').empty();

			$('.modal-title').append(Lang.get('messages.create') + ' ' + Lang.get('messages.account'));
			$('.modal-body').append(box);

			$('#AccountForm').append(alert);
			$('#AccountForm').append(inputT);
			$('#AccountForm').append(inputC);
			$('#AccountForm').append(inputE);
			$('#AccountForm').append(inputA);

			for (i = 0; i < options.length; i++) {
				var option = options[i];
				$('#typeA').append('<option value="' + option[0] + '">' + option[1] + '</option>');
			}

			$('#typeA').change(function () {
				type = $('#typeA').val();
				if (type == 'bank') {
					$("#entitych").html('<input id="entity" name="entity" type="text" class="form-control" placeholder="' + Lang.get('messages.entity') + '" required>');
					$("#labelA").html(Lang.get('messages.account') + ' ' + Lang.get('messages.bank'));
					$('#coinBox').show();
					_DWcurrencies('#coin', 'FIAT');
				} else {
					$("#entitych").html('<select class="form-control" name="entity" id="entity"></select>');
					$("#labelA").html(Lang.get('messages.address'));
					_DWcurrencies('#entity', 'Cryptocurrency');
					$('#coinBox').hide();
				}
			});
			_DWcurrencies('#entity', 'Cryptocurrency');
			$('.modal-footer').append("<div id='accButts'></div>");

			closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
			makeBut = $("<button type='button' name='button' class='btn btn-alternative' id='accCont'>" + Lang.get('messages.make') + "</button>");
			addMakeAccButton(makeBut);
			$('#coinBox').hide();

			$('#accButts').append(makeBut);
			$('#accButts').append(closeBut);
		});$('#result_account_page').change(function () {
			$('#form_account_search').trigger("submit");
		});

		$('#form_account_search').trigger("submit");
	}
	/* End Account Functions */

	/* Begin Account Functions */
	if (pathverify('/settings/account')) {
	    var url = globalUrl;
	    if(globalUrl == ""){
	        url = ".";
	    }
		var _orderTableAccountBy2 = function _orderTableAccountBy2(by) {
			if (orderAccountBy === by) {
				if (orderAccouDirection === "") {
					orderAccountDirection = "DESC";
				} else {
					orderAccountDirection = "";
				}
			} else {
				orderAccountBy = by;
				orderAccountDirection = "";
			}
			_searchAccount2(1);
		};

		//Get Newsletter Data
		var _searchAccount2 = function _searchAccount2(page) {
			resultPage = $("#result_account_page").val();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: url+"./account",
				type: 'post',
				data: { searchvalue: searchAccountValue, page: page, orderBy: orderAccountBy, orderDirection: orderAccountDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var accounts = data.result;

					if (accounts.length == 0) {
						$("#table_account_content").html("");
						$('#table_account_content').append('<tr><td colspan="9">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						$("#table_account_content").html("");
						for (i = 0; i < accounts.length; i++) {
							var account = accounts[i];

							var rowResult = $('<tr></tr>');
							if (account.user == null) {
								var colvalue_0 = $('<td>' + Lang.get('messages.deposit') + ' ' + Lang.get('messages.address') + '</td>');
							} else {
								var colvalue_0 = $('<td>' + account.user + '</td>');
							}
							var colvalue_1 = $('<td>' + account.user_id + '</td>');
							var colvalue_2 = $('<td>' + account.type + '</td>');
							var colvalue_3 = $('<td>' + account.coin + '</td>');
							var colvalue_4 = $('<td>' + account.address + '</td>');
							var colvalue_5 = $('<td>' + account.entity + '</td>');
							var colvalue_6 = $('<td>' + account.created_at + '</td>');
							var colvalue_7 = $('<td>' + account.updated_at + '</td>');
							var colvalue_8 = $('<td></td>');

							editBut = $('<button type="button"  data-toggle="modal" data-target="#accMod" id="editBut" class="btn btn-alternative btn-sm">' + Lang.get('messages.edit') + '</button>');
							delBut = $('<button type="button"  data-toggle="modal" data-target="#accMod" id="delBut" class="btn btn-alternative-danger btn-alternative btn-sm">' + Lang.get('messages.delete') + '</button>');
							if (data.eaccess && !account.verify) {
								verBut = $('<button type="button"  data-toggle="modal" data-target="#accMod" id="editBut" class="btn btn-alternative btn-alternative-success btn-sm">' + Lang.get('messages.verify') + '</button>');
								addVerifyAccountButton(verBut, account);
								colvalue_8.append(verBut);
							}
							// we have to make in steps to add the onclick event
							_addEditAccountClick(editBut, account);
							_addMakeDAccountButton(delBut, account);

							colvalue_8.append(editBut);
							colvalue_8.append(delBut);

							rowResult.append(colvalue_0);
							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);
							rowResult.append(colvalue_7);
							rowResult.append(colvalue_8);

							$("#table_account_content").append(rowResult);
						}

						pagination("#table_account_pagination", "#result_account_page", data.page, data.total, _addPageACButton2);
					}
					// Put the data into the element you care about.
				},
				// Fin
				error: function error(_error38) {
					ReadError(_error38);
				}
			});
		};

		var _addPageACButton2 = function _addPageACButton2(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				_searchAccount2(page);
			});
		};

		var _DWcurrencies2 = function _DWcurrencies2(select, type) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: url+"./currencies/name",
				type: 'post',
				datatype: 'json',
				data: { type: type },
				success: function success(data) {
					currencies = data.result;
					$(select).empty();
					for (i = 0; i < currencies.length; i++) {
						currency = currencies[i];
						$(select).append('<option value="' + currency.symbol + '">' + currency.name + '</option>');
					}
				},
				// Fin
				error: function error(_error39) {
					ReadError(_error39);
				}
			});
		};

		/* Modal Create Account */

		/*Make Button For Create News*/
		var _addMakeAccButton = function _addMakeAccButton(makeBut) {

			$('#AccountForm').validate({
				rules: {
					typeA: {
						required: true
					},
					entity: {
						required: true
					},
					address: {
						required: true,
						minlength: 7
					}
				}
			});

			makeBut.click(function (e) {
				if ($('#AccountForm').valid()) {

					alterForm('#AccountForm', true);

					$('#accCont').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' name='button' class='btn btn-alternative-success btn-alternative' id='accConf'>" + Lang.get('messages.confirm') + "</button>");
					backBut = $("<button type='button' name='button' class='btn btn-alternative' id='accBack'>" + Lang.get('messages.back') + "</button>");
					backButton(backBut, '#AccountForm', 'acc');
					_confirmaccButton(confirmBut);
					$('#accButts').prepend(backBut);
					$('#accButts').prepend(confirmBut);
				}
			});
		};

		/* Confirm User For Creation */


		var _confirmaccButton = function _confirmaccButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				type1 = $('#typeA').val();
				entity = $('#entity').val();
				address = $('#address').val();
				coin = $('#coin').val();
				$.ajax({

					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: url+'./account/create',
					type: 'POST',
					dataType: "json",
					data: { type1: type1, entity: entity, address: address, symbol: coin },
					success: function success(data) {
						$('#form_account_search').trigger("submit");
						$('#accMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.account') + ' ' + Lang.get('messages.created') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#accAlertMod').modal('show');
					},
					error: function error(_error40) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						if (_error40.responseJSON.error) {
							$('.text-alert').append(_error40.responseJSON.error);
						} else {
							$('.text-alert').append(Lang.get('messages.error'));
						}
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#accAlertMod').modal('show');
					}
				});
			});
		};

		/*Edit Button With Modal edition for Users*/


		var _addEditAccountClick = function _addEditAccountClick(buttonEdit, account) {
			buttonEdit.click(function () {
				box = $("<form class='AccountForm' id='AccountForm' enctype='multipart/form-data' ></form>");
				alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 2) + ' ' + Lang.get('messages.account') + '</strong></div>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + account.id + '" required>');

				inputT = $('<div class="form-group"><label for="type">Type</label><select class="form-control" name="type" id="type"></select></div>');
				inputC = $('<div class="form-group" id="coinBox"><label for="coin">' + Lang.get('messages.currency') + '</label><select class="form-control" name="coin" id="coin"></select></div>');
				inputE = $('<div class="form-group" id="entitych"><label for="entity">' + Lang.get('messages.entity') + '</label><input id="entity" name="entity" type="text" class="form-control" placeholder="' + Lang.get('messages.entity') + '" value="' + account.entity + '" required></div>');
				inputA = $('<div class="form-group"><label for="address">' + Lang.get('messages.address') + '</label><input id="address" class="form-control" name="address" rows="4" cols="50"  value="' + account.address + '" placeholder="' + Lang.get('messages.address') + '"/></div>');

				options = [['bank', Lang.get('messages.bank') + ' ' + Lang.get('messages.account')], ['crypto', Lang.get('messages.cryptocurrency')]];

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();

				$('.modal-title').append(Lang.get('messages.edit') + ' ' + Lang.get('messages.account'));
				$('.modal-body').append(box);

				$('#AccountForm').append(alert);
				$('#AccountForm').append(inputI);
				$('#AccountForm').append(inputT);
				$('#AccountForm').append(inputC);
				$('#AccountForm').append(inputE);
				$('#AccountForm').append(inputA);

				for (i = 0; i < options.length; i++) {
					option = options[i];
					if (account.type == option[0]) {
						$('#type').append('<option value="' + option[0] + '" selected>' + option[1] + '</option>');
					} else {
						$('#type').append('<option value="' + option[0] + '">' + option[1] + '</option>');
					}
				}

				$('#type').change(function () {
					type = $('#type').val();
					if (type == 'bank') {
						$("#entitych").html('<input id="entity" name="entity" type="text" class="form-control" placeholder="' + Lang.get('messages.entity') + '" required>');
						$('#coinBox').show();
					} else {
						$("#entitych").html('<select class="form-control" name="entity" id="entity"></select>');
						_DWcurrencies2('#entity', 'Cryptocurrency');
						$('#coinBox').hide();
					}
				});
				_DWcurrencies2('#coin', 'FIAT');

				$('.modal-footer').append("<div id='accButts'></div>");
				closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				makeBut = $("<button type='button' class='btn btn-alternative' name='button' id='accCont'>" + Lang.get('messages.make') + "</button>");
				_addMakeEaccButton(makeBut);

				$('#accButts').append(makeBut);
				$('#accButts').append(closeBut);
			});
		};

		/* Make User Button For editing */


		var _addMakeEaccButton = function _addMakeEaccButton(makeBut) {

			$('#AccountForm').validate({
				rules: {
					type: {
						required: true
					},
					entity: {
						required: true
					},
					address: {
						required: true,
						minlength: 7
					}
				}
			});
			makeBut.click(function (e) {
				if ($('#AccountForm').valid()) {

					alterForm('#AccountForm', true);

					$('#accCont').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' class='btn btn-alternative-success btn-alternative' name='button' id='accConf'>" + Lang.get('messages.confirm') + "</button>");
					backBut = $("<button type='button' class='btn btn-alternative' name='button' id='accBack'>" + Lang.get('messages.back') + "</button>");
					backButton(backBut, '#AccountForm', 'acc');
					_confirmEaccButton(confirmBut);
					$('#accButts').prepend(backBut);
					$('#accButts').prepend(confirmBut);
				}
			});
		};

		/* Confirm Button For Editing User */


		var _confirmEaccButton = function _confirmEaccButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();
				type2 = $('#type').val();
				entity = $('#entity').val();
				address = $('#address').val();
				coin = $('#coin').val();
				$.ajax({

					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: url+'./account/update',
					type: 'POST',
					dataType: "json",
					data: { id: id, type: type2, entity: entity, address: address, symbol: coin },
					success: function success(data) {
						$('#form_account_search').trigger("submit");
						$('#accMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.account') + ' ' + Lang.get('messages.edited') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#accAlertMod').modal('show');
					},
					error: function error(_error41) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#accAlertMod').modal('show');
					}
				});
			});
		};

		/* Delete Function For User */


		var _addMakeDAccountButton = function _addMakeDAccountButton(delButt, acc) {
			delButt.click(function () {
				box = $("<form class='AccountForm' id='AccountForm' enctype='multipart/form-data'></form>");
				alert = $('<h4><strong>' + Lang.get('messages.sure') + ' ' + Lang.choice('messages.the', 2) + ' ' + Lang.get('messages.account') + '#' + acc.address + '?</strong></h4>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + acc.id + '" required>');

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append(Lang.get('messages.delete') + ' ' + Lang.get('messages.account'));
				$('.modal-body').append(box);

				$('#AccountForm').append(alert);
				$('#AccountForm').append(inputI);

				$('.modal-footer').append("<div id='accButts'></div>");

				closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				makeBut = $("<button type='button' name='button' class='btn btn-alternative-danger btn-alternative' id='accCont'>" + Lang.get('messages.delete') + "</button>");

				_DeleteAccButton(makeBut);

				$('#accButts').append(makeBut);
				$('#accButts').append(closeBut);
			});
		};

		/* Confirmation Of User Deletion */


		var _DeleteAccButton = function _DeleteAccButton(delButt) {
			delButt.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: url+'./account/delete',
					type: 'POST',
					dataType: "json",
					data: { id: id },
					success: function success(data) {
						$('#form_account_search').trigger("submit");
						$('#accMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.account') + ' ' + Lang.get('messages.deleted') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#accAlertMod').modal('show');
					},
					error: function error(_error42) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#accAlertMod').modal('show');
					}
				});
			});
		};

		/*Edit Button With Modal edition for Users*/


		var addVerifyAccountButton = function addVerifyAccountButton(buttonVeri, account) {
			buttonVeri.click(function () {
				box = $("<form class='AccountForm' id='AccountForm' enctype='multipart/form-data' ></form>");
				alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>Please Check Your Information and Confirm the Account</strong></div>');
				alertB = $('<div><strong>' + Lang.get('messages.sure') + ' ' + Lang.get('messages.to') + ' ' + Lang.get('messages.validate') + ' ' + Lang.choice('messages.the', 2) + ' ' + Lang.get('messages.account') + ' #' + account.address + '?</strong></div>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + account.id + '" required>');

				if (account.type == 'crypto') {
					inputT = $('<div class="form-group"><label for="key">' + Lang.get('messages.key') + ' ' + Lang.get('messages.address') + '</label><input id="key" name="key" type="text" class="form-control" placeholder="' + Lang.get('messages.key') + '" value="" required></div>');
				}

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();

				$('.modal-title').append(Lang.get('messages.verify') + ' ' + Lang.get('messages.account'));
				$('.modal-body').append(box);

				$('#AccountForm').append(alert);
				$('#AccountForm').append(alertB);
				$('#AccountForm').append(inputI);
				if (account.type == 'crypto') {
					$('#AccountForm').append(inputT);
				}

				$('.modal-footer').append("<div id='accButts'></div>");

				closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');

				if (account.type == 'crypto') {
					makeBut = $("<button type='button' class='btn btn-alternative' name='button' id='accCont'>" + Lang.get('messages.make') + "</button>");
					addMakeVaccButton(makeBut);
				} else {
					makeBut = $("<button type='button' class='btn btn-alternative' name='button' id='accCont'>" + Lang.get('messages.confirm') + "</button>");
					confirmVaccButton(makeBut);
				}

				$('#accButts').append(makeBut);
				$('#accButts').append(closeBut);
			});
		};

		/* Make User Button For editing */


		var addMakeVaccButton = function addMakeVaccButton(makeBut) {

			$('#AccountForm').validate({
				rules: {
					key: {
						required: true
					}
				}
			});
			makeBut.click(function (e) {
				if ($('#AccountForm').valid()) {

					alterForm('#AccountForm', true);

					$('#accCont').hide();
					$('.alert').show();
					confirmBut = $("<button type='button' class='btn btn-alternative-success btn-alternative' name='button' id='accConf'>" + Lang.get('messages.confirm') + "</button>");
					backBut = $("<button type='button' class='btn btn-alternative' name='button' id='accBack'>" + Lang.get('messages.back') + "</button>");
					backButton(backBut, '#AccountForm', 'acc');
					confirmVaccButton(confirmBut);
					$('#accButts').prepend(backBut);
					$('#accButts').prepend(confirmBut);
				}
			});
		};

		/* Confirm Button For Editing User */


		var confirmVaccButton = function confirmVaccButton(confirmBut) {
			confirmBut.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();
				key = $('#key').val();

				$.ajax({

					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: url+'./account/verify',
					type: 'POST',
					dataType: "json",
					data: { id: id, key: key },
					success: function success(data) {
						$('#form_account_search').trigger("submit");
						$('#accMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.account') + ' ' + Lang.get('messages.verify') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#accAlertMod').modal('show');
					},
					error: function error(_error43) {
						confirmBut.removeClass('disabled');
						confirmBut.prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#accAlertMod').modal('show');
					}
				});
			});
		};

		/*Execute Script*/


		/*Search Account Table*/
		
		var urlimg = globalImgUrl;
		if(globalUrl==""){
		    urlimg = "."+globalImgUrl;
		}
		$('#body').css('background-image', 'url(".'+urlimg+'background/malla.jpg")');
		$('.listsetacc').addClass('active');

		$('#table_account_header_type').click(function (e) {
			_orderTableAccountBy2('type');
		});

		$('#table_account_header_user').click(function (e) {
			_orderTableAccountBy2('user');
		});

		$('#table_account_header_address').click(function (e) {
			_orderTableAccountBy2('address');
		});

		$('#table_account_header_entity').click(function (e) {
			_orderTableAccountBy2('entity');
		});

		$('#table_account_header_date').click(function (e) {
			_orderTableAccountBy2('created_at');
		});

		$('#table_account_header_update').click(function (e) {
			_orderTableAccountBy2('updated_at');
		});

		var orderAccountBy = "";
		var orderAccountDirection = "";
		var searchAccountValue = "";

		$("#form_account_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchAccountValue = $("#search_account_value").val();
			_searchAccount2(1);
		});

		$('.btn-create').click(function () {

			box = $("<form class='AccountForm' id='AccountForm' enctype='multipart/form-data' ></form>");
			alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 2) + ' ' + Lang.get('messages.account') + '</strong></div>');
			inputT = $('<div class="form-group"><label for="type1">' + Lang.get('messages.type') + '</label><select class="form-control" name="typeA" id="typeA"></select></div>');
			inputC = $('<div class="form-group" id="coinBox"><label for="coin">' + Lang.get('messages.currency') + '</label><select class="form-control" name="coin" id="coin"></select></div>');
			inputE = $('<div class="form-group"><label for="entity">' + Lang.get('messages.entity') + '</label><div id="entitych"><input id="entity" name="entity" type="text" class="form-control" placeholder="' + Lang.get('messages.entity') + '" required></div></div>');
			inputA = $('<div class="form-group"><label for="address">' + Lang.get('messages.address') + '</label><input id="address" class="form-control" name="address" rows="4" cols="50" placeholder="' + Lang.get('messages.address') + '"/></div>');

			options = [['bank', Lang.get('messages.bank') + ' ' + Lang.get('messages.account')], ['crypto', Lang.get('messages.cryptocurrency')]];

			$('.modal-title').empty();
			$('.modal-body').empty();
			$('.modal-footer').empty();

			$('.modal-title').append(Lang.get('messages.create') + ' ' + Lang.get('messages.account'));
			$('.modal-body').append(box);

			$('#AccountForm').append(alert);
			$('#AccountForm').append(inputT);
			$('#AccountForm').append(inputC);
			$('#AccountForm').append(inputE);
			$('#AccountForm').append(inputA);

			for (i = 0; i < options.length; i++) {
				var option = options[i];
				$('#typeA').append('<option value="' + option[0] + '">' + option[1] + '</option>');
			}

			$('#typeA').change(function () {
				type = $('#typeA').val();
				if (type == 'bank') {
					$("#entitych").html('<input id="entity" name="entity" type="text" class="form-control" placeholder="' + Lang.get('messages.entity') + '" required>');
					$('#coinBox').show();
				} else {
					$("#entitych").html('<select class="form-control" name="entity" id="entity"></select>');
					_DWcurrencies2('#entity', 'Cryptocurrency');
					$('#coinBox').hide();
				}
			});
			_DWcurrencies2('#coin', 'FIAT');
			$('.modal-footer').append("<div id='accButts'></div>");

			closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
			makeBut = $("<button type='button' name='button' class='btn btn-alternative' id='accCont'>" + Lang.get('messages.make') + "</button>");
			_addMakeAccButton(makeBut);

			$('#accButts').append(makeBut);
			$('#accButts').append(closeBut);
		});$('#result_account_page').change(function () {
			$('#form_account_search').trigger("submit");
		});

		$('#form_account_search').trigger("submit");
	}
	/* End Account Functions */

	/* Begin Orders Functions */

	if (pathverify('/orders')) {
		var btcExchange = function btcExchange() {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/currencies/exchangeable",
				type: 'post',
				success: function success(data) {
					currencies = data.result;

					for (i = 0; i < currencies.length; i++) {
						currency = currencies[i];
						id = '#btn' + currency.symbol;
						button = $('<button class="makeOrderbtn" id="' + id + '" type="button" name="button">' + currency.symbol + '</button>');
						$('.selectMakeOrder').append(button);
						selectCurrencyOrder(button, currency.symbol);
					}
					$('#btnBTC').trigger('click');
				}
			});
		};

		var tradeables = function tradeables(symbol) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/currencies/tradeable",
				data: { symbol: symbol },
				type: 'post',
				success: function success(data) {
					currencies = data.result;

					for (i = 0; i < currencies.length; i++) {
						currency = currencies[i];
						if (i == 0) {
							$('#currencyBuy').append('<option value="' + currency.symbol + '" selected>' + currency.name + '</option>');
							$('#currencySell').append('<option value="' + currency.symbol + '" selected>' + currency.name + '</option>');
						} else {
							$('#currencyBuy').append('<option value="' + currency.symbol + '">' + currency.name + '</option>');
							$('#currencySell').append('<option value="' + currency.symbol + '">' + currency.name + '</option>');
						}
					}
					$('#btnBTC').trigger('click');
				}
			});
		};

		var selectCurrencyOrder = function selectCurrencyOrder(button, currency) {

			button.click(function () {
				$('.selectbtn').removeClass('selectbtn');
				$(this).addClass('selectbtn');

				$('.orders').remove();

				box = $('<div class="orders"></div>');
				buy = $('<div class="orderBox" id="buy"><div class="titleOrder"><h3>Buy ' + currency + '</h3><p>Available <span id="availableBuy"></span></p></div></div>');
				buyform = $('<form class="OrderForm" id="BuyForm"></form>');

				buyform.append('<div><input id="altBuy" name="alt" style="display:none;" type="text" class="form-control" value="' + currency + '" disabled required></div>');
				inputcurrent = $('<div><input id="altSell" name="alt" style="display:none;" type="text" class="form-control" value="' + currency + '" disabled required></div>');
				buyselect = $('<div><label for="currency">Currency</label><select id="currencyBuy" class="form-control" name="currencybuy"></select></div>');
				sellselect = $('<div><label for="currency">Currency</label><select id="currencySell" class="form-control" name="currencysell"></select></div><div id="sellButts"><button type="button" name="button" id="MaxCuSell">Max</button><button type="button" name="button" id="Sell">Sell</button></div>');

				buyinput = $('<div id="amountD"><label for="amount">Amount</label><input id="amountBuy" name="amount" type="text" class="form-control" required></div><div id="buyButts"><button type="button" name="button" id="maxCuBuy">Max</button><button type="button" name="button" id="buyalt">Buy</button></div>');

				buyform.append('<div><input id="typeBuy" name="type" style="display:none;" type="text" class="form-control" value="buy" disabled required></div>');
				buyform.append(buyselect);
				buyform.append(buyinput);
				buy.append(buyform);

				sell = $('<div class="orderBox" id="sell"><div class="titleOrder"><h3>Sell ' + currency + '</h3><p>Available <span id="availableSell"></span></p></div></div>');
				sellform = $('<form class="OrderForm" id="SellForm"></form>');
				sellinput = $('<div id="amountD"><label for="amount">' + currency + ' Amount</label><input id="amountSell" name="amount" type="text" class="form-control" required=""></div>');

				sellform.append('<div><input id="typeSell" name="type" style="display:none;" type="text" class="form-control" value="sell" disabled required></div>');
				sellform.append(inputcurrent);
				sellform.append(sellinput);
				sellform.append(sellselect);
				sell.append(sellform);

				box.append(buy);
				box.append(sell);

				$('.makeOrder').prepend(box);

				formatInput('#amountSell');
				formatInput('#amountBuy');

				availableBalance('#currencyBuy', '#availableBuy', '', '');
				availableBalance('', '#availableSell', currency, '');

				selectMaxvalue('#maxCuBuy', '#amountBuy', 'buy');
				selectMaxvalue('#MaxCuSell', '#amountSell', 'sell');

				buySell('#buyalt', 'buy');
				buySell('#Sell', 'sell');

				tradeables(currency);

				$('#currencyBuy').trigger('change');
			});
		};

		var availableBalance = function availableBalance(selection, target, currency, type) {
			if (selection !== '') {
				$(selection).on('change', function () {
					currency = $(this).val();
					$.ajax({
						headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
						url: globalUrl+'/balance/available',
						type: 'POST',
						dataType: "json",
						data: { currency: currency },
						success: function success(data) {

							value = formatNumber.num(data.result.amount) + ' ' + currency;
							$(target).html(value);
						}
					});
				});
			} else if (currency !== '') {
				if (type == "max") {
					$.ajax({
						headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
						url: globalUrl+'/balance/available',
						type: 'POST',
						dataType: "json",
						data: { currency: currency },
						success: function success(data) {

							value = formatNumber.num(data.result.amount);
							$(target).val(value);
						}
					});
				} else {
					$.ajax({
						headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
						url: globalUrl+'/balance/available',
						type: 'POST',
						dataType: "json",
						data: { currency: currency },
						success: function success(data) {
							value = formatNumber.num(data.result.amount) + ' ' + currency;
							$(target).html(value);
						}
					});
				}
			}
		};

		var selectMaxvalue = function selectMaxvalue(button, target, type) {
			if (type == 'buy') {
				$(button).click(function () {
					currency = $('#currencyBuy').val();
					availableBalance('', target, currency, 'max');
				});
			} else if (type == 'sell') {
				$(button).click(function () {
					currency = $('#altSell').val();
					availableBalance('', target, currency, 'max');
				});
			}
		};

		var buySell = function buySell(button, type) {
			if (type == 'buy') {
				$(button).click(function () {
					alt = $('#altBuy').val();
					type = $('#typeBuy').val();
					currency = $('#currencyBuy').val();
					amount = $('#amountBuy').val().replace(/\./g, '');
					amount = amount.replace(/,/g, '.');

					$.ajax({
						headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
						url: globalUrl+'/balance/exhange',
						type: 'POST',
						dataType: "json",
						data: { currency: currency, amount: amount, type: type, alt: alt },
						success: function success(data) {
							alert(data.message);
							$('#form_order_search').trigger("submit");
						}
					});
				});
			} else if (type == 'sell') {
				$(button).click(function () {
					alt = $('#altSell').val();
					type = $('#typeSell').val();
					currency = $('#currencySell').val();
					amount = $('#amountSell').val().replace(/\./g, '');
					amount = amount.replace(/,/g, '.');

					$.ajax({
						headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
						url: globalUrl+'/balance/exchange',
						type: 'POST',
						dataType: "json",
						data: { currency: currency, amount: amount, type: type, alt: alt },
						success: function success(data) {
							alert(data.message);
							$('#form_order_search').trigger("submit");
						}
					});
				});
			}
		};

		/*Search Orders Table*/


		var orderTableOrderBy = function orderTableOrderBy(by) {
			if (orderOrderBy === by) {
				if (orderOrderDirection === "") {
					orderOrderDirection = "DESC";
				} else {
					orderOrderDirection = "";
				}
			} else {
				orderOrderBy = by;
				orderOrderDirection = "";
			}
			searchOrder(1);
		};

		//Get Order Dat

		var searchOrder = function searchOrder(page) {

			resultPage = $("#result_order_page").val();

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/orders",
				type: 'post',
				data: { searchvalue: searchOrderValue, page: page, orderBy: orderOrderBy, orderDirection: orderOrderDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var orders = data.result;

					if (orders.length == 0) {
						$("#table_order_content").html("");
						$('#table_order_content').append('<tr><td colspan="11">Ninguno</td></tr>');
					} else {
						$("#table_order_content").html("");
						for (i = 0; i < orders.length; i++) {
							var order = orders[i];
							// we have to make in steps to add the onclick event
							var rowResult = $('<tr></tr>');

							var colvalue_1 = $('<td>' + order.out_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_2 = $('<td>' + order.out_symbol + '/' + order.in_symbol + '</td>');
							var colvalue_3 = $('<td>' + order.in_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_4 = $('<td>' + order.trade_type + '</td>');
							var colvalue_5 = $('<td>' + order.rate.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_6 = $('<td>' + order.fee.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_7 = $('<td>' + order.reference + '</td>');
							var colvalue_9 = $('<td>' + order.ip + '</td>');
							var colvalue_10 = $('<td>' + order.ubication + '</td>');
							var colvalue_13 = $('<td>' + order.txid + '</td>');
							var colvalue_8 = $('<td>' + order.created_at + '</td>');
							var colvalue_11 = $('<td>' + order.status + '</td>');
							var colvalue_12 = $('<td></td>');

							if (order.status == 'pending') {
								var printbut = $("<button type='button' class='btn btn-alternative btn-alternative-blank' name='button' data-toggle='modal' data-target='#ordersMod' id='withPrint'>Eliminar</button>");
								addMakeDOrdersButton(printbut, order);
								colvalue_12.append(printbut);
							}

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);

							rowResult.append(colvalue_6);
							rowResult.append(colvalue_7);
							rowResult.append(colvalue_8);
							rowResult.append(colvalue_9);
							rowResult.append(colvalue_10);
							rowResult.append(colvalue_13);
							rowResult.append(colvalue_11);
							rowResult.append(colvalue_12);

							$("#table_order_content").append(rowResult);
						}

						pagination("#table_order_pagination", "#result_order_page", data.page, data.total, addPageOButton);
					}
					// Put the data into the element you care about.
				},
				// Fin
				error: function error(_error44) {
					ReadError(_error44);
				}
			});
		};

		var addPageOButton = function addPageOButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				searchOrder(page);
			});
		};

		/* Delete Function For User */
		var addMakeDOrdersButton = function addMakeDOrdersButton(delButt, acc) {
			delButt.click(function () {
				box = $("<form class='OrderForm' id='OrderForm' enctype='multipart/form-data'></form>");
				alert = $('<h4><strong>' + Lang.get('messages.sure') + ' ' + Lang.choice('messages.the', 2) + ' ' + Lang.get('messages.account') + '#' + acc.reference + '?</strong></h4>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + acc.id + '" required>');

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append(Lang.get('messages.delete') + ' ' + Lang.get('messages.order'));
				$('.modal-body').append(box);

				$('#OrderForm').append(alert);
				$('#OrderForm').append(inputI);

				$('.modal-footer').append("<div id='accButts'></div>");

				closeBut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				makeBut = $("<button type='button' name='button' class='btn btn-alternative-danger btn-alternative' id='accCont'>" + Lang.get('messages.delete') + "</button>");

				DeleteOrderButton(makeBut);

				$('#accButts').append(makeBut);
				$('#accButts').append(closeBut);
			});
		};

		/* Confirmation Of User Deletion */

		var DeleteOrderButton = function DeleteOrderButton(delButt) {
			delButt.click(function () {

				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/orders/delete',
					type: 'POST',
					dataType: "json",
					data: { id: id },
					success: function success(data) {
						$('#form_account_search').trigger("submit");

						$('#ordersMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.account') + ' ' + Lang.get('messages.deleted') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');

						$('#orAlertMod').modal('show');
					},
					error: function error(_error45) {

						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');

						$('#orAlertMod').modal('show');
					}
				});
			});
		};

		/* Deprecated Function
  *	function validateOrder(button, order) {
  *	button.click(function () {
  *		box = $("<form class='OrderForm' id='OrderForm' enctype='multipart/form-data' ></form>");
  *		alert = $('<h4><strong>' + Lang.get('messages.sure') + ' Validar ' + order.reference + ' ' + Lang.get('messages.order') + '?</strong></h4>');
  *		inputA = $('<div class="form-group"><label for="value">Valor Entrante</label><div id="valuechange"><input id="value" name="value" type="text" class="form-control" placeholder="' + Lang.get('messages.value') + '" required></div></div>');
  *		inputC = $('<div class="form-group"><label for="value">Precio</label><div id="valuechange"><input id="price" name="price" type="text" class="form-control" placeholder="' + Lang.get('messages.price') + '" required></div></div>');
  *		inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + order.id + '" required>');
  *
  *		$('.modal-title').empty();
  *		$('.modal-body').empty();
  *		$('.modal-footer').empty();
  *		$('.modal-title').append(Lang.get('messages.validate') + ' ' + Lang.get('messages.currency'));
  *		$('.modal-body').append(box);
  *
  *		$('#OrderForm').append(alert);
  *		$('#OrderForm').append(inputA);
  *		$('#OrderForm').append(inputC);
  *		$('#OrderForm').append(inputI);
  *
  *		$('.modal-footer').append("<div id='currnButts'></div>");
  *		closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
  *		makeBut = $("<button type='button' name='button' class='btn btn-alternative-danger btn-alternative' id='currnCont'>" + Lang.get('messages.confirm') + "</button>");
  *		VerifyOrderButton(makeBut);
  *
  *		$('#currnButts').append(makeBut);
  *		$('#currnButts').append(closebut);
  *	});
  *} 
  *
  */

		/*Delete Currency Confirm*/


		var VerifyOrderButton = function VerifyOrderButton(delButt) {
			delButt.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();
				value = $('#value').val();
				price = $('#price').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/orders/complete',
					type: 'POST',
					dataType: "json",
					data: { id: id, value: value, price: price },
					success: function success(data) {
						$('#form_order_search').trigger("submit");
						$('#ordersMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.order') + ' ' + Lang.get('messages.deleted') + ' ' + Lang.get('messages.successfully'));
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#orderAlertMod').modal('show');
					},
					error: function error(_error46) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(Lang.get('messages.error'));
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#orderAlertMod').modal('show');
					}
				});
			});
		};

		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$('#table_order_header_out_amount').click(function (e) {
			orderTableOrderBy('out_amount');
		});

		$('#table_order_header_in_amount').click(function (e) {
			orderTableOrderBy('in_amount');
		});

		$('#table_order_header_rate').click(function (e) {
			orderTableOrderBy('rate');
		});

		$('#table_order_header_fee').click(function (e) {
			orderTableOrderBy('fee');
		});

		$('#table_order_header_reference').click(function (e) {
			orderTableOrderBy('reference');
		});

		$('#table_order_header_date').click(function (e) {
			orderTableOrderBy('orders.created_at');
		});

		$('#table_order_header_status').click(function (e) {
			orderTableOrderBy('status');
		});

		var orderOrderBy = "";
		var orderOrderDirection = "";
		var searchOrderValue = "";

		$("#form_order_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchOrderValue = $("#search_order_value").val();
			searchOrder(1);
		});

		$('#result_order_page').change(function () {
			$('#form_order_search').trigger("submit");
		});

		$('#form_order_search').trigger("submit");
	}

	/* End Orders Functions */

	/*  Begin Market Functions */

	if (pathverify('/markets')) {
		var availbalance = function availbalance(symbolb, tradeable) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/balance/available",
				data: { symbol: symbolb, tradeable: tradeable },
				type: 'post',
				success: function success(data) {
					$('#table_balance_content').html('');
					balances = data.result;
					for (i = 0; i < balances.length; i++) {
						balance = balances[i];
						rowresult = $('<tr></tr>');

						col_1 = $('<td><img src="'+globalImgUrl+'icons/currencies/' + balance.symbol.toLowerCase() + '.svg" height="16" width="16" alt=""></td>');
						col_2 = $('<td>' + balance.symbol + '</td>');
						col_3 = $('<td>' + balance.amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
						col_4 = $('<td>' + balance.pending_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');

						rowresult.append(col_1);
						rowresult.append(col_2);
						rowresult.append(col_3);
						rowresult.append(col_4);

						$('#table_balance_content').append(rowresult);
					}
				}
			});
		};

		var backB = function backB(button) {
			button.click(function () {
				$('.marketunit').hide();
				$('.marketcards').show();
			});
		};

		var backBA = function backBA(button) {
			marketSelected(button, init);
		};

		var marketSelected = function marketSelected(card, currency) {
			card.click(function () {
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					url: globalUrl+"/coincard",
					type: 'get',
					success: function success(data) {
						init = currency;
						box = $('<div style="height:fit-content; float:right; top:-40px; position:relative"></div>');
						button = $('<button type="button" class="btn-back btn btn-alternative"><i class="fas fa-arrow-left"></i></button>');
						backB(button);

						$('.marketunit').html(data.view);
						$('#coinimg').attr('src', globalImgUrl+'icons/currencies-circle/' + currency.symbol + '.png');
						$('#symbol').html(currency.symbol);
						$('#currency').html(currency.name);
						$('#symtotal').html(currency.balance.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }));
						$('#usdtotal').html(currency.balance_usd.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }));
						$('.marketcards').hide();
						$('#generalAct').hide();
						$('.marketunit').show();
						$('#buttonBack').append(button);
						spentSelected('#btn-market', currency.symbol, currency.exchangeable, currency.balance, currency.balance_usd);
						activitySelected('#btn-activity', currency.symbol, currency.balance, currency.balance_usd);
					}
				});
			});
		};

		var activitySelected = function activitySelected(btn, symbolm, balance, balance_usd) {
			$(btn).click(function () {
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					url: globalUrl+"/activity",
					type: 'get',
					success: function success(data) {
						box = $('<div style="height:fit-content; float:right; top:-40px; position:relative"></div>');
						button = $('<button type="button" class="btn-back btn btn-alternative"><i class="fas fa-arrow-left"></i></button>');
						backBA(button, init);
						$('.market-title').html('<h3>' + Lang.get('messages.fastway') + ' ' + Lang.get('messages.market') + '</h3>');
						$('.market-title').append(box);
						$('.marketunit').html(data.view);
						$('#buttonBack').append(button);
						activity(symbolm, balance, balance_usd);
						$('.marketcards').hide();
						$('.marketunit').show();
					}
				});
			});
		};

		var spentSelected = function spentSelected(btn, symbolm, exch, balance, balance_usd) {
			$(btn).click(function () {
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					url: globalUrl+"/fastex",
					type: 'get',
					success: function success(data) {
						box = $('<div style="height:fit-content; float:right; top:-40px; position:relative"></div>');
						button = $('<button type="button" class="btn-back btn btn-alternative"><i class="fas fa-arrow-left"></i></button>');
						backBA(button, init);
						$('.market-title').html('<h3>' + Lang.get('messages.fastway') + ' ' + Lang.get('messages.market') + '</h3>');
						$('.market-title').append(box);
						$('.marketunit').html(data.view);
						$('#buttonBack').append(button);
						exchangeable(symbolm, exch, balance, balance_usd);
						$('.marketcards').hide();
						$('.marketunit').show();
					}
				});
			});
		};

		var marketCards = function marketCards() {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/currencies/exchangeable",
				type: 'post',
				success: function success(data) {
					currencies = data.result;
					for (i = 0; i < currencies.length; i++) {
						currency = currencies[i];
						box = $('<div class="col-sm-4"></div>');
						card = $('<div class="marketCard" style="background-image:url(\''+globalImgUrl+'icons/cards/' + currency.symbol + '.png\')"></div>');
						balance = $('<div class="cardBalance" style="display:none"><p style="font-weight:bold">' + Lang.get('messages.balance') + ': <span id="actual">' + currency.balance.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '  ' + currency.symbol + '</span></p><p>' + Lang.get('messages.pending') + ' ' + Lang.get('messages.balance') + ': <span id="pending">' + currency.pending_balance.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</span></p><p>' + Lang.get('messages.last') + ' ' + Lang.get('messages.trade') + ': <span id="last">' + currency.last + ' ' + currency.pair + '</span></p></div>');

						card.append(balance);
						box.append(card);

						$('.marketcards').append(box);
						marketSelected(card, currency);
						showBalance(card, balance);
					}
				}
			});
		};

		var showBalance = function showBalance(card, balance) {
			card.hover(function () {
				balance.slideToggle(400, 'linear');
			});
		};

		var exchangeable = function exchangeable(symbolm, exch, balance, balance_usd) {

			var excha = '';
			var lab = '';
			var symbol1 = '';
			var symbol2 = '';
			var valueexch = '';
			var type = '';
			var type2 = '';

			$('#coinexchimg').attr('src', globalImgUrl+'icons/minicoin/' + symbolm + '-text.png');
			$('#coinimg').attr('src', globalImgUrl+'icons/currencies-circle/' + symbolm + '.png');
			$('#symbol').html(symbolm);
			$('#symtotal').html(balance.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }));
			$('#usdtotal').html(balance_usd.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }));
			function receiveCoin(symbol, exch) {
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					data: { symbol: symbol },
					url: globalUrl+"/currencies/fastre",
					type: 'post',
					success: function success(data) {
						$('#optionsrec').html('');
						currencies = data.result;
						if (currencies.length == 0) {} else {
							for (i = 0; i < currencies.length; i++) {
								currency = currencies[i];

								box = $('<div class="option"></div>');
								if (i == 0) {
									radio = $('<input type="radio" name="recheck" value="' + currency.symbol + '" id="' + currency.symbol + 'rec" checked/>');
								} else {
									radio = $('<input type="radio" name="recheck" value="' + currency.symbol + '" id="' + currency.symbol + 'rec"/>');
								}
								image3 = $('<img src="'+globalImgUrl+'icons/minicoin/' + currency.symbol + '-text.png"/>');
								label = $('<label for="' + currency.symbol + 'rec"></label>');

								label.append(image3);
								box.append(radio);
								box.append(label);
								if(currency.symbol.toUpperCase() == "BTC" || currency.symbol.toUpperCase() == "PTR"){
								    $('#optionsrec').append(box);
								    rateExchange(label, symbol, currency.symbol, exch);
							    }

								if (currency.symbol.toUpperCase() == "BTC" || currency.symbol.toUpperCase() == "PTR") {
									symbol2 = currency.symbol;
									$("#symrec").val(currency.symbol);
									label.trigger('click');
								}
							}
						}
					}

				});
			}

			function rateExchange(label, primsym, secsym, exch) {
				label.click(function () {
					symbol1 = primsym;
					symbol2 = secsym;
					lab = label;
					$("#symexc").val(symbol1);
					$("#symrec").val(symbol2);

					excha = exch;
					if (secsym == 'PTR') {
						excha = 0;
					}

					if (secsym == 'VES') {
						excha = 1;
					}

					/* if (secsym == 'VES' || primsym == 'VES') {
         $('#exchange').addClass('disabled');
         $('#exchange').prop('disabled', true);
         $('#exchange').html('NO DISPONIBLE');
     } else {
         $('#exchange').removeClass('disabled');
         $('#exchange').prop('disabled', false);
         $('#exchange').html('Ejecutar');
     } */

					$.ajax({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						},
						data: { symbol: symbol1, symbol2: symbol2, value: valueexch, type: type },
						url: globalUrl+"/orders/fastrate",
						type: 'post',
						success: function success(data) {
							$('.exchequivalent').html('');
							$('.exchequivalent').append('<p> 1 ' + primsym + ' = ' + data.result + ' ' + secsym + ' </p>');
							if (data.exchange != 0) {
								switch (type2) {
									case 'cryptoexc':
										$('#cryptovaluerec').val(data.exchange[0]);
										$('#fiatvalueexc').val(data.exchange[1]);
										$('#fiatvaluerec').val(data.exchange[2]);
										$('#viewexch').html(valueexch + ' ' + primsym);
										$('#viewfexch').html('$' + data.exchange[1]);
										$('#viewrec').html(data.exchange[0] + ' ' + secsym);
										$('#viewfrec').html('$' + data.exchange[2]);
										break;
									case 'cryptorec':
										$('#cryptovalueexc').val(data.exchange[0]);
										$('#fiatvaluerec').val(data.exchange[1]);
										$('#fiatvalueexc').val(data.exchange[2]);
										$('#viewrec').html(valueexch + ' ' + secsym);
										$('#viewfrec').html('$' + data.exchange[1]);
										$('#viewexch').html(data.exchange[0] + ' ' + primsym);
										$('#viewfexch').html('$' + data.exchange[2]);
										break;
									case 'fiatexc':
										$('#cryptovaluerec').val(data.exchange[0]);
										$('#cryptovalueexc').val(data.exchange[1]);
										$('#fiatvaluerec').val(data.exchange[2]);
										$('#viewexch').html(data.exchange[1] + ' ' + primsym);
										$('#viewfexch').html('$' + valueexch);
										$('#viewrec').html(data.exchange[0] + ' ' + secsym);
										$('#viewfrec').html('$' + data.exchange[2]);
										break;
									case 'fiatrec':
										$('#cryptovalueexc').val(data.exchange[0]);
										$('#cryptovaluerec').val(data.exchange[1]);
										$('#fiatvalueexc').val(data.exchange[2]);
										$('#viewexch').html(data.exchange[0] + ' ' + primsym);
										$('#viewfexch').html('$' + data.exchange[2]);
										$('#viewrec').html(data.exchange[1] + ' ' + secsym);
										$('#viewfrec').html('$' + valueexch);
										break;
								}
							}
						},
						error: function error(_error47) {
							$('#exchange').removeClass('disabled');
							$('#exchange').prop('disabled', false);
							$('.text-alert').empty();
							if (_error47.responseJSON.error) {
								$('.text-alert').append(_error47.responseJSON.error);
								$('#marketAlertMod').modal('show');
								$('#cryptovalueexc').val('0.00');
								$('#cryptovaluerec').val('0.00');
								$('#fiatvalueexc').val('0.00');
								$('#fiatvaluerec').val('0.00');
								$('.alert').removeClass('alert-success');
								$('.alert').removeClass('alert-danger');
								$('.alert').addClass('alert-warning');
							}
						}
					});
				});
			}

			receiveCoin(symbolm, exch);

			$('#exchange').click(function () {
                
					debugger;
				$('.alert').addClass('alert-danger');
				$('.text-alert').html('Esta operación no se encuentra disponible');
				$('#marketAlertMod').modal('show');
				$('#exchange').removeClass('disabled');
				$('#exchange').prop('disabled', false);
				$('#cryptovalueexc').val('0.00');
				$('#cryptovaluerec').val('0.00');
				$('#fiatvalueexc').val('0.00');
				$('#fiatvaluerec').val('0.00');

                return false;
                
				$('#exchangeForm').validate({
					rules: {
						cryptovalueexc: {
							number: true,
							required: true,
							minlength: 3
						},
						fiatvalueexc: {
							number: true,
							required: true,
							minlength: 3
						},
						symexc: {
							required: true
						}
					},
					messages: {
						cryptovalueexc: "Por favor introduzca un monto minimo de 1 digito y 2 decimales, Sin separador de miles y el separador decimal expresado con un '.'",
						fiatvalueexc: "Por favor introduzca un monto minimo de 1 digito y 2 decimales, Sin separador de miles y el separador decimal expresado con un '.'"
					}

				});

				$('#receiveForm').validate({
					rules: {
						cryptovaluerec: {
							number: true,
							required: true,
							minlength: 3
						},
						fiatvaluerec: {
							number: true,
							required: true,
							minlength: 3
						},
						symrec: {
							required: true
						}
					},
					messages: {
						cryptovaluerec: "Por favor introduzca un monto minimo de 1 digito y 2 decimales, Sin separadores de miles y el separador decimal expresado con un '.'",
						fiatvalueexc: "Por favor introduzca un monto minimo de 1 digito y 2 decimales, Sin separadores de miles y el separador decimal expresado con un '.'"
					}
				});

				if ($('#exchangeForm').valid() && $('#receiveForm').valid()) {
					$('#exchange').addClass('disabled');
					$('#exchange').prop('disabled', true);
					amountI = $('#cryptovalueexc').val();
					symbolI = $('#symexc').val();
					amountO = $('#cryptovaluerec').val();
					symbolO = $('#symrec').val();
					if (amountO == '0.00' || amountI == '0.00') {
						$('.alert').addClass('alert-danger');
						$('.text-alert').html('Los valores no pueden estar en 0');
						$('#marketAlertMod').modal('show');
						$('#exchange').removeClass('disabled');
						$('#exchange').prop('disabled', false);
						$('#cryptovalueexc').val('0.00');
						$('#cryptovaluerec').val('0.00');
						$('#fiatvalueexc').val('0.00');
						$('#fiatvaluerec').val('0.00');
						return;
					}

					validI = parseFloat(amountI);
					validO = parseFloat(amountO);
					if (validI < 0) {
						$('.alert').addClass('alert-danger');
						$('.text-alert').html('Monto no puede ser negativo');
						$('#marketAlertMod').modal('show');
						$('#exchange').removeClass('disabled');
						$('#exchange').prop('disabled', false);
						$('#cryptovalueexc').val('0.00');
						$('#cryptovaluerec').val('0.00');
						$('#fiatvalueexc').val('0.00');
						$('#fiatvaluerec').val('0.00');
					}
					if (validO < 0) {
						$('.alert').addClass('alert-danger');
						$('.text-alert').html('Monto no puede ser negativo');
						$('#marketAlertMod').modal('show');
						$('#exchange').removeClass('disabled');
						$('#exchange').prop('disabled', false);
						$('#cryptovalueexc').val('0.00');
						$('#cryptovaluerec').val('0.00');
						$('#fiatvalueexc').val('0.00');
						$('#fiatvaluerec').val('0.00');
					}
					$.ajax({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						},
						url: globalUrl+"/balance/availableV",
						data: { symbol: symbolI, symbol2: symbolO },
						type: 'post',
						success: function success(data) {

							balance = 100000000;//data.result.amount;
							limit = parseFloat(data.result2);
							if (balance < amountI) {
								$('.alert').addClass('alert-danger');
								$('.text-alert').html('Fondos Insuficientes');
								$('#marketAlertMod').modal('show');
								$('#exchange').removeClass('disabled');
								$('#exchange').prop('disabled', false);
								$('#cryptovalueexc').val('0.00');
								$('#cryptovaluerec').val('0.00');
								$('#fiatvalueexc').val('0.00');
								$('#fiatvaluerec').val('0.00');
							} else {
								if (limit > 0) {
        
									if (symbolI == 'PTR') {

										if (limit < amountI) {

											$('.alert').addClass('alert-danger');
											$('.text-alert').html('El limite de transaccion es de ' + limit + ' ' + symbolI);
											$('#marketAlertMod').modal('show');
											$('#exchange').removeClass('disabled');
											$('#exchange').prop('disabled', false);
											$('#cryptovalueexc').val('0.00');
											$('#cryptovaluerec').val('0.00');
											$('#fiatvalueexc').val('0.00');
											$('#fiatvaluerec').val('0.00');
											return;
										}
									} else {
										if (limit < amountO) {
											$('.alert').addClass('alert-danger');
											$('.text-alert').html('El limite de transaccion es de ' + limit + ' ' + symbolO);
											$('#marketAlertMod').modal('show');
											$('#exchange').removeClass('disabled');
											$('#exchange').prop('disabled', false);
											$('#cryptovalueexc').val('0.00');
											$('#cryptovaluerec').val('0.00');
											$('#fiatvalueexc').val('0.00');
											$('#fiatvaluerec').val('0.00');
											return;
										}
									}
								}
                                
								$.ajax({
									headers: {
										'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
									},
									url: globalUrl+"/balance/fastexchange",
									data: { amountI: amountI, amountO: amountO, symbolI: symbolI, symbolO: symbolO, type: excha },
									type: 'post',
									success: function success(data) {
										$('#exchange').removeClass('disabled');
										$('#exchange').prop('disabled', false);
										$('#cryptovalueexc').val('0.00');
										$('#cryptovaluerec').val('0.00');
										$('#fiatvalueexc').val('0.00');
										$('#fiatvaluerec').val('0.00');
										$('.alert').addClass('alert-success');
										$('.text-alert').html("Su Orden se esta procesando. En breve seran reflejados sus fondos.");
										$('#marketAlertMod').modal('show');
										setTimeout(function () {
											window.location.replace("/markets");
										}, 800);
									},
									error: function error(_error48) {
										$('#exchange').removeClass('disabled');
										$('#exchange').prop('disabled', false);
										$('.text-alert').empty();
										$('.text-alert').append(_error48.responseJSON.error);
										$('#cryptovalueexc').val('0.00');
										$('#cryptovaluerec').val('0.00');
										$('#fiatvalueexc').val('0.00');
										$('#fiatvaluerec').val('0.00');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										$('#marketAlertMod').modal('show');
									}
								});
							}
						},
						error: function error(_error49) {
							$('#exchange').removeClass('disabled');
							$('#exchange').prop('disabled', false);
							$('.text-alert').empty();
							$('#cryptovalueexc').val('0.00');
							$('#cryptovaluerec').val('0.00');
							$('#fiatvalueexc').val('0.00');
							$('#fiatvaluerec').val('0.00');
							$('.text-alert').append(_error49.responseJSON.error);
							$('.alert').removeClass('alert-success');
							$('.alert').removeClass('alert-danger');
							$('.alert').addClass('alert-warning');
							$('#marketAlertMod').modal('show');
						}
					});
				}
			});

			$('#cryptovalueexc').change(function () {
				valueexch = parseFloat($(this).val());
				type = 'cryptoexc';
				type2 = 'cryptoexc';
				lab.trigger('click');
			});

			$('#cryptovaluerec').change(function () {
				valueexch = parseFloat($(this).val());
				type = 'cryptorec';
				type2 = 'cryptorec';
				lab.trigger('click');
			});

			$('#fiatvalueexc').change(function () {
				valueexch = parseFloat($(this).val());
				type = 'fiatexc';
				type2 = 'fiatexc';
				lab.trigger('click');
			});

			$('#fiatvaluerec').change(function () {
				valueexch = parseFloat($(this).val());
				type = 'fiatrec';
				type2 = 'fiatrec';
				lab.trigger('click');
			});
		};

		var activity = function activity(symbolm, balance, balance_usd) {
			$('#coinimg').attr('src', globalImgUrl+'icons/currencies-circle/' + symbolm + '.png');
			$('#symbol').html(symbolm);
			$('#symtotal').html(balance.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }));
			$('#usdtotal').html(balance_usd.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }));
			function searchActivity(page) {
				resultPage = $("#result_order_page").val();

				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					url: globalUrl+"/activity",
					type: 'post',
					data: { page: page, resultPage: resultPage, symbol: symbolm },
					success: function success(data) {
						//Inicio
						var activities = data.result;

						if (activities.length == 0) {
							var box = $('<div class="card card-alternative"></div>');
							var header = $('<div class="card-header row text-center justify-content-center" id="headingone"></div>');
							var div1 = $('<a class="col-12 d-flex" data-toggle="collapse" href="#collapse1" role="button" aria-expanded="false" aria-controls="collapse1" ></a>');
							var col_1 = $('<div class="col-12 col-md-12 text-center">' + Lang.get('messages.none') + '</div>');

							$('#accordionActivity').html("");

							div1.append(col_1);
							header.append(div1);
							box.append(header);

							$('#accordionActivity').append(box);
						} else {
							$("#table_order_content").html("");
							for (i = 0; i < activities.length; i++) {
								var activity = activities[i];
								var usd = 'USD';

								var box = $('<div class="card card-alternative" style="border-radius: 10px; font-size: 1.5rem;"></div>');
								var header = $('<div class="card-alternative card-header row font-weight-bold" id="heading' + i + '" style="padding: 5px;"></div>');
								var div_1 = $('<a class="col-12" data-toggle="collapse" href="#collapse' + i + '" role="button" aria-expanded="false" aria-controls="collapse' + i + '" ></a>');
								var row1 = $('<div class="row align-items-center"></div>');

								var col_1 = $('<div class="col-6 col-md-3 text-center"><img src="'+globalImgUrl+'icons/lineicons/INTERCAMBIO.png" class="img-fluid icon-activity"" /></div>');
								var col_2 = $('<div class="col-6 col-md-3 text-left" style="font-size: 12px;">Has cambiado $' + activity.out_usd.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' de ' + activity.out_symbol + ' a ' + activity.in_symbol + '</div>');

								if (activity.status == 'complete') {
									var col_3 = $('<div class="col-6 col-md-3 text-center mt-4 mt-md-0"><img src="'+globalImgUrl+'icons/lineicons/EXITOSO.png" class="img-fluid icon-activity"/></div>');
								} else if (activity.status == 'cancelled') {
									var col_3 = $('<div class="col-6 col-md-3 text-center mt-4 mt-md-0"><img src="'+globalImgUrl+'icons/lineicons/CANCELADO.png" class="img-fluid icon-activity" /></div>');
								} else {
									var col_3 = $('<div class="col-6 col-md-3 text-center mt-4 mt-md-0"><img src="'+globalImgUrl+'icons/lineicons/PENDIENTE.png" class="img-fluid icon-activity" /></div>');
								}
								var col_4 = $('<div class="col-6 col-md-3 text-center mt-4 mt-md-0" style="font-size: 12px;">' + activity.created_at + '</div>');

								row1.append(col_1);
								row1.append(col_2);
								row1.append(col_3);
								row1.append(col_4);
								div_1.append(row1);
								header.append(div_1);

								var collapse = $('<div id="collapse' + i + '" class="collapse" aria-labelledby="heading' + i + '" data-parent="#generalActivity"></div>');
								var body = $('<div class="card card-alternative card-body"></div>');
								var row = $('<div class="row"></div>');

								var col_1_1 = $('<div class="col-6 col-md-3 div-info"></div>');
								var data_1_1 = $('<div class="vertical-line line-left" style="position: absolute; left: 4px; top: 0; height: 65%;"></div>');
								var data_1_2 = $('<h6 id="cuenter" class="font-weight-bold">' + activity.out_symbol + '</h6>');
								var data_1_3 = $('<p></p>');
								var data_1_4 = $('<h5 id="cuenterstatus" class="red">' + Lang.get('messages.' + activity.status + '') + '</h5>');
								var data_1_5 = $('<h5>' + Lang.get('messages.price') + ' ' + Lang.get('messages.of') + ' ' + Lang.get('messages.exchange') + ' <span class= "rate" >(' + activity.rate_usd.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + usd.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ')</span></h5>');
								var data_1_6 = $('<p></p>');

								col_1_1.append(data_1_1);
								col_1_1.append(data_1_2);
								col_1_1.append(data_1_3);
								col_1_1.append(data_1_4);
								col_1_1.append(data_1_6);
								col_1_1.append(data_1_5);

								var col_2_1 = $('<div class="col-6 col-md-2 div-info text-right"></div>');
								var data_2_1 = $('<h5><br/> </h5>');
								var data_2_2 = $('<p></p>');
								var data_2_3 = $('<h5 id="cuenteramount" class="red font-weight-bold">- ' + activity.out_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.out_symbol + '</h5>');
								var data_2_4 = $('<h5><span class="rateenter font-weight-bold">' + activity.rate.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.out_symbol + '</span></h5>');
								var data_2_5 = $('<p></p>');

								col_2_1.append(data_2_1);
								col_2_1.append(data_2_2);
								col_2_1.append(data_2_3);
								col_2_1.append(data_2_5);
								col_2_1.append(data_2_4);

								var col_mid = $('<div class="my-auto col-12 col-md-2 text-center"><img src="'+globalImgUrl+'icons/lineicons/CAMBIO.png" class="img-fluid icon-activity"/></div>');

								var col_3_1 = $('<div class="col-6 col-md-2 div-info text-left"></div>');
								var data_3_1 = $('<h5><br/> </h5>');
								var data_3_2 = $('<p></p>');
								var data_3_3 = $('<h5 id="cuexitamount" class="green font-weight-bold">+' + activity.in_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.in_symbol + '</h5>');
								var data_3_4 = $('<h5 class="rate font-weight-bold" id="rateexit" >(' + activity.fee.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.out_symbol + ')</h5>');
								var data_3_5 = $('<h5 class="rate font-weight-bold" id="ratenet" >(' + activity.fee_network.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.out_symbol + ')</h5>');
								var data_3_6 = $('<h5 class="rate font-weight-bold" id="rateexc" >(' + activity.fee_exchange.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.out_symbol + ')</h5>');
								var data_3_7 = $('<p></p>');

								col_3_1.append(data_3_1);
								col_3_1.append(data_3_2);
								col_3_1.append(data_3_3);
								col_3_1.append(data_3_7);
								col_3_1.append(data_3_4);
								col_3_1.append(data_3_5);
								col_3_1.append(data_3_6);

								var col_4_1 = $('<div class="col-6 col-md-3 div-info text-right"></div>');
								var data_4_1 = $('<div class="vertical-line line-right" style="position: absolute; height: 100%;top: 0;"></div>');
								var data_4_2 = $('<h6 style="font-weight: bold;">' + activity.in_symbol + '</h6>');
								var data_4_7 = $('<p></p>');
								var data_4_3 = $('<h5 id="cuexitstatus" class="green">' + Lang.get('messages.' + activity.status + '') + '</h5>');
								var data_4_4 = $('<h5 class="rate">' + Lang.get('messages.rate') + ' ' + Lang.get('messages.total') + '</h5>');
								var data_4_5 = $('<h5 class="rate">' + Lang.get('messages.rate') + ' ' + Lang.get('messages.of') + ' ' + Lang.get('messages.network') + '</h5>');
								var data_4_6 = $('<h5 class="rate">' + Lang.get('messages.rate') + ' ' + Lang.get('messages.of') + ' ' + Lang.get('messages.exchange') + '</h5>');
								var data_4_8 = $('<p></p>');

								col_4_1.append(data_4_2);
								col_4_1.append(data_4_7);
								col_4_1.append(data_4_3);
								col_4_1.append(data_4_8);
								col_4_1.append(data_4_4);
								col_4_1.append(data_4_5);
								col_4_1.append(data_4_6);
								col_4_1.append(data_4_1);

								row.append(col_1_1);
								row.append(col_2_1);
								row.append(col_mid);
								row.append(col_3_1);
								row.append(col_4_1);

								var row_2 = $('<div class="row"></div>');

								var col_b_1 = $('<div class="col-12 col-md-6 div-info text-left"></div>');
								var data_b_1_1 = $('<h6 class="font-weight-bold">' + activity.created_at + '</h6>');
								var data_b_1_2 = $('<p></p>');
								var data_b_1_3 = $('<h5 class="text-uppercase">Referencia de transacción</h5>');
								if (activity.status == 'complete') {
									var data_b_1_4 = $('<h5 class="font-weight-bold">' + activity.txid + '</h5>');
								} else {
									var data_b_1_4 = $('<h5 class="font-weight-bold">' + activity.reference + '</h5>');
								}

								col_b_1.append(data_b_1_1);
								col_b_1.append(data_b_1_2);
								col_b_1.append(data_b_1_3);
								col_b_1.append(data_b_1_4);

								var col_b_2 = $('<div class="my-auto col-12 col-md-6 div-info text-right"></div>');
								if (activity.status == 'complete') {
									var button_1 = $('<button type="button" class="btn btn-alternative btn-alternative-operation btn-deposit" style="font-weight: bold; color: rgba(255, 255, 253, 1);">Completado</button>');
								} else if (activity.status == 'cancelled') {
									var button_1 = $('<button type="button" class="btn btn-alternative btn-alternative-operation btn-deposit" style="font-weight: bold; color: red">Cancelado</button>');
								} else {
									var button_1 = $('<button type="button" class="btn btn-alternative btn-alternative-operation btn-deposit" style="font-weight: bold; color: orange">En Proceso</button>');
								}

								col_b_2.append(button_1);

								row_2.append(col_b_1);
								row_2.append(col_b_2);

								body.append(row);
								body.append(row_2);
								collapse.append(body);

								box.append(header);
								box.append(collapse);

								$("#accordionActivity").append(box);
							}

							pagination("#table_order_pagination", "#result_order_page", data.page, data.total, addPageAButton);
						}
						// Put the data into the element you care about.
					},
					// Fin
					error: function error(_error50) {
						ReadError(_error50);
					}
				});
			}

			function addPageAButton(pagebutton) {
				pagebutton.click(function () {
					page = $(this).text();
					searchActivity(page);
				});
			}

			searchActivity(1);
		};

		var generalActivity = function generalActivity() {

			function searchActivity(page) {
				resultPage = $("#result_order_page").val();

				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					url: globalUrl+"/gactivity",
					type: 'post',
					data: { page: page, resultPage: resultPage },
					success: function success(data) {
						//Inicio
						var activities = data.result;

						if (activities.length == 0) {

							var box = $('<div class="card card-alternative"></div>');
							var header = $('<div class="card-header row text-center justify-content-center" id="headingone"></div>');
							var div1 = $('<a class="col-12 d-flex" data-toggle="collapse" href="#collapse1" role="button" aria-expanded="false" aria-controls="collapse1" ></a>');
							var col_1 = $('<div class="col-12 col-md-12 text-center">' + Lang.get('messages.none') + '</div>');

							$('#generalActivity').html("");

							div1.append(col_1);
							header.append(div1);
							box.append(header);

							$('#generalActivity').append(box);
						} else {
							$("#table_order_content").html("");
							for (i = 0; i < activities.length; i++) {
								var activity = activities[i];
								var usd = 'USD';

								var box = $('<div class="card card-alternative" style="border-radius: 10px; font-size: 1.5rem;"></div>');
								var header = $('<div class="card-alternative card-header row font-weight-bold" id="heading' + i + '" style="padding: 5px;"></div>');
								var div_1 = $('<a class="col-12" data-toggle="collapse" href="#collapse' + i + '" role="button" aria-expanded="false" aria-controls="collapse' + i + '" ></a>');
								var row1 = $('<div class="row align-items-center"></div>');

								var col_1 = $('<div class="col-6 col-md-3 text-center"><img src="'+globalImgUrl+'icons/lineicons/INTERCAMBIO.png" class="img-fluid icon-activity"" /></div>');
								var col_2 = $('<div class="col-6 col-md-3 text-left" style="font-size: 12px;">Has cambiado $' + activity.out_usd.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' de ' + activity.out_symbol + ' a ' + activity.in_symbol + '</div>');

								if (activity.status == 'complete') {
									var col_3 = $('<div class="col-6 col-md-3 text-center mt-4 mt-md-0"><img src="'+globalImgUrl+'icons/lineicons/EXITOSO.png" class="img-fluid icon-activity"/></div>');
								} else if (activity.status == 'cancelled') {
									var col_3 = $('<div class="col-6 col-md-3 text-center mt-4 mt-md-0"><img src="'+globalImgUrl+'icons/lineicons/CANCELADO.png" class="img-fluid icon-activity" /></div>');
								} else {
									var col_3 = $('<div class="col-6 col-md-3 text-center mt-4 mt-md-0"><img src="'+globalImgUrl+'icons/lineicons/PENDIENTE.png" class="img-fluid icon-activity" /></div>');
								}
								var col_4 = $('<div class="col-6 col-md-3 text-center mt-4 mt-md-0" style="font-size: 12px;">' + activity.created_at + '</div>');

								row1.append(col_1);
								row1.append(col_2);
								row1.append(col_3);
								row1.append(col_4);
								div_1.append(row1);
								header.append(div_1);

								var collapse = $('<div id="collapse' + i + '" class="collapse" aria-labelledby="heading' + i + '" data-parent="#generalActivity"></div>');
								var body = $('<div class="card card-alternative card-body"></div>');
								var row = $('<div class="row"></div>');

								var col_1_1 = $('<div class="col-6 col-md-3 div-info"></div>');
								var data_1_1 = $('<div class="vertical-line line-left" style="position: absolute; left: 4px; top: 0; height: 65%;"></div>');
								var data_1_2 = $('<h6 id="cuenter" class="font-weight-bold">' + activity.out_symbol + '</h6>');
								var data_1_3 = $('<p></p>');
								var data_1_4 = $('<h5 id="cuenterstatus" class="red">' + Lang.get('messages.' + activity.status + '') + '</h5>');
								var data_1_5 = $('<h5>' + Lang.get('messages.price') + ' ' + Lang.get('messages.of') + ' ' + Lang.get('messages.exchange') + ' <span class= "rate" >(' + activity.rate_usd.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + usd.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ')</span></h5>');
								var data_1_6 = $('<p></p>');

								col_1_1.append(data_1_1);
								col_1_1.append(data_1_2);
								col_1_1.append(data_1_3);
								col_1_1.append(data_1_4);
								col_1_1.append(data_1_6);
								col_1_1.append(data_1_5);

								var col_2_1 = $('<div class="col-6 col-md-2 div-info text-right"></div>');
								var data_2_1 = $('<h5><br/> </h5>');
								var data_2_2 = $('<p></p>');
								var data_2_3 = $('<h5 id="cuenteramount" class="red font-weight-bold">- ' + activity.out_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.out_symbol + '</h5>');
								var data_2_4 = $('<h5><span class="rateenter font-weight-bold">' + activity.rate.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.out_symbol + '</span></h5>');
								var data_2_5 = $('<p></p>');

								col_2_1.append(data_2_1);
								col_2_1.append(data_2_2);
								col_2_1.append(data_2_3);
								col_2_1.append(data_2_5);
								col_2_1.append(data_2_4);

								var col_mid = $('<div class="my-auto col-12 col-md-2 text-center"><img src="'+globalImgUrl+'icons/lineicons/CAMBIO.png" class="img-fluid icon-activity"/></div>');

								var col_3_1 = $('<div class="col-6 col-md-2 div-info text-left"></div>');
								var data_3_1 = $('<h5><br/> </h5>');
								var data_3_2 = $('<p></p>');
								var data_3_3 = $('<h5 id="cuexitamount" class="green font-weight-bold">+' + activity.in_amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.in_symbol + '</h5>');
								var data_3_4 = $('<h5 class="rate font-weight-bold" id="rateexit" >(' + activity.fee.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.out_symbol + ')</h5>');
								var data_3_5 = $('<h5 class="rate font-weight-bold" id="ratenet" >(' + activity.fee_network.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.out_symbol + ')</h5>');
								var data_3_6 = $('<h5 class="rate font-weight-bold" id="rateexc" >(' + activity.fee_exchange.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + ' ' + activity.out_symbol + ')</h5>');
								var data_3_7 = $('<p></p>');

								col_3_1.append(data_3_1);
								col_3_1.append(data_3_2);
								col_3_1.append(data_3_3);
								col_3_1.append(data_3_7);
								col_3_1.append(data_3_4);
								col_3_1.append(data_3_5);
								col_3_1.append(data_3_6);

								var col_4_1 = $('<div class="col-6 col-md-3 div-info text-right"></div>');
								var data_4_1 = $('<div class="vertical-line line-right" style="position: absolute; height: 100%;top: 0;"></div>');
								var data_4_2 = $('<h6 style="font-weight: bold;">' + activity.in_symbol + '</h6>');
								var data_4_7 = $('<p></p>');
								var data_4_3 = $('<h5 id="cuexitstatus" class="green">' + Lang.get('messages.' + activity.status + '') + '</h5>');
								var data_4_4 = $('<h5 class="rate">' + Lang.get('messages.rate') + ' ' + Lang.get('messages.total') + '</h5>');
								var data_4_5 = $('<h5 class="rate">' + Lang.get('messages.rate') + ' ' + Lang.get('messages.of') + ' ' + Lang.get('messages.network') + '</h5>');
								var data_4_6 = $('<h5 class="rate">' + Lang.get('messages.rate') + ' ' + Lang.get('messages.of') + ' ' + Lang.get('messages.exchange') + '</h5>');
								var data_4_8 = $('<p></p>');

								col_4_1.append(data_4_2);
								col_4_1.append(data_4_7);
								col_4_1.append(data_4_3);
								col_4_1.append(data_4_8);
								col_4_1.append(data_4_4);
								col_4_1.append(data_4_5);
								col_4_1.append(data_4_6);
								col_4_1.append(data_4_1);

								row.append(col_1_1);
								row.append(col_2_1);
								row.append(col_mid);
								row.append(col_3_1);
								row.append(col_4_1);

								var row_2 = $('<div class="row"></div>');

								var col_b_1 = $('<div class="col-12 col-md-6 div-info text-left"></div>');
								var data_b_1_1 = $('<h6 class="font-weight-bold">' + activity.created_at + '</h6>');
								var data_b_1_2 = $('<p></p>');
								var data_b_1_3 = $('<h5 class="text-uppercase">referencia de transacción</h5>');
								if (activity.status == 'complete') {
									var data_b_1_4 = $('<h5 class="font-weight-bold">' + activity.txid + '</h5>');
								} else {
									var data_b_1_4 = $('<h5 class="font-weight-bold">' + activity.reference + '</h5>');
								}

								col_b_1.append(data_b_1_1);
								col_b_1.append(data_b_1_2);
								col_b_1.append(data_b_1_3);
								col_b_1.append(data_b_1_4);

								var col_b_2 = $('<div class="my-auto col-12 col-md-6 div-info text-right"></div>');
								if (activity.status == 'complete') {
									var button_1 = $('<button type="button" class="btn btn-alternative btn-alternative-operation btn-deposit" style="font-weight: bold; color: rgba(255, 255, 253, 1);">Completado</button>');
								} else if (activity.status == 'cancelled') {
									var button_1 = $('<button type="button" class="btn btn-alternative btn-alternative-operation btn-deposit" style="font-weight: bold; color: red">Cancelado</button>');
								} else {
									var button_1 = $('<button type="button" class="btn btn-alternative btn-alternative-operation btn-deposit" style="font-weight: bold; color: orange">En Proceso</button>');
								}

								col_b_2.append(button_1);

								row_2.append(col_b_1);
								row_2.append(col_b_2);

								body.append(row);
								body.append(row_2);
								collapse.append(body);

								box.append(header);
								box.append(collapse);

								$("#generalActivity").append(box);
							}

							pagination("#table_order_pagination", "#result_order_page", data.page, data.total, addPageAButton);
						}
						// Put the data into the element you care about.
					},
					// Fin
					error: function error(_error51) {
						ReadError(_error51);
					}
				});
			}

			function addPageAButton(pagebutton) {
				pagebutton.click(function () {
					page = $(this).text();
					searchActivity(page);
				});
			}

			searchActivity(1);
		};

		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		level();

		var init = '';
		var symbol1 = '';
		var symbol2 = '';
		var valueexch = '';
		var type = '';
		var type2 = '';
		var lab = '';

		$('.listmarkets').addClass('active');

		marketCards();

		generalActivity();
	}

	/* End Market Functions */

	if (pathverify('/fastway')) {}

	/* Begin Funds Functions */

	if (pathverify('/transactions')) {
		var _orderTableDepositBy = function _orderTableDepositBy(by) {
			if (orderDepositBy === by) {
				if (orderDepositDirection === "") {
					orderDepositDirection = "DESC";
				} else {
					orderDepositDirection = "";
				}
			} else {
				orderDepositBy = by;
				orderDepositDirection = "";
			}
			_searchDeposit(1);
		};

		//Get Deposit Data


		var _searchDeposit = function _searchDeposit(page) {

			resultPage = $("#result_deposit_page").val();

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/deposit",
				type: 'post',
				data: { searchvalue: searchDepositValue, page: page, orderBy: orderDepositBy, orderDirection: orderDepositDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var deposits = data.result;

					if (deposits.length == 0) {
						$("#table_deposit_content").html("");
						$('#table_deposit_content').append('<tr><td colspan="11">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						// Put the data into the element you care about.
						$("#table_deposit_content").html("");

						for (i = 0; i < deposits.length; i++) {
							var deposit = deposits[i];

							// we have to make in steps to add the onclick event
							var rowResult = $('<tr></tr>');
							var colvalue_0 = $('<td>' + deposit.user + '</td>');
							var colvalue_1 = $('<td>' + deposit.entity + '</td>');
							var colvalue_2 = $('<td>' + deposit.symbol + '</td>');
							var colvalue_3 = $('<td>' + deposit.amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_4 = $('<td>' + deposit.rate.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_5 = $('<td>' + deposit.reference + '</td>');
							var colvalue_6 = $('<td>' + deposit.ip + '</td>');
							var colvalue_7 = $('<td>' + deposit.ubication + '</td>');
							var colvalue_8 = $('<td>' + deposit.created_at + '</td>');
							var colvalue_9 = $('<td>' + deposit.status + '</td>');
							var colvalue_10 = $('<td class="text-center"></td>');
							var printbut = $("<button type='button' name='button' class='btn btn-alternative btn-sm' id='txPrint'>" + Lang.get('messages.receipt') + "</button>");

							if (data.eaccess && (deposit.status == 'pending' || deposit.status == 'complete')) {
								var delbut = $("<button type='button' name='button' data-toggle='modal' data-target='#fundsMod' class='btn btn-alternative-danger btn-alternative btn-sm' id='txdel'>" + Lang.get('messages.delete') + "</button>");
								_addMakeDTxButton(delbut, deposit);

								colvalue_10.append(delbut);
								if (deposit.symbol == 'VES') {
									var verbut = $("<button type='button' name='button' data-toggle='modal' data-target='#fundsMod' class='btn btn-alternative-success btn-alternative btn-sm' id='txdel'>" + Lang.get('messages.verify') + "</button>");
									addMakeVTxButton(verbut, deposit);
									colvalue_10.append(verbut);
								}
							}

							colvalue_10.append(printbut);

							rowResult.append(colvalue_0);
							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);
							rowResult.append(colvalue_7);
							rowResult.append(colvalue_8);
							rowResult.append(colvalue_9);
							rowResult.append(colvalue_10);

							$("#table_deposit_content").append(rowResult);
						}

						pagination("#table_deposit_pagination", "#result_deposit_page", data.page, data.total, _addPageDeButton);
					}
				},
				// Fin
				error: function error(_error52) {
					ReadError(_error52);
				}
			});
		};

		var _addPageDeButton = function _addPageDeButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				_searchDeposit(page);
			});
		};

		var _orderTableWithdrawBy = function _orderTableWithdrawBy(by) {
			if (orderWithdrawBy === by) {
				if (orderWithdrawDirection === "") {
					orderWithdrawDirection = "DESC";
				} else {
					orderWithdrawDirection = "";
				}
			} else {
				orderWithdrawBy = by;
				orderWithdrawDirection = "";
			}
			_searchWithdraw(1);
		};

		//Get Deposit Data


		var _searchWithdraw = function _searchWithdraw(page) {

			resultPage = $("#result_pending_transaction_page").val();

			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/withdraw",
				type: 'post',
				data: { searchvalue: searchWithdrawValue, page: page, orderBy: orderWithdrawBy, orderDirection: orderWithdrawDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var withdraws = data.result;

					if (withdraws.length == 0) {
						$("#table_withdraw_content").html("");
						if (data.eaccess) {
							$('#table_withdraw_content').append('<tr><td colspan="9">' + Lang.get('messages.none') + '</td></tr>');
						} else {
							$('#table_withdraw_content').append('<tr><td colspan="8">' + Lang.get('messages.none') + '</td></tr>');
						}
					} else {
						// Put the data into the element you care about.
						$("#table_withdraw_content").html("");

						for (i = 0; i < withdraws.length; i++) {
							var withdraw = withdraws[i];

							// we have to make in steps to add the onclick event
							var rowResult = $('<tr></tr>');
							var colvalue_0 = $('<td>' + withdraw.user + '</td>');
							var colvalue_1 = $('<td>' + withdraw.symbol + '</td>');
							var colvalue_2 = $('<td>' + withdraw.amount.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_3 = $('<td>' + withdraw.rate.toLocaleString('de-DE', { style: 'decimal', maximumFractionDigits: 12 }) + '</td>');
							var colvalue_4 = $('<td>' + withdraw.reference + '</td>');
							var colvalue_5 = $('<td>' + withdraw.ip + '</td>');
							var colvalue_6 = $('<td>' + withdraw.ubication + '</td>');
							var colvalue_7 = $('<td>' + withdraw.created_at + '</td>');
							var colvalue_8 = $('<td>' + withdraw.status + '</td>');
							var colvalue_9 = $('<td class="text-center"></td>');
							var printbut = $("<button type='button' name='button' data-toggle='modal' data-target='#fundsMod' class='btn btn-alternative-success btn-alternative btn-sm' id='printbutt'>" + Lang.get('messages.receipt') + "</button>");

							if (data.eaccess && (withdraw.status == 'pending' || withdraw.status == 'complete')) {
								var delbut = $("<button type='button' name='button' data-toggle='modal' data-target='#fundsMod' class='btn btn-alternative-danger btn-alternative btn-sm' id='txdel'>" + Lang.get('messages.delete') + "</button>");
								_addMakeDTxButton(delbut, withdraw);
								var verbut = $("<button type='button' name='button' data-toggle='modal' data-target='#fundsMod' class='btn btn-alternative-success btn-alternative btn-sm' id='txdel'>" + Lang.get('messages.verify') + "</button>");
								addMakeVTxButton(verbut, withdraw);
								colvalue_9.append(delbut);
								colvalue_9.append(verbut);
							}
							colvalue_9.append(printbut);

							rowResult.append(colvalue_0);
							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);
							rowResult.append(colvalue_7);
							rowResult.append(colvalue_8);
							rowResult.append(colvalue_9);

							$("#table_withdraw_content").append(rowResult);
						}
						pagination("#table_withdraw_pagination", "#result_withdraw_page", data.page, data.total, _addPageWIButton);
					}
				},
				// Fin
				error: function error(_error53) {
					ReadError(_error53);
				}
			});
		};

		var _addPageWIButton = function _addPageWIButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				_searchWithdraw(page);
			});
		};

		/* Delete Function For User */


		var _addMakeDTxButton = function _addMakeDTxButton(delButt, trans) {
			delButt.click(function () {
				box = $("<form class='TxForm' id='TxForm' enctype='multipart/form-data' ></form>");
				alert = $('<h4><strong>' + Lang.get('messages.sure') + ' ' + Lang.get('messages.delete') + ' ' + Lang.get('messages.transaction') + ' #' + trans.reference + '?</strong></h4>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + trans.id + '" required>');

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append(Lang.get('messages.delete') + ' ' + Lang.get('messages.transaction'));
				$('.modal-body').append(box);

				$('#TxForm').append(alert);
				$('#TxForm').append(inputI);

				$('.modal-footer').append("<div id='txButts'></div>");

				makeBut = $("<button type='button' class='btn btn-alternative-danger btn-alternative' name='button' id='txCont'>" + Lang.get('messages.delete') + "</button>");
				closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				_DeleteTxButton(makeBut);

				$('#txButts').append(makeBut);
				$('#txButts').append(closebut);
			});
		};

		/* Confirmation Of User Deletion */


		var _DeleteTxButton = function _DeleteTxButton(delButt) {
			delButt.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/balance/delete',
					type: 'POST',
					dataType: "json",
					data: { id: id },
					success: function success(data) {
						$('#fundsMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append('Transaction Deleted Sucessfully');
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#fundsAlertMod').modal('show');

						$('#form_balance_currency_search').trigger("submit");
						$('#form_balance_crypto_search').trigger("submit");
						$('#form_balance_token_search').trigger("submit");
						$('#form_transaction_search').trigger("submit");
						$('#form_pending_transaction_search').trigger("submit");
						_totalBalance();
					},
					error: function error(_error54) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append('An error has ocurred');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#fundsAlertMod').modal('show');
					}
				});
			});
		};
		/*End Transaction History*/

		/* Delete Function For User */


		var addMakeVTxButton = function addMakeVTxButton(verButt, trans) {
			verButt.click(function () {
				box = $("<form class='TxForm' id='TxForm' enctype='multipart/form-data' ></form>");
				alert = $('<h4><strong>' + Lang.get('messages.sure') + ' ' + Lang.get('messages.verify') + ' ' + Lang.get('messages.transaction') + ' #' + trans.reference + '?</strong></h4>');
				inputI = $('<input id="id" name="id" style="display: none;" type="text" class="form-control" value="' + trans.id + '" required>');

				$('.modal-title').empty();
				$('.modal-body').empty();
				$('.modal-footer').empty();
				$('.modal-title').append(Lang.get('messages.verify') + Lang.get('messages.transaction'));
				$('.modal-body').append(box);

				$('#TxForm').append(alert);
				$('#TxForm').append(inputI);

				$('.modal-footer').append("<div id='txButts'></div>");

				makeBut = $("<button type='button' class='btn btn-alternative-success btn-alternative' name='button' id='txCont'>" + Lang.get('messages.verify') + "</button>");
				closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				VerifyTxButton(makeBut);

				$('#txButts').append(makeBut);
				$('#txButts').append(closebut);
			});
		};

		/* Confirmation Of User Deletion */


		var VerifyTxButton = function VerifyTxButton(verButt) {
			verButt.click(function () {
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				id = $('#id').val();

				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/balance/verify',
					type: 'POST',
					dataType: "json",
					data: { id: id },
					success: function success(data) {
						$('#fundsMod').modal('hide');
						$('.text-alert').empty();
						$('.text-alert').append('Transaction Verify Sucessfully');
						$('.alert').removeClass('alert-warning');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-success');
						$('#fundsAlertMod').modal('show');

						$('#form_deposit_search').trigger("submit");
						$('#form_withdraw_search').trigger("submit");
						_totalBalance();
					},
					error: function error(_error55) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append('An error has ocurred');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#fundsAlertMod').modal('show');
					}
				});
			});
		};
		/*End Transaction History*/

		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$('.listtransaction').addClass('active');
		/*Funds Balances*/

		/*Deposit History*/

		$('#table_deposit_header_user').click(function (e) {
			_orderTableDepositBy('user');
		});

		$('#table_deposit_header_currency').click(function (e) {
			_orderTableDepositBy('symbol');
		});

		$('#table_deposit_header_amount').click(function (e) {
			_orderTableDepositBy('in_amount');
		});

		$('#table_deposit_header_reference').click(function (e) {
			_orderTableDepositBy('reference');
		});

		$('#table_deposit_header_rate').click(function (e) {
			_orderTableDepositBy('rate');
		});

		$('#table_deposit_header_date').click(function (e) {
			_orderTableDepositBy('created_at');
		});

		$('#table_deposit_header_status').click(function (e) {
			_orderTableDepositBy('status');
		});

		var orderDepositBy = "";
		var orderDepositDirection = "";
		var searchDepositValue = "";

		$("#form_deposit_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchDepositValue = $("#search_deposit_value").val();
			_searchDeposit(1);
		});

		$('#table_withdraw_header_user').click(function (e) {
			_orderTableDepositBy('user');
		});

		$('#table_withdraw_header_currency').click(function (e) {
			orderTablePendingTransactionBy('symbol');
		});

		$('#table_withdraw_header_amount').click(function (e) {
			_orderTableWithdrawBy('out_amount');
		});

		$('#table_withdraw_header_rate').click(function (e) {
			_orderTableWithdrawBy('rate');
		});

		$('#table_withdraw_header_date').click(function (e) {
			_orderTableWithdrawBy('created_at');
		});

		$('#table_withdraw_header_reference').click(function (e) {
			_orderTableWithdrawBy('reference');
		});

		$('#table_withdraw_header_status').click(function (e) {
			_orderTableWithdrawBy('status');
		});

		var orderWithdrawBy = "";
		var orderWithdrawDirection = "";
		var searchWithdrawValue = "";

		$("#form_withdraw_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchWithdrawValue = $("#search_withdraw_value").val();
			_searchWithdraw(1);
		});

		$('#result_deposit_page').change(function () {
			$('#form_deposit_search').trigger("submit");
		});

		$('#result_withdraw_page').change(function () {
			$('#form_withdraw_search').trigger("submit");
		});

		$('#form_deposit_search').trigger("submit");
		$('#form_withdraw_search').trigger("submit");
	}

	/* End Funds Functions */

	/* Function Verify Email Code */

	if (pathverify('/email-code')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$("#verify").submit(function (e) {
			e.preventDefault();
			$('#verify').validate({
				rules: {
					secret: {
						number: true,
						required: true
					}
				},
				messages: {
					secret: "Please introduce a valid code 2FA"
				}
			});
			if ($('#verify').valid()) {
				var code = $('#secret').val();
				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/verify-code',
					type: 'POST',
					dataType: "json",
					data: { one_time_password: code },
					success: function success(data) {
						return window.location.replace(globalUrl+'/dashboard');
					},
					error: function error(_error56) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append('An error has ocurred');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						return $('#fundsAlertMod').modal('show');
					}
				});
			}
		});
	}
	/* End Function Verify Email Code */

	/* Function Verify 2FA */

	if (pathverify('/validate-auth')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$("#verify").submit(function (e) {
			e.preventDefault();
			$('#verify').validate({
				rules: {
					secret: {
						number: true,
						required: true
					}
				},
				messages: {
					secret: "Please introduce a valid code 2FA"
				}
			});
			if ($('#verify').valid()) {
				var code = $('#secret').val();
				sendCode(code);
			}
		});
	}
	/* End Function Verify 2FA */

	/* Function KYC */

	if (pathverify('/kyc-verification')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
		$('#natural').click(function (e) {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Usted confirma que el tipo de persona seleccionado es natural? Si desea cambiar el tipo de persona debe contactarnos de forma directa e indicar los motivos del cambio.');
			$('#yes').click(function (e) {
				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/valid-type-person',
					type: 'post',
					data: { type_person: 1 },
					success: function success(data) {
						return window.location.replace(globalUrl+'/personal-information');
					},
					error: function error(_error57) {
						return false;
					}
				});
			});
			return false;
		});

		$('#juridic').click(function (e) {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Confirma que el tipo de persona seleccionado es jurídica? Si desea cambiar el tipo de persona debe contactarnos de forma directa e indicar los motivos del cambio.');
			$('#yes').click(function (e) {
				$.ajax({
					headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
					url: globalUrl+'/valid-type-person',
					type: 'post',
					data: { type_person: 2 },
					success: function success(data) {
						return window.location.replace(globalUrl+'/juridic-information');
					},
					error: function error(_error58) {
						return false;
					}
				});
			});
			return false;
		});
	}

	/*User KYC Functions*/

	if (pathverify('/kycusers')){
		var _orderTableUserBy = function _orderTableUserBy(by) {
			if (orderUserBy === by) {
				if (orderUserDirection === "") {
					orderUserDirection = "DESC";
				} else {
					orderUserDirection = "";
				}
			} else {
				orderUserBy = by;
				orderUserDirection = "";
			}
			_searchUser(1);
		};

		//Get User Data


		var _searchUser = function _searchUser(page) {
			resultPage = $("#result_user_page").val();
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				url: globalUrl+"/kycusers",
				type: 'post',
				data: { searchvalue: searchUserValue, page: page, orderBy: orderUserBy, orderDirection: orderUserDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var users = data.result;

					if (users.length == 0) {
						$("#table_user_content").html("");
						$('#table_user_content').append('<tr><td colspan="6" style="text-align:center">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						$("#table_user_content").html("");
						for (i = 0; i < users.length; i++) {
							var user = users[i];

							var rowResult = $('<tr></tr>');
							var colvalue_1 = $('<td>' + user.profile.fname + ' ' + user.profile.flastname + '</td>');
							var colvalue_2 = $('<td>' + user.email + '</td>');

							if (user.profile.level3_confirmed) {
								var colvalue_3 = $('<td>Nivel 3 Verificado</td>');
							} else if (user.profile.level2_confirmed) {
								var colvalue_3 = $('<td>Nivel 2 Verificado</td>');
							} else if (user.profile.level1_confirmed) {
								var colvalue_3 = $('<td>Nivel 1 Verificado</td>');
							} else {
								var colvalue_3 = $('<td>No Verificado</td>');
							}

							editBut = $('<button type="button" class="btn btn-alternative btn-sm" data-toggle="modal" data-target="#userMod" id="editBut">' + Lang.get('messages.verify') + '</button> ');
							editButt = $('<button type="button" class="btn btn-alternative btn-sm" data-toggle="modal" data-target="#userMod" id="editBut">' + Lang.get('messages.edit') + '</button> ');
							// we have to make in steps to add the onclick event
							addVerifyUserClick(editBut, user);
							addEditVUserClick(editButt, user);
							var colvalue_4 = $('<td>' + user.created_at + '</td>');
							var colvalue_5 = $('<td>' + user.updated_at + '</td>');
							var colvalue_6 = $('<td class="text-center"></td>');

							colvalue_6.append(editBut);
							colvalue_6.append(editButt);

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);

							$("#table_user_content").append(rowResult);
						}

						pagination("#table_user_pagination", "#result_user_page", data.page, data.total, _addPageUButton);
					}
					// Put the data into the element you care about.
				},
				// Fin
				error: function error(_error59) {
					ReadError(_error59);
				}
			});
		};

		var _addPageUButton = function _addPageUButton(pagebutton) {
			pagebutton.click(function () {
				page = $(this).text();
				_searchUser(page);
			});
		};

		/*Edit Button With Modal edition for Users*/


		var addVerifyUserClick = function addVerifyUserClick(buttonEdit, user) {
			buttonEdit.click(function () {

				box = $("<div class='UserForm'></div>");

				box1 = $('<div class="row"></div>');
				box2 = $('<div class="row"></div>');
				box0 = $('<div class="row"></div>');
				if (!user.profile.level1_confirmed) {

					if (user.profile.user_type == 'Natural') {
						datas = ['user_type', 'name', 'lastname', 'email', 'address', 'id_number', 'type_id', 'date_issue', 'date_expiry', 'gender', 'marital_status', 'born_date', 'phonenumber', 'born_site', 'issuing_state'];
						documents = ['identification', 'selfie'];
					} else if (user.profile.user_type == 'Juridico') {
						datas = ['user_type', 'corporate_name', 'date_incorporation', 'place_incorporation', 'register_incoporation_office', 'postal_code', 'type_company', 'shareholders', 'legal_representative', 'merchant_record', 'issuing_state', 'date_issue', 'date_expiry', 'phone_number', 'website', 'email_address'];
						documents = ['rif', 'merchant_record'];
					} else {
						datas = ['No suministrada'];
						documents = [];
					}
				} else if (!user.profile.level2_confirmed) {

					if (user.profile.user_type == 'Natural') {
						datas = ['profession_occupation', 'position', 'politically_exposed_person', 'exposed_type', 'years_in_company', 'annual_income'];
						documents = ['rif', 'politically_document'];
					} else if (user.profile.user_type == 'Juridico') {
						datas = ['business_sector', 'products', 'services', 'monthly_income', 'annual_income', 'net_worth'];
						documents = [];
					} else {
						datas = ['No suministrada'];
						documents = [];
					}
				} else if (!user.profile.level3_confirmed) {

					if (user.profile.user_type == 'Natural') {
						datas = ['financial_institution', 'account_number'];
						documents = ['source_founds', 'sworn_declaration'];
					} else if (user.profile.user_type == 'Juridico') {
						datas = ['account_number', 'ABA_routing', 'SWIFT', 'IBAN', 'financial_institution', 'bank_address', 'currency'];
						documents = ['source_founds'];
					} else {
						datas = ['No suministrada'];
						documents = [];
					}
				}

				inside1 = $('<div class="col-sm-6"></div>');
				inside2 = $('<div class="col-sm-6"></div>');

				inside3 = $('<div class="col-sm-6"></div>');
				inside4 = $('<div class="col-sm-6"></div>');

				count1 = datas.length / 2;
				count2 = documents.length / 2;

				for (a = 0; a < datas.length; a++) {
					data = datas[a];

					card = $('<div class="row"></div>');

					title = $('<div class="col-sm-12 pl-4 mt-2"><h5>' + Lang.get("messages." + data) + '</h5></div>');

					if (data == 'No suministrada') {
						card.append(title);
					}

					var make = false;
					for (var i in user) {

						for (var o in user[i]) {
							if (user.profile.user_type == 'Natural' && i == 'profile') {
								if (o == data) {
									body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + user[i][o] + '</span></div></div>');
									card.append(title);
									card.append(body);
								}
							} else if (user.profile.user_type == 'Juridico' && i == 'organization') {
								console.log(o);
								if (o == data) {
									body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + user[i][o] + '</span></div></div>');
									card.append(title);
									card.append(body);
								}
							}

							if (data == 'exposed_type') {

								switch (o) {
									case 'public_employee':
										if (user[i][o] && !make) {
											body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + Lang.get("messages." + o) + '</span></div></div>');
											card.append(title);
											card.append(body);
											make = true;
										}
										break;
									case 'military':
										if (user[i][o] && !make) {
											body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + Lang.get("messages." + o) + '</span></div></div>');
											card.append(title);
											card.append(body);
											make = true;
										}
										break;
									case 'political_party_member':
										if (user[i][o] && !make) {
											body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + Lang.get("messages." + o) + '</span></div></div>');
											card.append(title);
											card.append(body);
											make = true;
										}
										break;
									case 'diplomatic':
										if (user[i][o] && !make) {
											body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + Lang.get("messages." + o) + '</span></div></div>');
											card.append(title);
											card.append(body);
											make = true;
										}
										break;
									default:
										if (!make) {
											body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + Lang.get("messages.none") + '</span></div></div>');
											card.append(title);
											card.append(body);

											make = true;
										}
										break;
								}
							}

							if (data == 'name') {
								if (o == 'fname') {
									name = user[i][o] + ' ';
								} else if (i == 'sname') {
									name += user[i][o];
									body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + name + '</span></div></div>');
									card.append(title);
									card.append(body);
								}
							}

							if (data == 'lastname') {
								if (o == 'flastname') {
									lastname = user[i][o] + ' ';
								} else if (o == 'slastname') {
									lastname += user[i][o];
									body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + lastname + '</span></div></div>');
									card.append(title);
									card.append(body);
								}
							}
						}
					}

					if (data == 'shareholders') {
						var _iteratorNormalCompletion6 = true;
						var _didIteratorError6 = false;
						var _iteratorError6 = undefined;

						try {
							for (var _iterator6 = user['organization']['patners'][Symbol.iterator](), _step6; !(_iteratorNormalCompletion6 = (_step6 = _iterator6.next()).done); _iteratorNormalCompletion6 = true) {
								var e = _step6.value;

								if (e['fname_legal_shareholder']) {
									title = $('<div class="col-sm-12 pl-4 mt-2"><h5>' + Lang.get("messages.shareholder") + '</h5></div>');
									body0 = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + e['position'] + '</span></div></div>');
									body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + e['fname_legal_shareholder'] + ' ' + e['sname_legal_shareholder'] + ' ' + e['flname_legal_shareholder'] + ' ' + e['slname_legal_shareholder'] + '</span></div></div>');
									body2 = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + e['id_legal_shareholder'] + '</span></div></div>');
									card.append(title);
									card.append(body0);
									card.append(body);
									card.append(body2);
								} else if (e['fname_legal_representative']) {
									title = $('<div class="col-sm-12 pl-4 mt-2"><h5>' + Lang.get("messages.legal_representative") + '</h5></div>');
									body0 = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + e['position'] + '</span></div></div>');
									body = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + e['fname_legal_representative'] + ' ' + e['sname_legal_representative'] + ' ' + e['flname_legal_representative'] + ' ' + e['slname_legal_representative'] + '</span></div></div>');
									body2 = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><span id="' + data + '">' + e['id_legal_representative'] + '</span></div></div>');
									card.append(title);
									card.append(body0);
									card.append(body);
									card.append(body2);
								}
							}
						} catch (err) {
							_didIteratorError6 = true;
							_iteratorError6 = err;
						} finally {
							try {
								if (!_iteratorNormalCompletion6 && _iterator6.return) {
									_iterator6.return();
								}
							} finally {
								if (_didIteratorError6) {
									throw _iteratorError6;
								}
							}
						}
					}

					if (a < count1) {
						inside1.append(card);
					} else {
						inside2.append(card);
					}
				}

				for (a = 0; a < documents.length; a++) {
					document1 = documents[a];

					card2 = $('<div class="row"></div>');

					title2 = $('<div class="col-sm-12 pl-4 mt-2"><h5>' + Lang.get("messages." + document1) + '</h5></div>');
					for (var i in user.document) {

						if (i == document1) {
							if (user.profile.user_type == 'Natural') {
								link = '/storage/' + user.profile.id_number + '/' + user.document[i];
							} else {
								link = '/storage/' + user.organization.merchant_record + '/' + user.document[i];
							}
							body2 = $('<div class="col-sm-12 card card-alternative" style="padding:0px; margin:0 auto;"><div class="card-body"><img id="' + data + '"  src="' + link + '" width="100%" ></div></div>');
							button = $('<a href="' + link + '" target="_blank"><button type="button" class="btn btn-alternative" >Descargar</button></a>');
							bigImage(body2, link);
						}
					}

					card2.append(title2);
					card2.append(body2);
					card2.append(button);

					if (a < count2) {
						inside3.append(card2);
					} else {
						inside4.append(card2);
					}
				}
				alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 0) + ' ' + Lang.get('messages.user') + '</strong></div>');

				id = $('<div class="form-group col-sm-6"><input id="id" name="id" type="hidden" value="' + user.id + '" class="form-control"></div>');

				box1.append(inside1);
				box1.append(inside2);

				box2.append(inside3);
				box2.append(inside4);

				box0.append(id);

				$('#userMod .modal-title').empty();
				$('#userMod .modal-body').empty();
				$('#userMod .modal-footer').empty();
				$('#userMod .modal-title').append(Lang.get('messages.verify') + ' ' + Lang.get('messages.user'));
				$('#userMod .modal-body').append(box);

				$('.UserForm').append(alert);

				$('.UserForm').append(box1);
				$('.UserForm').append(box2);
				$('.UserForm').append(box0);

				$('#userMod .modal-footer').append("<div id='userButts'></div>");

				closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				peBut = $("<button type='button' name='button' class='btn btn-alternative' id='userPass'>" + Lang.get('messages.verify') + "</button>");
				peButt = $("<button type='button' name='button' class='btn btn-alternative' id='userPass'>" + Lang.get('messages.reject') + "</button>");

				addMakeVuserButton(peBut);
				addMakeRuserButton(peButt);
				if (user.profile.user_type != 'Ninguno') {
					$('#userButts').append(peBut);
					$('#userButts').append(peButt);
				}

				$('#userButts').append(closebut);
			});
		};

		var addEditVUserClick = function addEditVUserClick(Button, user) {
			Button.click(function () {
				box = $("<div class='UserForm'></div>");

				box1 = $('<div class="row"></div>');
				box2 = $('<div class="row"></div>');
				box0 = $('<div class="row"></div>');
				body = '';

				if (!user.profile.level1_confirmed) {

					if (user.profile.user_type == 'Natural') {
						datas = ['fname', 'flastname', 'sname', 'slastname', 'email', 'street', 'house', 'country_id', 'region_id', 'city_id', 'id_number', 'type_id', 'date_issue', 'date_expiry', 'gender', 'marital_status', 'born_date', 'phonenumber', 'born_site', 'issuing_state'];
						documents = ['identification', 'selfie'];
					} else if (user.profile.user_type == 'Juridico') {
						datas = ['user_type', 'corporate_name', 'date_incorporation', 'place_incorporation', 'country_id', 'region_id', 'city_id', 'register_incoporation_office', 'postal_code', 'type_company', 'shareholders', 'legal_representative', 'merchant_record', 'issuing_state', 'date_issue', 'date_expiry', 'phone_number', 'website', 'email_address'];
						documents = ['rif', 'merchant_record'];
					} else {
						datas = ['No suministrada'];
						documents = [];
					}
				} else if (!user.profile.level2_confirmed) {
					if (user.profile.user_type == 'Natural') {
						datas = ['profession_occupation', 'position', 'politically_exposed_person', 'exposed_type', 'years_in_company', 'annual_income'];
						documents = ['rif', 'politically_document'];
					} else if (user.profile.user_type == 'Juridico') {
						datas = ['business_sector', 'products', 'services', 'monthly_income', 'annual_income', 'net_worth'];
					} else {
						datas = ['No suministrada'];
						documents = [];
					}
				} else if (!user.profile.level3_confirmed) {
					if (user.profile.user_type == 'Natural') {
						datas = ['financial_institution', 'account_number'];
						documents = ['source_founds', 'sworn_declaration'];
					} else if (user.profile.user_type == 'Juridico') {
						datas = ['account_number', 'ABA_routing', 'SWIFT', 'IBAN', 'financial_institution', 'bank_address', 'currency'];
						documents = ['source_founds'];
					} else {
						datas = ['No suministrada'];
						documents = [];
					}
				}

				inside1 = $('<div class="col-sm-6"></div>');
				inside2 = $('<div class="col-sm-6"></div>');

				inside3 = $('<div class="col-sm-6"></div>');
				inside4 = $('<div class="col-sm-6"></div>');

				count1 = datas.length / 2;
				count2 = documents.length / 2;

				for (a = 0; a < datas.length; a++) {
					data = datas[a];

					card = $('<div class="formgroup"></div>');

					title = $('<div class="col-sm-12 pl-4 mt-2"><h5>' + Lang.get("messages." + data) + '</h5></div>');

					var make = false;

					if (data == 'No suministrada') {
						card.append(title);
					}

					for (var i in user) {

						for (var o in user[i]) {
							if (o == data) {
								if (user.profile.user_type == 'Natural' && i == 'profile') {
									if (data == 'date_issue') {
										body = $('<input type="date" class="form-control" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" value="' + user[i][o] + '" >');
									} else if (data == 'date_expiry') {
										body = $('<input type="date" class="form-control" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" value="' + user[i][o] + '" >');
									} else if (data == 'born_date') {
										body = $('<input type="date" class="form-control" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" value="' + user[i][o] + '" >');
									} else {
										body = $('<input type="text" class="form-control" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" value="' + user[i][o] + '" >');
									}
								} else if (user.profile.user_type == 'Juridico' && i == 'organization') {
									if (data == 'date_issue') {
										body = $('<input type="date" class="form-control" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" value="' + user[i][o] + '" >');
									} else if (data == 'date_expiry') {
										body = $('<input type="date" class="form-control" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" value="' + user[i][o] + '" >');
									} else if (data == 'date_incorporation') {
										body = $('<input type="date" class="form-control" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" value="' + user[i][o] + '" >');
									} else {
										body = $('<input type="text" class="form-control" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" value="' + user[i][o] + '" >');
									}
								}
							}
						}

						if (data == 'type_id') {
							body = $('<select class="form-control custom-select" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" ></select');
							op1 = $('<option value="1">Cedula</option>');
							op2 = $('<option value="2">Pasaporte</option>');
							op3 = $('<option value="3">Licencia de Conducir</option>');
							body.append(op1);
							body.append(op2);
							body.append(op3);
						}

						if (data == 'exposed_type') {
							body = $('<select class="form-control custom-select" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" ></select');
							op0 = $('<option value="none">Ninguno</option>');
							op1 = $('<option value="public_employee">Empleado Publico</option>');
							op2 = $('<option value="military">Militar</option>');
							op3 = $('<option value="political_party_member">Miembro de partido politico</option>');
							op4 = $('<option value="diplomat">Diplomatico</option>');
							body.append(op0);
							body.append(op1);
							body.append(op2);
							body.append(op3);
							body.append(op4);
						}

						if (data == 'politically_exposed_person') {
							body = $('<select class="form-control custom-select" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" ></select');
							op1 = $('<option value="0">No</option>');
							op2 = $('<option value="1">Si</option>');
							body.append(op1);
							body.append(op2);
						}

						if (data == 'gender') {
							body = $('<select class="form-control custom-select" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '" ></select');
							op1 = $('<option value="M">Masculino</option>');
							op2 = $('<option value="F">Femenino</option>');
							body.append(op1);
							body.append(op2);
						}

						if (data == 'marital_status') {
							body = $('<select class="form-control custom-select" id="' + data + '" placeholder="' + Lang.get("messages." + data) + '"  ></select');
							op1 = $('<option value="1">Soltero</option>');
							op2 = $('<option value="2">Casado</option>');
							op3 = $('<option value="3">Divorciado</option>');
							op4 = $('<option value="4">Viudo</option>');
							body.append(op1);
							body.append(op2);
							body.append(op3);
							body.append(op4);
						}

						if (data == 'country_id') {
							body = $('<select class="form-control custom-select" id="country" placeholder="' + Lang.get("messages." + data) + '"  ></select');
						}

						if (data == 'region_id') {
							body = $('<select class="form-control custom-select" id="state" placeholder="' + Lang.get("messages." + data) + '"  ></select');
						}

						if (data == 'city_id') {
							body = $('<select class="form-control custom-select" id="city" placeholder="' + Lang.get("messages." + data) + '"></select');
						}

						if (data == 'born_site') {
							body = $('<select class="form-control custom-select" id="bornCity" placeholder="' + Lang.get("messages." + data) + '" ></select');
						}

						if (data == 'issuing_state') {
							body = $('<select class="form-control custom-select" id="issuState" placeholder="' + Lang.get("messages." + data) + '" ></select');
						}
					}

					if (data == 'shareholders') {
						var numA = 0;
						var numB = 0;
						var _iteratorNormalCompletion7 = true;
						var _didIteratorError7 = false;
						var _iteratorError7 = undefined;

						try {
							for (var _iterator7 = user['organization']['patners'][Symbol.iterator](), _step7; !(_iteratorNormalCompletion7 = (_step7 = _iterator7.next()).done); _iteratorNormalCompletion7 = true) {
								var e = _step7.value;


								if (e['fname_legal_shareholder']) {

									title = $('<div class="col-sm-12 pl-4 mt-2"><h5>' + Lang.get("messages.shareholder") + '</h5></div>');

									body0 = $('<input type="text" class="form-control" id="position' + e['id'] + '" placeholder="' + Lang.get("messages.position") + '" value="' + e['position'] + '" >');
									body1 = $('<input type="text" class="form-control" id="fname_shareholder' + e['id'] + '" placeholder="' + Lang.get("messages.fname") + '" value="' + e['fname_legal_shareholder'] + '" >');
									body2 = $('<input type="text" class="form-control" id="sname_shareholder' + e['id'] + '" placeholder="' + Lang.get("messages.sname") + '" value="' + e['sname_legal_shareholder'] + '" >');
									body3 = $('<input type="text" class="form-control" id="flname_shareholder' + e['id'] + '" placeholder="' + Lang.get("messages.flastname") + '" value="' + e['flname_legal_shareholder'] + '" >');
									body4 = $('<input type="text" class="form-control" id="slname_shareholder' + e['id'] + '" placeholder="' + Lang.get("messages.slastname") + '" value="' + e['slname_legal_shareholder'] + '" >');
									body5 = $('<input type="text" class="form-control" id="id_shareholder' + e['id'] + '" placeholder="' + Lang.get("messages.id") + '" value="' + e['id_legal_shareholder'] + '" >');

									card.append(title);
									card.append(body0);
									card.append(body1);
									card.append(body2);
									card.append(body3);
									card.append(body4);
									card.append(body5);

									numA++;
								} else if (e['fname_legal_representative']) {

									title = $('<div class="col-sm-12 pl-4 mt-2"><h5>' + Lang.get("messages.legal_representative") + '</h5></div>');

									body0 = $('<input type="text" class="form-control" id="position' + e['id'] + '" placeholder="' + Lang.get("messages.position") + '" value="' + e['position'] + '" >');
									body1 = $('<input type="text" class="form-control" id="fname_representative' + e['id'] + '" placeholder="' + Lang.get("messages.fname") + '" value="' + e['fname_legal_representative'] + '" >');
									body2 = $('<input type="text" class="form-control" id="sname_representative' + e['id'] + '" placeholder="' + Lang.get("messages.sname") + '" value="' + e['sname_legal_representative'] + '" >');
									body3 = $('<input type="text" class="form-control" id="flname_representative' + e['id'] + '" placeholder="' + Lang.get("messages.flastname") + '" value="' + e['flname_legal_representative'] + '" >');
									body4 = $('<input type="text" class="form-control" id="slname_representative' + e['id'] + '" placeholder="' + Lang.get("messages.slastname") + '" value="' + e['slname_legal_representative'] + '" >');
									body5 = $('<input type="text" class="form-control" id="id_representative' + e['id'] + '" placeholder="' + Lang.get("messages.id") + '" value="' + e['id_legal_representative'] + '" >');

									card.append(title);
									card.append(body0);
									card.append(body1);
									card.append(body2);
									card.append(body3);
									card.append(body4);
									card.append(body5);

									numB++;
								}
							}
						} catch (err) {
							_didIteratorError7 = true;
							_iteratorError7 = err;
						} finally {
							try {
								if (!_iteratorNormalCompletion7 && _iterator7.return) {
									_iterator7.return();
								}
							} finally {
								if (_didIteratorError7) {
									throw _iteratorError7;
								}
							}
						}
					}

					card.append(title);
					card.append(body);

					if (a < count1) {
						inside1.append(card);
					} else {
						inside2.append(card);
					}
				}

				for (a = 0; a < documents.length; a++) {
					document1 = documents[a];

					card2 = $('<div class="formgroup"></div>');

					title2 = $('<div class="col-sm-12 pl-4 mt-2"><h5>' + Lang.get("messages." + document1) + '</h5></div>');
					for (var i in user.document) {
						console.log(i);
						if (i == document1) {
							body2 = $('<input type="file" class="form-control" id="f' + i + '"/>');
						}
					}

					card2.append(title2);
					card2.append(body2);

					if (a < count2) {
						inside3.append(card2);
					} else {
						inside4.append(card2);
					}
				}

				alert = $('<div class="alert alert-success" style="display: none;"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> <strong>' + Lang.get('messages.check_confirm') + ' ' + Lang.choice('messages.the', 0) + ' ' + Lang.get('messages.user') + '</strong></div>');

				id = $('<div class="form-group col-sm-6"><input id="id" name="id" type="hidden" value="' + user.id + '" class="form-control"></div>');

				box1.append(inside1);
				box1.append(inside2);

				box2.append(inside3);
				box2.append(inside4);

				box0.append(id);

				$('#userMod .modal-title').empty();
				$('#userMod .modal-body').empty();
				$('#userMod .modal-footer').empty();
				$('#userMod .modal-title').append(Lang.get('messages.verify') + ' ' + Lang.get('messages.user'));
				$('#userMod .modal-body').append(box);

				$('.UserForm').append(alert);

				$('.UserForm').append(box1);
				$('.UserForm').append(box2);
				$('.UserForm').append(box0);

				$('#userMod .modal-footer').append("<div id='userButts'></div>");

				closebut = $('<button type="button" class="btn btn-alternative" data-dismiss="modal">' + Lang.get('messages.close') + '</button>');
				peBut = $("<button type='button' name='button' class='btn btn-alternative' id='userPass'>" + Lang.get('messages.edit') + "</button>");

				addMakeVEuserButton(peBut, user);

				$('#userButts').append(peBut);
				$('#userButts').append(closebut);

				if (user.profile.user_type == 'Natural') {
					country(user.profile.country_id);
					countryS('#issuState', user.profile.issuing_state);
					states('#country', user.profile.region_id);
					cities('#state', user.profile.city_id);
					bornCountry(user.profile.born_site);
				} else {
					country(user.organization.country_id);
					console.log(user.organization.issuing_state);
					statesS('#issuState', '#country', user.organization.issuing_state);
					states('#country', user.organization.region_id);
					cities('#state', user.organization.city_id);
				}
			});
		};

		var bigImage = function bigImage(modal, src) {
			modal.click(function () {
				$('#userImage .modal-body').empty();
				$('#userImage .modal-body').append("<img class='imageModal'  src='" + src + "' width='100%' height='auto' >");
			});
		};

		/* Make User Button For editing */


		var addMakeVuserButton = function addMakeVuserButton(makeBut) {

			makeBut.click(function (e) {

				$('#confirm').modal('show');

				$('#text-content').empty();
				$('#text-content').append('Realmente desea verificar a este usuario?');
				$('#confirm').modal('show');
				$(this).addClass('disabled');
				$(this).prop('disabled', true);

				if (confirmPut == false) {
					confirmPut = true;
					$('#yes').click(function (e) {
						id = $('#id').val();
						$('#confirm').modal('hide');
						$.ajax({
							headers: {
								'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
							},
							data: { id: id },
							url: globalUrl+'/kycconfirm',
							type: 'post',
							success: function success(data) {
								$(this).removeClass('disabled');
								$(this).prop('disabled', false);
								$('.text-alert').empty();
								$('.text-alert').append(data.respond);
								$('.alert').removeClass('alert-danger');
								$('.alert').removeClass('alert-warning');
								$('.alert').addClass('alert-success');
								$('#userAlertMod').modal('show');
								$('#userMod').modal('hide');
								_searchUser(1);
							},
							error: function error(_error60) {
								$(this).removeClass('disabled');
								$(this).prop('disabled', false);
								$('.text-alert').empty();
								$('.text-alert').append('An error has ocurred');
								$('.alert').removeClass('alert-success');
								$('.alert').removeClass('alert-danger');
								$('.alert').addClass('alert-warning');
								$('#userAlertMod').modal('show');
							}
						});
					});
				}
			});
		};

		var addMakeVEuserButton = function addMakeVEuserButton(makeBut, user) {

			makeBut.click(function (e) {

				$('#confirm').modal('show');

				$('#text-content').empty();
				$('#text-content').append('Realmente desea modificar a este usuario?');
				$('#confirm').modal('show');
				$(this).addClass('disabled');
				$(this).prop('disabled', true);
				$('#yes').click(function (e) {
					id = $('#id').val();
					$('#confirm').modal('hide');

					if (!user.profile.level1_confirmed) {
						if (user.profile.user_type == "Natural") {

							var photo_id = $('#fidentification')[0].files[0];
							var selfie = $('#fselfie')[0].files[0];
							var fname = $('#fname').val();
							var sname = $('#sname').val();
							var flastname = $('#flastname').val();
							var slastname = $('#slastname').val();
							var id_number = $('#id_number').val();
							var type_id = $('#type_id').val();
							var date_issue = $('#date_issue').val();
							var date_expiry = $('#date_expiry').val();
							var email = $('#email').val();
							var gender = $('#gender').val();
							var street = $('#street').val();
							var marital_status = $('#marital_status').val();
							var house = $('#house').val();
							var country = $('#country').val();
							var phonenumber = $('#phonenumber').val();
							var state = $('#state').val();
							var city = $('#city').val();
							var born_site = $('#bornCity').val();
							var born_date = $('#born_date').val();
							var issuing_state = $('#issuState').val();

							var data = {
								id: id,
								fname: fname,
								sname: sname,
								flastname: flastname,
								slastname: slastname,
								id_number: id_number,
								type_id: type_id,
								date_issue: date_issue,
								date_expiry: date_expiry,
								email: email,
								gender: gender,
								street: street,
								marital_status: marital_status,
								house: house,
								country: country,
								born_date: born_date,
								phonenumber: phonenumber,
								state: state,
								city: city,
								born_site: born_site,
								issuing_state: issuing_state
							};

							if (photo_id || selfie) {

								if (photo_id) {
									var file_type = photo_id.type.split('/');

									if (file_type[0] != 'image') {
										$('.text-alert').empty();
										$('.text-alert').append('El archivo subido de ser de tipo imagen');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										return $('#fundsAlertMod').modal('show');
									}
									readerFile(photo_id, 'photo_id', '/photo-id-edit', id, true);
								}

								if (selfie) {
									file_type = selfie.type.split('/');

									if (file_type[0] != 'image') {
										$('.text-alert').empty();
										$('.text-alert').append('Los archivos subidos deben ser de tipo imagen');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										return $('#fundsAlertMod').modal('show');
									}
									readerFile(selfie, 'selfie', '/selfie-edit', id, true);
								}
							}
						} else {
							var juridic_rif = $('#frif')[0].files[0];
							var fmerchant_record = $('#fmerchant_record')[0].files[0];
							var corporate_name = $('#corporate_name').val();
							var date_incorporation = $('#date_incorporation').val();
							var place_incorporation = $('#place_incorporation').val();
							var country = $('#country').val();
							var state = $('#state').val();
							var city = $('#city').val();
							var register_incoporation_office = $('#register_incoporation_office').val();
							var postal_code = $('#postal_code').val();
							var type_company = $('#type_company').val();
							var sharehold = [];
							for (i = 0; i < user.organization.patners.length; i++) {
								console.log(sharehold);
								if (user.organization.patners[i].fname_legal_shareholder) {
									share = {
										position: $('#position' + user.organization.patners[i].id).val(),
										fname: $('#fname_shareholder' + user.organization.patners[i].id).val(),
										sname: $('#sname_shareholder' + user.organization.patners[i].id).val(),
										flname: $('#flname_shareholder' + user.organization.patners[i].id).val(),
										slname: $('#slname_shareholder' + user.organization.patners[i].id).val(),
										id_number: $('#id_shareholder' + user.organization.patners[i].id).val(),
										id: user.organization.patners[i].id,
										type: 'shareholder'
									};
									sharehold.push(share);
								} else {
									share = {
										position: $('#position' + user.organization.patners[i].id).val(),
										fname: $('#fname_representative' + user.organization.patners[i].id).val(),
										sname: $('#sname_representative' + user.organization.patners[i].id).val(),
										flname: $('#flname_representative' + user.organization.patners[i].id).val(),
										slname: $('#slname_representative' + user.organization.patners[i].id).val(),
										id_number: $('#id_representative' + user.organization.patners[i].id).val(),
										id: user.organization.patners[i].id,
										type: 'representative'
									};
									sharehold.push(share);
								}
								console.log(share);
							}
							var shareholders = $('#shareholders').val();
							var legal_representative = $('#legal_representative').val();
							var merchant_record = $('#merchant_record').val();
							var issuing_state = $('#issuState').val();
							var date_issue = $('#date_issue').val();
							var date_expiry = $('#date_expiry').val();
							var phone_number = $('#phone_number').val();
							var website = $('#website').val();
							var email_address = $('#email_address').val();
							console.log(sharehold);
							var data = {
								id: id,
								corporate_name: corporate_name,
								date_incorporation: date_incorporation,
								place_incorporation: place_incorporation,
								register_incoporation_office: register_incoporation_office,
								postal: postal_code,
								type_company: type_company,
								sharehold: sharehold,
								shareholders: shareholders,
								legal_representative: legal_representative,
								merchant_record: merchant_record,
								phone_number: phone_number,
								website: website,
								email_address: email_address,
								date_issue: date_issue,
								date_expiry: date_expiry,
								country: country,
								state: state,
								city: city,
								issuing_state: issuing_state
							};

							if (juridic_rif || fmerchant_record) {
								var fd = new FormData();

								if (juridic_rif) {
									var file_type = juridic_rif.type.split('/');

									if (file_type[0] != 'pdf') {
										$('.text-alert').empty();
										$('.text-alert').append('El archivo subido de ser de tipo pdf');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										return $('#fundsAlertMod').modal('show');
									}
									fd.append('rif', juridic_rif);
								}

								if (fmerchant_record) {
									file_type = fmerchant_record.type.split('/');

									if (file_type[0] != 'pdf') {
										$('.text-alert').empty();
										$('.text-alert').append('Los archivos subidos deben ser de tipo pdf');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										return $('#fundsAlertMod').modal('show');
									}
									fd.append('merchant_record', fmerchant_record);
								}

								$.ajax({
									headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
									url: globalUrl+'/juridic-edit',
									type: 'POST',
									data: fd,
									contentType: false,
									processData: false,
									success: function success(data) {},
									error: function error(_error61) {
										$('.text-alert').empty();
										$('.text-alert').append('Error');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										return $('#AlertMod').modal('show');
									}
								});
							}
						}
					} else if (!user.profile.level2_confirmed) {
						if (user.profile.user_type == "Natural") {
							var rif = $('#frif')[0].files[0];
							var politically_document = $('#fpolitically_document')[0].files[0];

							var profession_occupation = $('#profession_occupation').val();
							var exposed_type = $('#exposed_type').val();
							var position = $('#position').val();
							var years_in_company = $('#years_in_company').val();
							var politically_exposed_person = $('#politically_exposed_person').val();
							var annual_income = $('#annual_income').val();

							data = {
								id: id,
								profession_occupation: profession_occupation,
								exposed_type: exposed_type,
								position: position,
								years_in_company: years_in_company,
								politically_exposed_person: politically_exposed_person,
								annual_income: annual_income
							};

							if (rif || politically_document) {

								if (rif) {
									var file_type = rif.type.split('/');

									if (file_type[0] != 'image') {
										$('.text-alert').empty();
										$('.text-alert').append('El archivo subido de ser de tipo imagen');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										return $('#fundsAlertMod').modal('show');
									}
									readerFile(rif, 'rif', '/address-edit', id, true);
								}

								if (politically_document) {
									file_type = selfie.type.split('/');

									if (file_type[0] != 'pdf') {
										$('.text-alert').empty();
										$('.text-alert').append('Los archivos subidos deben ser de tipo PDF');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										return $('#fundsAlertMod').modal('show');
									}
									readerFile(politically_document, 'political', '/exposed-edit', id, true);
								}
							}
						} else {
							var business_sector = $('#business_sector').val();
							var products = $('#products').val();
							var services = $('#services').val();
							var monthly_income = $('#monthly_income').val();
							var annual_income = $('#annual_income').val();
							var net_worth = $('#net_worth').val();

							data = {
								id: id,
								business_sector: business_sector,
								products: products,
								services: services,
								monthly_income: monthly_income,
								annual_income: annual_income,
								net_worth: net_worth
							};
						}
					} else if (!user.profile.level3_confirmed) {
						if (user.profile.user_type == "Natural") {
							var source_founds = $('#fsource_founds')[0].files[0];
							var sworn_declaration = $('#fsworn_declaration')[0].files[0];
							var financial_institution = $('#financial_institution').val();
							var account_number = $('#account_number').val();

							data = {
								id: id,
								financial_institution: financial_institution,
								account_number: account_number
							};

							if (source_founds || sworn_declaration) {

								var fd = new FormData();

								if (source_founds) {
									var file_type = source_founds.type.split('/');

									if (file_type[1] != 'pdf') {
										$('.text-alert').empty();
										$('.text-alert').append('El archivo subido debe ser de tipo pdf');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										return $('#AlertMod').modal('show');
									}

									fd.append('source_founds', source_founds);
								}

								if (sworn_declaration) {
									file_type = sworn_declaration.type.split('/');

									if (file_type[1] != 'pdf') {
										$('.text-alert').empty();
										$('.text-alert').append('Los archivos subidos deben ser de tipo pdf');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										return $('#AlertMod').modal('show');
									}

									fd.append('sworn_declaration', sworn_declaration);
								}

								$.ajax({
									headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
									url: globalUrl+'/bank-edit',
									type: 'POST',
									data: fd,
									contentType: false,
									processData: false,
									success: function success(data) {},
									error: function error(_error62) {
										$('.text-alert').empty();
										$('.text-alert').append('Error');
										$('.alert').removeClass('alert-success');
										$('.alert').removeClass('alert-danger');
										$('.alert').addClass('alert-warning');
										return $('#AlertMod').modal('show');
									}
								});
							}
						} else {
							var source_founds = $('#fsource_founds')[0].files[0];
							var financial_institution = $('#financial_institution').val();
							var account_number = $('#account_number').val();
							var aba_routing = $('#ABA_routing').val();
							var swift = $('#SWIFT').val();
							var iban = $('#IBAN').val();
							var bank_address = $('#bank_address').val();
							var currency = $('#currency').val();

							data = {
								id: id,
								financial_institution: financial_institution,
								account_number: account_number,
								ABA_routing: aba_routing,
								SWIFT: swift,
								IBAN: iban,
								bank_address: bank_address,
								currency: currency
							};

							if (source_founds) {

								var file_type = source_founds.type.split('/');

								if (file_type[0] != 'pdf') {
									$('.text-alert').empty();
									$('.text-alert').append('El archivo subido de ser de tipo pdf');
									$('.alert').removeClass('alert-success');
									$('.alert').removeClass('alert-danger');
									$('.alert').addClass('alert-warning');
									return $('#fundsAlertMod').modal('show');
								}
								readerFile(source_founds, 'source_founds', '/bank-juridic-edit', id, true);
							}
						}
					}

					$.ajax({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						},
						data: data,
						url: globalUrl+'/kycupdate',
						type: 'post',
						success: function success(data) {
							$(this).removeClass('disabled');
							$(this).prop('disabled', false);
							$('.text-alert').append(data.respond);
							$('.alert').removeClass('alert-danger');
							$('.alert').removeClass('alert-warning');
							$('.alert').addClass('alert-success');
							$('#userAlertMod').modal('show');
							$('#userMod').modal('hide');
							_searchUser(1);
						},
						error: function error(_error63) {
							$(this).removeClass('disabled');
							$(this).prop('disabled', false);
							$('.text-alert').empty();
							$('.text-alert').append('An error has ocurred');
							$('.alert').removeClass('alert-success');
							$('.alert').removeClass('alert-danger');
							$('.alert').addClass('alert-warning');
							$('#userAlertMod').modal('show');
						}
					});
				});
			});
		};

		/* Make User Button For editing */


		var addMakeRuserButton = function addMakeRuserButton(makeBut) {

			makeBut.click(function (e) {
				$('#userReject .modal-title').empty();
				$('#userReject .modal-body').empty();
				$('#userReject .modal-footer').empty();

				$('#userReject .modal-title').append('Rechazar usuario');

				box = $('<div></div>');
				select1 = $('<label><input id="invalidData" type="checkbox" name=invalidData"" value="true">Datos Invalidos</label>');
				select2 = $('<label><input id="concordanceData" type="checkbox" name="checkbox" value="true">Datos no concuerdan</label>');
				select3 = $('<label><input id="invalidFiles" type="checkbox" name="checkbox" value="true">Archivos Invalidos</label>');

				button = $("<button type='button' name='button' class='btn btn-alternative' id='userPass'>" + Lang.get('messages.reject') + "</button>");

				addRejectUserButton(button);

				box.append(select1);
				box.append(select2);
				box.append(select3);

				$('#userReject .modal-body').append(box);
				$('#userReject .modal-footer').append(button);

				$('#userReject').modal('show');
			});
		};

		var addRejectUserButton = function addRejectUserButton(button) {
			button.click(function () {

				id = $('#id').val();
				if ($('#invalidData').is(':checked')) {
					data = true;
				} else {
					data = false;
				}
				if ($('#concordanceData').is(':checked')) {
					concor = true;
				} else {
					concor = false;
				}
				if ($('#invalidFiles').is(':checked')) {
					files = true;
				} else {
					files = false;
				}

				$('#userReject').modal('hide');
				$.ajax({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					},
					data: { id: id, data: data, concor: concor, files: files },
					url: globalUrl+'/kycreject',
					type: 'post',
					success: function success(data) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append(data.respond);
						$('.alert').removeClass('alert-danger');
						$('.alert').removeClass('alert-warning');
						$('.alert').addClass('alert-success');
						$('#userAlertMod').modal('show');
						$('#userMod').modal('hide');
						_searchUser(1);
					},
					error: function error(_error64) {
						$(this).removeClass('disabled');
						$(this).prop('disabled', false);
						$('.text-alert').empty();
						$('.text-alert').append('An error has ocurred');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						$('#userAlertMod').modal('show');
					}
				});
			});
		};

		/*Execute Script*/


		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');

		$('.listkycUser').addClass('active');
		/*Search User Table*/

		$('#table_user_header_name').click(function (e) {
			_orderTableUserBy('name');
		});

		$('#table_user_header_email').click(function (e) {
			_orderTableUserBy('email');
		});

		$('#table_user_header_date').click(function (e) {
			_orderTableUserBy('created_at');
		});

		$('#table_user_header_verify').click(function (e) {
			_orderTableUserBy('kyc_confirmed');
		});

		$('#table_user_header_update').click(function (e) {
			_orderTableUserBy('updated_at');
		});

		var orderUserBy = "";
		var orderUserDirection = "";
		var searchUserValue = "";
		var confirmPut = false;

		$("#form_user_search").submit(function (e) {
			e.preventDefault();
			//DESC
			searchUserValue = $("#search_user_value").val();
			_searchUser(1);
		});

		$('#result_user_page').change(function () {
			$('#form_user_search').trigger("submit");
		});

		$('#form_user_search').trigger("submit");
	}

	/*End User KYC Functions*/

	/*KYC Personal Information*/

	if (pathverify('/personal-information')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
		country();
		states('#country');
		phonePrefix('#country');
		cities('#state');
		bornCountry();
		countryS('#issuing_state');

		$('#continue').click(function () {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Está seguro de la información que desea cargar? Se pediran soportes de los datos y si desea cambiar alguna información, debera contactarnos de forma directa');
			$('#yes').click(function (e) {
				jQuery.validator.addMethod("lettersonly", function (value, element) {
					return this.optional(element) || /^[a-z\s]+$/i.test(value);
				}, "Solo caracteres alfabéticos");

				jQuery.validator.addMethod("username", function (value, element) {
					return this.optional(element) || /^[a-z\s\d]+$/i.test(value);
				}, "Solo caracteres alfabéticos and numbers");

				$('#kycForm').validate({
					rules: {
						type_id: {
							required: true
						},
						identification: {
							required: true
						},
						issuing_state: {
							required: true
						},
						date_issue: {
							required: true
						},
						date_expiry: {
							required: true
						},
						gender: {
							required: true
						},
						marital_status: {
							required: true
						},
						country: {
							required: true
						},
						state: {
							required: true
						},
						street: {
							required: true
						},
						house: {
							required: true
						},
						postal: {
							required: true,
							minlength: 4,
							number: true
						},
						phone: {
							required: true
						},
						bornDate: {
							required: true
						},
						bornCity: {
							required: true
						}
					}
				});

				if ($('#kycForm').valid()) {
					type_id = $('#type_id').val();
					issuing_state = $('#issuing_state').val();
					date_issue = $('#date_issue').val();
					date_expiry = $('#date_expiry').val();
					gender = $('#gender').val();
					marital_status = $('#marital_status').val();
					identification = $('#identification').val();
					country = $('#country').val();
					state = $('#state').val();
					city = $('#city').val();
					street = $('#street').val();
					house = $('#house').val();
					postal = $('#postal').val();
					phone = $('#phone').val();
					birthDate = $('#bornDate').val();
					bornCity = $('#bornCity').val();

					$.ajax({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						},
						data: {
							type_id: type_id, issuing_state: issuing_state, date_issue: date_issue, date_expiry: date_expiry,
							gender: gender, marital_status: marital_status, country: country, state: state, city: city, street: street,
							house: house, postal: postal, phone: phone, birthDate: birthDate, bornCity: bornCity, identification: identification
						},
						url: globalUrl+"/valid-personal-information",
						type: 'post',
						success: function success(data) {
							window.location.replace(globalUrl+'/personal-document');
						},
						error: function error(_error65) {
							$('.text-alert').empty();
							if (_error65.responseJSON.message) {
								$('.text-alert').append(_error65.responseJSON.message);
							} else {
								$('.text-alert').append(Lang.get('messages.error'));
							}
							$('.alert').removeClass('alert-success');
							$('.alert').removeClass('alert-danger');
							$('.alert').addClass('alert-warning');
							$('#AlertMod').modal('show');
						}
					});
				} else {
					$('#confirm').modal('hide');
				}
			});
		});
	}

	/*End KYC Personal Information*/

	/* Function Upload Document */

	function readerFile(photo, flag, url) {
		var user = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
		var other = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;

		var newphoto = null;
		var name = photo.name;
		var reader = new FileReader();
		reader.readAsDataURL(photo);
		reader.onloadend = function () {
			photoTemp = reader.result;
			var img = document.createElement('img');
			img.src = photoTemp;
			img.onload = function () {
				photoTemp = toDataUrl(img);
				toDataBlob(img, name).then(function (imageBlob) {
					newphoto = imageBlob;
					var fd = new FormData();
					fd.append(flag, newphoto);
					fd.append('id', user);
					$.ajax({
						headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
						url: globalUrl+url,
						type: 'POST',
						data: fd,
						contentType: false,
						processData: false,
						success: function success(data) {
							if (!other) {
								window.location.replace(globalUrl+'/success');
							}
						},
						error: function error(_error66) {
							$('.text-alert').empty();
							$('.text-alert').append('Error');
							$('.alert').removeClass('alert-success');
							$('.alert').removeClass('alert-danger');
							$('.alert').addClass('alert-warning');
							return $('#fundsAlertMod').modal('show');
						}
					});
				});
			};
		};
	}

	/* Function Upload Document */

	/*KYC Personal Document*/

	if (pathverify('/personal-document')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
		$('#next').click(function (e) {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Está seguro que los documentos cargados son correctos? Se analizará la información solicitada, si existe alguna incongruencia le notificaremos vía correo electrónico y deberá contactarnos de forma directa para poder verificar los documentos auténticos.');
			$('#yes').click(function () {
				$('#confirm').modal('hide');
				$('#document').validate({
					rules: {
						photo_id: {
							required: true
						},
						selfie: {
							required: true
						}
					}
				});

				if ($('#document').valid()) {
					var photo_id = $('#photo_id')[0].files[0];
					var selfie = $('#selfie')[0].files[0];

					var file_type = photo_id.type.split('/');

					if (file_type[0] != 'image') {
						$('.text-alert').empty();
						$('.text-alert').append('El archivo subido de ser de tipo imagen');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						return $('#fundsAlertMod').modal('show');
					}

					file_type = selfie.type.split('/');

					if (file_type[0] != 'image') {
						$('.text-alert').empty();
						$('.text-alert').append('Los archivos subidos deben ser de tipo imagen');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						return $('#fundsAlertMod').modal('show');
					}

					readerFile(photo_id, 'photo_id', '/valid-photo-id');
					readerFile(selfie, 'selfie', '/valid-selfie');
					return;
				} else {
					$('#confirm').modal('hide');
					return;
				}

				return;
			});
		});
	}

	/*End KYC Personal Document*/

	/*KYC Professional Information*/

	if (pathverify('/professional-information')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');

		$('#politically_exposed_person').change(function () {
			if ($('select[name=politically_exposed_person]').val() == 1) {
				div_form = $('<div class="form-group col-md-6" id="delet"></div>');

				label_exposed = $('<label for="fname" class="control-label font-weight-bold">Tipo de persona</label>');
				select_exposed = $('<select name="select_exposed_person" id="select_exposed_person" class="form-control custom-select"></select>');

				option_public_employee = $('<option value="public_employee">Empleado Publico</option>');
				option_military = $('<option value="military">Militar</option>');
				option_political_party_member = $('<option value="political_party_member">Miembro de partido político</option>');
				option_diplomat = $('<option value="diplomat">Diplomatico</option>');

				div_form.append(label_exposed);
				div_form.append(select_exposed);

				select_exposed.append(option_public_employee);
				select_exposed.append(option_military);
				select_exposed.append(option_political_party_member);
				select_exposed.append(option_diplomat);

				return $('#exposed').append(div_form);
			} else {
				return $('#delet').remove();
			}
		});

		$('#continue').click(function () {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Está seguro de la información que desea cargar? Se pedirán soportes de los datos y si desea cambiar alguna información, deberá contactarnos de forma directa');
			$('#yes').click(function (e) {
				$('#kycProForm').validate({
					rules: {
						profession_occupation: {
							required: true
						},
						position: {
							required: true
						},
						politically_exposed_person: {
							required: true
						},
						years_in_company: {
							required: true
						},
						annual_income: {
							required: true
						}
					}
				});

				if ($('#kycProForm').valid()) {
					profession_occupation = $('#profession_occupation').val();
					position = $('#position').val();
					politically_exposed_person = $('#politically_exposed_person').val();
					years_in_company = $('#years_in_company').val();
					annual_income = $('#annual_income').val();
					select_exposed_person = $('#select_exposed_person').val();

					$.ajax({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						},
						data: {
							profession_occupation: profession_occupation, position: position, politically_exposed_person: politically_exposed_person,
							years_in_company: years_in_company, annual_income: annual_income, select_exposed_person: select_exposed_person
						},
						url: globalUrl+"/valid-professional-information",
						type: 'post',
						success: function success(data) {
							window.location.replace(globalUrl+'/professional-document');
						}
					});
				} else {
					$('#confirm').modal('hide');
				}
			});
		});
	}
	/*End KYC Professional Information*/

	/* KYC Professional Document */

	if (pathverify('/professional-document')){
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');

		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			url: globalUrl+"/get-person-exposed",
			type: 'get',
			success: function success(data) {
				if (data) {
					div_form = $('<div class="form-group col-md-12"></div>');

					label_exposed = $('<label for="person_exposed" class="control-label font-weight-bold">Documento de persona politicamente expuesta</label>');
					input_exposed = $('<input id="person_exposed" type="file" class="form-control" style="height: auto;" name="person_exposed">');

					div_form.append(label_exposed);
					div_form.append(input_exposed);

					$('#exposedDocument').append(div_form);

					$('#next').click(function (e) {
						$('#confirm').modal('show');
						$('#text-content').empty();
						$('#text-content').append('¿Está seguro que los documentos cargados son correctos? Se analizará la información solicitada, si existe alguna incongruencia le notificaremos via correo electrónico y debera contactarnos de forma directa para poder verificar los documentos autenticos.');
						$('#yes').click(function () {
							$('#confirm').modal('hide');
							var address = $('#address')[0].files[0];
							var person_exposed = $('#person_exposed')[0].files[0];

							var file_type = address.type.split('/');

							if (file_type[0] != 'image') {
								$('.text-alert').empty();
								$('.text-alert').append('El archivo subido de ser de tipo imagen');
								$('.alert').removeClass('alert-success');
								$('.alert').removeClass('alert-danger');
								$('.alert').addClass('alert-warning');
								return $('#AlertMod').modal('show');
							}

							file_type = person_exposed.type.split('/');

							if (file_type[1] != 'pdf') {
								$('.text-alert').empty();
								$('.text-alert').append('Los archivos subidos deben ser de tipo pdf');
								$('.alert').removeClass('alert-success');
								$('.alert').removeClass('alert-danger');
								$('.alert').addClass('alert-warning');
								return $('#AlertMod').modal('show');
							}

							readerFile(address, 'address', '/valid-address');

							var fd = new FormData();
							fd.append('person_exposed', person_exposed);

							$.ajax({
								headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
								url: globalUrl+'/valid-person-exposed',
								type: 'POST',
								data: fd,
								contentType: false,
								processData: false,
								success: function success(data) {
									window.location.replace(globalUrl+'/success');
								},
								error: function error(_error67) {
									$('.text-alert').empty();
									$('.text-alert').append('Error');
									$('.alert').removeClass('alert-success');
									$('.alert').removeClass('alert-danger');
									$('.alert').addClass('alert-warning');
									return $('#AlertMod').modal('show');
								}
							});

							return;
						});
					});
				} else {
					$('#next').click(function (e) {
						$('#confirm').modal('show');
						$('#text-content').empty();
						$('#text-content').append('¿Está seguro que los documentos cargados son correctos? Se analizará la información solicitada, si existe alguna incongruencia le notificaremos via correo electrónico y debera contactarnos de forma directa para poder verificar los documentos autenticos.');
						$('#yes').click(function () {
							$('#confirm').modal('hide');

							var address = $('#address')[0].files[0];

							var file_type = address.type.split('/');

							if (file_type[0] != 'image') {
								$('.text-alert').empty();
								$('.text-alert').append('El archivo subido de ser de tipo imagen');
								$('.alert').removeClass('alert-success');
								$('.alert').removeClass('alert-danger');
								$('.alert').addClass('alert-warning');
								return $('#AlertMod').modal('show');
							}

							readerFile(address, 'address', '/valid-address');
							return;
						});
					});
				}
			}
		});

		return;
	}

	/* End KYC Professional Document */

	/* KYC Bank Information */

	if (pathverify('/bank-information')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
		$('#continue').click(function () {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Está seguro de la información que desea cargar? Se pedirán soportes de los datos y si desea cambiar alguna información, deberá contactarnos de forma directa');
			$('#yes').click(function (e) {

				$('#kycBankForm').validate({
					rules: {
						financial_institution: {
							required: true
						},
						account_number: {
							required: true
						}
					}
				});

				if ($('#kycBankForm').valid()) {
					financial_institution = $('#financial_institution').val();
					account_number = $('#account_number').val();

					$.ajax({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						},
						data: {
							financial_institution: financial_institution, account_number: account_number
						},
						url: globalUrl+"/valid-bank-information",
						type: 'post',
						success: function success(data) {
							window.location.replace(globalUrl+'/bank-document');
						}
					});
				} else {
					$('#confirm').modal('hide');
				}
			});
		});
	}

	/* End KYC Bank Information */

	/*KYC Bank Document*/

	if (pathverify('/bank-document')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
		$('#next').click(function (e) {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Está seguro que los documentos cargados son correctos? Se analizará la información solicitada, si existe alguna incongruencia le notificaremos vía correo electrónico y deberá contactarnos de forma directa para poder verificar los documentos auténticos.');
			$('#yes').click(function () {
				$('#confirm').modal('hide');
				$('#documentBank').validate({
					rules: {
						source_founds: {
							required: true
						},
						sworn_declaration: {
							required: true
						}
					}
				});

				if ($('#documentBank').valid()) {
					var source_founds = $('#source_founds')[0].files[0];
					var sworn_declaration = $('#sworn_declaration')[0].files[0];

					var file_type = source_founds.type.split('/');

					if (file_type[1] != 'pdf') {
						$('.text-alert').empty();
						$('.text-alert').append('El archivo subido debe ser de tipo pdf');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						return $('#AlertMod').modal('show');
					}

					file_type = sworn_declaration.type.split('/');

					if (file_type[1] != 'pdf') {
						$('.text-alert').empty();
						$('.text-alert').append('Los archivos subidos deben ser de tipo pdf');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						return $('#AlertMod').modal('show');
					}

					var fd = new FormData();
					fd.append('source_founds', source_founds);
					fd.append('sworn_declaration', sworn_declaration);

					$.ajax({
						headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
						url: globalUrl+'/valid-bank-document',
						type: 'POST',
						data: fd,
						contentType: false,
						processData: false,
						success: function success(data) {
							window.location.replace(globalUrl+'/success');
						},
						error: function error(_error68) {
							$('.text-alert').empty();
							$('.text-alert').append('Error');
							$('.alert').removeClass('alert-success');
							$('.alert').removeClass('alert-danger');
							$('.alert').addClass('alert-warning');
							return $('#AlertMod').modal('show');
						}
					});
					return;
				}
				return;
			});
		});
	}

	/*End KYC Bank Document*/

	/* KYC Juridic Information */

	if (pathverify('/juridic-information')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
		country();
		states('#country');
		phonePrefix('#country');
		cities('#state');
		bornCountry();

		$('#continue').click(function (e) {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Está seguro de la información que desea cargar? Se pedirán soportes de los datos y si desea cambiar alguna información, deberá contactarnos de forma directa.');
			$('#yes').click(function (e) {
				$('#kycForm').validate({
					rules: {
						corporate_name: {
							required: true
						},
						date_incorporation: {
							required: true
						},
						place_incorporation: {
							required: true
						},
						register_incoporation_office: {
							required: true
						},
						type_company: {
							required: true
						},
						shareholders: {
							required: true
						},
						fname_legal_representative: {
							required: true
						},
						sname_legal_representative: {
							required: true
						},
						flastname_legal_representative: {
							required: true
						},
						slastname_legal_representative: {
							required: true
						},
						position: {
							required: true
						},
						country: {
							required: true
						},
						state: {
							required: true
						},
						city: {
							required: true
						},
						id_legal_representative: {
							required: true
						},
						email_address: {
							required: true
						},
						postal: {
							required: true,
							minlength: 4,
							number: true
						},
						merchant_record: {
							required: true
						},
						issuing_state: {
							required: true
						},
						date_issue: {
							required: true
						},
						date_expiry: {
							required: true
						},
						phone_number: {
							required: true
						}
					}
				});

				if ($('#kycJuridicForm').valid()) {
					corporate_name = $('#corporate_name').val();
					date_incorporation = $('#date_incorporation').val();
					place_incorporation = $('#place_incorporation').val();
					register_incoporation_office = $('#register_incoporation_office').val();
					type_company = $('#type_company').val();
					shareholders = parseFloat($('#shareholders').val());
					fname_legal_representative = $('#fname_legal_representative').val();
					sname_legal_representative = $('#sname_legal_representative').val();
					flastname_legal_representative = $('#flastname_legal_representative').val();
					slastname_legal_representative = $('#slastname_legal_representative').val();
					position = $('#position').val();
					country = parseFloat($('#country').val());
					state =parseFloat( $('#state').val());
					city = parseFloat($('#city').val());
					postal = $('#postal').val();
					id_legal_representative = $('#id_legal_representative').val();
					email_address = $('#email_address').val();
					merchant_record = $('#merchant_record').val();
					issuing_state = $('#issuing_state').val();
					date_issue = $('#date_issue').val();
					date_expiry = $('#date_expiry').val();
					phone_number = $('#phone_number').val();
					website = $('#website').val();
					
					var parms = {
							corporate_name: corporate_name, date_incorporation: date_incorporation, place_incorporation: place_incorporation,
							register_incoporation_office: register_incoporation_office,
							type_company: type_company, shareholders: shareholders, country: country, state: state,
							city: city, fname_legal_representative: fname_legal_representative,
							sname_legal_representative: sname_legal_representative, postal: postal,
							flastname_legal_representative: flastname_legal_representative, slastname_legal_representative: slastname_legal_representative,
							id_legal_representative: id_legal_representative, email_address: email_address,
							merchant_record: merchant_record, issuing_state: issuing_state, date_issue: date_issue,
							date_expiry: date_expiry, phone_number: phone_number, position: position, website: website
						};
                    console.log(parms);
					$.ajax({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						},
						data: {
							corporate_name: corporate_name, date_incorporation: date_incorporation, place_incorporation: place_incorporation,
							register_incoporation_office: register_incoporation_office,
							type_company: type_company, shareholders: shareholders, country: country, state: state,
							city: city, fname_legal_representative: fname_legal_representative,
							sname_legal_representative: sname_legal_representative, postal: postal,
							flastname_legal_representative: flastname_legal_representative, slastname_legal_representative: slastname_legal_representative,
							id_legal_representative: id_legal_representative, email_address: email_address,
							merchant_record: merchant_record, issuing_state: issuing_state, date_issue: date_issue,
							date_expiry: date_expiry, phone_number: phone_number, position: position, website: website
						},
						url: globalUrl+"/valid-juridic-information",
						type: 'post',
						success: function success(data) {
							if (data.shareholders) {
								return window.location.replace(globalUrl+'/valid-patners');
							}
							return window.location.replace(globalUrl+'/juridic-document');
						}
					});
				} else {
					$('#confirm').modal('hide');
				}
			});
		});
	}

	/* End KYC Juridic Information */

	/* Valid Patners */

	if (pathverify('/valid-patners')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');

		$.ajax({
			headers: {
				'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
			},
			url: globalUrl+"/get-patners",
			type: 'get',
			success: function success(data) {
				patners = data.patners;
				for (i = 0; i < patners; i++) {
					h = $('<p>Socio ' + (i + 1) + '</p>');

					div_row = $('<div class="row"></div>');
					div_form = $('<div class="form-group col-md-6"></div>');
					div_row.append(div_form);

					label_fname = $('<label for="fname' + i + '" class="control-label font-weight-bold">Primer Nombre</label>');
					input_fname = $('<input id="fname' + i + '" name="fname' + i + '" type="text" class="form-control">');
					div_form.append(label_fname);
					div_form.append(input_fname);

					div_form1 = $('<div class="form-group col-md-6"></div>');
					div_row.append(div_form1);

					label_sname = $('<label for="sname' + i + '" class="control-label font-weight-bold">Segundo Nombre</label>');
					input_sname = $('<input id="sname' + i + '" name="sname' + i + '" type="text" class="form-control">');
					div_form1.append(label_sname);
					div_form1.append(input_sname);

					div_form2 = $('<div class="form-group col-md-6"></div>');
					div_row.append(div_form2);

					label_flastname = $('<label for="flastname' + i + '" class="control-label font-weight-bold">Primer Apellido</label>');
					input_flastname = $('<input id="flastname' + i + '" name="flastname' + i + '" type="text" class="form-control">');
					div_form2.append(label_flastname);
					div_form2.append(input_flastname);

					div_form3 = $('<div class="form-group col-md-6"></div>');
					div_row.append(div_form3);

					label_slastname = $('<label for="slastname' + i + '" class="control-label font-weight-bold">Segundo Apellido</label>');
					input_slastname = $('<input id="slastname' + i + '" name="slastname' + i + '" type="text" class="form-control">');
					div_form3.append(label_slastname);
					div_form3.append(input_slastname);

					div_form4 = $('<div class="form-group col-md-6"></div>');
					div_row.append(div_form4);

					label_identification = $('<label for="identification' + i + '" class="control-label font-weight-bold">Cedula o rif</label>');
					input_identification = $('<input id="identification' + i + '" name="identification' + i + '" type="text" class="form-control">');
					div_form4.append(label_identification);
					div_form4.append(input_identification);

					div_form5 = $('<div class="form-group col-md-6"></div>');
					div_row.append(div_form5);

					label_ocupation = $('<label for="ocupation' + i + '" class="control-label font-weight-bold">Posición</label>');
					input_ocupation = $('<input id="ocupation' + i + '" name="ocupation' + i + '" type="text" class="form-control">');
					div_form5.append(label_ocupation);
					div_form5.append(input_ocupation);

					$('#patners').append(h);
					$('#patners').append(div_row);
				}
				div_center = $('<div class="text-center"></div>');
				button = $('<button type="button" class="btn btn-alternative" id="next" name="button">Continuar</button>');
				div_center.append(button);
				$('#patners').append(div_center);

				$('#next').click(function () {
					$('#confirm').modal('show');
					$('#text-content').empty();
					$('#text-content').append('¿Está seguro de la información que desea cargar? Se pedirán soportes de los datos y si desea cambiar alguna información, deberá contactarnos de forma directa');
					$('#yes').click(function () {
						var data = [];
						for (i = 0; i < patners; i++) {
							var _shareholders = {
								'fname': $('#fname' + i + '').val(), 'sname': $('#sname' + i + '').val(), 'flastname': $('#flastname' + i + '').val(),
								'slastname': $('#slastname' + i + '').val(), 'identification': $('#identification' + i + '').val(), 'ocupation': $('#ocupation' + i + '').val()
							};
							data.push(_shareholders);
						}
						$.ajax({
							headers: {
								'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
							},
							data: {
								shareholders: data
							},
							url: globalUrl+"/post-patners",
							type: 'post',
							success: function success(data) {
								return window.location.replace(globalUrl+'/juridic-document');
							},
							error: function error(_error69) {
								return;
							}
						});
					});
				});
				return;
			},
			error: function error(_error70) {
				return;
			}
		});
	}

	/* End Valid Patners */

	/*KYC Juridic Document*/

	if (pathverify('/juridic-document')){
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
		$('#next').click(function (e) {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Está seguro que los documentos cargados son correctos? Se analizará la información solicitada, si existe alguna incongruencia le notificaremos vía correo electrónico y deberá contactarnos de forma directa para poder verificar los documentos auténticos.');
			$('#yes').click(function () {
				$('#confirm').modal('hide');
				$('#Juridicdocument').validate({
					rules: {
						juridic_rif: {
							required: true
						},
						merchant_record: {
							required: true
						}
					}
				});

				if ($('#merchant_record').valid()) {
					var juridic_rif = $('#juridic_rif')[0].files[0];
					var merchant_record = $('#merchant_record')[0].files[0];

					var file_type = juridic_rif.type.split('/');

					if (file_type[1] != 'pdf') {
						$('.text-alert').empty();
						$('.text-alert').append('El archivo subido debe ser de tipo pdf');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						return $('#fundsAlertMod').modal('show');
					}

					file_type = merchant_record.type.split('/');

					if (file_type[1] != 'pdf') {
						$('.text-alert').empty();
						$('.text-alert').append('Los archivos subidos deben ser de tipo pdf');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						return $('#fundsAlertMod').modal('show');
					}

					var fd = new FormData();
					fd.append('rif', juridic_rif);
					fd.append('register', merchant_record);

					$.ajax({
						headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
						url: globalUrl+'/valid-juridic-document',
						type: 'POST',
						data: fd,
						contentType: false,
						processData: false,
						success: function success(data) {
							window.location.replace(globalUrl+'/success');
						},
						error: function error(_error71) {
							$('.text-alert').empty();
							$('.text-alert').append('Error');
							$('.alert').removeClass('alert-success');
							$('.alert').removeClass('alert-danger');
							$('.alert').addClass('alert-warning');
							return $('#fundsAlertMod').modal('show');
						}
					});
					return;
				}
				return;
			});
		});
	}

	/*End KYC Juridic Document*/

	/* KYC Juridic Professional Information */

	if (pathverify('/juridic-professional-information')){
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');

		$('#continue').click(function () {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Está seguro de la información que desea cargar? Se pedirán soportes de los datos y si desea cambiar alguna información, deberá contactarnos de forma directa');
			$('#yes').click(function (e) {

				$('#kycJuridPro').validate({
					rules: {
						business_sector: {
							required: true
						},
						products: {
							required: true
						},
						services: {
							required: true
						},
						monthly_income: {
							required: true
						},
						annual_income: {
							required: true
						},
						net_worth: {
							required: true
						}
					}
				});

				if ($('#kycJuridPro').valid()) {
					business_sector = $('#business_sector').val();
					products = $('#products').val();
					services = $('#services').val();
					monthly_income = $('#monthly_income').val();
					annual_income = $('#annual_income').val();
					net_worth = $('#net_worth').val();

					$.ajax({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						},
						data: {
							business_sector: business_sector, products: products, services: services, monthly_income: monthly_income,
							annual_income: annual_income, net_worth: net_worth
						},
						url: globalUrl+"/valid-juridic-professional-information",
						type: 'post',
						success: function success(data) {
							window.location.replace(globalUrl+'/success');
						}
					});
				} else {
					$('#confirm').modal('hide');
				}
			});
		});
	}

	/* KYC End Juridic Professional Information */

	/* KYC Juridic Bank Information */

	if (pathverify('/juridic-bank-information')){
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');

		$('#continue').click(function () {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Está seguro de la información que desea cargar? Se pedirán soportes de los datos y si desea cambiar alguna información, deberá contactarnos de forma directa');
			$('#yes').click(function (e) {

				$('#kycJuridBank').validate({
					rules: {
						account_number: {
							required: true
						},
						ABA_routing: {
							required: true
						},
						SWIFT: {
							required: true
						},
						monthly_income: {
							required: true
						},
						annual_income: {
							required: true
						},
						net_worth: {
							required: true
						}
					}
				});

				if ($('#kycJuridBank').valid()) {
					account_number = $('#account_number').val();
					ABA_routing = $('#ABA_routing').val();
					SWIFT = $('#SWIFT').val();
					IBAN = $('#IBAN').val();
					financial_institution = $('#financial_institution').val();
					bank_address = $('#bank_address').val();
					currency = $('#currency').val();

					$.ajax({
						headers: {
							'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
						},
						data: {
							account_number: account_number, ABA_routing: ABA_routing, SWIFT: SWIFT, IBAN: IBAN,
							financial_institution: financial_institution, bank_address: bank_address, currency: currency
						},
						url: globalUrl+"/valid-juridic-bank-information",
						type: 'post',
						success: function success(data) {
							window.location.replace(globalUrl+'/juridic-bank-document');
						}
					});
				} else {
					$('#confirm').modal('hide');
				}
			});
		});
	}

	/* KYC End Juridic Bank Information */

	/*KYC Juridic Bank Document*/

	if (pathverify('/juridic-bank-document')){
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
		$('#next').click(function (e) {
			$('#confirm').modal('show');
			$('#text-content').empty();
			$('#text-content').append('¿Está seguro que los documentos cargados son correctos? Se analizará la información solicitada, si existe alguna incongruencia le notificaremos vía correo electrónico y deberá contactarnos de forma directa para poder verificar los documentos autenticos.');
			$('#yes').click(function () {
				$('#confirm').modal('hide');
				$('#JuridicBank').validate({
					rules: {
						source_founds: {
							required: true
						}
					}
				});

				if ($('#JuridicBank').valid()) {
					var source_founds = $('#source_founds')[0].files[0];

					var file_type = source_founds.type.split('/');

					if (file_type[1] != 'pdf') {
						$('.text-alert').empty();
						$('.text-alert').append('El archivo subido debe ser de tipo pdf');
						$('.alert').removeClass('alert-success');
						$('.alert').removeClass('alert-danger');
						$('.alert').addClass('alert-warning');
						return $('#AlertMod').modal('show');
					}

					var fd = new FormData();
					fd.append('source_founds', source_founds);

					$.ajax({
						headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
						url: globalUrl+'/valid-juridic-bank-document',
						type: 'POST',
						data: fd,
						contentType: false,
						processData: false,
						success: function success(data) {
							window.location.replace(globalUrl+'/success');
						},
						error: function error(_error72) {
							$('.text-alert').empty();
							$('.text-alert').append('Error');
							$('.alert').removeClass('alert-success');
							$('.alert').removeClass('alert-danger');
							$('.alert').addClass('alert-warning');
							return $('#AlertMod').modal('show');
						}
					});
					return;
				}
				return;
			});
		});
	}

	/*End KYC Juridic Bank Document*/

	/* Success */

	if (pathverify('/success')){
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/generalBackground.png")');
	}

	/*Verified IP*/

	if (pathverify('/validate-ip')) {
		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$('#sendIP').click(function (e) {
			$.ajax({
				headers: { 'X-CSRF-Token': $('meta[name=csrf-token]').attr('content') },
				url: globalUrl+'/send-verify',
				type: 'POST',
				dataType: "json",
				success: function success(data) {
					$('#profileMod').modal('hide');
					$('.text-alert').empty();
					$('.text-alert').append('Email enviado con exito');
					$('.alert').removeClass('alert-warning');
					$('.alert').removeClass('alert-danger');
					$('.alert').addClass('alert-success');
					return $('#IPAlertMod').modal('show');
				},
				error: function error(_error73) {
					$(this).removeClass('disabled');
					$(this).prop('disabled', false);
					$('.text-alert').empty();
					$('.text-alert').append('Ha ocurrido un error, recargue la pagina');
					$('.alert').removeClass('alert-success');
					$('.alert').removeClass('alert-danger');
					$('.alert').addClass('alert-warning');
					return $('#IPAlertMod').modal('show');
				}
			});
		});
	}

	/* Contract */
	if (pathverify('/contract')) {
		div = '#terminos';
		button = "#contract";
		finishScroll(div, button);
		$("#contract").click(function (e) {
			$.ajax({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				},
				data: { accept: 1 },
				url: globalUrl+"/accept-contract",
				type: 'post',
				success: function success(data) {
					window.location.replace(globalUrl+'/dashboard');
				}
			});
		});
	}

	/* End Contract */

	/*Report List Functions*/

	if (pathverify('/reportT')) {
		var orderTableReportBy = function orderTableReportBy(by) {
			if (orderReportsBy === by) {
				if (orderReportsDirection === "") {
					orderReportsDirection = "DESC";
				} else {
					orderReportsDirection = "";
				}
			} else {
				orderTableReportsBy = by;
				orderReportsDirection = "";
			}
			searchReport(1);
		};

		//Tomar nombres de columnas
		var filterTableReport = function filterTableReport() {
			$.ajax({
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				url: globalUrl+'/filterReportT',
				type: 'get',
				datatype: 'json',
				success: function success(data) {
					var filters = data.result;
					//return console.log(filters); 
					for (i = 0; i < filters.length; i++) {
						filter = filters[i];
						$('#filter').append('<option value="' + filter.sym + '">' + filter.name + '</option>');
					}
				} //end the success funtion data

			}); // end the ajax
		};

		var searchReport = function searchReport(page) {
			resultPage = $("#result_report_page").val();
			searchFilter = $('#filter').val();

			$.ajax({
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				url: globalUrl+'/reportT',
				type: 'post',
				datatype: 'json',
				data: { searchvalue: searchReportsValue, filter: searchFilter, page: page, orderBy: orderReportsBy, orderDirection: orderReportsDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var orders = data.result;
					if (orders.length == 0) {
						$("#table_report_content").html("");
						$('#table_report_content').append('<tr><td colspan="9">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						// end for del recorrido

						/*report Button With Modal pdf, Excel for Users*/
						var _addReportPdfClick = function _addReportPdfClick(buttonPdf, dato) {
							buttonPdf.click(function () {
								//alert('boton');
								//return console.log(dato.id);
								alert = $('<h4><strong>' + Lang.get('Tickets PDF') + '</strong></h4>');
								box = $('<form class="" id="ticket" enctype="multipart/form-data"></form>');
								inputId = '<input type="hidden" name="opcion" value="' + dato.id + '"/>';

								box1 = $('<div class="row justify-content-center" ></div>');
								pdf = $('<button type="submit" class="btn btn-alternative btn-sm" value="' + dato.id + '" id="ticketPdf">' + Lang.get('PDF') + '</button>');
								//excel = $('<button type="submit" class="btn btn-alternative btn-sm" value="'+ dato.id +'" id="ticketExcel">' + Lang.get('Excel') + '</button> ');

								$('.modal-title').empty();
								$('.modal-body').empty();
								$('.modal-footer').empty();

								$('.modal-title').append(alert);
								$('.modal-body').append(box);

								box1.append(pdf);
								//box1.append(excel);

								$('#ticket').append(inputId);
								$('#ticket').append(box1);

								$.ajax({
									headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
									url: globalUrl+'/pdf/' + dato.id,
									type: 'get',
									datatype: 'json',
									success: function success(data) {
										var datos = dato.id;

										if (datos.length == 0) {
											return console.log(datos);
										} else {
											$('#ticketPdf').click(function () {
												window.open('/pdf/' + datos, '_blank');
											}); // reporte general boton
										}
									}
								});
							});
						}; // ticket individual

						$('#table_reports_content').html("");
						for (i = 0; i < orders.length; i++) {
							var dato = orders[i];
							var rowResult = $('<tr> </tr>');
							var colvalue_1 = $('<td>' + dato.user + '</td>');
							var colvalue_2 = $('<td>' + dato.trade_type + '</td>');
							var colvalue_3 = $('<td>' + formatNumber.num(dato.in_amount) + '</td>');
							var colvalue_4 = $('<td>' + dato.in_symbol + '/' + dato.out_symbol + '</td>');
							var colvalue_5 = $('<td>' + formatNumber.num(dato.out_amount) + '</td>');
							var colvalue_6 = $('<td>' + dato.reference + '</td>');
							var colvalue_7 = $('<td>' + dato.created_at + '</td>');
							var colvalue_8 = $('<td>' + dato.updated_at + '</td>');
							var colvalue_9 = $('<td class="text-center"></td>');

							pdfBut = $('<button type="button" class="btn btn-alternative btn-sm pdfBut" data-toggle="modal" data-target="#reportMod" value="' + dato.id + '">' + Lang.get('Ticket') + '</button> ');

							// we have to make in steps to add the onclick event
							_addReportPdfClick(pdfBut, dato);

							colvalue_9.append(pdfBut);

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);
							rowResult.append(colvalue_7);
							rowResult.append(colvalue_8);
							rowResult.append(colvalue_9);

							$('#table_reports_content').append(rowResult);
						}$('#generalreport').click(function (data) {
							//var id=dato.user_id;
							//return  console.log(id);
							window.open('/pdfGeneral', '_blank');
						});
					} // end the else
				} // end the success funtion data
			}); // end the ajax
		}; // end the funtion listreport


		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$('.listreportT').addClass('active');

		$('#table_report_header_user').click(function (e) {
			orderTableReportBy('user');
		});

		$('#table_report_header_currency').click(function (e) {
			orderTableReportBy('symbol');
		});

		$('#table_report_header_amount').click(function (e) {
			orderTableReportBy('out_amount');
		});

		$('#table_report_header_rate').click(function (e) {
			orderTableReportBy('rate');
		});

		$('#table_report_header_date').click(function (e) {
			orderTableReportBy('created_at');
		});

		$('#table_report_header_reference').click(function (e) {
			orderTableReportBy('reference');
		});

		$('#table_report_header_status').click(function (e) {
			orderTableReportBy('status');
		});

		var orderReportsBy = "";
		var orderReportsDirection = "";
		var searchReportsValue = "";

		$('#form_report_search').submit(function (e) {
			e.preventDefault();

			searchReportsValue = $('#search_report_value').val();
			searchReport(1);
		});

		searchReport(1);
		filterTableReport();
	}
	// end the if


	if (pathverify('/reportC')) {
		var _orderTableReportBy = function _orderTableReportBy(by) {
			if (orderReportsBy === by) {
				if (orderReportsDirection === "") {
					orderReportsDirection = "DESC";
				} else {
					orderReportsDirection = "";
				}
			} else {
				orderTableReportsBy = by;
				orderReportsDirection = "";
			}
			_searchReport(1);
		};

		//Tomar nombres de columnas


		var _filterTableReport = function _filterTableReport() {
			$.ajax({
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				url: globalUrl+'/filterReportC',
				type: 'get',
				datatype: 'json',
				success: function success(data) {
					var filters = data.result;
					for (i = 0; i < filters.length; i++) {
						filter = filters[i];
						$('#filter').append('<option value="' + filter.sym + '">' + filter.name + '</option>');
					}
				} //end the success funtion data

			}); // end the ajax
		};

		var _searchReport = function _searchReport(page) {
			resultPage = $("#result_report_page").val();
			searchFilter = $('#filter').val();

			$.ajax({
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				url: globalUrl+'/reportC',
				type: 'post',
				datatype: 'json',
				data: { searchvalue: searchReportsValue, filter: searchFilter, page: page, orderBy: orderReportsBy, orderDirection: orderReportsDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var orders = data.result;
					if (orders.length == 0) {
						$("#table_report_content").html("");
						$('#table_report_content').append('<tr><td colspan="9">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						// end for del recorrido

						/*report Button With Modal pdf, Excel for Users*/
						var _addReportPdfClick2 = function _addReportPdfClick2(buttonPdf, dato) {
							buttonPdf.click(function () {
								//alert('boton');
								//return console.log(dato.id);
								alert = $('<h4><strong>' + Lang.get('Tickets PDF') + '</strong></h4>');
								box = $('<form class="" id="ticket" enctype="multipart/form-data"></form>');
								inputId = '<input type="hidden" name="opcion" value="' + dato.id + '"/>';

								box1 = $('<div class="row justify-content-center" ></div>');
								pdf = $('<button type="submit" class="btn btn-alternative btn-sm" value="' + dato.id + '" id="ticketPdf">' + Lang.get('PDF') + '</button>');
								//excel = $('<button type="submit" class="btn btn-alternative btn-sm" value="'+ dato.id +'" id="ticketExcel">' + Lang.get('Excel') + '</button> ');

								$('.modal-title').empty();
								$('.modal-body').empty();
								$('.modal-footer').empty();

								$('.modal-title').append(alert);
								$('.modal-body').append(box);

								box1.append(pdf);
								//box1.append(excel);

								$('#ticket').append(inputId);
								$('#ticket').append(box1);

								$.ajax({
									headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
									url: globalUrl+'/pdf/' + dato.id,
									type: 'get',
									datatype: 'json',
									success: function success(data) {
										var datos = dato.id;

										if (datos.length == 0) {
											return console.log(datos);
										} else {
											$('#ticketPdf').click(function () {
												window.open('/pdf/' + datos, '_blank');
											}); // reporte general boton
										}
									}
								});
							});
						}; // ticket individual

						$('#table_reports_content').html("");
						for (i = 0; i < orders.length; i++) {
							var dato = orders[i];
							var rowResult = $('<tr> </tr>');
							var colvalue_1 = $('<td>' + dato.user + '</td>');
							var colvalue_2 = $('<td>' + dato.trade_type + '</td>');
							var colvalue_3 = $('<td>' + formatNumber.num(dato.in_amount) + '</td>');
							var colvalue_4 = $('<td>' + dato.in_symbol + '/' + dato.out_symbol + '</td>');
							var colvalue_5 = $('<td>' + formatNumber.num(dato.out_amount) + '</td>');
							var colvalue_6 = $('<td>' + dato.reference + '</td>');
							var colvalue_7 = $('<td>' + dato.created_at + '</td>');
							var colvalue_8 = $('<td>' + dato.updated_at + '</td>');
							var colvalue_9 = $('<td class="text-center"></td>');

							pdfBut = $('<button type="button" class="btn btn-alternative btn-sm pdfBut" data-toggle="modal" data-target="#reportMod" value="' + dato.id + '">' + Lang.get('Ticket') + '</button> ');

							// we have to make in steps to add the onclick event
							_addReportPdfClick2(pdfBut, dato);

							colvalue_9.append(pdfBut);

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);
							rowResult.append(colvalue_7);
							rowResult.append(colvalue_8);
							rowResult.append(colvalue_9);

							$('#table_reports_content').append(rowResult);
						}$('#generalreport').click(function (data) {
							//var id=dato.user_id;
							//return  console.log(id);
							window.open('/pdfGeneral', '_blank');
						});
					} // end the else
				} // end the success funtion data
			}); // end the ajax
		}; // end the funtion listreport


		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$('.listreportC').addClass('active');

		$('#table_report_header_user').click(function (e) {
			_orderTableReportBy('user');
		});

		$('#table_report_header_currency').click(function (e) {
			_orderTableReportBy('symbol');
		});

		$('#table_report_header_amount').click(function (e) {
			_orderTableReportBy('out_amount');
		});

		$('#table_report_header_rate').click(function (e) {
			_orderTableReportBy('rate');
		});

		$('#table_report_header_date').click(function (e) {
			_orderTableReportBy('created_at');
		});

		$('#table_report_header_reference').click(function (e) {
			_orderTableReportBy('reference');
		});

		$('#table_report_header_status').click(function (e) {
			_orderTableReportBy('status');
		});

		var orderReportsBy = "";
		var orderReportsDirection = "";
		var searchReportsValue = "";

		$('#form_report_search').submit(function (e) {
			e.preventDefault();

			searchReportsValue = $('#search_report_value').val();
			_searchReport(1);
		});

		_searchReport(1);
		_filterTableReport();
	} // end the if

	if (pathverify('/reportU')) {
		var _orderTableReportBy2 = function _orderTableReportBy2(by) {
			if (orderReportsBy === by) {
				if (orderReportsDirection === "") {
					orderReportsDirection = "DESC";
				} else {
					orderReportsDirection = "";
				}
			} else {
				orderTableReportsBy = by;
				orderReportsDirection = "";
			}
			_searchReport2(1);
		};

		//Tomar nombres de columnas


		var _filterTableReport2 = function _filterTableReport2() {
			$.ajax({
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				url: globalUrl+'/filterReportU',
				type: 'get',
				datatype: 'json',
				success: function success(data) {
					var filters = data.result;
					for (i = 0; i < filters.length; i++) {
						filter = filters[i];
						$('#filter').append('<option value="' + filter.sym + '">' + filter.name + '</option>');
					}
				} //end the success funtion data

			}); // end the ajax
		};

		var _searchReport2 = function _searchReport2(page) {
			resultPage = $("#result_report_page").val();
			searchFilter = $('#filter').val();

			$.ajax({
				headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
				url: globalUrl+'/reportU',
				type: 'post',
				datatype: 'json',
				data: { searchvalue: searchReportsValue, filter: searchFilter, page: page, orderBy: orderReportsBy, orderDirection: orderReportsDirection, resultPage: resultPage },
				success: function success(data) {
					//Inicio
					var orders = data.result;
					if (orders.length == 0) {
						$("#table_report_content").html("");
						$('#table_report_content').append('<tr><td colspan="9">' + Lang.get('messages.none') + '</td></tr>');
					} else {
						// end for del recorrido

						/*report Button With Modal pdf, Excel for Users*/
						var _addReportPdfClick3 = function _addReportPdfClick3(buttonPdf, dato) {
							buttonPdf.click(function () {
								//alert('boton');
								//return console.log(dato.id);
								alert = $('<h4><strong>' + Lang.get('Tickets PDF') + '</strong></h4>');
								box = $('<form class="" id="ticket" enctype="multipart/form-data"></form>');
								inputId = '<input type="hidden" name="opcion" value="' + dato.id + '"/>';

								box1 = $('<div class="row justify-content-center" ></div>');
								pdf = $('<button type="submit" class="btn btn-alternative btn-sm" value="' + dato.id + '" id="ticketPdf">' + Lang.get('PDF') + '</button>');
								//excel = $('<button type="submit" class="btn btn-alternative btn-sm" value="'+ dato.id +'" id="ticketExcel">' + Lang.get('Excel') + '</button> ');

								$('.modal-title').empty();
								$('.modal-body').empty();
								$('.modal-footer').empty();

								$('.modal-title').append(alert);
								$('.modal-body').append(box);

								box1.append(pdf);
								//box1.append(excel);

								$('#ticket').append(inputId);
								$('#ticket').append(box1);

								$.ajax({
									headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
									url: globalUrl+'/pdf/' + dato.id,
									type: 'get',
									datatype: 'json',
									success: function success(data) {
										var datos = dato.id;

										if (datos.length == 0) {
											return console.log(datos);
										} else {
											$('#ticketPdf').click(function () {
												window.open('/pdf/' + datos, '_blank');
											}); // reporte general boton
										}
									}
								});
							});
						}; // ticket individual

						$('#table_reports_content').html("");
						for (i = 0; i < orders.length; i++) {
							var dato = orders[i];
							var rowResult = $('<tr> </tr>');
							var colvalue_1 = $('<td>' + dato.user + '</td>');
							var colvalue_2 = $('<td>' + dato.trade_type + '</td>');
							var colvalue_3 = $('<td>' + formatNumber.num(dato.in_amount) + '</td>');
							var colvalue_4 = $('<td>' + dato.in_symbol + '/' + dato.out_symbol + '</td>');
							var colvalue_5 = $('<td>' + formatNumber.num(dato.out_amount) + '</td>');
							var colvalue_6 = $('<td>' + dato.reference + '</td>');
							var colvalue_7 = $('<td>' + dato.created_at + '</td>');
							var colvalue_8 = $('<td>' + dato.updated_at + '</td>');
							var colvalue_9 = $('<td class="text-center"></td>');

							pdfBut = $('<button type="button" class="btn btn-alternative btn-sm pdfBut" data-toggle="modal" data-target="#reportMod" value="' + dato.id + '">' + Lang.get('Ticket') + '</button> ');

							// we have to make in steps to add the onclick event
							_addReportPdfClick3(pdfBut, dato);

							colvalue_9.append(pdfBut);

							rowResult.append(colvalue_1);
							rowResult.append(colvalue_2);
							rowResult.append(colvalue_3);
							rowResult.append(colvalue_4);
							rowResult.append(colvalue_5);
							rowResult.append(colvalue_6);
							rowResult.append(colvalue_7);
							rowResult.append(colvalue_8);
							rowResult.append(colvalue_9);

							$('#table_reports_content').append(rowResult);
						}$('#generalreport').click(function (data) {
							//var id=dato.user_id;
							//return  console.log(id);
							window.open('/pdfGeneral', '_blank');
						});
					} // end the else
				} // end the success funtion data
			}); // end the ajax
		}; // end the funtion listreport


		$('#body').css('background-image', 'url("'+globalImgUrl+'background/malla.jpg")');
		$('.listreportU').addClass('active');

		$('#table_report_header_user').click(function (e) {
			_orderTableReportBy2('user');
		});

		$('#table_report_header_currency').click(function (e) {
			_orderTableReportBy2('symbol');
		});

		$('#table_report_header_amount').click(function (e) {
			_orderTableReportBy2('out_amount');
		});

		$('#table_report_header_rate').click(function (e) {
			_orderTableReportBy2('rate');
		});

		$('#table_report_header_date').click(function (e) {
			_orderTableReportBy2('created_at');
		});

		$('#table_report_header_reference').click(function (e) {
			_orderTableReportBy2('reference');
		});

		$('#table_report_header_status').click(function (e) {
			_orderTableReportBy2('status');
		});

		var orderReportsBy = "";
		var orderReportsDirection = "";
		var searchReportsValue = "";

		$('#form_report_search').submit(function (e) {
			e.preventDefault();

			searchReportsValue = $('#search_report_value').val();
			_searchReport2(1);
		});

		_searchReport2(1);
		_filterTableReport2();
	} // end the if

	if (pathverify('/terms')) {
		div = '#terminos';
		button = "#aceptar_condiciones";
		finishScroll(div, button);
	}
});

/***/ })

/******/ });