/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"en.messages":{"2fa_enable":"Authentication Enabled","2fa_enable_desc":"Your two-factor authentication is active","account":"Account","accounts":"Accounts","active":"Active","address":"Address","address_management":"Address Management","amount":"Amount","back":"back","balance":"Balance","basic_information":"Basic Information","birthdate":"Birth Date","born":"Born","change":"Change","chart":"Chart","check_confirm":"Please Check Your Information and Confirm","city":"City","close":"Close","confirm":"Confirm","copyright":"Copyright (c) 2019 Copyright","country":"Country","create":"Create","created":"Created","created_by":"Created By","currencies":"Currencies","currency":"Currency","daily":"Daily","date":"Date","delete":"Delete","deposit":"Deposit","deposits":"Deposits","distribution":"Distribution","edited":"Edited","equivalent":"Equivalent","0":"kyc_description","edit":"edit","email":"E-Mail Address","enabled":"Enabled","enter":"Enter","entity":"Finance Entity","error":"An error has ocurred","exchangeable":"Exchangeable","fee":"fee","first":"First","forgot_password":"Forgot Your Password?","general":"General","google_auth":"Google Authenticator","google_authenticate":"Google Authenticator","google_desc":"Set up your two factor authentication by scanning the barcode below. Alternatively, you can use the code","historical":"Historical","home":"Home","house":"House","inactive":"Inactive","info":"Information","ip":"IP","kyc_send":"KYC Sent","kyc_send_desc":"Your documents must be verified","last_login_ip":"Last Login Ip","last_login_time":"Last Login Time","last_modified":"Last Modified","lastname":"Lastname","lenguage":"Language","level":"Levels of authentication","login":"Login","logout":"Logout","make":"Make","markets":"Markets","message":"Message","modify":"Modify","monthly":"Monthly","name":"Name","new":"New","newsletter":"Newsletter","next":"Next","no":"No","none":"None","old":"Old","options":"Options","password":"Password","pending":"Pending","phone":"Phone","photo":"Photo","portfolio":"Portfolio","postal":"Postal Code","prev":"Previous","price":"Price","prima":"Prima","profile":"profile","profile_text_1":"Used for withdrawal and security modifications","profile_text_2":"Address Management allows you to save and write memos for each of your withdrawal addresses. The Whitelist function helps protect your funds by only allowing withdrawals to whitelisted addresses.","rate":"Rate","reference":"Reference","register":"Register","remember":"Remember me","reserved":"All Rights Reserved.","reset_password":"Reset Password","roles":"Roles","search":"Search","second":"Second","select":"select","select_lenguage":"Please select language for the system.","select_theme":"Please select theme for the system.","selection":"Selection","settings":"Settings","state":"State","status":"Status","stepone":"First Step","stepthree":"Third Step","stepthree_text_1":"To finish, please enter the information of the company.","steptwo":"Second Step","steptwo_text_1":"Now, we need the information of the administrator, the e-mail address will be used as login username.","street":"Street","successfully":"Successfully","sure":"Are you sure for","symbol":"Symbol","system":"System","test":"This system is in test, if you see a problem please contact us through","the":"{0} the|[1,2] the","theme":"Theme","this":"this","title":"Title","total":"Total","transactions":"Transactions","two_factor":"To activate the authentication of two factors of google you must first download the Google Authenticator application, you can do it by scanning the following QR code with your smartphone.","type":"Type","ubication":"Ubication","update":"Update","upload":"Upload","user":"User","users":"Users","value":"Value","verify_kyc":"KYC Verification","weekly":"Weekly","welcome_steps_1":"Default Language","welcome_steps_10":"Withdraw Max Amount","welcome_steps_2":"Default Theme","welcome_steps_3":"Administrator Username","welcome_steps_4":"Administrator Password","welcome_steps_5":"Administrator Personal Data","welcome_steps_6":"Company Name","welcome_steps_7":"Company Logo","welcome_steps_8":"Company Favicon","welcome_steps_9":"Principal Fiat Currency","welcome_text_1":"Welcome To General Trading System GTS. Before getting started, we need some information on the database. You will need to know the following items before proceeding.","welcome_text_2":"We're going to use this information to create administrator user and settings data.","welcome_text_3":"In all likelihood, these items were supplied to you by the Company Owner and System Administrator. If you do not have this information, then you will need to contact them before you can continue. if you're all ready...","welcome_title":"Welcome","withdraw":"Withdraw","withdrawal_address":"Withdrawal Address Management","withdraws":"Withdraws","yes":"Yes","1":"Verify your identity and get benefits."},"en.validation":{"accepted":"The :attribute must be accepted.","active_url":"The :attribute is not a valid URL.","after":"The :attribute must be a date after :date.","after_or_equal":"The :attribute must be a date after or equal to :date.","alpha":"The :attribute may only contain letters.","alpha_dash":"The :attribute may only contain letters, numbers, and dashes.","alpha_num":"The :attribute may only contain letters and numbers.","alpha_pass":"The :attribute must have at least one capital letter, lower letter, and number, minimun 6 characters","array":"The :attribute must be an array.","attributes":[],"before":"The :attribute must be a date before :date.","before_or_equal":"The :attribute must be a date before or equal to :date.","between":{"array":"The :attribute must have between :min and :max items.","file":"The :attribute must be between :min and :max kilobytes.","numeric":"The :attribute must be between :min and :max.","string":"The :attribute must be between :min and :max characters."},"boolean":"The :attribute field must be true or false.","confirmed":"The :attribute confirmation does not match.","custom":{"g-recaptcha-response":{"captcha":"Captcha error! try again later or contact site admin.","required":"Please verify that you are not a robot."}},"date":"The :attribute is not a valid date.","date_format":"The :attribute does not match the format :format.","different":"The :attribute and :other must be different.","digits":"The :attribute must be :digits digits.","digits_between":"The :attribute must be between :min and :max digits.","dimensions":"The :attribute has invalid image dimensions.","distinct":"The :attribute field has a duplicate value.","email":"The :attribute must be a valid email address.","exists":"The selected :attribute is invalid.","file":"The :attribute must be a file.","filled":"The :attribute field must have a value.","gt":{"array":"The :attribute must have more than :value items.","file":"The :attribute must be greater than :value kilobytes.","numeric":"The :attribute must be greater than :value.","string":"The :attribute must be greater than :value characters."},"gte":{"array":"The :attribute must have :value items or more.","file":"The :attribute must be greater than or equal :value kilobytes.","numeric":"The :attribute must be greater than or equal :value.","string":"The :attribute must be greater than or equal :value characters."},"image":"The :attribute must be an image.","in":"The selected :attribute is invalid.","in_array":"The :attribute field does not exist in :other.","integer":"The :attribute must be an integer.","ip":"The :attribute must be a valid IP address.","ipv4":"The :attribute must be a valid IPv4 address.","ipv6":"The :attribute must be a valid IPv6 address.","json":"The :attribute must be a valid JSON string.","lt":{"array":"The :attribute must have less than :value items.","file":"The :attribute must be less than :value kilobytes.","numeric":"The :attribute must be less than :value.","string":"The :attribute must be less than :value characters."},"lte":{"array":"The :attribute must not have more than :value items.","file":"The :attribute must be less than or equal :value kilobytes.","numeric":"The :attribute must be less than or equal :value.","string":"The :attribute must be less than or equal :value characters."},"max":{"array":"The :attribute may not have more than :max items.","file":"The :attribute may not be greater than :max kilobytes.","numeric":"The :attribute may not be greater than :max.","string":"The :attribute may not be greater than :max characters."},"mimes":"The :attribute must be a file of type: :values.","mimetypes":"The :attribute must be a file of type: :values.","min":{"array":"The :attribute must have at least :min items.","file":"The :attribute must be at least :min kilobytes.","numeric":"The :attribute must be at least :min.","string":"The :attribute must be at least :min characters."},"not_in":"The selected :attribute is invalid.","not_regex":"The :attribute format is invalid.","numeric":"The :attribute must be a number.","present":"The :attribute field must be present.","regex":"The :attribute format is invalid.","required":"The :attribute field is required.","required_if":"The :attribute field is required when :other is :value.","required_unless":"The :attribute field is required unless :other is in :values.","required_with":"The :attribute field is required when :values is present.","required_with_all":"The :attribute field is required when :values is present.","required_without":"The :attribute field is required when :values is not present.","required_without_all":"The :attribute field is required when none of :values are present.","role":"Select at least one role","same":"The :attribute and :other must match.","size":{"array":"The :attribute must contain :size items.","file":"The :attribute must be :size kilobytes.","numeric":"The :attribute must be :size.","string":"The :attribute must be :size characters."},"string":"The :attribute must be a string.","timezone":"The :attribute must be a valid zone.","unique":"The :attribute has already been taken.","uploaded":"The :attribute failed to upload.","url":"The :attribute format is invalid."},"es.messages":{"2fa_enable":"Autenticaci\u00f3n Habilitada","2fa_enable_desc":"Tu autenticaci\u00f3n de dos factores est\u00e1 activa","ABA_routing":"Ruta ABA","Cryptocurrency":"Criptomoneda","FIAT":"Fiduciaria","IBAN":"IBAN","SWIFT":"SWIFT","accept":"Aceptar","account":"Cuenta","account_number":"N\u00famero de cuenta","accounts":"Cuentas","active":"Activo","activity":"Actividad","address":"Direcci\u00f3n","address_management":"Administrar Direcciones","amount":"Monto","annual_income":"Ingreso Anual","available":"Disponible","back":"Atr\u00e1s","balance":"Balance","bank":"Banco","bank_address":"Direcci\u00f3n del Banco","basic_information":"Informaci\u00f3n B\u00e1sica","birthdate":"Fecha de nacimiento","born":"Nacimiento","born_date":"Fecha de nacimiento","born_site":"Pa\u00eds de nacimiento","business_sector":"Sector Financiero","cancel":"Cancelar","card":"Tarjeta","change":"Cambiar","chart":"Gr\u00e1fica","check_confirm":"Por favor revise la informaci\u00f3n y confirme","city":"Ciudad","close":"Cerrar","complete":"Completo","completed":"Completado","conective_de":"De","confirm":"Confirmar","copyright":"Copyright (c) 2019 Copyright","corporate_name":"Nombre Corporativo","country":"Pa\u00eds","create":"Crear","created":"Creado","created_by":"Creado Por","cryptocurrency":"Criptomoneda","currencies":"Monedas","currency":"Moneda","daily":"Diario","date":"Fecha","date_expiry":"Fecha de expiraci\u00f3n","date_incorporation":"Fecha de incorporaci\u00f3n","date_issue":"Fecha de emisi\u00f3n","delete":"Borrar","deposit":"Deposito","deposits":"Dep\u00f3sitos","distribution":"Distribuci\u00f3n","edit":"Editar","edited":"Editado","email":"Correo Electr\u00f3nico","email_address":"Direcci\u00f3n de Email","enabled":"Habilitar","enter":"Entrar","entity":"Entidad Financiera","equivalent":"Equivalente","error":"Ha ocurrido un error","exchange":"Cambio","exchangeable":"Intercambiable","exchanging":"Cambiando","execute":"Ejecutar","exposed_type":"Tipo de exposici\u00f3n","fee":"Cuota","financial_institution":"Instituci\u00f3n financiera","first":"Primer","forgot_password":"Olvido Su Contrase\u00f1a","funds":"Fondos","gender":"Genero","general":"General","google_auth":"Autenticaci\u00f3n de Google","google_authenticate":"Autenticaci\u00f3n de Google.","google_desc":"Configure su autenticaci\u00f3n de factor escaneando el siguiente c\u00f3digo de barras, de forma alternativa puede usar el c\u00f3digo","historical":"Hist\u00f3rico","home":"Inicio","house":"Casa","id_number":"Identificaci\u00f3n","identification":"Identificaci\u00f3n","inactive":"Inactivo","info":"Informaci\u00f3n","ip":"IP","issuing_state":"Pa\u00eds de emisi\u00f3n","kyc":"KYC","kyc_description":"Verifica tu identidad y obt\u00e9n beneficios.","kyc_send":"KYC Enviado","kyc_send_desc":"Tus documentos deben ser verificados","last":"Ultimo","last_login_ip":"Ultimo IP de inicio","last_login_time":"Ultimo inicio de sesi\u00f3n","last_modified":"\u00daltima Modificaci\u00f3n","lastname":"Apellido","legal_representative":"Representante Legal","lenguage":"Lenguaje","level":"Niveles de autenticaci\u00f3n","login":"Acceder","logout":"Cerrar Sesi\u00f3n","make":"Hacer","marital_status":"Estado Civil","markets":"Mercados","merchant_record":"Registro Mercantil","message":"Mensaje","military":"Militar","modify":"Modificar","monthly":"Mensual","monthly_income":"Ingreso Mensual","name":"Nombre","net_worth":"Valor Neto","network":"Red","new":"Nueva","new_password":"Nueva Contrase\u00f1a","newsletter":"Comunicados","next":"Siguiente","no":"No","none":"Ninguno","of":"de","old":"Vieja","old_password":"Contrase\u00f1a Actual","options":"Opciones","or":"o","password":"Contrase\u00f1a","pending":"Pendiente","phone":"Tel\u00e9fono","phone_number":"Numero de Telefono","phonenumber":"Numero de tel\u00e9fono","photo":"Foto","place_incorporation":"Sitio de incorporaci\u00f3n","politically_document":"Documento Pol\u00edtico","politically_exposed_person":"Persona Expuesta pol\u00edticamente","portfolio":"Portafolio","position":"Posici\u00f3n","postal":"C\u00f3digo Postal","postal_code":"Codigo Postal","prev":"Anterior","price":"Precio","prima":"Prima","processing":"Procesando","products":"Productos","profession_occupation":"Profesi\u00f3n","profile":"Perfil","profile_text_1":"Utilizado para retiros y modificaciones de seguridad.","profile_text_2":"La Administraci\u00f3n de direcciones te permite guardar y escribir tus direcciones para retiros. La funci\u00f3n de lista blanca ayuda a proteger tus fondos permitiendo solamente retiros de tus direcciones asociadas.","public_employee":"Empleado P\u00fablico","rate":"Tarifa","receive":"Recibiendo","reference":"Referencia","register":"Registrarse","register_incoporation_office":"Oficina de registro","reject":"Rechazar","remember":"Recordarme","reserved":"Todos los derechos reservados.","reset_password":"Resetear Contrase\u00f1a","rif":"RIF","roles":"Roles","search":"Buscar","second":"Segundo","select":"Seleccionar","select_lenguage":"Por favor seleccione el lenguaje para el sistema.","select_theme":"Por favor seleccione el tema para el sistema.","selection":"Selecci\u00f3n","selfie":"Retrato","services":"Servicios","settings":"Configuraci\u00f3n","shareholder":"Accionista","shareholders":"Accionistas","source_founds":"Origen de fondos","state":"Estado","status":"Estado","stepone":"Primer Paso","stepthree":"Tercer Paso","stepthree_text_1":"Para finalizar, por favor introduzca los datos de la compa\u00f1ia.","steptwo":"Segundo Paso","steptwo_text_1":"Ahora, necesitamos la informaci\u00f3n del administrador, el correo electr\u00f3nico ser\u00e1 utilizado como nombre de usuario.","street":"Calle","successfully":"Exitosamente","sure":"Esta seguro de","sworn_declaration":"Declaraci\u00f3n jurada","symbol":"S\u00edmbolo","system":"Sistema","test":"Este sistema aun esta en desarrollo, si ve alg\u00fan problema por favor cont\u00e1ctenos a trav\u00e9s de","the":"{0} el|[1,2] la","theme":"Tema","this":"este","title":"Titulo","total":"Total","trade":"Intercambio","transactions":"Transacciones","two_factor":"Para activar la autenticaci\u00f3n de dos factores de google primero debe descargar la aplicaci\u00f3n Google Authenticator, puede hacerlo escaneando el siguiente c\u00f3digo QR con su smartphone.","type":"Tipo","type_company":"Tipo de compa\u00f1ia","type_id":"Tipo de identificaci\u00f3n","ubication":"Ubicaci\u00f3n","update":"Actualizar","upload":"Subir","use":"Utilizar","user":"Usuario","user_id":"ID del usuario","user_type":"Tipo de usuario","users":"Usuarios","value":"Valor","verified":"Verificado","verify":"Verificar","verify_kyc":"Verificaci\u00f3n KYC","website":"Sitio Web","weekly":"Semanal","welcome_steps_1":"Lenguaje por defecto.","welcome_steps_10":"Monto M\u00e1ximo de retiros","welcome_steps_11":"Cuota Crypto a Crypto","welcome_steps_12":"Cuota Crypto a Fiat","welcome_steps_13":"Cuota Fiat a Crypto","welcome_steps_2":"Tema por defecto.","welcome_steps_3":"Usuario administrador.","welcome_steps_4":"Contrase\u00f1a administrador.","welcome_steps_5":"Informaci\u00f3n personal del administrador.","welcome_steps_6":"Nombre de la compa\u00f1\u00eda","welcome_steps_7":"Logo de la compa\u00f1\u00eda.","welcome_steps_8":"Favicon de la compa\u00f1\u00eda.","welcome_steps_9":"Moneda principal fiduciaria","welcome_text_1":"Bienvenido a General Trading System GTS. Antes de empezar, necesitamos alguna informaci\u00f3n en la base de datos. Por favor ten contigo la siguiente informaci\u00f3n antes de continuar.","welcome_text_2":"Vamos a usar esta informaci\u00f3n para crear el usuario administrativo y los datos del sistema.","welcome_text_3":"Con toda probabilidad, estos elementos fueron proporcionados por el propietario de la compa\u00f1\u00eda y el administrador del sistema. Si no tiene esta informaci\u00f3n, tendr\u00e1 que comunicarse con ellos antes de poder continuar. Si ya est\u00e1s listo.","welcome_title":"Bienvenido","withdraw":"Retiro","withdrawal_address":"Administraci\u00f3n de direcciones para retiro","withdraws":"Retiros","yare":"Estas","years_in_company":"A\u00f1os en compa\u00f1\u00eda","yes":"Si","ywill":"Estas"},"es.validation":{"accepted":":attribute tiene que ser aceptado.","active_url":":attribute no es un URL valido.","after":":attribute debe ser una fecha despues de :date.","after_or_equal":":attribute debe ser una fecha despues o igual que :date.","alpha":":attribute debe contener solo letras.","alpha_dash":":attribute debe contener solo numeros, letras y guiones.","alpha_num":":attribute debe contener solo letras y numeros.","alpha_pass":":attribute debe contener al menos una mayuscula, una miniscula y un numero, minimo 6 caracteres","array":":attribute debe ser un arreglo.","attributes":[],"before":":attribute debe ser una fecha antes de :date.","before_or_equal":":attribute debe ser una fecha antes o igual que  :date.","between":{"array":"The :attribute must have between :min and :max items.","file":"The :attribute must be between :min and :max kilobytes.","numeric":"The :attribute must be between :min and :max.","string":"The :attribute must be between :min and :max characters."},"boolean":"The :attribute field must be true or false.","confirmed":"The :attribute confirmation does not match.","custom":{"g-recaptcha-response":{"captcha":"Error de Captcha. Prueba despues o contacta al administrador del sitio.","required":"Por favor. Verifica que no eres un Robot!"}},"date":"The :attribute is not a valid date.","date_format":"The :attribute does not match the format :format.","different":"The :attribute and :other must be different.","digits":"The :attribute must be :digits digits.","digits_between":"The :attribute must be between :min and :max digits.","dimensions":"The :attribute has invalid image dimensions.","distinct":"The :attribute field has a duplicate value.","email":"The :attribute must be a valid email address.","exists":"The selected :attribute is invalid.","file":"The :attribute must be a file.","filled":"The :attribute field must have a value.","gt":{"array":"The :attribute must have more than :value items.","file":"The :attribute must be greater than :value kilobytes.","numeric":"The :attribute must be greater than :value.","string":"The :attribute must be greater than :value characters."},"gte":{"array":"The :attribute must have :value items or more.","file":"The :attribute must be greater than or equal :value kilobytes.","numeric":"The :attribute must be greater than or equal :value.","string":"The :attribute must be greater than or equal :value characters."},"image":"The :attribute must be an image.","in":"The selected :attribute is invalid.","in_array":"The :attribute field does not exist in :other.","integer":"The :attribute must be an integer.","ip":"The :attribute must be a valid IP address.","ipv4":"The :attribute must be a valid IPv4 address.","ipv6":"The :attribute must be a valid IPv6 address.","json":"The :attribute must be a valid JSON string.","lt":{"array":"The :attribute must have less than :value items.","file":"The :attribute must be less than :value kilobytes.","numeric":"The :attribute must be less than :value.","string":"The :attribute must be less than :value characters."},"lte":{"array":"The :attribute must not have more than :value items.","file":"The :attribute must be less than or equal :value kilobytes.","numeric":"The :attribute must be less than or equal :value.","string":"The :attribute must be less than or equal :value characters."},"max":{"array":"The :attribute may not have more than :max items.","file":"The :attribute may not be greater than :max kilobytes.","numeric":"The :attribute may not be greater than :max.","string":"The :attribute may not be greater than :max characters."},"mimes":"The :attribute must be a file of type: :values.","mimetypes":"The :attribute must be a file of type: :values.","min":{"array":"The :attribute must have at least :min items.","file":"The :attribute must be at least :min kilobytes.","numeric":"The :attribute must be at least :min.","string":"The :attribute must be at least :min characters."},"not_in":"The selected :attribute is invalid.","not_regex":"The :attribute format is invalid.","numeric":"The :attribute must be a number.","present":"The :attribute field must be present.","regex":"The :attribute format is invalid.","required":"The :attribute field is required.","required_if":"The :attribute field is required when :other is :value.","required_unless":"The :attribute field is required unless :other is in :values.","required_with":"The :attribute field is required when :values is present.","required_with_all":"The :attribute field is required when :values is present.","required_without":"The :attribute field is required when :values is not present.","required_without_all":"The :attribute field is required when none of :values are present.","role":"Seleccione al menos un rol","same":"The :attribute and :other must match.","size":{"array":"The :attribute must contain :size items.","file":"The :attribute must be :size kilobytes.","numeric":"The :attribute must be :size.","string":"The :attribute must be :size characters."},"string":"The :attribute must be a string.","timezone":"The :attribute must be a valid zone.","unique":"The :attribute has already been taken.","uploaded":"The :attribute failed to upload.","url":"The :attribute format is invalid."}});
})();
