<?php
// cms/api/transactions/listcsv

    header("Content-type: text/csv");
    header("Content-Disposition: attachment; filename=transacciones.csv");
    //header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $order = determinateOrder($_GET['order']);
    $daterange = '';
    $type = '';
    $currencyid = '';
    
    $accountType = ' AND users.id > 0 ';
    
    $caseType = " CASE ".
    "           WHEN t.dsc LIKE '%comis%' THEN 'Comisión' ".
    "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 'Ajuste' ".
    "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 'Intercambio' ".
    "           WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 'Depósito' ".
    "           WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 'Retiro' ".
    "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 'Transferencia' END AS type,";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 40))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    //En caso de que el daterange sea enviado, se construye el query
    if(isset($_GET["daterange"]) && $_GET["daterange"] != ""){
        $daterange = determinateRange($_GET["daterange"]);
    }
    
    //En caso de que el type sea enviado, se construye el query
    if(isset($_GET["type"]) && $_GET["type"] != ""){
        $type = determinateType($_GET["type"]);
    }
    
    //En caso que el accounttype sea enviado, se construye el query
    if(isset($_GET['accounttype']) && $_GET['accounttype'] != ""){
        if($_GET['accounttype'] == -1){
            $accountType = ' AND users.id = -1 ';
            $caseType = " CASE ".
            "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 'Ajuste' ".
            "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 'Intercambio' ".
            "           WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 'Depósito' ".
            "           WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 'Retiro' ".
            "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 'Transferencia' ".
            "           WHEN t.dsc LIKE '%comis%' THEN 'Comisión' END AS type,";
            
            if(isset($_GET["type"]) && $_GET["type"] != ""){
                $type = determinateTypeAFX($_GET["type"]);
                //$out->testing = $type;
            }
        }else{
            $accountType= ' AND users.id > 0 ';
        }
    }
    
    //EN caso que el currencyid sea enviado, se construye el query
    if(isset($_GET["currencyid"]) && $_GET["currencyid"] != ""){
        $currencyid = " AND currencies.id = ".$_GET["currencyid"];
    }
    
    //En caso de que el filter sea enviado, se construye el query
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        // Iniciamos la cadena del query
        $filter = " AND ( ";
        
        //Separamos el filtro por el simbolo +
        $filterEl = separateFilter($_GET["filter"]);
        
        //Recorremos cada elemento
        foreach($filterEl as $index => $el){
            //Si la fecha tiene / lo partimos en mil
            if(strpos($el, '/') !== false){
                $dateelements = explode("/",$el);
                
                foreach($dateelements as $i => $element){
                    if($i == 0){
                        $dateConverted .= $element;
                    }else{
                        $dateConverted .= "-".$element;
                    }
                }
                
                $dateel = strftime("%Y-%m-%d", strtotime($dateConverted));
            }else{
                $dateel = strftime("%Y-%m-%d", strtotime($el));
            }
            
            if($index == 0){
                $filter .= " usercompanies.name LIKE '%".$el."%' ".
                "           OR userpersons.fname LIKE '%".$el."%' ".
                "           OR t.dsc LIKE '".$el."%' ".
                "           OR DATE(t.datecreated) = DATE('".$dateel."') ".
                "           OR t.id = '".$el."'".
                "           OR (CASE ".
                "               WHEN t.dsc LIKE '%comis%' THEN 'Comisión' ".
                "               WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 'Ajuste' ".
                "               WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 'Intercambio' ".
                "               WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 'Depósito' ".
                "               WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 'Retiro' ".
                "               WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 'Transferencia' END) LIKE '".$el."%'".
                "           ".(validNumber($el) ?  'OR t.amount = '.floatval($el) : (validNumberFormatted($el) ? 'OR t.amount = '.parseFormattedNumber($el) : '')).
                "           ".(validNumber($el) ?  'OR t.amount = -'.floatval($el) : (validNumberFormatted($el) ? 'OR t.amount = -'.parseFormattedNumber($el) : '')).
                "           OR users.usr LIKE '%".$el."%' ".
                "           OR currencies.symbol LIKE '".$el."%'";
            }else{
                $filter .= " OR usercompanies.name LIKE '%".$el."%' ".
                "           OR userpersons.fname LIKE '%".$el."%' ".
                "           OR t.dsc LIKE '".$el."%' ".
                "           OR DATE(t.datecreated) = DATE('".$dateel."') ".
                "           OR t.id = '".$el."'".
                "           OR (CASE ".
                "               WHEN t.dsc LIKE '%comis%' THEN 'Comisión' ".
                "               WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 'Ajuste' ".
                "               WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 'Intercambio' ".
                "               WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 'Depósito' ".
                "               WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 'Retiro' ".
                "               WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 'Transferencia' END) LIKE '".$el."%'".
                "           ".(validNumber($el) ?  'OR t.amount = '.floatval($el) : (validNumberFormatted($el) ? 'OR t.amount = '.parseFormattedNumber($el) : '')).
                "           ".(validNumber($el) ?  'OR t.amount = -'.floatval($el) : (validNumberFormatted($el) ? 'OR t.amount = -'.parseFormattedNumber($el) : '')).
                "           OR users.usr LIKE '%".$el."%' ".
                "           OR currencies.symbol LIKE '".$el."%'";
            }
        }
        
        $filter .= " ) ";
    }
    
    $sql = "SELECT t.id AS txid, ".
    "       t.datecreated AS date, ".
    "       t.amount AS amount, ".
    "       t.dsc AS dsc, ".
    "       currencies.symbol AS currencysymbol, ".
    "       currencies.id AS currencyid, ".
    "       currencies.decimals AS decimals, ".
    "       t.txid AS txindexid, ".
    "       ".$caseType.
    "       users.usr AS usr, ".
    "       users.id AS userid, ".
    "       userpersons.fname AS personname, ".
    "       userpersons.flastname AS personlastname, ".
    "       usercompanies.name AS companyname, ".
    "       usercompanies.comercialname AS companycomercialname ".
    "       FROM transactions t, accounts, currencies, users ".
    "           LEFT JOIN usercompanies ON usercompanies.usrid = users.id ".
    "          	LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "       WHERE t.accountid = accounts.id ".
    "       AND accounts.userid = users.id ".
    "       AND accounts.currencyid = currencies.id ".
    "       ".$accountType.
    //"       AND t.amount != 0 ". // 27/01/2021: se traen los movimientos EN 0
    "       ".$currencyid.
    "       ".$type.
    "       ".$daterange.
    "       ".$filter.
    "       ".$order;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        //$record->test = $row;
        $record->id = (int)$row['txid'];
        
        $record->amount = new stdClass();
        $record->amount->number = $row['amount'];
        $record->amount->formatted = numberFormatt($row['amount'],$row['decimals']);
        
        $record->currency = new stdClass();
        $record->currency->id = (int)$row['currencyid'];
        $record->currency->symbol = $row['currencysymbol'];
        
        $record->user = new stdClass();
        $record->user->id = (int)$row['userid'];
        $record->user->usr = $row['usr'];
        
        $record->date = new stdClass();
        $record->date->cannonical = date("Y-m-d h:i a", strtotime($row["date"]));
        $record->date->formatted = date("d/m/Y", strtotime($row["date"]))." - ".date("h:i a", strtotime($row["date"]));
        
        $record->description = $row['dsc'];
        
        $record->type = $row['type'];
        
        $csvarray [] = array(
            'datecreated'=>$record->date->formatted,
            'txid'=>$record->id,
            'type'=>$record->type,
            'dsc'=>$record->description,
            'user'=>$record->user->usr,
            'currency'=>$record->currency->symbol,
            'amount'=>$record->amount->formatted
        );
    }
    
    $BOM = "\xEF\xBB\xBF"."\xEF\xBB\xBF";
    $fp = fopen('php://output', 'wb');
    fwrite($fp, $BOM);
    
    $line = array('FECHA','REF','TIPO','DESCRIPCIÓN','USUARIO','MONEDA','MONTO/CANTIDAD');
    
    fputcsv($fp, $line, ';', '"');
    
    foreach($csvarray as $arr){
        fputcsv($fp,$arr,';');
    }
    
    fclose($fp);
    
    die();
    
    /* Funcion para determinar el rango de operaciones, donde:
    *   1 = Hoy
    *   2 = Ultimos 7 dias
    *   3 = Ultimos 30 dias
    *   4 = Ultimos 3 meses
    *   5 = Ultimos 5 meses
    */
    function determinateRange($daterange){
        $str = '';
        
        switch($daterange){
            case 1:
                $str = " AND DATE(t.datecreated) >= DATE_SUB(NOW(), INTERVAL 1 DAY)";
                break;
            case 2:
                $str = " AND DATE(t.datecreated) >= DATE_SUB(NOW(), INTERVAL 7 DAY)";
                break;
            case 3:
                $str = " AND DATE(t.datecreated) >= DATE_SUB(NOW(), INTERVAL 30 DAY)";
                break;
            case 4:
                $str = " AND DATE(t.datecreated) >= DATE_SUB(NOW(), INTERVAL 90 DAY)";
                break;
            case 5:
                $str = " AND DATE(t.datecreated) >= DATE_SUB(NOW(), INTERVAL 6 MONTH)";
                break;
            default: 
                badEnd("500", array("msg"=>"El parametro fecha solo puede ser 1, 2, 3, 4 o 5"));
                break;
        }
        
        return $str;
    }
    
    /* Funcion para determinar el tipo de operacion a obtener, donde:
    *   1 = Depositos
    *   2 = Retiros
    *   3 = Transferencias
    *   4 = Intercambios
    *   5 = Comisiones
    */
    function determinateType($type){
        $query = '';
        
        switch($type){
            case 1:
                $query = " AND (CASE ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 END) = 1";
                break;
            case 2:
                $query = " AND (CASE ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 END) = 2";
                break;
            case 3:
                $query = " AND (CASE ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 END) = 3";
                break;
            case 4:
                $query = " AND (CASE ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 END) = 4";
                break;
            case 5:
                $query = " AND (CASE ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 END) = 5";
                break;
            case 6:
                $query = " AND (CASE ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 END) = 6";
                break;
        }
        
        return $query;
    }
    
    /* Funcion para determinar el orden de los resultados, donde:
    *   1 = Datetime(DEFAULT)
    *   2 = Monto
    *   3 = Usario
    */
    function determinateOrder($order){
        $query = '';
        
        switch($order){
            case 1:
                $query = ' ORDER BY t.datecreated DESC, t.id DESC';
                break;
            case 2:
                $query = ' ORDER BY t.amount DESC';
                break;
            case 3:
                $query = ' ORDER BY users.usr ASC';
                break;
            case -1:
                $query = ' ORDER BY t.datecreated ASC, t.id DESC';
                break;
            case -2:
                $query = ' ORDER BY t.amount ASC';
                break;
            case -3:
                $query = ' ORDER BY users.usr DESC';
                break;
            default:
                $query = ' ORDER BY t.datecreated DESC, t.id DESC';
                break;
        }
        
        return $query;
        
    }
    
    function determinateTypeAFX($type){
        $query = '';
        
        switch($type){
            case 1:
                $query = " AND (CASE ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 END) = 1";
                break;
            case 2:
                $query = " AND (CASE ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 END) = 2";
                break;
            case 3:
                $query = " AND (CASE ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 END) = 3";
                break;
            case 4:
                $query = " AND (CASE ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 END) = 4";
                break;
            case 5:
                $query = " AND (CASE ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 END) = 5";
                break;
            case 6:
                $query = " AND (CASE ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 6 ".
                "       WHEN (SELECT  COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 4 ".
                "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 1 ".
                "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 2 ".
                "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 3 ".
                "       WHEN t.dsc LIKE '%comis%' THEN 5 END) = 6";
                break;
        }
        
        return $query;
    }
?>
