<?php
// cms/api/users/list

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","offset","numofrec");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $offset = $_GET["offset"];
    $numofrec = $_GET["numofrec"];
    $order = "";
    $filter = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 18))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //En caso de que el filter sea enviado, se construye el query
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        // Iniciamos la cadena del query
        $filter = " AND ( ";
        
        //Separamos el filtro por el simbolo +
        $filterEl = separateFilter($_GET["filter"]);
        
        //Recorremos cada elemento
        foreach($filterEl as $index => $el){
            if($index == 0){
                $filter .= "  cms.name LIKE '%".$el."%' ".
                "           OR cms.usr LIKE '%".$el."%' ".
                "           OR (SELECT cmsusers.name FROM cmsusers ".
                "               WHERE cmsusers.type = 1  ".
                "               AND cmsusers.id = cms.rolid) LIKE '%".$el."%' ";
            }else{
                $filter .= " OR cms.name LIKE '%".$el."%' ".
                "           OR cms.usr LIKE '%".$el."%' ".
                "           OR (SELECT cmsusers.name FROM cmsusers ".
                "               WHERE cmsusers.type = 1  ".
                "               AND cmsusers.id = cms.rolid) LIKE '%".$el."%' ";
            }
            
        }
        
        $filter .= " ) ";
    }
    
    //En caso de que el order sea enviado, se construye el query
    if(isset($_GET["order"]) && $_GET["order"] != ""){
        $order = " ORDER BY ".determinateOrder($_GET["order"]);
    }
    
    //Contamos los resultados total del query a ejecutar
    $sql = "SELECT COUNT(cms.id) AS qty".
    "       FROM cmsusers cms".
    "       WHERE cms.type = 0 ".
    "       ".$filter;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
    $total = $rs->fetch_assoc();
    
    //Retornamos el total de elementos resultantes del query
    $out->numofrecords = (int)$total["qty"];
    
    //Consultamos los registros que sean type = 0(usuarios)
    $sql = "SELECT cms.* FROM cmsusers cms".
    "       WHERE cms.type = 0 ".
    "       ".$filter.
    "       ".$order.
    "       LIMIT ".$offset.", ".$numofrec;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
    
    //Ordenamos los valores
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["id"];
        $record->name = $row["name"];
        $record->email = $row["usr"];
        
        $record->status = new stdClass();
        $record->status->id = (int)$row["status"];
        $record->status->dsc =  $record->status->id == 1 ? "Activo" : "Inactivo";
        
        $record->rol = $row["rolid"] == 0 ? null : new stdClass();
        
        //Si el rol es distinto a null, consultamos sus datos
        if($record->rol != null){
            $sql = "SELECT * FROM cmsusers WHERE type = 1 AND id =".$row["rolid"];
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $rowrol = $res->fetch_assoc();
            
            $record->rol->id = (int)$rowrol["id"];
            $record->rol->name = $rowrol["name"];
            
            // Verificamos que coindidan los privilegios del usuario a los del rol
            $rolmodified = false;
            if ($row["rolid"]){
                // Calculamos rol
                $sql2 = "SELECT SUM(privilegeid) suma, COUNT(*) qty " . 
                "       FROM   userprivileges " .
                "       WHERE  userid=" . $row["rolid"];
                if (!$rs2 = $db->query($sql2))
                    badEnd("500", array("msg"=>$db->error));
                
                $suma = 0;
                $qty = 0;
                if ($row2 = $rs2->fetch_assoc()){
                    $suma = $row2["suma"];
                    $qty = $row2["qty"];
                }
                
                // Calculamos usuario
                $sql2 = "SELECT SUM(privilegeid) suma, COUNT(*) qty " . 
                "       FROM   userprivileges " .
                "       WHERE  userid=" . $row["id"];
                if (!$rs2 = $db->query($sql2))
                    badEnd("500", array("msg"=>$db->error));
                    
                
                $rolmodified = false;
                
                //Si la cantidad es distinta fue modificado
                if ($row2 = $rs2->fetch_assoc()){
                    $rolmodified =  !($suma == $row2["suma"] && $qty == $row2["qty"]);
                }
            }
            
            $record->rol->rolmodified = (boolean) $rolmodified;
        
        }
        
        //Formateamos la fecha quitandole las horas
        $record->datecreated = date("Y-m-d", strtotime($row["datecreated"]));
        $records [] = $record;
    }
    
    $out->records = $records;
    
    //Retornamos los privilegios del usuario en este modulo
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 15);
    $access->read =   tienePrivilegio($db, $sessionid, 18);
    $access->update = tienePrivilegio($db, $sessionid, 16);
    $access->delete = tienePrivilegio($db, $sessionid, 17);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para determinar el orden de los resultados, donde:
    *   0 = ID del usuario DESCENDENTE (mas reciente)
    *   1 = Nombre del usuario ASCENDENTE
    *   2 = Email del usuario ASCENDENTE
    *   3 = Status del usuario ASCEDENTE
    *   -1 = Nombre del usuario DESCENDENTE
    *   -2 = Email del usuario DESCENDENTE
    *   -3 = Status del usuario DESCENDENTE
    *   Y si el order es enviado si ser algunos de estos valores,
    *   Retornara un error para avisarle al desarrollador/@
    */
    function determinateOrder($order){
        $orderres = "";
        switch($order){
            case 0:
                $orderres = " cms.id DESC";
                break;
            case 1:
                $orderres = " cms.name ASC";
                break;
            case 2:
                $orderres = " cms.usr ASC";
                break;
            case 3:
                $orderres = " cms.status ASC";
                break;
            case 4:
                $orderres = " cms.id ASC";
                break;
            case -1:
                $orderres = " cms.name DESC";
                break;
            case -2:
                $orderres = " cms.usr DESC";
                break;
            case -3:
                $orderres = " cms.status DESC";
                break;
            case -4:
                $orderres = " cms.id DESC";
                break;
            default:
                badEnd("400", array("msg"=>"Order debe ser 0, 1, 2, 3, 4, -1, -2, -3 o -4"));
                break;
        }
        
        return $orderres;
    }
?>
