//Variables globales
var sessionId = sessionStorage.getItem("sessionId");
var editCountryId;
var deleteCountryId;

window.onload = function(){
    initApp();
    loadList(document.getElementById("search").value, 1, 0, 10, sessionId);
    
    document.getElementById("iconAddCountry").addEventListener('click', function (event) {
        editCountryId=0;
        var msg = document.getElementById("messageApi"); 
        if (this.dataset.privilegeCreate == "1"){
            updateElement(0,document.getElementById("addCountryName").value,document.getElementById("addTcvcode").value);
        }else{
            msg.innerHTML = "No posee privilegios para crear un país";
            msg.style.display="block";
            msg.classList.add("msgError");
            setTimeout(function() {
                msg.classList.remove("msgError");
                msg.style.display="none";
            }, 3000);
        }
    });

    document.getElementById("closeModal").addEventListener("click", function(){
        var modal = document.getElementById("myModal");
         modal.style.display = "none";
    });
    
    document.getElementById("buttonCancelModal").addEventListener("click", function(){
        var modal = document.getElementById("myModal");
         modal.style.display = "none";
    });
    document.getElementById("buttonAceptModal").addEventListener("click", function(){
        deleteElement();
    });
    
    var selectOrderBy = document.getElementById("orderBy");
    selectOrderBy.addEventListener("change", function(){
        loadList(document.getElementById("search").value, selectOrderBy.value, 0, 10, sessionId);
    });
    //Asignar evento barra de busqueda
    document.getElementById("search").addEventListener("change",function(){
        loadList(this.value, document.getElementById("orderBy").value, 0, 10, sessionId);
    });
    document.getElementById("search").addEventListener("keyup",function(e){
        if(e.keyCode==13)loadList(this.value, document.getElementById("orderBy").value, 0, 10, sessionId);
    });
    /*funcion del ordenar**/
     
        var orderDirect = document.getElementById("orderDirect");
        if(orderDirect!==null){
            orderDirect.addEventListener("change",function(){
                document.getElementById("orderBy").dispatchEvent(new Event("change"));
            });
        }
}

//Función para cargar listado
function loadList(filter, order, offset, numofrec, sessionid){
    var par = {};
    //Se pasa el document.getElementById("search").value por el parametro filter.
        if(filter !== "" && filter !== undefined && filter !== null)
        par.filter = filter;
        var order = Math.abs(order);
        var dir = document.getElementById("orderDirect").value;
        if(dir=="desc")order="-"+order;
        par.order = order;
        par.offset = offset;
        par.numofrec = numofrec;
        par.sessionid = sessionid;
        //Especifico el servicio, los parametros y la funcion de retorno del listado listado
        callWS("GET", "countries/list", par, respList);
        return 0;
}
//Función para el retorno del listado listado
function respList(status, rsp){
            let currencies = JSON.parse(rsp);
            var msg = document.getElementById("messageApi");
            switch(status){
                case 200:
                    console.log(currencies);
                    
                    if( currencies.privileges.create == false || currencies.privileges.create == "false"){
                        document.getElementById("iconAddCountry").dataset.privilegeCreate = "0";
                    } else {
                        document.getElementById("iconAddCountry").dataset.privilegeCreate = "1";
                    }
                    

                        if (currencies.numofrecords === 0){
                            /*Blanquear tabla*/
                            var nodeNoDelete = document.getElementById("noCurrencieDefine");
                            if (nodeNoDelete ){
                                nodeNoDelete.children[0].innerHTML = ""; 
                                nodeNoDelete.style.display="none";
                            }
                            var table = document.getElementById("bodyTableCountries");
                            table.innerHTML = "";
                            
                            
                            /**-hasta aqui-**/
                            document.getElementById("noCurrencieDefine").style.display= "flex";
                            document.getElementById("msgInTable").innerHTML="No Posee países definidos";
                            document.getElementById("paginator").style.display= "none";
                        }else{
                            if(currencies.numofrecords <= 10){
                                document.getElementById("paginator").style.display= "none";    
                            } else {
                                document.getElementById("paginator").style.display= ""; 
                                drawPags(currencies.numofrecords, "numbersPaginator");
                            }
                            /*Blanquear tabla*/
                            var nodeNoDelete = document.getElementById("noCurrencieDefine");
                            if (nodeNoDelete ){
                                nodeNoDelete.children[0].innerHTML = ""; 
                                nodeNoDelete.style.display="none";
                            }
                            var table = document.getElementById("bodyTableCountries");
                            table.innerHTML = "";
                            //if(nodeClone!==undefined && nodeClone!==null)table.appendChild(nodeClone);
                            /**-hasta aqui-**/
                            //Pintar registros
                            paintRowsList(currencies);
                     }
                    break;
                case 400:
                    msg.innerHTML=currencies.msg;
                    msg.classList.add("msgError");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError");   
                        msg.style.display="none";
                    }, 100000);
                    break;
                    break;
                case 401:
                    msg.innerHTML="Sesión expirada o inválida, vuelva a iniciar sesión";
                    msg.classList.add("msgError"); 
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError"); 
                        myLogout()
                        msg.style.display="none";
                    }, 3000);
                    break;
                case 403:
                    msg.innerHTML="No posee privilegios para ver países";
                    msg.classList.add("msgError"); 
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError"); 
                        msg.style.display="none";
                    }, 3000);
                    break;
                case 500:
                    msg.innerHTML=" Error Interno";
                    msg.classList.add("msgError"); 
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError"); 
                        msg.style.display="none";
                    }, 3000);
                    break;
                default:
                    msg.innerHTML=currencies.msg;
                    msg.classList.add("msgError"); 
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError"); 
                        msg.style.display="none";
                    }, 3000);
            }
}
//Funcion para el Paginado
var pagerNumber = 10;
function drawPags(numofrecords, tbl){
    var pages = Math.ceil( numofrecords / pagerNumber );
    var numbersPaginator = document.getElementById(tbl);
    var lastPag = 0;
    if(numbersPaginator.getElementsByClassName("pSelect").length>0){
        lastPag = numbersPaginator.getElementsByClassName("pSelect")[0].getAttribute("data-page");
    }
    numbersPaginator.innerHTML = "";
    
    var initialPage=0;
    var n=8;
    if (pages>n){  // cambio de formato en caso de mas de n paginas
        initialPage = Math.max((lastPag-Math.ceil(n/2)+2), 1)-1;
    }
    
    // puntitos iniciales cuando son más de 10 página y no se empieza por la primera
    if (pages>n && initialPage !== 0 && initialPage !== 1){
        spanF = document.createElement("div");
        spanF.classList.add("pages");
        spanF.innerHTML = "1 ...";
        spanF.dataset.page= 1;
        spanF.style.cursor="pointer";
        spanF.addEventListener("click", function(){
            //Se desmarca la página anterior
            var pSel = document.getElementsByClassName("pSelect");
            if(pSel.length>0)pSel[0].classList.remove("pSelect");
            
            //Se actualiza la página seleccionada
            this.classList.add("pSelect");
            
            //Se repinta el listado desde el offset seleccionado
            var offset = (this.getAttribute("data-page")-1)*pagerNumber;
            var order = document.getElementById("orderBy").value;
            var filter = document.getElementById("search").value;
            loadList(filter, order, offset, pagerNumber, sessionStorage.getItem("sessionId"));
        });
        numbersPaginator.appendChild(spanF);
        /*
        span = document.createElement("div");
        span.classList.add("pages");
        span.innerHTML = "...";
        numbersPaginator.appendChild(span);*/
        
    }

    //Pintar paginas de table (numeros)
    for(var k=initialPage; k<pages && !(k-initialPage > n-1); k++){
        var p = document.createElement("div");
        p.classList.add("pages");
        p.innerHTML = k+1;
        p.dataset.page= k+1;
        if(lastPag==0 && k==0)p.classList.add("pSelect");//Se selecciona la página 1
        else if(lastPag!==0 && (lastPag-1)==k)p.classList.add("pSelect");
        
        p.addEventListener("click", function(){
            //Se desmarca la página anterior
            var pSel = document.getElementsByClassName("pSelect");
            if(pSel.length>0)pSel[0].classList.remove("pSelect");
            
            //Se actualiza la página seleccionada
            this.classList.add("pSelect");
            
            //Se repinta el listado desde el offset seleccionado
            var offset = (this.innerHTML-1)*pagerNumber;
            var order = document.getElementById("orderBy").value;
            var filter = document.getElementById("search").value;
            loadList(filter, order, offset, pagerNumber, sessionStorage.getItem("sessionId"));
        });
        p.style.cursor="pointer";
        numbersPaginator.appendChild(p);
                                
    }
    
    // puntitos si no se ven las útlimas páginas
    if (pages>n && initialPage+n<pages){
        /*
        span = document.createElement("div");
        span.setAttribute("title", pages+" páginas")
        span.classList.add("pages");
        span.innerHTML = "...";
        numbersPaginator.appendChild(span);
        */
        
        spanL = document.createElement("div");
        spanL.classList.add("pages");
        spanL.innerHTML = "... "+pages;
        spanL.dataset.page= pages;
        spanL.style.cursor="pointer";
        spanL.addEventListener("click", function(){
            //Se desmarca la página anterior
            var pSel = document.getElementsByClassName("pSelect");
            if(pSel.length>0)pSel[0].classList.remove("pSelect");
            
            //Se actualiza la página seleccionada
            this.classList.add("pSelect");
            
            //Se repinta el listado desde el offset seleccionado
            var offset = (this.getAttribute("data-page")-1)*pagerNumber;
            var order = document.getElementById("orderBy").value;
            var filter = document.getElementById("search").value;
            loadList(filter, order, offset, pagerNumber, sessionStorage.getItem("sessionId"));
        });
        numbersPaginator.appendChild(spanL);
    }
    
    
    
    //Asignación de eventos validar que sólo se haga una vez
    if(numbersPaginator.getAttribute("arrowsEvent")=="false"){
        var leftArrow = numbersPaginator.previousElementSibling;
        var rightArrow = numbersPaginator.nextElementSibling;
        //Evento flecha izquierda
        leftArrow.addEventListener("click",function(){
            var pSel = document.getElementsByClassName("pSelect");
            if(pSel.length>0){
                //Si el elemento anterior al seleccionado es una pagina
                if(pSel[0].previousElementSibling.classList.contains("pages")){
                    var last = pSel[0];
                    pSel[0].previousElementSibling.classList.add("pSelect");
                    last.classList.remove("pSelect");
                    //Se repinta el listado desde el offset seleccionado
                    var offset = (pSel[0].innerHTML-1)*pagerNumber;
                    var order = document.getElementById("orderBy").value;
                    var filter = document.getElementById("search").value;
                    loadList(filter, order, offset, pagerNumber, sessionStorage.getItem("sessionId"));
                }
            }
        });
        //Evento flecha derecha
        rightArrow.addEventListener("click",function(){
            var pSel = document.getElementsByClassName("pSelect");
            if(pSel.length>0){
                //Si el elemento anterior al seleccionado es una pagina
                if(pSel[0].nextElementSibling.classList.contains("pages")){
                    pSel[0].nextElementSibling.classList.add("pSelect");
                    pSel[0].classList.remove("pSelect");
                    
                    //Se repinta el listado desde el offset seleccionado
                    var offset = (pSel[0].innerHTML-1)*pagerNumber;
                    var order = document.getElementById("orderBy").value;
                    var filter = document.getElementById("search").value;
                    loadList(filter, order, offset, pagerNumber, sessionStorage.getItem("sessionId"));
                }
            }
        });
        numbersPaginator.setAttribute("arrowsEvent",true);
    }
    
    
}

function updateElement(id,dsc,tcvcode){
    var par = {};
    par.id= parseInt(id);
    par.dsc=dsc;
    par.tcvCode = tcvcode;
    par.status=1;
    par.sessionid = sessionId;
    callWS("GET", "countries/update", par, rspUpdate);
    return 0;
}
function rspUpdate(status, rsp){
    var respuesta = JSON.parse(rsp);
    var msg = document.getElementById("messageApi");
        switch(status){
            case 200:
                console.log(respuesta)
                if(editCountryId !== 0){
                    //Es una actualizacion
                    document.getElementById("countriesIcons/"+editCountryId).classList.remove("nShow");
                    document.getElementById("countriesIconsEdit/"+editCountryId).classList.add("nShow");
                    document.getElementById("line/"+editCountryId).classList.remove("editLine");
                    document.getElementById("countryName/"+editCountryId).disabled = true;
                    msg.innerHTML="País actualizado con éxito"
                    msg.classList.add("goodEdit");
                    msg.style.display="block";
                        setTimeout(function() {
                            msg.classList.remove("goodEdit");
                            msg.style.display="none";
                        }, 4000);
                }else{
                    //Es un nuevo elemento
                    msg.innerHTML="País creado con éxito"
                    msg.classList.add("goodEdit");
                    msg.style.display="block";
                        setTimeout(function() {
                            msg.classList.remove("goodEdit");
                            msg.style.display="none";
                            
                            //Se repinta el listado desde el offset seleccionado
                            var order = document.getElementById("orderBy").value;
                            var filter = document.getElementById("search").value;
                            loadList(filter, order, 0, 10, sessionId);
                        }, 4000);
                }
            break;
            case 204://Registro sin modificar
                console.log(respuesta)
            break;
            case 400://Registro sin modificar
                console.log(respuesta)
            break;
            case 401:
                msg.innerHTML="Sesi\u00F3n expirada o inv\u00E1lida, vuelva a iniciar sesi\u00F3n"
                msg.classList.add("msgError");
                msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError");
                        msg.style.display="none";
                        myLogout();
                    }, 3000);
            break;
            case 403:
                    msg.innerHTML="No posee los privilegios para actualizar países."
                    msg.classList.add("msgError");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError");
                        msg.style.display="none";
                    }, 3000);
                    break;
                    
            case 500:
                msg.innerHTML="Error al actualizar países, intente nuevamente."
                msg.classList.add("msgError");
                msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError");
                        msg.style.display="none";
                    }, 3000);
            break;
            default:
                msg.innerHTML= respuesta.msg;
                msg.classList.add("msgError");
                msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError");
                        msg.style.display="none";
                    }, 3000);
        }
}
//Hace que solo este disponible 1 linea para editar    
function cleanAll(){
    document.querySelectorAll('[id^="countriesIcons/"]').forEach(function (element) {
        element.classList.remove("nShow");
    });
    document.querySelectorAll('[id^="countriesIconsEdit/"]').forEach(function (element) {
        element.classList.add("nShow");
    });
    document.querySelectorAll('[id^="line/"]').forEach(function (element) {
        element.classList.remove("editLine");
    });
    document.querySelectorAll('[id^="countryName/"]').forEach(function (element) {
        element.disabled = true;
    });
}

//Aqui se pintan los registros
function paintRowsList(data){
    var pageInPaginator = document.getElementsByClassName("pSelect")[0];
    if(pageInPaginator){
        pageInPaginator = pageInPaginator.innerHTML;
    }
    var rowCurrencie = document.getElementById("bodyTableCountries");
    rowCurrencie.innerHTML = "";
    var filas;
    if (data.numofrecords > 10){
        filas = parseInt(data.numofrecords) - ((parseInt(pageInPaginator) - 1) * 10);
        if(filas > 10){
            filas = 10;
        }
    } else {
        filas = data.numofrecords
    }
    //type 0 = impar, 1 = par
    let type = 0;
    let dataC = data.records;
    for (let i=0; i<filas; i++){
        var tableLine = document.createElement("div");
        tableLine.classList.add("tableLine");
        tableLine.id= "line/"+dataC[i].id;
        if(type === 0){
            tableLine.classList.add("rowImpar");
            type=type+1;
        }else if(type === 1){
            type = 0;
        }
        tableLine.innerHTML = '<div class="cell1" style="width:auto">'+
                                    '<div class="divCellCnt" >'+
                                       '<input class="inputRow" value="'+dataC[i].dsc+'" id="countryName/'+dataC[i].id+'" disabled>'+
                                    '</div>'+
                                '</div>'+
                                 '<div class="cell1" style="width:25%">'+
                                    '<div class="divCellCnt">'+
                                       '<input class="inputRow" style="text-align:left" value="'+dataC[i].tcvCode+'" id="countryTcv/'+dataC[i].id+'" disabled>'+
                                    '</div>'+
                                '</div>'+
                                '<div class="cell1" style="width:60px">'+
                                    '<div class="divCellCnt countriesicons" id="countriesIcons/'+dataC[i].id+'">'+
                                        '<a id="edit/'+dataC[i].id+'"><i class="fas fa-edit"></i></a>'+
                                        '<a id="delete/'+dataC[i].id+'"><i class="fas fa-trash-alt"></i></a>'+
                                    '</div>'+
                                    '<div class="divCellCnt countriesicons edit nShow" id="countriesIconsEdit/'+dataC[i].id+'">'+
                                        '<a id="editConfirm/'+dataC[i].id+'"><i class="fas fa-check-circle"></i></a>'+
                                        '<a id="editClose/'+dataC[i].id+'"><i class="far fa-times-circle"></i></a>'+
                                    '</div>'+
                                '</div>';
        rowCurrencie.appendChild(tableLine);
    }
    document.querySelectorAll('[id^="edit/"]').forEach(function (element) {
        if(!(data.privileges.update == false || data.privileges.update == "false")){
            element.addEventListener('click', function (event) {
                var id= (this.id).split("/")[1];
                cleanAll();
                document.getElementById("countriesIcons/"+id).classList.add("nShow");
                document.getElementById("countriesIconsEdit/"+id).classList.remove("nShow");
                document.getElementById("line/"+id).classList.add("editLine");
                document.getElementById("countryName/"+id).disabled = false;
                document.getElementById("countryTcv/"+id).disabled = false;
                document.getElementById("countryName/"+id).focus();
            });
        }else{
            var msg = document.getElementById("messageApi");
            element.addEventListener("click", function(){
                var msg = document.getElementById("messageApi");
                msg.innerHTML="No posee los privilegios para actualizar países.";
                msg.classList.add("msgError");
                msg.style.display="block";
                setTimeout(function() {
                    msg.classList.remove("msgError");
                    msg.style.display="none";
                }, 3000);
            });
        }
        
    });
    document.querySelectorAll('[id^="editClose/"]').forEach(function (element) {
        element.addEventListener('click', function (event) {
            var id= (this.id).split("/")[1];
            document.getElementById("countriesIcons/"+id).classList.remove("nShow");
            document.getElementById("countriesIconsEdit/"+id).classList.add("nShow");
            document.getElementById("line/"+id).classList.remove("editLine");
            document.getElementById("countryName/"+id).disabled = true;
            document.getElementById("countryTcv/"+id).disabled = true;
 
        });
    });
    document.querySelectorAll('[id^="editConfirm/"]').forEach(function (element) {
        element.addEventListener('click', function (event) {
            var id= (this.id).split("/")[1];
            editCountryId = id;
            updateElement(id,document.getElementById("countryName/"+id).value,document.getElementById("countryTcv/"+id).value);
        });
    });
    document.querySelectorAll('[id^="delete/"]').forEach(function (element) {
        if(!(data.privileges.delete == false || data.privileges.delete == "false")){
            element.addEventListener('click', function (event) {
                var id= (this.id).split("/")[1];
                deleteCountryId=id;
                document.getElementById("countryDelete").innerText= document.getElementById("countryName/"+id).value;
                var modal = document.getElementById("myModal");
                modal.style.display = "block";
            });
        }else{
            element.addEventListener("click", function(){
                var msg = document.getElementById("messageApi");
                msg.innerHTML="No posee los privilegios para eliminar países";
                msg.classList.add("msgError");
                msg.style.display="block";
                setTimeout(function() {
                    msg.classList.remove("msgError");
                    msg.style.display="none";
                }, 3000);
            });
            
        }
    });
}
function deleteElement(){
    var par = {};
    par.id= parseInt(deleteCountryId);
    par.sessionid = sessionId;
    callWS("GET", "countries/delete", par, rspDelete);
    return 0;
}
function rspDelete(status, rsp){
    var msg = document.getElementById("messageApi");
        switch(status){
            case 200:
                var respuesta = JSON.parse(rsp);
                var modal = document.getElementById("myModal");
                modal.style.display = "none";
                msg.innerHTML= "País eliminado correctamente"
                msg.classList.add("msgSucess");
                msg.style.display="block";
                setTimeout(function() {
                    msg.classList.remove("msgSucess");
                    msg.style.display="none";
                }, 3000);
                /*Blanquear tabla*/
                var nodeNoDelete = document.getElementById("noCurrencieDefine");
                if (nodeNoDelete ){
                    nodeNoDelete.children[0].innerHTML = ""; 
                    nodeNoDelete.style.display="none";
                }
                var table = document.getElementById("bodyTableCountries");
                table.innerHTML = "";
                var pageInPaginator = document.getElementsByClassName("pSelect")[0];
                let offSetDelete = 0;
                if(pageInPaginator){
                    pageInPaginator = pageInPaginator.innerHTML;
                    offSetDelete = (pageInPaginator - 1) * 10;
                }
                loadList(document.getElementById("search").value, document.getElementById("orderBy").value, offSetDelete, 10, sessionId);
                //table.appendChild(nodeClone);
                    
                //location.reload();
            break;
            case 204://Registro sin modificar
                var respuesta = JSON.parse(rsp);
                console.log(respuesta)
            break;
            
            case 304:
                msg.innerHTML="Existen dependencias que no permiten eliminar este País"
                msg.classList.add("msgError"); 
                msg.style.display="block";
                var modal = document.getElementById("myModal");
                modal.style.display = "none";
                setTimeout(function() {
                    msg.classList.remove("msgError");
                    msg.style.display="none";
                    msg = document.getElementById("messageApi")
                }, 3000);
            break;
                    
            case 400://Registro sin modificar
                var respuesta = JSON.parse(rsp);
                console.log(respuesta)
            break;
            case 401:
                msg.innerHTML="Sesi\u00F3n expirada o inv\u00E1lida, vuelva a iniciar sesi\u00F3n"
                msg.classList.add("msgError");
                msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError");
                        msg.style.display="none";
                        myLogout();
                    }, 3000);
            break;
            case 403:
                    msg.innerHTML="No posee privilegios para realizar esta acción."
                    msg.classList.add("msgError");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError");
                        msg.style.display="none";
                    }, 3000);
                    break;
            
                    
            case 500:
                msg.innerHTML="Error interno, intente nuevamente."
                msg.classList.add("msgError");
                msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError");
                        msg.style.display="none";
                    }, 3000);
            break;
            default:
                var respuesta = JSON.parse(rsp);
                msg.innerHTML= respuesta.msg;
                msg.classList.add("msgError");
                msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgError");
                        msg.style.display="none";
                    }, 3000);
        }
}
