<?php
// api/fees/exchange

    header("Content-Type:application/json");
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    if (isset($_SERVER['HTTP_TOKENID']) && $_SERVER['HTTP_TOKENID'] == '')
        badEnd("400", array("msg"=>"Parametros obligatorios tokenid"));
    
    // parametros obligatorios
    $parmsob = array('pairid');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    // Obtener sessionid
    $sessionid = $_SERVER['HTTP_TOKENID'];
    $pairid = $_GET['pairid'];
    $out->exchanges = new stdClass();
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValid($db, $sessionid);
    
    // Consultamos los decimales para montos formateados
    $sql = "SELECT currencies.decimals AS decimals FROM currencies, pairs ".
    "       WHERE pairs.currencyid = currencies.id".
    "       AND pairs.id = ".$pairid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $currencydecimals = $rs->fetch_assoc();
    
    // Consultamos los datos de usuario natural 
    $sql = "SELECT cmspreffees.*, levels.name AS levelname FROM cmspreffees, levels WHERE cmspreffees.pairid = ".$pairid.
    "       AND levels.id = cmspreffees.levelid";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    while($row = $rs->fetch_assoc()){
        // Depositos
        $exchange = new stdClass();
            
        $exchange->id = (int)$row['levelid'];
        $exchange->level = (int)$row['levelid'];
        $exchange->leveldsc = $row['levelname'];
        
        $exchange->feesmkt = new stdClass();
        $exchange->feesmkt->pctfee = new stdClass();
        //$exchange->feesmkt->nmalfee = new stdClass();
        
        // COmisiones market
        if($row['pctmktfee'] != null){
            $exchange->feesmkt->pctfee->number = (float)$row['pctmktfee'];
            $exchange->feesmkt->pctfee->formatted = numberFormatt($exchange->feesmkt->pctfee->number, 3).'%';
            
            //$exchange->feesmkt->nmalfee->number = null;
            //$exchange->feesmkt->nmalfee->formatted = null;
        }else{
            $exchange->feesmkt->pctfee->number = null;
            $exchange->feesmkt->pctfee->formatted = null;
            
        //    $exchange->feesmkt->nmalfee->number = (float)$row['nmlmktfee'];
        //    $exchange->feesmkt->nmalfee->formatted = numberFormatt($exchange->feesmkt->nmalfee->number, $currencydecimals['decimals']);
        }
        
        $exchange->feeslimit = new stdClass();
        $exchange->feeslimit->pctfee = new stdClass();
        //$exchange->feeslimit->nmalfee = new stdClass();
        
        // COmisiones market
        if($row['pctmktfee'] != null){
            $exchange->feeslimit->pctfee->number = (float)$row['pctmktfee'];
            $exchange->feeslimit->pctfee->formatted = numberFormatt($exchange->feeslimit->pctfee->number, 3).'%';
            
            //$exchange->feeslimit->nmalfee->number = null;
            //$exchange->feeslimit->nmalfee->formatted = null;
        }else{
            $exchange->feeslimit->pctfee->number = null;
            $exchange->feeslimit->pctfee->formatted = null;
            
            //$exchange->feeslimit->nmalfee->number = (float)$row['nmlmktfee'];
            //$exchange->feeslimit->nmalfee->formatted = numberFormatt($exchange->feeslimit->nmalfee->number, $currencydecimals['decimals']);
        }
        
        
        // Validamos el tipo de usuario
        if($row['usertype'] == 1){
            
            $naturalexchanges [] = $exchange;
            
        }else{
            
            $juridicexchanges [] = $exchange;
            
        }
    }
    
    $out->exchanges->natural = $naturalexchanges;
    $out->exchanges->juridic = $juridicexchanges;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>