<?php
// app/api/login2fa/accept
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    include("../../hooks/google2fa/autoload.php");
    use PragmaRX\Google2FA\Google2FA;
    
    // parametros obligatorios
    $parmsob = array("sessionid", 'otp');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = $_GET["sessionid"];
    $otp = $_GET['otp'];
    $valid = false;
    
    //Validamos que la session del usuario sea valida para continuar
    $userid = isSessionValid($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    //  Obtenemos los datos del usuario 
    $sql = "SELECT * FROM users WHERE id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $userdata = $rs->fetch_assoc();
    
    /* Parametro type
        1: Google
        2: Email
        3: Phone
    */
    if ($userdata['login2fa'] == 1) {
        $google2fa = new Google2FA();
        $valid = $google2fa->verifyKey($userdata['google2fa'], $otp, 0);
    }else if ($userdata['login2fa'] == 2) {
        
    }else if ($userdata['login2fa'] == 3) {
        
    }
    
    if (!$valid) {
        badEnd("401", array("msg"=>"Código de autenticación inválido"));
    }
    
    $sql =  "SELECT  id, sessionid,  DATE_FORMAT(validthru, '%Y%m%d%H%i%s') vt, usr, type ".
            "FROM    users ".
            "WHERE   id = ".$userid;
    if (!$rs = $db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    $row = $rs->fetch_assoc();
    
    $out->id =(int)$row["id"];
    $out->sessionid = $row["sessionid"];
    $out->validthru = $row["vt"];
    $out->name = $row["usr"];
    $out->type = (int)$row['type'];
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>