window.onload = function(){
    
    // Entry
    getEntry(sessionStorage.getItem('sessionid'))
    
    // Go to Register Person
    document.getElementById('person').addEventListener("click", function(){
        var req = {
            "sessionid" : sessionStorage.getItem('sessionid'),
            "step" : 0,
            "uploadids" : ''
        }
        updatePerson(req);
    });
    
    // Go to Register Company
    document.getElementById('company').addEventListener("click", function(){
        var req = {
            "sessionid" : sessionStorage.getItem('sessionid'),
            "step" : 0,
            "uploadids" : ''
        }
        updateCompany(req);
    });
    
    setLang();
    
    //Mostrar HTML cargado
    //esconderHTML(false);
}

function gotoStep(rsp){
    var lastpag = document.referrer;
    if(lastpag !== ""){
        //Pagina anterior detetcto si viene de un boton anterior
        var lastid="";
        var sid = lastpag.indexOf("&sid=", 0);
        var sess = lastpag.indexOf("&ses", 0);
        if(sid>0 && sess>0){
            lastid = lastpag.substr((sid+5), ((sess)-(sid+5)));
            
            document.getElementById("cellTypeUsr").style.visibility="";//Muestro el form
            esconderHTML(false);
    }else{
            //Valido que tegna un tipo seleccionado
            if(rsp.entry.type.id !== 0 ){
                //Redirecciono a paginas de persona natural dependiendo del paso
                if(rsp.entry.type.id == 1){
                    switch(rsp.entry.person.step){
                        case 0:
                            document.getElementById("cellTypeUsr").style.visibility="";
                            esconderHTML(false);
                            break;
                        case 1:
                            gotoPage('register','regPerson',"");
                            break;
                        case 2:
                            gotoPage('register','regPersonRes',"");
                            break;
                        case 3:
                            gotoPage('register','regPersonInf',"");
                            break;
                        case 4:
                            gotoPage('register','regPersonImg',"");
                            break;
                        case 5:
                            gotoPage('register','regPersonTr',"");
                            break;
                        case 6:
                            gotoPage('register','regPersonStatement',"");
                        break;
                        case 7:
                            if(rsp.entry.view == 0){
                                gotoPage('dashboard','home',"");
                            }else{
                                gotoPage('step','main',"");
                            }
                        break;
                    }
                }else{
                    switch(rsp.entry.company.step){
                        case 0:
                            document.getElementById("cellTypeUsr").style.visibility="";
                            esconderHTML(false);
                            break;
                        case 1:
                            gotoPage('register','regCompany',"");
                            break;
                        case 2:
                            gotoPage('register','regCompanyPartner',"");
                            break;
                        case 3:
                            gotoPage('register','regCompanyRes',"");
                            break;
                        case 4:
                            gotoPage('register','regCompanyInf',"");
                            break;
                        case 5:
                            gotoPage('register','regCompanyImg',"");
                            break;
                        case 6:
                            gotoPage('register','regCompanyTr',"");
                            break;
                        case 7:
                            gotoPage('register','regCompanyStatement',"");
                            break;
                        case 8:
                            if(rsp.entry.view == 0){
                                gotoPage('dashboard','home',"");
                            }else{
                                gotoPage('step','main',"");
                            }
                            break;
                }
            }
            }else{
                document.getElementById("cellTypeUsr").style.visibility="";
                esconderHTML(false);
            }
        }
    }
}

function getEntry(sessionid){
    callWS("GET", "users/entry", { 'sessionid' : sessionid}, response);
    function response(status, rsp){
        switch(status){
            case 200:
                gotoStep(JSON.parse(rsp));
                break;
            case 304:
                document.getElementById("cellTypeUsr").style.visibility="";
                esconderHTML(false);
                break;
            default:
                break;
        }
    }    
}


// Update step with updateperson
function updatePerson(req){
    callWS("POST", "users/updateperson", req, response);
    function response(status, rsp){
        switch(status){
            case 200:
                gotoPage('register','regPerson',"");
                break;
            default:
                break;
        }
    }  
}

// Update step with updatecompany
function updateCompany(req){
    callWS("POST", "users/updatecompany", req, response);
    function response(status, rsp){
        switch(status){
            case 200:
                gotoPage('register','regCompany',"");
                break;
            default:
                break;
        }
    }  
}

function setLang(){
    
    addFooter()
    
    lang = localStorage.getItem('lang');
    
    /* inner HTML */
    setWordLanginnerHTML('title','title');
    setWordLanginnerHTML('information','information');
    setWordLanginnerHTML('person','natural');
    setWordLanginnerHTML('company','legal');
    setWordLanginnerHTML('ts','ts');

}

function changeLang(){
    
    lang = localStorage.getItem('lang');
    
    /* inner HTML */
    setWordLanginnerHTML('title','title');
    setWordLanginnerHTML('information','information');
    setWordLanginnerHTML('person','natural');
    setWordLanginnerHTML('company','legal');
    setWordLanginnerHTML('ts','ts');
    
}

function expiredSession(){
    document.getElementsByClassName('expired')[0].style.display = "table"
    WS_waitscreen = false;
    var seconds = 30;
    var countdown = setInterval(countDown, 1000);
    
    function countDown(){
        seconds--;
        if(seconds == 0){
            if(document.getElementsByClassName('expired')[0].style.display == "table"){
                gotoPage('login','main','');
                clearInterval(countdown);
            }
        }
        if(document.getElementsByClassName('expired')[0].style.display == "none"){
            clearInterval(countdown)
        }
    }
}