<?php
// app/api/wallets/validate

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    $out = new stdClass();
    
    //Con este servicio consultaremos la cuenta mas reciente de los usuarios para validar sus direcciones
    
    // Obtenemos las direcciones que esten por debajo de la fecha actual
    /*
    $sql = "SELECT wall.id AS walletid, ".
    "       wall.accountid AS walletaccountid ".
    "       FROM wallets wall ".
    "       WHERE expirationDate < NOW() ".
    "       AND (SELECT COUNT(wallets.id) ".
    "        	FROM wallets, accounts ".
    "         	WHERE wallets.expirationDate > NOW() ".
    "         	AND wallets.accountid = accounts.id ".
    "         	AND wallets.accountid = wall.accountid ) = 0 ";
    */
    //La primera consulta debe ser a las cuentas, tenemos que retornar aquellas que no tengan wallet o que 'la mas reciente' esté vencida.
    //Adicionalmente se necesita el interface para indentifica el tipo de dirección a generar, el symbol es necesario para las llamadas adicionales (BTC/PTR)
    $sql =  "SELECT acc.*,c.interface,c.symbol,ws.wallet,ws.expirationdate FROM `accounts` acc " .
            "LEFT JOIN ( " .
                "SELECT w.wallet,w.accountid,MAX(w.expirationDate) AS expirationDate ".
                "FROM wallets w GROUP BY w.accountid " .
            "   ) ws ".
            "ON ws.accountid = acc.id " .
            "LEFT JOIN currencies c " .
            "ON c.id = acc.currencyid " .
            "WHERE paymentmethodid=-1 " .
            "AND (ws.expirationDate<NOW() OR ws.wallet IS NULL) " . //Filtro de uentas con wallets vencidas o vacías (null)
            "AND (c.interface = 4 OR c.interface = 5) " . //Filtro adicional de interfaces no necesario
            "GROUP BY acc.id,userid ORDER BY c.interface, ws.expirationDate DESC, acc.id";
          //  die($sql);
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    // Recorremos las cuentas
    while($row = $rs->fetch_assoc()){
        switch(intval($row['interface'])){
            case 6:
                //TETHER
                
                //Validamos que se tengan fondos
                $request = array('method'=>'getBalances', "address" => $USDT_CENTRAL_WALLET);
                $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
                
                // Si es mayor a 10 podemos crearle una wallet nueva
                if($rest['TRX'] > 10){
                    $request = array('method'=>'createAddress');
                    $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);
                    
                    if($rest == null || $rest['newaddress']['address_base58'] == null){
                        continue 2;
                        //  badEnd('402',array("msg"=>"Error al obtener direccion: ", 'msg2'=>$rest));
                    }else{
                        $walletid = $rest['newaddress']['address_base58'];
                        $apiKeySecret = $rest['newaddress']['private_key'];
                        
                        $txidWallet = $rest['transaction']['txid'];
                        
                        // Si se agrego la direccion la colocamos en details1
                        if(insertNewAddress($db, $row['id'], $walletid, $apiKeySecret, $txidWallet)){
                            putNewAddress($db, $row['id'], $walletid);
                        }
                    }
                }
                
                break;
            case 5:
                // interface == 5 || PTR
                $rsp = queryPrivate('deposit_address', $TCV_JWT, $TCV_URL, $VERSION_API, false, ['currency' => $row['symbol']]);
                
                // Si la direccion es null y la respuesta es distinta a 201, hubo un error
                if($rsp['address'] == NULL || $rsp['httpres'] != 201){
                    continue 2;
                }else{
                    // Si la direccion no es nula, la guardamos para actualizar nuestra cuenta e insertar la wallet
                    $walletid = $rsp['address'];
                    
                    // Si se agrego la direccion la colocamos en details1
                    if(insertNewAddress($db, $row['id'], $walletid, randomString(8), NULL)){
                        putNewAddress($db, $row['id'], $walletid);
                    }
                }
                
                break;
            case 4:
                // interface == 4 || BTC
                $parms = array("label"=>"afxaddr");
                $request = array('method'=>'getnewaddress','parms' => $parms);
                $rsp = json_decode(queryServicesBTC($BTC_URL, $request), true);
    
                // Validamos que el error no sea nulo para mandar el mensaje
                if($rsp['error'] != null){
                    //badEnd('500',array("msg"=>$rest['error']['message']));
                    continue 2;
                }else if($rsp['result'] == null){
                    //badEnd('402',array("msg"=>"Error al obtener direccion: ", 'msg2'=>$rsp));
                    continue 2;
                }else{
                    $walletid = $rsp['result'];
                    // Si se agrego la direccion la colocamos en details1
                    if(insertNewAddress($db, $row['id'], $walletid, randomString(8), NULL)){
                        putNewAddress($db, $row['id'], $walletid);
                    }
                }
                break;
        }
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /* Funcion para agregar a details1 la wallet, recibe:
    *   $db = conexion a la base de datos
    *   $accountid = id de la cuenta
    *   $newaddress = nueva direccion a colocar
    */
    function putNewAddress($db, $accountid, $newaddress){
        
        // Si existe la actualizamos
        $sql = "UPDATE accounts SET ".
        "       details1 = '".$newaddress."' ".
        "       WHERE id = ".$accountid;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
    }
    
    /* Funcion para insertar la nueva direccion, recibe
    *   $db = conexion a la base de datos
    *   $accountid = id de la cuenta
    *   $newaddress = nueva direccion a colocar
    *   secretKey = Clave secreta de la wallet para acceso
    *   txid = Transaccion de fondeo para la wallet
    */
    function insertNewAddress($db, $accountid, $newaddress, $secretkey, $txid = NULL){
        
        // Insertamos la wallet
        $sql = "INSERT INTO wallets(".
        "       wallet, secretKey, ".
        "       accountid, txid, expirationDate".
        "       ) ".
        "       VALUES(".
        "       '".$newaddress."', ".
        "       '".$secretkey."', ".
        "       ".$accountid.", ".
        "       '".$txid."', ".
        "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
        "       )";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        return true;
    }
?>