<?php
// app/api/fees/entry

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","currencyid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $currencyid = $_GET["currencyid"];
    
    //Ordenamos los datos
    $out->entry = new stdClass();
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Consultamos los datos del usuario para encontrar su fee
    $sql = "SELECT id, usr, type, level ".
    "       FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $userdata = $rs->fetch_assoc();
    
    $level = 1;
    
    if($userdata["level"] == 0){
        $level = 1;
    }else{
        $level = $userdata["level"];
    }
    
    // Consultamos los datos de la moneda
    $sql = "SELECT * ".
    "       FROM currencies ".
    "       WHERE id = ".$currencyid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $currencydata = $rs->fetch_assoc();
    
    // Fee de la blockchain
    if(intval($currencydata['interface']) == 4){
        // Obtenemos el fee estimado
            
        $out->entry->blockchainfee = new stdClass();
        
        $out->entry->blockchainfee->number = (float)number_format(determinateFee(intval($currencydata['interface']), $BTC_URL, 10),$currencydata['decimals'],'.','');
        $out->entry->blockchainfee->formatted = numberFormatt($out->entry->blockchainfee->number, $currencydata['decimals']);
    }else if(intval($currencydata['interface']) == 5){
        // Obtenemos el fee estimado
        $out->entry->blockchainfee = new stdClass();
        
        $out->entry->blockchainfee->number = (float)number_format(determinateFee(intval($currencydata['interface']), $TCV_URL, 10, $VERSION_API, $TCV_JWT),$currencydata['decimals'],'.','');
        $out->entry->blockchainfee->formatted = numberFormatt($out->entry->blockchainfee->number, $currencydata['decimals']);
    }
    else if(intval($currencydata['interface']) == 6){
        // Obtenemos el fee estimado
        $out->entry->blockchainfee = new stdClass();
        
        $out->entry->blockchainfee->number = (float)number_format(0,$currencydata['decimals'],'.','');
        $out->entry->blockchainfee->formatted = numberFormatt($out->entry->blockchainfee->number, $currencydata['decimals']);
    }
    
    
    //$out->entry->test = number_format((float)determinateFee(intval($currencydata['interface']), $BTC_URL, 10), $currencydata['decimals'],'.','');
    
    //Consultamos las comisiones con los datos del usuario
    $sql = "SELECT * FROM cmspreffees ".
    "       WHERE levelid = ".$level.
    "       AND currencyid = ".$currencyid.
    "       AND usertype = ".$userdata["type"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $feedata = $rs->fetch_assoc();
    
    //Comisiones para depositos
    $out->entry->deposits = new stdClass();
    
    if($feedata["pctfeedeposits"] == 0){
        $out->entry->deposits->pctfee = null;
        
        $out->entry->deposits->nmalfee = new stdClass();
        $out->entry->deposits->nmalfee->number = (float)number_format($feedata["nmlfeedeposits"],$currencydata['decimals'],'.','');
        $out->entry->deposits->nmalfee->formatted = numberFormatt($feedata["nmlfeedeposits"],$currencydata['decimals']);
        
    }else{
        $out->entry->deposits->pctfee = new stdClass();
        $out->entry->deposits->pctfee->number = (float)number_format($feedata["pctfeedeposits"], 3,'.','');
        $out->entry->deposits->pctfee->formatted = number_format($feedata["pctfeedeposits"],3,",",".");
        
        $out->entry->deposits->nmalfee = null;
    }
    
    $out->entry->deposits->min = new stdClass();
    $out->entry->deposits->min->number = (float)number_format($feedata['mindeposit'], $currencydata['decimals'],'.','');
    $out->entry->deposits->min->formatted = numberFormatt($out->entry->deposits->min->number, $currencydata['decimals']);
    
    if(floatval($feedata["maxamountmonthlyopdeposits"]) == 0){
        $out->entry->deposits->max = null;
    }else{
        $out->entry->deposits->max = new stdClass();
        $out->entry->deposits->max->number = (float)number_format($feedata['maxamountmonthlyopdeposits'], $currencydata['decimals'],'.','');
        $out->entry->deposits->max->formatted = numberFormatt($out->entry->deposits->max->number, $currencydata['decimals']);
    }
    
    //Comisiones para retiros
    $out->entry->withdrawals = new stdClass();
    
    if($feedata["pctfeewithdrawals"] == 0){
        $out->entry->withdrawals->pctfee = null;
        
        $out->entry->withdrawals->nmalfee = new stdClass();
        $out->entry->withdrawals->nmalfee->number = (float)number_format($feedata["nmlfeewithdrawals"], $currencydata['decimals'],'.','');
        $out->entry->withdrawals->nmalfee->formatted = numberFormatt($feedata["nmlfeewithdrawals"],$currencydata['decimals']);
    
    }else{
        $out->entry->withdrawals->pctfee = new stdClass();
        $out->entry->withdrawals->pctfee->number = (float)number_format($feedata["pctfeewithdrawals"], 3,'.','');
        $out->entry->withdrawals->pctfee->formatted = number_format($feedata["pctfeewithdrawals"],3,",",".");
        
        $out->entry->withdrawals->nmalfee = null;
    }
    
    $out->entry->withdrawals->min = new stdClass();
    $out->entry->withdrawals->min->number = (float)number_format($feedata['minwithdraw'], $currencydata['decimals'],'.','');
    $out->entry->withdrawals->min->formatted = numberFormatt($out->entry->withdrawals->min->number, $currencydata['decimals']);
    
    if(floatval($feedata['maxamountmonthlyopwithdrawals']) == 0){
        $out->entry->withdrawals->max = null;
    }else{
        $out->entry->withdrawals->max = new stdClass();
        $out->entry->withdrawals->max->number = (float) number_format($feedata['maxamountmonthlyopwithdrawals'], $currencydata['decimals'],'.','');
        $out->entry->withdrawals->max->formatted = numberFormatt($out->entry->withdrawals->max->number, $currencydata['decimals']);
    }
    
    
    //Comisiones para retiros
    $out->entry->xfer = new stdClass();
    
    if($feedata["pctfeexfer"] == 0){
        $out->entry->xfer->pctfee = null;
        
        $out->entry->xfer->nmalfee = new stdClass();
        $out->entry->xfer->nmalfee->number = (float) number_format($feedata["nmlfeesxfer"], $currencydata['decimals'],'.','');
        $out->entry->xfer->nmalfee->formatted = numberFormatt($feedata["nmlfeesxfer"],$currencydata['decimals']);
    
    }else{
        $out->entry->xfer->pctfee = new stdClass();
        $out->entry->xfer->pctfee->number = (float)number_format($feedata["pctfeexfer"], 3,'.','');
        $out->entry->xfer->pctfee->formatted = number_format($feedata["pctfeexfer"],3,",",".");
        
        $out->entry->xfer->nmalfee = null;
    }
    
    $out->entry->xfer->min = new stdClass();
    $out->entry->xfer->min->number = (float) number_format($feedata['minxfer'], $currencydata['decimals'],'.','');
    $out->entry->xfer->min->formatted = numberFormatt($out->entry->xfer->min->number, $currencydata['decimals']);
    if(floatval($feedata['maxamountmonthlyopxfer']) == 0){
        $out->entry->xfer->max = null;
    }else{
        $out->entry->xfer->max = new stdClass();
        $out->entry->xfer->max->number = (float) number_format($feedata['maxamountmonthlyopxfer'], $currencydata['decimals'],'.','');
        $out->entry->xfer->max->formatted = numberFormatt($out->entry->xfer->max->number, $currencydata['decimals']);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>