<?php
// cms/api/countries/list

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("order","offset","numofrec","sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    
    //Definimos las variables que usaremos y las inicializamos
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $order = determinateOrder(intval($_GET["order"]));
    $offset = $_GET["offset"];
    $numofrec = $_GET["numofrec"];
    $filter = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 47))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Verificamos que no estemos recibiendo el filtro y si es asi construimos el query
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        // Iniciamos la cadena del query
        $filter = " WHERE ( ";
        
        //Separamos el filtro por el simbolo +
        $filterEl = separateFilter($_GET["filter"]);
        
        //Recorremos cada elemento
        foreach($filterEl as $index => $el){
            if($index == 0){
                $filter .= " name LIKE '".$el."%' ";
            }else{
                $filter .= " OR name LIKE '".$el."%' ";
            }
        }
        
        $filter .= " ) ";
        
    }
    
    
    //Contamos la cantidad total de registros que existiran con el query
    $sql = "SELECT count(id) AS qty FROM countries".
    "       ".$filter;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
    
    $total = $rs->fetch_assoc();
    
    //Retornamos la cantidad total de registros del query
    $out->numofrecords = (int)$total["qty"];
    
    //Consultamos los datos principales de los paises
    $sql = "SELECT id, name, status, tcvCode FROM countries".
    "       ".$filter.
    "       ORDER BY ".$order.
    "       LIMIT ".$offset.",".$numofrec;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
            
    //Creamos los records de cada pais
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row["id"];
        $record->dsc = $row["name"];
        $record->tcvCode = nvl($row["tcvCode"],"");
        $record->status = new stdClass();
        $record->status->id = (int)$row["status"];
        $record->status->dsc =  $record->status->id == 1 ? "Activo" : "Inactivo";
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    //Retornamos los privilegios del usuario actual
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 44);
    $access->read =   tienePrivilegio($db, $sessionid, 47);
    $access->update = tienePrivilegio($db, $sessionid, 45);
    $access->delete = tienePrivilegio($db, $sessionid, 46);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    
    /*  Funcion para determinar el orden de los resultados, donde:
    *   1 = Nombre del pais ASCENDENTE
    *   2 = Status del pais ASCENDENTE
    *   -1 = Nombre del pais DESCENDENTE
    *   -2 = Status del pais DESCENDENTE
    *   Y si el order es enviado si ser algunos de estos valores,
    *   Retornara un error para avisarle al desarrollador/@
    */
    function determinateOrder($order){
        $orderres = "";
        switch($order){
            case 0:
                $orderres = "id DESC";
                break;
            case 1:
                $orderres = "name ASC, id DESC";
                break;
            case 2:
                $orderres = "id ASC, status ASC";
                break;
            case 3:
                $orderres = "id ASC";
                break;
            case -1:
                $orderres = "name DESC, id DESC";
                break;
            case -2:
                $orderres = "id ASC, status DESC";
                break;
            case -3:
                $orderres = "id DESC";
                break;
            default:
                badEnd("400", array("msg"=>"Order debe ser 1, 2, 3 -1, -2 o -3"));
                break;
        }
        
        return $orderres;
    }
?>
