<?php
// cms/api/currencies/delete

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que tenga privilegios para eliminar
    if (!tienePrivilegio($db, $sessionid, 13))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Validamos que exista el registro
    $sql = "SELECT id, name, status FROM currencies WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 204 cuando la busqueda no obtiene resutados
    if($row["name"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    $nameCurrency = $row['name'];
    
    //Validamos que no sea una moneda de una forma de pago
    $sql = "SELECT count(id) AS qty FROM paymentmethods".
    "       WHERE currencies LIKE '%".$id."%' AND id > 0";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 304 cuando la moneda pertenece a una forma de pago
    if($row["qty"] > 0){
        badEnd("304", array("msg"=>"Existen dependencias que no permiten eliminar esta Moneda"));
    }
    
    //Validamos que no sea una moneda de una cuenta
    $sql = "SELECT count(id) AS qty FROM accounts".
    "       WHERE currencyid = ".$id.
    "       AND userid > 0";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 304 cuando la moneda pertenece a una forma de pago
    if($row["qty"] > 0){
        badEnd("304", array("msg"=>"Existen dependencias que no permiten eliminar esta Moneda"));
    }
    
    $db->autocommit(FALSE);
    
    // Consultamos los metodos de pago de AFX 
    $sql = "SELECT * FROM paymentmethods WHERE id = -1";
    if (!$rs=$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error.$sql));
    }
            
    $row = $rs->fetch_assoc();
    //Limpiamos el string y lo guardamos
    $currencies = validateCurrency($id, $row['currencies']);
        
    //Actualizamos el campo
    $sql = "UPDATE paymentmethods SET currencies = '".$currencies."' WHERE id < 0";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error.$sql));
    }
    
    //Eliminamos las cuentas ya que no fue utilizada la moneda
    $sql = "DELETE FROM accounts WHERE currencyid = ".$id." AND userid < 0";
    if (!$db->query($sql)){
        $error = $db->error;
        $errono = $db->errno;
        $db->rollback();
        $db->close();
        if ($errono == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar esta Moneda"));
        else
            badEnd("500",array("msg"=>$error." ".$error));
    }
    
    // Eliminamos el registro en rates
    $sql = "DELETE FROM cmsprefrates WHERE currencyid = ".$id;
    if (!$db->query($sql)){
        $error = $db->error;
        $errono = $db->errno;
        $db->rollback();
        $db->close();
        if ($errono == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar esta Moneda"));
        else
            badEnd("500",array("msg"=>$error." ".$error));
    }
    
    $sql = "DELETE FROM currencies WHERE id = ".$id;
    if (!$db->query($sql)){
        $error = $db->error;
        $errono = $db->errno;
        $db->rollback();
        $db->close();
        if ($errono == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar esta Moneda"));
        else
            badEnd("500",array("msg"=>$error." ".$error));
    }
    
    //COnsultamos que sea de preferencias
    $sql = "SELECT COUNT(levelid) AS qty FROM cmspreffees WHERE currencyid = ".$id;
    if (!$res=$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500",array("msg"=>$error));
    }
    
    $row = $res->fetch_assoc();
    
    if(intval($row['qty']) != 0){
        $sql = "DELETE FROM cmspreffees WHERE currencyid = ".$id;
        if (!$db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            if ($error == 1451)
                badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar esta Moneda"));
            else
                badEnd("500",array("msg"=>$error));
        }   
    }
    
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>"No se pudo modificar"));
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "MONEDAS", $sessionid, "CMS", "Se eliminó la moneda ".$nameCurrency);
    
    $db->commit();
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para crear string y sacar la moneda a borrar
    */
    function validateCurrency($currencyid, $currencies){
        $str = "";
        $currenciesarr = explode(",", $currencies);
        
        foreach($currenciesarr as $index => $currency){
            if(intval($currency) != intval($currencyid)){
                $str .= $index == 0 ? ''.$currency : ','.$currency; 
            }
        }
        
        return $str;
    }
?>
