<?php
// cms/api/transactions/update
    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id','date','dsc','currencyid','userid','amount');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    $date = $_GET['date'];
    $dsc = $_GET['dsc'];
    $currencyid = $_GET['currencyid'];
    $userid = $_GET['userid'];
    $amount = $_GET['amount'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Si es 0 insertamos el ajuste, si no lo modificamos
    if($id == 0){
        
        //Validamos que el usuario tenga privilegios para crear
        if(!tienePrivilegio($db, $sessionid, 37))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos si el usuario posee una cuenta
        $sql = "SELECT COUNT(id) AS qty".
        "       FROM accounts ".
        "       WHERE userid = ".$userid.
        "       AND currencyid = ".$currencyid.
        "       AND paymentmethodid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
        
        //Si el usuario no posee cuenta en esa moneda se la creamos
        if($row['qty'] == 0){
            //Consultamos los datos de la moneda para validar que tipo es
            $sql = "SELECT * FROM currencies ".
            "       WHERE id = ".$currencyid;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        
            $currencydata = $rs->fetch_assoc();
        
            $isCripto = false;
            $isFiat = false;
            
            //Verificamos si se debe llamar a una api o no, copmo tambien si es fiat o cripto
            if(intval($currencydata['interface']) == 1 || intval($currencydata['interface']) == 2 || intval($currencydata['interface']) == 3){
                $isFiat = true;
            }else if(intval($currencydata['interface']) == 4 || intval($currencydata['interface']) == 5 || intval($currencydata['interface']) == 6){
                $isCripto = true;
            }
        
            $db->autocommit(FALSE);
        
            if($isCripto && !$isFiat){
                $apiKeySecret = '';
                $txidWallet = '';
                //Si interface = 5, generamos la wallet con la api de la TCV
                if(intval($currencydata['interface']) == 5){
                    // PETRO
                    $rsp = queryPrivate('deposit_address', $TCV_JWT, $TCV_URL, $VERSION_API, false, ['currency' => $currencydata['symbol']]);
                    $out->test = $rsp;
                
                    //Si el address es null o la respuesta distinta a 201, error
                    if($rsp['address'] == NULL || $rsp['httpres'] != 201){
                        badEnd("402", array("msg"=>'Error al obtener direccion: '.$rsp['httpres']." - ".$rsp['error']->message));
                    }
                
                    $walletid = $rsp['address'];
                    $apiKeySecret = randomString(8);
                }elseif(intval($currencydata['interface']) == 4){
                    // BTC
                    $parms = array("label"=>"afxaddr");
                    $request = array('method'=>'getnewaddress','parms' => $parms);
                    $rsp = json_decode(queryServicesBTC($BTC_URL, $request), true);
    
                    // Validamos que el error no sea nulo para mandar el mensaje
                    if($rsp['error'] != null){
                        badEnd('500',array("msg"=>$rest['error']['message']));
                    }
                    
                    if($rsp['result'] == null){
                        badEnd('402',array("msg"=>"Error al obtener direccion: ".$rsp['error']['message']));
                    }
                    
                    $walletid = $rsp['result'];
                    $apiKeySecret = randomString(8);
                }else if(intval($currencydata['interface']) == 6){
                    //TETHER
                    $request = array('method'=>'createAddress');
                    $rest = json_decode(queryServicesUSDT($USDT_URL, $request), true);

                    if($rest['newaddress']['address_base58'] == null){
                        badEnd('402',array("msg"=>"Error al obtener direccion: ", 'msg2'=>$rest));
                    }
                    
                    $walletid = $rest['newaddress']['address_base58'];
                    $apiKeySecret = $rest['newaddress']['private_key'];
                    
                    $txidWallet = $rest['transaction']['txid'];
                }else{
                    $walletid = randomString(30);
                    $apiKeySecret = randomString(8);
                }
        
                //Insertamos la nueva cuenta
                $sql = "INSERT INTO accounts".
                "       (".
                "       paymentmethodid, ".
                "       userid, ".
                "       currencyid, ".
                "       details1, ".
                "       status ".
                "       )".
                "       VALUES(".
                "       -1, ".
                "       ".$userid.", ".
                "       ".$currencyid.", ".
                "       '".$walletid."', ".
                "       1 ".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error." 1 ".$sql));
                }
            
                // Retornamos el id que fue insertado
                $idcreated = (int)$db->insert_id;
        
                //Al ser una cripto, creamos una wallet
                $sql = "INSERT INTO wallets".
                "       (".
                "       wallet, ".
                "       secretKey, ".
                "       accountid, ".
                "       txid, ".
                "       expirationDate".
                "       )".
                "       VALUES(".
                "       '".$walletid."', ".
                "       '".$apiKeySecret."', ".
                "       ".$idcreated.", ".
                "       ".($txidWallet == '' ? 'NULL' : "'".$txidWallet."'").", ".
                "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error."2"));
                }
        
            }else if($isFiat && !$isCripto){
                
                //Insertamos la nueva cuenta
                $sql = "INSERT INTO accounts".
                "       (".
                "       paymentmethodid, ".
                "       userid, ".
                "       currencyid, ".
                "       status".
                "       )".
                "       VALUES(".
                "       -1, ".
                "       ".$userid.", ".
                "       ".$currencyid.", ".
                "       1".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error."3"));
                }
                
            }else{
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
            }
        
            $db->commit();
            $db->autocommit(TRUE);
        }
        
        //Consultamos los datos de la moneda para validar que tipo es
        $sql = "SELECT * FROM currencies ".
        "       WHERE id = ".$currencyid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $currencydata = $rs->fetch_assoc();
        
        $amount = validNumber($amount) ? $amount : (validNumberFormatted($amount) ? parseFormattedNumber($amount) : badEnd("403", array("msg"=>"Monto debe ser num��rico")));
        
        $sql = "SELECT id ".
        "       FROM accounts ".
        "       WHERE userid = ".$userid.
        "       AND currencyid = ".$currencyid.
        "       AND paymentmethodid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
        
        $sql = "INSERT INTO transactions (".
        "       datecreated, ".
        "       dsc, ".
        "       amount, ".
        "       amountghost, ".
        "       accountid, ".
        "       accountdestination ".
        "       ) VALUES (".
        "       '".$date."', ".
        "       '".$dsc."', ".
        "       ".number_format($amount, $currencydata['decimals'], '.', '').", ".
        "       0, ".
        "       ".$row['id'].", ".
        "       ".$row['id'].
        "       )";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //Le colocamos a la primera transferencia el txid
        $sql = "UPDATE transactions SET".
        "       txid = ".$out->id.
        "       WHERE id = ".$out->id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        // Obtenemos los datos del usuario
        $sql = "SELECT * FROM users WHERE id = ".$userid;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $rowUser = $res->fetch_assoc();
        
        $sql = "SELECT * FROM currencies ".
        "       WHERE id = ".$currencyid;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $currencydataAu = $res->fetch_assoc();
        
        //auditoria
        setAudit($db, "TRANSACCIONES", $sessionid, "CMS", "Se hizo un ajuste de ".number_format($amount, $currencydata['decimals'], ',', '.')." ".$currencydataAu['symbol']." al usuario ".$rowUser['usr']);
    }else{
        
        //Validamos que el usuario tenga privilegios para actualizar
        if(!tienePrivilegio($db, $sessionid, 38))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        //Consultamos para verificar que existe el ajuste
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM transactions ".
        "       WHERE txid = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $rs->fetch_assoc();
        
        // Si es 0 no existe el registro
        if($row['qty'] == 0){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        //Consultamos si el usuario posee una cuenta
        $sql = "SELECT COUNT(id) AS qty".
        "       FROM accounts ".
        "       WHERE userid = ".$userid.
        "       AND currencyid = ".$currencyid.
        "       AND paymentmethodid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
        
        //Si el usuario no posee cuenta en esa moneda se la creamos
        if($row['qty'] == 0){
            //Consultamos los datos de la moneda para validar que tipo es
            $sql = "SELECT * FROM currencies ".
            "       WHERE id = ".$currencyid;
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        
            $currencydata = $rs->fetch_assoc();
        
            $isCripto = false;
            $isFiat = false;
            
            if($currencydata['interface'] == 1 || $currencydata['interface'] == 2 || $currencydata['interface'] == 3){
                $isFiat = true;
            }else if($currencydata['interface'] == 4 || $currencydata['interface'] == 5 || $currencydata['interface'] == 6){
                $isCripto = true;
            }
        
            $db->autocommit(FALSE);
        
            if($isCripto && !$isFiat){
                $randomWallet = randomString(30);
        
                //Insertamos la nueva cuenta
                $sql = "INSERT INTO accounts".
                "       (".
                "       paymentmethodid, ".
                "       userid, ".
                "       currencyid, ".
                "       details1, ".
                "       status ".
                "       )".
                "       VALUES(".
                "       -1, ".
                "       ".$userid.", ".
                "       ".$currencyid["id"].", ".
                "       '".$randomWallet."', ".
                "       1 ".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error." 1 ".$sql));
                }
            
                // Retornamos el id que fue insertado
                $idcreated = (int)$db->insert_id;
        
                //Al ser una cripto, creamos una wallet
                $sql = "INSERT INTO wallets".
                "       (".
                "       wallet, ".
                "       secretKey, ".
                "       accountid, ".
                "       expirationDate".
                "       )".
                "       VALUES(".
                "       '".$randomWallet."', ".
                "       '".randomString(8)."', ".
                "       ".$idcreated.", ".
                "       DATE_ADD(NOW(), INTERVAL 1 YEAR)".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error."2"));
                }
        
            }else if($isFiat && !$isCripto){
                //Insertamos la nueva cuenta
                $sql = "INSERT INTO accounts".
                "       (".
                "       paymentmethodid, ".
                "       userid, ".
                "       currencyid, ".
                "       status".
                "       )".
                "       VALUES(".
                "       -1, ".
                "       ".$userid.", ".
                "       ".$currencyid["id"].", ".
                "       1".
                "       )";
                if (!$db->query($sql)){
                    $error = $db->error;
                    $db->rollback();
                    $db->close();
                    badEnd("500", array("msg"=>$error."3"));
                }
            }else{
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>"No se logro determinar el tipo de moneda, avise para verificar el arreglo de monedas"));
            }
        
            $db->commit();
            $db->autocommit(TRUE);
        }
        
        $sql = "SELECT id ".
        "       FROM accounts ".
        "       WHERE userid = ".$userid.
        "       AND currencyid = ".$currencyid.
        "       AND paymentmethodid = -1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $row = $rs->fetch_assoc();
        
        $amount = validNumber($amount) ? $amount : (validNumberFormatted($amount) ? parseFormattedNumber($amount) : badEnd("403", array("msg"=>"Monto debe ser num��rico")));
        
        $sql = "SELECT * FROM currencies ".
        "       WHERE id = ".$currencyid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
        $currencydata = $rs->fetch_assoc();
        
        // Obtenemos el registro viejos
        $sql = "SELECT * FROM transactions WHERE txid = ".$id;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $rowOldTx = $res->fetch_assoc();
        
        //actualizamos el registro
        $sql = "UPDATE transactions SET ".
        "       amount = ".number_format($amount, $currencydata['decimals'], '.', '').", ".
        "       dsc = '".$dsc."', ".
        "       datecreated = '".$date."', ".
        "       accountid = ".$row['id'].", ".
        "       accountdestination = ".$row['id'].
        "       WHERE txid = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        // Obtenemos los datos del usuario
        $sql = "SELECT * FROM users WHERE id = ".$userid;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $rowUser = $res->fetch_assoc();
        
        //auditoria
        setAudit($db, "TRANSACCIONES", $sessionid, "CMS", "Se cambió un ajuste de ".number_format($rowOldTx['amount'], $currencydata['decimals'], ',', '.')." ".$currencydata['symbol']." a ".number_format($amount, $currencydata['decimals'], ',', '.')." ".$currencydata['symbol']." al usuario ".$rowUser['usr']);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
