<?php
// app/api/transactions/verifyvalidation

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // Consultamos las transacciones que tengan validator y vencimiento menor a hora actual
    $sql = "SELECT * FROM transactions ".
    "       WHERE validator IS NOT NULL".
    "       AND validthru < NOW()";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
       
    $db->autocommit(FALSE);
      
    while($txdata = $rs->fetch_assoc()){
        // consultamos para saber el tipo
        $sql = "SELECT t.id AS txid, ".
        "       CASE ".
        "       WHEN t.dsc LIKE '%comis%' THEN 'Comisión' ".
        "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 'Ajuste' ".
        "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 'Intercambio' ".
        "       WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 'Depósito' ".
        "       WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 'Retiro' ".
        "       WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 'Transferencia' END AS type".
        "       FROM transactions t".
        "       WHERE t.txid = ".$txdata["id"];
        if (!$res = $db->query($sql)){
            $error = $db->error;
            $db->rollback();
            $db->close();
            badEnd("500", array("msg"=>$error));
        }
        
        $row = $res->fetch_assoc();
        
        if($row['type'] == "Transferencia"){
            
            //eliminar la transaccion
            $sql = "DELETE FROM transactions ".
            "       WHERE id = ".$txdata["id"].
            "       OR txid = ".$txdata["id"];
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error));
            }
        }else{
            
            // cancelamos el movimiento
            $sql = "UPDATE transactions SET ".
            "       validator = NULL, ".
            "       validthru = NULL, ".
            "       amountghost = amount + amountghost, ".
            "       amount = 0 ".
            "       WHERE txid = ".$txdata["id"];
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error));
            }
            
            //Colocamos la fecha de validacion del retiro
            $sql = "UPDATE withdrawals SET".
            "       rejected = NOW() ".
            "       WHERE transactionid = ".$txdata["id"];
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error));
            }
            
            //Colocamos la fecha de validacion del deposito
            $sql = "UPDATE deposits SET".
            "       rejected = NOW() ".
            "       WHERE transactionid = ".$txdata["id"];
            if (!$db->query($sql)){
                $error = $db->error;
                $db->rollback();
                $db->close();
                badEnd("500", array("msg"=>$error));
            }
        }
        
        $db->commit();
    }
    
    $db->close();
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
