<?php
// cms/api/users/update

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","pwd","newpwd");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $pwd = $_GET["pwd"];
    $newpwd = $_GET["newpwd"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    // Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    //Validamos que la clave actual sea igual a $pwd
    $sql = "SELECT id,usr, pwd FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $userdata = $rs->fetch_assoc();
    
    //Si la pwd no coincide retornamos error
    if($userdata["pwd"] != $pwd){
        badEnd("400", array("msg"=>determinateMsgFail(array(
            "esp"=>"La contraseña no coincide con la actual",
            "eng"=>"The new password is the same as the current"), $lang, "La contraseña no coincide con la actual")));
    }
    
    //Si la pwd es igual a la actualretornamos error
    if($userdata["pwd"] == $newpwd){
        badEnd("409", array("msg"=>determinateMsgFail(array(
            "esp"=>"La nueva contraseña es igual a la actual",
            "eng"=>"The new password is the same as the current"), $lang, "La nueva contraseña es igual a la actual")));
    }
    
    //Actualizamos la pwd del usuario por su ssid y su clave vieja
    $sql = "UPDATE users SET".
    "       pwd = '".$newpwd."'".
    "       WHERE sessionid = '".$sessionid."'".
    "       AND pwd = '".$pwd."'";
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>determinateMsgFail(array(
            "esp"=>"No se pudo modificar",
            "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
    
    
    $out->id = (int)$userdata["id"];
    
    //auditoria
    setAudit($db, "USUARIOS APP", $sessionid, "APP", "Se cambio la clave del usuario ".$userdata['usr']);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>

