WS_waitscreen = true;
 
window.onload = function(){
    
    // Call Entry
    getEntry(getParameterByName('sessionid'));
    document.getElementById('example-element-toggle2').checked = false;
    
    // Change Markers
    chargeMarkers();
    changePortfolio();
    changeOrders();
    
    // Go to preferences
    document.getElementById('preferences').addEventListener("click", function(){
        gotoPage('preferences','main',{ 'sessionid' : getParameterByName('sessionid') })
    });
    
    // Go to preferences
    document.getElementById('preferencesR').addEventListener("click", function(){
        gotoPage('preferences','main',{ 'sessionid' : getParameterByName('sessionid') })
    });
    markersList();
    markersEntry();
    markersChart();
    ordersList();
    transactionsList();
    
    document.getElementById('logouticon').addEventListener("click", function(){
        logout();
    });
    document.getElementById('logouticon2').addEventListener("click", function(){
        logout();
    });
    
    // Bar
    document.getElementById('togglebar').addEventListener("click", function(){
        var el = document.getElementById('addView2')
        //el.style.display = 'block';
        //el.style.display = (el.style.display == 'none') ? 'block' : 'none';
        //document.getElementById('datas').style.display = 'none'
        document.getElementById('addView2').style.display = 'block'
        
        setTimeout(function(){ 
            document.getElementById('example-element-toggle2').checked = !document.getElementById('example-element-toggle2').checked;
        }, 15);   
        
    });
    if (screen.width <= 700){
        changeDivs()
    }
}

function changeDivs(){
    // Cambiar el 2 por 4 y el 3 por 5
    var card2 = document.getElementsByClassName('card2')[0]
    var card4 = document.getElementsByClassName('card4')[0]
    var card3 = document.getElementsByClassName('card3')[0]
    var card5 = document.getElementsByClassName('card5')[0]
    
    var clon2 = card2.cloneNode(true)
    var clon4 = card4.cloneNode(true)
    var clon3 = card3.cloneNode(true)
    var clon5 = card5.cloneNode(true)
    
    card2.innerHTML = clon4.innerHTML
    card2.classList.remove('card2')
    card2.classList.add('card4')
    
    card4.innerHTML = clon2.innerHTML
    card4.classList.remove('card4')
    card4.classList.add('card2')
    
    card3.innerHTML = clon5.innerHTML
    card3.classList.remove('card3')
    card3.classList.add('card5')
    
    card5.innerHTML = clon3.innerHTML
    card5.classList.remove('card5')
    card5.classList.add('card3')
    
    var card6 = document.getElementsByClassName('card6')[0]
    var card7 = document.getElementsByClassName('card7')[0]
    
    card6.parentNode.parentNode.classList.remove('tableForm')
    card6.parentNode.parentNode.classList.remove('principalMiniCard')
    
    card6.parentNode.classList.remove('cellForm')
    card6.parentNode.classList.remove('cellForm61')
    
    card7.parentNode.classList.remove('cellForm')
    card7.parentNode.classList.remove('cellForm39')
    
    card6.classList.add('principalMiniCard')
    card7.classList.add('principalMiniCard')
    
    var segundo = document.getElementById('segundo')
    var clonsegundo = segundo.cloneNode(true)
    segundo.children[0].style.display = 'none';
    
    for (var i = 1; i < segundo.children.length; i++){
        console.log('hola')
        var clone = segundo.children[i].cloneNode(true)
        var clone0 = clone.children[0]
        var clone1 = clone.children[1]
        var clone2 = clone.children[2]
        var clone3 = clone.children[3]
        var div = '<div>'
        console.log(clone3)
        segundo.children[i].innerHTML = div + clone3.innerHTML + '</div>' + div + clone2.innerHTML + '</div>' + div + clone1.innerHTML + '</div>' + div + clone0.innerHTML + '</div>'
        segundo.children[i].children[0].classList.add('divOrder1')
        segundo.children[i].children[1].classList.add('divOrder2')
        segundo.children[i].children[2].classList.add('divOrder3')
        segundo.children[i].children[3].classList.add('divOrder4')
    }
    console.log(segundo)

}

function getEntry(sessionid){
    callWS("GET", "users/entry", { 'sessionid' : sessionid}, response);
        
    function response(status, rsp){
        switch(status){
            case 200:
                entrydata = (JSON.parse(rsp).entry)
                console.log(JSON.parse(rsp).entry)
                putName(entrydata);
                document.getElementsByClassName('pageCnt')[0].style.visibility="visible"
                // Window Load
                var waitScreen = document.getElementById("waitScreen");
                document.body.removeChild(waitScreen);
                WS_waitscreen = false;
                break;
            case 204:
                break;
            case 400:
                // Parametros incorrectos
                break;
            case 500:
                // Error
                break;
            default:
                break;
        }
    }    
}

function putName(entrydata){
    var name;
    if(entrydata.company){
        if(entrydata.company.name=="" || entrydata.company.name== null){
            name = entrydata.usr
        }else{
            name = entrydata.company.name
        }
    }
    else if(entrydata.person){
        if(entrydata.person.firstname=="" || entrydata.person.firstname==null){
            name = entrydata.usr
        }else{
            name = entrydata.person.firstname + ' '+ entrydata.person.firstlastname
        }
    }
    document.getElementById('name').innerHTML = name
    document.getElementById('name2').innerHTML = name
}

function chargeMarkers(){
    markers = [
        {
            'src' : './img/bitcoin.svg',
            'name' : 'BTC',
            'ult' : '9,547,4 USD',
            'day' : '1.40 %',
            'vol' : '29,960,435',
            'color' : 'green'
        },
        {
            'src' : './img/ether.svg',
            'name' : 'ETH',
            'ult' : '237,33 USD',
            'day' : '7.60 %',
            'vol' : '18,698,74',
            'color' : 'green'
        },
        {
            'src' : './img/bitcoin.svg',
            'name' : 'BTC',
            'ult' : '8,597,4 USD',
            'day' : '1.36 %',
            'vol' : '3,541,874',
            'color' : 'green'
        },
        {
            'src' : './img/ether.svg',
            'name' : 'ETH',
            'ult' : '0,024866 BTC',
            'day' : '1.25 %',
            'vol' : '2,412,698',
            'color' : 'green'
        },
        {
            'src' : './img/usdt.svg',
            'name' : 'USDt',
            'ult' : '1.00004 USD',
            'day' : '6.26 %',
            'vol' : '2,258,741',
            'color' : 'green'
        },
        {
            'src' : './img/Ripple.svg',
            'name' : 'XRP',
            'ult' : '0,20523 USD',
            'day' : '0.01 %',
            'vol' : '1,547,698',
            'color' : 'red'
        },
        {
            'src' : './img/EOS.svg',
            'name' : 'EOS',
            'ult' : '2,7086 USD',
            'day' : '3.76 %',
            'vol' : '1,324,698',
            'color' : 'green'
        },
        {
            'src' : './img/Litecoin.svg',
            'name' : 'LTC',
            'ult' : '47.192 USD',
            'day' : '5.72 %',
            'vol' : '1,136,987',
            'color' : 'green'
        },
        {
            'src' : './img/ether.svg',
            'name' : 'ETH',
            'ult' : '213,06 USD',
            'day' : '4.10 %',
            'vol' : '981,658',
            'color' : 'green'
        },
        {
            'src' : './img/bitcoin.svg',
            'name' : 'BSV',
            'ult' : '0,020767 BTC',
            'day' : '7.70 %',
            'vol' : '944,360',
            'color' : 'green'
        }
    ]
    
    listDraw(markers, 'markers')
}

function changePortfolio(){
    portfolio = [
        {
            'src' : './img/bitcoin.svg',
            'name' : 'BTC',
            'amount' : '7,236.00',
            'ptc' : '28%'
        },
        {
            'src' : './img/ether.svg',
            'name' : 'ETH',
            'amount' : '1.9876,31',
            'ptc' : '36%'
        },
        {
            'src' : '',
            'name' : 'Ves',
            'amount' : '40,659.58',
            'ptc' : '12%'
        },
        {
            'src' : './img/bitcoin.svg',
            'name' : 'BTC',
            'amount' : '7,236.00',
            'ptc' : '28%'
        },
        {
            'src' : './img/ether.svg',
            'name' : 'ETH',
            'amount' : '1.9876,31',
            'ptc' : '36%'
        },
        {
            'src' : '',
            'name' : 'Ves',
            'amount' : '40,659.58',
            'ptc' : '12%'
        }
    ]
    
    listDraw(portfolio, 'portfolio')
}

function changeOrders(){
    orders = [
        {
            'num' : '10',
            'cant' : '1.033',
            'total': '1.033',
            'price' : '7,236.00'
        },
        {
            'num' : '1',
            'cant' : '0.2500',
            'total': '0.2500',
            'price' : '7,236.00'
        },
        {
            'num' : '1',
            'cant' : '0.2000',
            'total': '4.443',
            'price' : '7,236.00'
        },
        {
            'num' : '2',
            'cant' : '0.0900',
            'total': '4.444',
            'price' : '7,236.00'
        },
        {
            'num' : '6',
            'cant' : '0.0782',
            'total': '4.985',
            'price' : '7,236.00'
        },
        {
            'num' : '1',
            'cant' : '0.0042',
            'total': '5.159',
            'price' : '7,236.00'
        },
        {
            'num' : '1',
            'cant' : '2.000',
            'total': '6.123',
            'price' : '7,236.00'
        },
        {
            'num' : '1',
            'cant' : '8.785',
            'total': '7.741',
            'price' : '7,236.00'
        },
        {
            'num' : '2',
            'cant' : '0.4587',
            'total': '8.985',
            'price' : '7,236.00'
        },
        {
            'num' : '5',
            'cant' : '7.243',
            'total': '9.0125',
            'price' : '7,236.00'
        },
    ]

    listDraw(orders, 'order')
    listDraw(orders, 'ordertwo')
}

function listDraw(rsp, changeName){
    var tbl;
    var node;
    if(changeName==='markers'){
        tbl = document.getElementsByClassName("card2")[0];
        var node = tbl.lastElementChild.cloneNode(true);
        tbl.children[3].innerHTML = "";
    }
    if (changeName === 'portfolio'){
        tbl = document.getElementsByClassName("card3")[0];
        var node = tbl.children[3].cloneNode(true);
        //tbl.children[3].innerHTML = "";
    }
    if (changeName === 'order'){
        tbl = document.getElementsByClassName("card6")[0];
        var node = tbl.children[2].children[0].children[1].cloneNode(true);
    }
    if (changeName === 'ordertwo'){
        tbl = document.getElementsByClassName("card6")[0];
        var node = tbl.children[2].children[1].children[1].cloneNode(true);
    }
    if(changeName==='exchange'){
        tbl = document.getElementsByClassName("card7")[0];
        var node = tbl.lastElementChild.cloneNode(true);
        tbl.children[3].innerHTML = "";
    }
    var tmp = null; tmp = node.cloneNode(true);
    //tbl.children[2].innerHTML = "";
    if(changeName==='markers'){
        tbl.removeChild(document.getElementById('tableMarks'))   
    }
    if (changeName === 'portfolio'){
        tbl.children[3].removeChild(document.getElementById('tablePortfolio'))   
    }
    if (changeName === 'order'){
        tbl.children[2].children[0].removeChild(document.getElementById('tableOrderOne'))   
    }
    if (changeName === 'ordertwo'){
        tbl.children[2].children[1].removeChild(document.getElementById('tableOrderTwo'))   
    }
    if(changeName==='exchange'){
        tbl.removeChild(document.getElementById('tableExchange'))   
    }
    if(!(rsp.length>0)){
        var ele = null;
        ele = tmp.cloneNode(true);
        ele.style.display = "none";
        tbl.appendChild(ele);
    }else{
        for(var i=0; i<rsp.length; i++){
            var ele = null;
            ele = tmp.cloneNode(true);
            ele.style.display = "table";
            if(rsp[i].name !== ""){
                if(changeName==='markers'){
                    ele.children[0].children[0].setAttribute("src",rsp[i].src);
                    ele.children[1].children[0].textContent = rsp[i].name
                    ele.children[2].children[0].textContent = rsp[i].ult
                    ele.children[3].children[0].textContent = rsp[i].day
                    if(rsp[i].color === 'green'){
                        ele.children[3].children[0].style.color="#85BB4F"
                    }else{
                        ele.children[3].children[0].style.color="#C04F5D"
                    }
                    ele.children[4].children[0].textContent = rsp[i].vol   
                    tbl.appendChild(ele);
                }
                if (changeName === 'portfolio'){
                    ele.children[0].children[0].children[0].setAttribute("src",rsp[i].src);
                    ele.children[0].children[1].children[0].textContent = rsp[i].name
                    ele.children[0].children[2].children[0].textContent = rsp[i].amount
                    ele.children[0].children[3].children[0].textContent = rsp[i].ptc
                    //tbl.insertBefore(ele,document.getElementById('totalPortfolio'))
                    tbl.children[3].appendChild(ele.children[0]);
                }
                if(changeName==='order'){
                    ele.children[0].children[0].textContent = rsp[i].num
                    ele.children[1].children[0].textContent = rsp[i].cant
                    ele.children[2].children[0].textContent = rsp[i].total
                    ele.children[3].children[0].textContent = rsp[i].price   
                    tbl.children[2].children[0].appendChild(ele);
                }
                if(changeName==='ordertwo'){
                    ele.children[3].children[0].textContent = rsp[i].num
                    ele.children[2].children[0].textContent = rsp[i].cant
                    ele.children[1].children[0].textContent = rsp[i].total
                    ele.children[0].children[0].textContent = rsp[i].price
                    tbl.children[2].children[1].appendChild(ele);
                }
                if(changeName==='exchange'){
                    if (rsp[i].color === 'red'){
                        ele.children[0].children[0].innerHTML = '<i class="fas fa-caret-down" style="color: #C04F5D"></i>'
                    }
                    else if (rsp[i].color === 'green'){
                        ele.children[0].children[0].innerHTML = '<i class="fas fa-caret-up" style="color: #85BB4F"></i>'
                    }
                    else if (rsp[i].color === 'none'){
                        ele.children[0].children[0].innerHTML = '<i class="fas fa-caret-up" style="color: #2F3236"></i>'
                    }
                    ele.children[1].children[0].textContent = rsp[i].date
                    ele.children[2].children[0].textContent = rsp[i].total
                    ele.children[3].children[0].textContent = rsp[i].price
                    tbl.appendChild(ele);
                }

            }
            
        }
    }
}

// Service markers/list
function markersList(){
    
    var sessionid = getParameterByName('sessionid')
    var order = 2 // Puede ser 1, 2, 3 o 4.
    var time;
    var numofrec = 10; // Puede ser cualquiera
    
    var req ={
        'sessionid': sessionid,
        'order' : order,
        'numofrec' : numofrec
    }
    
    callWS('GET', 'markers/list', req, response);

    function response(status, rsp){
        //console.log(JSON.parse(rsp));
        //console.log(status)
        switch(status){
            case 200:
                break;
            case 400:
                break;
            case 401:
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

// Service markers/entry
function markersEntry(){
    
    var sessionid = getParameterByName('sessionid')
    var id = 1 // Valor que se consulta. Varia.
    var time;
    
    var req ={
        'sessionid': sessionid,
        'id' : id,
    }
    
    callWS('GET', 'markers/entry', req, response);

    function response(status, rsp){
        //console.log(JSON.parse(rsp));
        //console.log(status)
        switch(status){
            case 200:
                break;
            case 400:
                break;
            case 401:
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

// Service markers/chart
function markersChart(){
    
    var sessionid = getParameterByName('sessionid')
    var id = 1 // Valor que se consulta. Varia.
    var time;
    
    var req ={
        'sessionid': sessionid,
        'id' : id
    }
    
    callWS('GET', 'markers/chart', req, response);

    function response(status, rsp){
        //console.log(JSON.parse(rsp));
        //console.log(status)
        switch(status){
            case 200:
                break;
            case 400:
                break;
            case 401:
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

// Service orders/list
function ordersList(){
    
    var sessionid = getParameterByName('sessionid')
    var parid = 1 // Valor que se opera. Varia.
    var order; // ??
    var numofrec = 5 // Numero de registros que devuelve
    
    var req ={
        'sessionid': sessionid,
        'parid' : parid,
        'order' : order,
        'numofrec' : numofrec
    }
    
    callWS('GET', 'orders/list', req, response);

    function response(status, rsp){
        console.log(JSON.parse(rsp));
        console.log(status)
        switch(status){
            case 200:
                break;
            case 400:
                break;
            case 401:
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

// Service transactions/list
function transactionsList(){
    
    var sessionid = getParameterByName('sessionid')
    var parid = 1 // Valor que se opera. Varia.
    var order; // ??
    var numofrec = 10 // Numero de registros que devuelve
    var offset = 0; // Registro desde el que se mostrará la información
    
    var req ={
        'sessionid': sessionid,
        'parid' : parid,
        'order' : order,
        'numofrec' : numofrec,
        'offset' : offset
    }
    
    callWS('GET', 'transactions/list', req, response);

    function response(status, rsp){
        console.log(JSON.parse(rsp));
        console.log(status)
        switch(status){
            case 200:
                changeExchange(JSON.parse(rsp));
                break;
            case 400:
                break;
            case 401:
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

function changeExchange(data){
    
    var exchange = [];
    
    var color = new Array(data.numofrecords);
    var date = new Array(data.numofrecords);
    var total = new Array(data.numofrecords);
    var price = new Array(data.numofrecords);
    
    //var obj = {}
    for (var i = 0; i < data.numofrecords ; i++ ){
        if (data.records[i].side.id == 0){
            color[i] = 'none'
        }
        else if (data.records[i].side.id == 1){
            color[i] = 'green'
        }
        else if (data.records[i].side.id == 2){
            color[i] = 'red'
        }
        
        date[i] = data.records[i].date.formatted
        total[i] = data.records[i].qty.formatted 
        price[i] = data.records[i].price.formatted
        
        exchange.push({
            'color' : color[i],
            'date' : date[i].slice(0, -3),
            'total' : total[i],
            'price' : price[i]
        })
    }
    
    //obj.data = data;
    //console.log(obj.data)
    listDraw(exchange, 'exchange')
}

function logout(){
    var sessionid = getParameterByName('sessionid')
    var req ={
        'sessionid': sessionid,
    }
    
    callWS('GET', 'login/logout', req, response);

    function response(status, rsp){
        console.log(JSON.parse(rsp));
        console.log(status)
        switch(status){
            case 200:
                gotoPage('login','main','')
                break;
            case 400:
                break;
            case 401:
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}