<?php
// app/api/accounts/update

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","paymentmethodid","currencyid","details1","status");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out= new stdClass;
    $sessionid = $_POST["sessionid"];
    $id = $_POST["id"];
    $paymentmethodid = $_POST["paymentmethodid"];
    $currencyid = $_POST["currencyid"];
    $details1 = $_POST["details1"];
    $status = $_POST["status"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    $sql = "SELECT id, usr FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    //Obtenemos el id del usuario
    $userid = $row["id"];
    
    //Validamos el si el usuario puede crear cuentas
    isLevelValid($db, $userid);
            
    //Si el id es 0 se crea, si no se actualiza
    if($id == 0){
        //Insertamos la nueva cuenta
        $sql = "INSERT INTO accounts".
        "       (".
        "       paymentmethodid, ".
        "       userid, ".
        "       currencyid, ".
        "       details1, ".
        "       ".validateInsertField("details2","details2").
        "       ".validateInsertField("details3","details3").
        "       ".validateInsertField("details4","details4").
        "       status".
        "       )".
        "       VALUES(".
        "       ".$paymentmethodid.", ".
        "       ".$userid.", ".
        "       ".$currencyid.", ".
        "       '".$details1."', ".
        "       ".validateInsertValue("details2","string")." ".
        "       ".validateInsertValue("details3","string")." ".
        "       ".validateInsertValue("details4","string")." ".
        "       ".$status.
        "       )";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "F. DE PAGO", $sessionid, "APP", "Se incluyo la forma de pago ".$out->id);
        
    }else{
        
        //Consultamos para validar que el registro exista
        $sql = "SELECT id, userid FROM accounts WHERE id = ".$id.
        "       AND userid = ".$userid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["id"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        $sql = "UPDATE accounts SET".
        "       paymentmethodid = ".$paymentmethodid.", ".
        "       currencyid = ".$currencyid.", ".
        "       details1 = '".$details1."', ".
        "       details2 = '".($_POST["details2"] == "" ? null : $_POST["details2"])."', ".
        "       details3 = '".($_POST["details3"] == "" ? null : $_POST["details3"])."', ".
        "       details4 = '".($_POST["details4"] == "" ? null : $_POST["details4"])."', ".
        "       status = ".$status.
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para validar que el campo fue enviado, 
    *   y armar los campos a insertar
    *   Se reciben dos parametros:
    *   $param = Parametro a validar
    *   $field = nombre del campo
    */
    function validateInsertField($param, $field){
        $str = "";
        
        if(isset($_POST[$param]) && $_POST[$param] != ""){
            $str = $str." ".$field.",";
        }
        
        return $str;
    }
    
    /*  Funcion para validar que el valor fue enviado, 
    *   y armar el string para insertarlo
    *   Se recibe un parametro:
    *   $param = Parametro a validar
    *   $type = Tipo de valor
    */
    function validateInsertValue($param,$type){
        $str = "";
        
        if(isset($_POST[$param]) && $_POST[$param] != ""){
            if($type == "string"){
                $str = $str." '".$_POST[$param]."',";
            }else if($type == "number"){
                $str = $str." ".$_POST[$param].",";
            }else{
                $str = $str." '".$_POST[$param]."',";
            }
        }
        
        return $str;
    }
    
?>
