WS_waitscreen = true;

window.onload = function(){
    
    // Window Load
    document.getElementsByClassName('pageCnt')[0].style.visibility="visible"
    var waitScreen = document.getElementById("waitScreen");
    document.body.removeChild(waitScreen);
    WS_waitscreen = false;
    
    // Go to Login Page
    document.getElementById('send').addEventListener("click", function(){
        noError('password','epassword')
        document.getElementById('epass').style.bottom = '10px';
        noError('confirmPassword','econfirm')
        document.getElementById('econf').style.bottom = '10px';
        recover()
        //gotoPage('login','main','')
    }); 
    
    // Show or hide icon eye password
    document.getElementById('iconEye').addEventListener("click", function(){
        show('iconEye','password')
    }); 
    
    // Show or hide icon eye password confirm
    document.getElementById('iconEyeConfirm').addEventListener("click", function(){
        show('iconEyeConfirm','confirmPassword')
    }); 
    
    // Remove red errors 
    document.getElementsByTagName('body')[0].addEventListener("click", function(){
        if (document.getElementById('password').value !== '' && isOkPass(document.getElementById('password').value).result){
            noError('password','epassword')
            document.getElementById('epass').style.bottom = '10px';
        }
        if (document.getElementById('confirmPassword').value !== '' 
            && document.getElementById('econfirm').innerHTML !== 'Las contraseñas no coinciden.' && isOkPass(document.getElementById('confirmPassword').value).result){
            noError('confirmPassword','econfirm')
            document.getElementById('econf').style.bottom = '10px';
        }
    }); 
    
    // Focus
    document.getElementById('password').addEventListener('keydown', (event) => focusE(event, 'confirmPassword'));
    document.getElementById('confirmPassword').addEventListener('keydown', (event) => focusE(event, 'next-button'));
    
}

// Show or Hide Password
function show(iconId,passwordId) {
    var icon = document.getElementById(iconId);
    var passwordInput = document.getElementById(passwordId);
    if (passwordInput.getAttribute('type') == "password") {
        icon.removeAttribute("class");
        icon.setAttribute("class","fas fa-eye");
        passwordInput.removeAttribute("type");
        passwordInput.setAttribute("type","text");
    } else {
        passwordInput.removeAttribute("type");
        passwordInput.setAttribute('type','password');
        icon.removeAttribute("class");
        icon.setAttribute("class","fas fa-eye-slash");
    };
}


function recover(){
    var pwd = document.getElementById('password');
    var cnf = document.getElementById('confirmPassword');
    if ( pwd.value === "" ){
        error('password','epassword','Introduzca una contraseña.');
            document.getElementById('epass').style.bottom = '34px';   
    }
    if ( cnf.value === "" ){
        error('confirmPassword','econfirm','Introduzca una contraseña.');
        document.getElementById('econf').style.bottom = '34px';   
    }
    if ( pwd.value == cnf.value && pwd.value !== ''){
        
        if(isOkPass(pwd.value).result){
         
             var req = {
                "hash": getParameterByName('hash'),
                "pwd": MD5(pwd.value)
            }
            document.getElementById('waitScreen').style.display ="table";
            callWS("GET", "login/recover", req, response);
            function response(status, rsp){
                //console.log(JSON.parse(rsp));
                switch(status){
                    case 200:
                        document.getElementById('econfirm').innerHTML = 'Se ha cambiado exitosamente.';
                        document.getElementById('econf').style.bottom = '34px';   
                        setTimeout(function(){ 
                            gotoPage('login','main',''); 
                        }, 5000);
                        break;
                    case 400:
                        //console.log('Error en la llamada del servicio.');
                        document.getElementById('econfirm').innerHTML = 'Error.';
                        break;
                    case 401:
                        error('confirmPassword','econfirm','Enlace inválido.');
                        document.getElementById('econf').style.bottom = '34px';   
                        break;
                    case 409:
                        break;
                    case 500:
                        document.getElementById('econfirm').innerHTML = 'Error.';
                        break;
                    default:
                        break;
                }
                document.getElementById('waitScreen').style.display ="none";
            }    
            
        }else{
            error('password','epassword','');
            error('confirmPassword','econfirm','La contraseña debe tener una longitud mínima  de 8 caracteres con una letra mayúscula, una letra minúscula, un número y un símbolo.');
            document.getElementById('econf').style.bottom = '65px';
            
            if (screen.width<= 388){
                document.getElementById('econf').style.bottom = '82px'
            }
        }
        
        
    }else if (cnf.value !== '' && pwd.value !== cnf.value) {
        error('confirmPassword','econfirm','Las contraseñas no coinciden.');
            document.getElementById('econf').style.bottom = '34px';   
    }
}

function isOkPass(p){
    var anUpperCase = /[A-Z]/;
    var aLowerCase = /[a-z]/; 
    var aNumber = /[0-9]/;
    var aSpecial = /[!|@|#|$|%|^|&|*|(|)|-|_|.|=|+|\/]/;
    var obj = {};
    obj.result = true;

    if(p.length < 8){
        obj.result=false;
        obj.error="Not long enough!"
        return obj;
    }

    var numUpper = 0;
    var numLower = 0;
    var numNums = 0;
    var numSpecials = 0;
    for(var i=0; i<p.length; i++){
        if(anUpperCase.test(p[i]))
            numUpper++;
        else if(aLowerCase.test(p[i]))
            numLower++;
        else if(aNumber.test(p[i]))
            numNums++;
        else if(aSpecial.test(p[i]))
            numSpecials++;
    }

    if(numUpper < 1 || numLower < 1 || numNums < 1 || numSpecials <1){
        obj.result=false;
        obj.error="Wrong Format!";
        return obj;
    }
    return obj;
}
