WS_waitscreen = true;

window.onload = function(){
    
    document.getElementsByClassName('pageCnt')[0].style.visibility="visible"
    // Window Load
    var waitScreen = document.getElementById("waitScreen");
    document.body.removeChild(waitScreen);
    WS_waitscreen = false;
    
    // Go to Register Data Page
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage('register','register-data',{ 'usr': document.getElementById('usr').textContent })
    }); 
    
    // Go to Register Confirm Page
    document.getElementById('next-button').addEventListener("click", function(){
        verif();
    }); 
    
    // Remove red errors 
    document.getElementsByTagName('body')[0].addEventListener("click", function(){
        if (document.getElementById('number').value !== '' ){
            noError('number','ehash')
        }
    }); 
    
    // Resend verification code
    document.getElementById('resend').addEventListener("click", function(){
        resend();
    }); 
    
    // Enter
    document.getElementById('number').addEventListener('keydown', (event) => focusE(event, 'next-button'));
    
    //Mostrar HTML cargado
    esconderHTML(false);
}

// Service users/activate
function verif(){
    var usr = document.getElementById('usr');
    var hash = document.getElementById('number');
    if ( hash.value === "" ){
        error('number','ehash','Introduzca el número de verificación.');
    } else{
        var req = {
            "usr": usr.textContent,
            "hash": hash.value
        }
        callWS("GET", "users/activate", req, response);
    
        function response(status, rsp){
            //console.log(JSON.parse(rsp));
            switch(status){
                case 200:
                    gotoPage('register','register-confirm','');
                    break;
                case 204:
                    document.getElementById('ehash').innerHTML = 'No se encuentra el registro.';
                    break;
                case 400:
                    document.getElementById('ehash').innerHTML = 'Error.';
                    break;
                case 401:
                    error('number','ehash','La combinación del email y el número de verificación es incorrecta.');
                    break;
                case 403:
                    document.getElementById('ehash').innerHTML = 'Usted no posee privilegios.';
                    break;
                case 500:
                    document.getElementById('ehash').innerHTML = 'Error.';
                    break;
                default:
                    break;
            }
        }    
    } 
}

function resend(){
    var usr = document.getElementById('usr');
    var req = {
        "usr": usr.textContent
    }
    callWS("GET", "users/insert", req, response);
    document.getElementById('waitScreen').style.display ="table";
    function response(status, rsp){
            switch(status){
                case 200:
                    document.getElementById('ehash').innerHTML = 'Se ha enviado un nuevo número de verificación.';
                    break;
                case 400:
                    document.getElementById('ehash').innerHTML = 'Error.';
                    break;
                case 401:
                    error('number','ehash','Hash Inválido.');
                    break;
                case 409:
                    document.getElementById('ehash').innerHTML = 'El email se encuentra registrado.';
                    break;
                case 500:
                    document.getElementById('ehash').innerHTML = 'Error.';
                    break;
                default:
                    break;
            }
            document.getElementById('waitScreen').style.display ="none";
        }   
    
}