window.onload = function(){
    var sessionId = sessionStorage.getItem("sessionId");
    initApp();
    LoadPaymentMethods('', 0, 0, 10, sessionId);
    
    document.getElementById("closeModal").addEventListener("click", function(){
        document.getElementById("dataDelete").innerHTML="";
        var modal = document.getElementById("myModal");
         modal.style.display = "none";
    });
    
    document.getElementById("closeSectionAdd").addEventListener("click", function(){
        document.getElementById("StatusAdd").value = "";
        document.getElementById("payMethodsAdd").value= "";
        document.getElementById("detail1").value = "";
        document.getElementById("detail3").value = "";
        document.getElementById("CountryAdd").value = " ";
        document.getElementById("detail2").value = "";
        document.getElementById("detail4").value = "";
        var curren = document.getElementById("CurrencieAdd")
        curren.value = "";
        document.getElementById("selectGruop").innerHTML= "";
        var sectionAddCurrencie = document.getElementById("addSection");
        sectionAddCurrencie.style.display = "none";
        for(let i=0; i<curren.options.length; i++){
            curren.options[i].disabled= false;
        }
    });
    
    document.getElementById("arrowOrderBy").addEventListener("mouseover",function(){
        var iconContainer = this.parentElement;
        var node = iconContainer.cloneNode(true);
        var content =iconContainer.parentElement;
        content.removeChild(iconContainer);
        setTimeout(function() {
            content.appendChild(node);    
        }, 2000);
        
    });
    
    document.getElementById("arrowStatus").addEventListener("mouseover",function(){
        var iconContainer = this.parentElement;
        var node = iconContainer.cloneNode(true);
        var content =iconContainer.parentElement;
        content.removeChild(iconContainer);
        setTimeout(function() {
            content.appendChild(node);    
        }, 2000);
        
    });
    
    document.getElementById("arrowCountry").addEventListener("mouseover",function(){
        var iconContainer = this.parentElement;
        var node = iconContainer.cloneNode(true);
        var content =iconContainer.parentElement;
        content.removeChild(iconContainer);
        setTimeout(function() {
            content.appendChild(node);    
        }, 2000);
        
    });
    
    document.getElementById("arrowCurrencie").addEventListener("mouseover",function(){
        var iconContainer = this.parentElement;
        var node = iconContainer.cloneNode(true);
        var content =iconContainer.parentElement;
        content.removeChild(iconContainer);
        setTimeout(function() {
            content.appendChild(node);    
        }, 2000);
        
    });
    
    var selectOrderBy = document.getElementById("orderBy");
    selectOrderBy.addEventListener("change", function(){
        var nodeNoDelete = document.getElementById("noCurrencieDefine");
        if (nodeNoDelete ){
            var nodeClone = nodeNoDelete.cloneNode(true);    
        }
        //var table = document.getElementById("bodyTableCurrencies").innerHTML = "";
        let order = 0;
        if(selectOrderBy.value == " "){
            order = 0;
        } else{
            order = selectOrderBy.value;
        }
         var pSel = document.getElementsByClassName("pSelect")[0];
         var offset = 0;
        if(pSel){
            //Se repinta el listado desde el offset seleccionado
            offset = (pSel.innerHTML - 1) * 10;
        } 
        LoadPaymentMethods('', offset, order, 10, sessionId);
        //table.appendChild(nodeClone);
    });
    
    //Asignar evento barra de busqueda
    document.getElementById("search").addEventListener("change",function(){
        let order = 0;
        if(document.getElementById("orderBy").value == " "){
            order = 0;
        } else{
            order = document.getElementById("orderBy").value;
        }
        var pSel = document.getElementsByClassName("pSelect")[0];
        var offset = 0;
        if(pSel){
            //Se repinta el listado desde el offset seleccionado
            offset = (pSel.innerHTML - 1) * 10;
        } 
        LoadPaymentMethods(this.value, offset, order, 10, sessionId);
    });
    document.getElementById("search").addEventListener("keyup",function(e){
        let order = 0;
        if(document.getElementById("orderBy").value == " "){
            order = 0;
        } else{
            order = document.getElementById("orderBy").value;
        }
        var pSel = document.getElementsByClassName("pSelect")[0];
        var offset = 0;
        if(pSel){
            //Se repinta el listado desde el offset seleccionado
            offset = (pSel.innerHTML - 1) * 10;
        } 
        if(e.keyCode==13)LoadPaymentMethods(this.value, offset, order, 10, sessionId);
    });
    
    document.getElementById("iconAddCurrencie").addEventListener("click", function(){
        if(document.getElementById("iconAddCurrencie").getAttribute("data-privilegecreate") == "0"){
            var msg = document.getElementById("messageApi");
            msg.innerHTML="No posee privilegios para crear formas de pago";
            msg.style.display = "flex";
            headerTableCurrencies.style.border= "1px solid #D0021B";
            setTimeout(function() {
                msg.style.display="none";
                headerTableCurrencies.style.border= "1px solid #D5DCE5";
            }, 3000);
        } else {
            var sectionAddCurrencie = document.getElementById("addSection");
            if(sectionAddCurrencie.style.display != 'none'){
                document.getElementById("closeSectionAdd").dispatchEvent(new Event("click"));
            }
            var selectGruop = document.getElementById("selectGruop");
            var p = document.createElement("p");
            p.innerHTML = "Moneda";
            p.setAttribute("id","divCurrencieAddSelectGruop");
            p.style.marginTop = "8px";
            p.style.fontSize = "88%";
            p.style.fontWeight = "300";
            selectGruop.appendChild(p);
            document.getElementById("StatusAdd").value = "1";
            sectionAddCurrencie.getElementsByClassName("titleAdd")[0].innerHTML = "Agregar Forma de Pago";
            sectionAddCurrencie.getElementsByClassName("titleAdd")[0].dataset.id = 0;
            sectionAddCurrencie.style.display = "flex";
            
        }
    });
    
    
    document.getElementById("CurrencieAdd").addEventListener("change", function(){
        var curren = document.getElementById("CurrencieAdd");
        var slectGroup = document.getElementById("selectGruop");
        var p = document.getElementById("divCurrencieAddSelectGruop");
        if(p){
            slectGroup.removeChild(p);
        }
        var span= document.createElement("span");
        span.setAttribute("id",curren.value);
        var textOp = curren[curren.selectedIndex].text.split('(')[1];
        var spanRemove = document.createElement("span");
        spanRemove.innerHTML = "&times";
        spanRemove.style.fontWeight="normal";
        span.innerHTML= textOp.split(')')[0];
        span.appendChild(spanRemove);
        const idParent = curren.value;
        spanRemove.addEventListener("click", function(){
            RemoveSpan("idCurrencie"+idParent);
        });
        spanRemove.style.cursor="pointer";
        slectGroup.appendChild(span);
        var idx = curren.selectedIndex
        curren.options[idx].disabled = true;
        console.log("option disabled", curren.options[idx], "disabled", curren.options[idx].disabled);
    });
    
    document.getElementById("buttonAceptAdd").addEventListener("click", function(){
        AceptSectionUpdate();
    });
    
    //Asignación de los botones del delete
    document.getElementById("buttonCancelModal").addEventListener("click", function(){
        document.getElementById("dataDelete").innerHTML="";
        var modal = document.getElementById("myModal");
         modal.style.display = "none";
    });
    document.getElementById("buttonAceptModal").addEventListener("click", function(){
        DeleteRow(this.getAttribute("eleid"));
        var dataDelete = document.getElementById("dataDelete");
        dataDelete.innerHTML="";
        var modal = document.getElementById("myModal");
         modal.style.display = "none";
    });
    
    LoadServicesSectionAdd();
}

function LoadPaymentMethods(filter, offset, order, numofrec, sessionid){
    var par = {};
    //Para no acomodar en todos los lugares dónde pusiste la función leo si es vacío busco en el valor del search
    //Lo correcto sería pasar el document.getElementById("search").value por el parametro.
        if(filter === "")filter = document.getElementById("search").value;
        par.filter = filter;
        par.order = order
        par.offset = offset;
        par.numofrec = numofrec;
        par.sessionid =sessionid;
        callWS("GET", "paymentmethods/list", par, respuesta);
        function respuesta(status, rsp){
            let currencies = JSON.parse(rsp);
            var msg = document.getElementById("messageApi")
            switch(status){
                case 200:
                    
                    if( ! (currencies.privileges.create == false || currencies.privileges.create == "false")){
                        document.getElementById("iconAddCurrencie").dataset.privilegeCreate = "1";
                    } else {
                        document.getElementById("iconAddCurrencie").dataset.privilegeCreate = "0";
                    }
                    
                    if(currencies.privileges.read == false || currencies.privileges.read == "false"){
                        document.getElementById("noCurrencieDefine").style.display= "flex";
                        document.getElementById("msgInTable").innerHTML="No Posee privilegios de lectura";
                    } else {
                        if (currencies.numofrecords === 0){
                            /*Blanquear tabla*/
                            var nodeNoDelete = document.getElementById("noCurrencieDefine");
                            if (nodeNoDelete ){
                                var nodeClone = nodeNoDelete.cloneNode(true);   
                                nodeClone.style.display="none";
                            }
                            var table = document.getElementById("bodyTableCurrencies");
                            table.innerHTML = "";
                            if(nodeClone!==undefined && nodeClone!==null)table.appendChild(nodeClone);
                            /**-hasta aqui-**/
                            document.getElementById("noCurrencieDefine").style.display= "flex";
                            document.getElementById("msgInTable").innerHTML="No Posee Monedas definidas";
                            document.getElementById("paginator").style.display= "none";
                        } else {
                            
                            if(currencies.numofrecords <= 10){
                                document.getElementById("paginator").style.display= "none";    
                            } else {
                                drawPags(currencies.numofrecords, "numbersPaginator");
                            }
                            /*Blanquear tabla*/
                            var nodeNoDelete = document.getElementById("noCurrencieDefine");
                            if (nodeNoDelete ){
                                var nodeClone = nodeNoDelete.cloneNode(true);   
                                nodeClone.style.display="none";
                            }
                            var table = document.getElementById("bodyTableCurrencies");
                            table.innerHTML = "";
                            if(nodeClone!==undefined && nodeClone!==null)table.appendChild(nodeClone);
                            /**-hasta aqui-**/
                            //Pintar registros
                            paintRowsPayMethods(currencies);
                        }
                    }
                    break;
                case 400:
                    msg.innerHTML=currencies.msg;
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                case 401:
                    msg.innerHTML="Sesi\u00F3n expirada o inv\u00E1lida, vuelva a iniciar sesi\u00F3n";
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        myLogout()
                        msg.style.display="none";
                    }, 3000);
                    break;
                case 500:
                    msg.innerHTML=currencies.msg;
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                default:
                   msg.innerHTML=currencies.msg;
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
            }
        }
}

function drawPags(numofrecords, tbl){
    var pages = Math.ceil( numofrecords / 10 );
    var numbersPaginator = document.getElementById(tbl);
    var lastPag = 0;
    if(numbersPaginator.getElementsByClassName("pSelect").length>0){
        lastPag = numbersPaginator.getElementsByClassName("pSelect")[0].getAttribute("data-page");
    }
    numbersPaginator.innerHTML = "";
    for(let k=0; k<pages; k++){
        var p = document.createElement("div");
        p.classList.add("pages");
        p.innerHTML = k+1;
        p.dataset.page= k+1;
        if(lastPag==0 && k==0)p.classList.add("pSelect");//Se selecciona la página 1
        else if(lastPag!==0 && (lastPag-1)==k)p.classList.add("pSelect");
        
        p.addEventListener("click", function(){
            //Se desmarca la página anterior
            var pSel = document.getElementsByClassName("pSelect");
            if(pSel.length>0)pSel[0].classList.remove("pSelect");
            
            //Se actualiza la página seleccionada
            this.classList.add("pSelect");
            
            //Se repinta el listado desde el offset seleccionado
            var offset = (this.innerHTML-1)*10;
            var order = document.getElementById("orderBy").value;
            var filter = document.getElementById("search").value;
            if(order == " " || order == ""){
                order = 0;
            }
            LoadPaymentMethods(filter, offset, order, 10, sessionStorage.getItem("sessionId"));
        });
        p.style.cursor="pointer";
        numbersPaginator.appendChild(p);
                                
    }
    //Asignación de eventos validar que sólo se haga una vez
    if(numbersPaginator.getAttribute("arrowsEvent")=="false"){
        var leftArrow = numbersPaginator.previousElementSibling;
        var rightArrow = numbersPaginator.nextElementSibling;
        //Evento flecha izquierda
        leftArrow.addEventListener("click",function(){
            var pSel = document.getElementsByClassName("pSelect");
            if(pSel.length>0){
                //Si el elemento anterior al seleccionado es una pagina
                if(pSel[0].previousElementSibling.classList.contains("pages")){
                    var last = pSel[0];
                    pSel[0].previousElementSibling.classList.add("pSelect");
                    last.classList.remove("pSelect");
                    
                    //Se repinta el listado desde el offset seleccionado
                    var offset = (pSel[0].innerHTML-1)*10;
                    var order = document.getElementById("orderBy").value;
                    var filter = document.getElementById("search").value;
                    if(order == " "){
                        order = 0;
                    }
                    LoadPaymentMethods(filter, offset, order, 10, sessionStorage.getItem("sessionId"));
                }
            }
        });
        
        //Evento flecha derecha
        rightArrow.addEventListener("click",function(){
            var pSel = document.getElementsByClassName("pSelect");
            if(pSel.length>0){
                //Si el elemento anterior al seleccionado es una pagina
                if(pSel[0].nextElementSibling.classList.contains("pages")){
                    pSel[0].nextElementSibling.classList.add("pSelect");
                    pSel[0].classList.remove("pSelect");
                    
                    //Se repinta el listado desde el offset seleccionado
                    var offset = (pSel[0].innerHTML-1)*10;
                    var order = document.getElementById("orderBy").value;
                    var filter = document.getElementById("search").value;
                    if(order == " "){
                        order = 0;
                    } 
                    LoadPaymentMethods(filter, offset, order, 10, sessionStorage.getItem("sessionId"));
                }
            }
        });
        
        numbersPaginator.setAttribute("arrowsEvent",true);
    }
    
}

function EditRow(id){
    var parent = document.getElementById(id);
    let i = id.substr(id.length - 1);
    
    var sessionId = sessionStorage.getItem("sessionId");
    req = {};
    req.id = parent.dataset.id; 
    req.sessionid = sessionId;
    callWS("GET", "paymentmethods/entry", req, respuesta);
        function respuesta(status, rsp){
            let respuesta = JSON.parse(rsp);
            var msg = document.getElementById("messageApi")
            switch(status){
                case 200:
                    var sectionAddCurrencie = document.getElementById("addSection");
                    if(sectionAddCurrencie.style.display != 'none'){
                        document.getElementById("closeSectionAdd").dispatchEvent(new Event("click"));
                    }
                    sectionAddCurrencie.getElementsByClassName("titleAdd")[0].innerHTML = "Editar Forma de Pago";
                    sectionAddCurrencie.getElementsByClassName("titleAdd")[0].dataset.id = req.id;
                    document.getElementById("StatusAdd").value = respuesta.entry.status.id;
                    document.getElementById("payMethodsAdd").value= respuesta.entry.dsc;
                    document.getElementById("detail1").value = respuesta.entry.details1;
                    document.getElementById("detail3").value = respuesta.entry.details3;
                    document.getElementById("CountryAdd").value = respuesta.entry.country.id;
                    document.getElementById("detail2").value = respuesta.entry.details2;
                    document.getElementById("detail4").value = respuesta.entry.details4;
                    for(let i=0; i<respuesta.entry.currencies.length; i++){
                        var slectGroup = document.getElementById("selectGruop");
                        var span= document.createElement("span");
                        span.setAttribute("id",respuesta.entry.currencies[i].id);
                        var textOp = respuesta.entry.currencies[i].symbol;
                        var spanRemove = document.createElement("span");
                        spanRemove.innerHTML = "&times";
                        spanRemove.style.fontWeight="normal";
                        span.innerHTML= textOp;
                        span.appendChild(spanRemove);
                        const idParent = respuesta.entry.currencies[i].id;
                        spanRemove.addEventListener("click", function(){
                            RemoveSpan("idCurrencie"+idParent);
                        });
                        spanRemove.style.cursor="pointer";
                        slectGroup.appendChild(span);
                    }
                    document.getElementById("selectGruop").value = respuesta.entry.currencies[0].id;
                    sectionAddCurrencie.style.display = "flex";
                    break;
                    
                case 400:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML=respuesta.msg;
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.innerHTML="";
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                    
                case 409:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML="Campo duplicado";
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.innerHTML="";
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                        myLogout();
                    }, 3000);
                    break;
                    
                case 500:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML="Error al actualizar monedas, intente nuevamente.";
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.innerHTML="";
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                default:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML= respuesta.msg;
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.innerHTML= "";    
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
            }
        }
    
}

function DeleteRow(id){
    var sessionId = sessionStorage.getItem("sessionId");
    var li = document.querySelectorAll('[data-id="'+ id+ '"]');
    var liIdx = li[0].id;
    console.log("liIdx", liIdx)
    rowError = document.getElementById(liIdx);
    console.log("rowError ", rowError);
    let i = liIdx.substr(liIdx.length - 1);
    req = {};
    req.id = id; 
    req.sessionid = sessionId;
    callWS("GET", "paymentmethods/delete", req, respuesta);
        function respuesta(status, rsp){
            if (rsp){
                let respuesta = JSON.parse(rsp);    
            }
            var msg = document.getElementById("messageApi")
            switch(status){
                case 200:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML= "Forma de pago eliminada correctamente"
                    msg.classList.add("msgSucessTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgSucessTable");
                        msg.style.display="none";
                    }, 3000);
                    var nodeNoDelete = document.getElementById("noCurrencieDefine");
                    if (nodeNoDelete ){
                        var nodeClone = nodeNoDelete.cloneNode(true);    
                    }
                    var table = document.getElementById("bodyTableCurrencies");
                    table.innerHTML = "";
                    var pageInPaginator = document.getElementsByClassName("pSelect")[0];
                    let offSetDelete = 0;
                    if(pageInPaginator){
                        pageInPaginator = pageInPaginator.innerHTML;
                        offSetDelete = (pageInPaginator - 1) * 10;
                    }
                    LoadPaymentMethods('', offSetDelete, document.getElementById("orderBy").value, 10, req.sessionid);
                    table.appendChild(nodeClone);
                    break;
                
                case 304:
                    var rowErrorColor = 'white';
                    if(rowError.classList.contains('rowImpar')){
                        rowErrorColor = "rgba(245, 246, 248, 1)"
                    }
                    rowError.style.backgroundColor= "#FAE5E8";
                    msg = document.getElementById("msgErrorliPayMet" + i);
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML= "Existen dependencias que no permiten eliminar esta Forma de Pago"
                    msg.classList.add("msgErrorLi");
                    msg.style.display="block";
                    setTimeout(function() {
                        rowError.style.backgroundColor = rowErrorColor;
                        msg.classList.remove("msgErrorLi");
                        msg.style.display="none";
                        msg = document.getElementById("messageApi")
                    }, 3000);
                    break;
                    
                case 400:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML=respuesta.msg
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                    
                case 401:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML="Sesi\u00F3n expirada o inv\u00E1lida, vuelva a iniciar sesi\u00F3n"
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                        myLogout();
                    }, 3000);
                    break;
                    
                case 403:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML="No posee los privilegios para actualizar Monedas."
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                    
                case 500:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML="Error al actualizar monedas, intente nuevamente."
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                default:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML= respuesta.msg;
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
            }
        }
}

function CancelEditCurrencie(id){
    let i = id.substr(id.length - 1);
    document.getElementById("liCurrencie"+i).style.backgroundColor = "";
    var inputNameEdit = document.getElementById("inputName"+i);
    var inputSymbolEdit = document.getElementById("inputSymbol"+i);
    var inputStatusEdit = document.getElementById("inputStatus"+i);
    var iconDeleteClear = document.getElementById("iconDelete"+i);
    var pAvailable = document.getElementById("p"+i);
    var pDisabled = document.getElementById("pEdit"+i);
    inputNameEdit.disabled = true;
    inputSymbolEdit.disabled = true;
    inputStatusEdit.disabled = true;
    pAvailable.style.visibility ="visible";
    pAvailable.style.position ="relative";
    pDisabled.style.visibility ="hidden";
    pDisabled.style.position ="absolute";
}

function ConfirmDeleteCurrencie(id) {
    var parent = document.getElementById(id);
    var idItem = parent.getAttribute('data-id');
    let i = id.substr(id.length - 1);
    
    var dataDelete2 = document.createElement("li")
    dataDelete2.innerHTML = "Forma de Pago: " + document.getElementById("inputNameBank"+i).value;
    dataDelete2.style.fontWeight = "normal";
    var dataDelete1 = document.createElement("li")
    dataDelete1.innerHTML = "Pa\u00EDs: " + document.getElementById("inputCountry"+i).value;
    dataDelete1.style.fontWeight = "normal";
    var dataDelete3 = document.createElement("li")
    dataDelete3.innerHTML = "Moneda: " + document.getElementById("inputCurrencie"+i).value;
    dataDelete3.style.fontWeight = "normal";
    
    var modal = document.getElementById("myModal");
    document.getElementById("dataDelete").appendChild(dataDelete1);
    document.getElementById("dataDelete").appendChild(dataDelete2);
    document.getElementById("dataDelete").appendChild(dataDelete3);
    document.getElementById("dataDelete").style.display= "block"
    document.getElementById("dataDelete").style.textAlign="center";
    document.getElementById("dataDelete").style.marginTop="15px";
    document.getElementById("dataDelete").style.textDecoration="none";
    modal.style.display = "block";
    
    document.getElementById("buttonAceptModal").setAttribute("eleid",idItem)
    
    
}

function sendApiUpdate(req){
    callWS("GET", "paymentmethods/update", req, respuesta);
        function respuesta(status, rsp){
            if(rsp){
                let response = JSON.parse(rsp);    
            }
            
            var msg = document.getElementById("messageApi")
            switch(status){
                case 200:
                    var sectionAddCurrencie = document.getElementById("addSection");
                    sectionAddCurrencie.getElementsByClassName("titleAdd")[0].dataset.id = "";
                    document.getElementById("StatusAdd").value = "";
                    document.getElementById("payMethodsAdd").value= "";
                    document.getElementById("detail1").value = "";
                    document.getElementById("detail3").value = "";
                    document.getElementById("CountryAdd").value = " ";
                    document.getElementById("detail2").value = "";
                    document.getElementById("detail4").value = "";
                    document.getElementById("CurrencieAdd").value = " ";
                    document.getElementById("selectGruop").innerHTML= "";
                    var sectionAddCurrencie = document.getElementById("addSection");
                    sectionAddCurrencie.style.display = "none";
                    var nodeNoDelete = document.getElementById("noCurrencieDefine");
                    if(nodeNoDelete){
                        var nodeClone = nodeNoDelete.cloneNode(true);
                    }
                    var table = document.getElementById("bodyTableCurrencies");
                    table.innerHTML = "";
                    var pageInPaginator = document.getElementsByClassName("pSelect")[0];
                    let offSetDelete = 0;
                    if(pageInPaginator){
                        pageInPaginator = pageInPaginator.innerHTML;
                        offSetDelete = (pageInPaginator - 1) * 10;
                    }
                    LoadPaymentMethods('', offSetDelete, document.getElementById("orderBy").value, 10, req.sessionid);
                    table.appendChild(nodeClone);
                    if(req.id == 0){
                        msg.innerHTML = "Forma de pago creada correctamente";
                    } else{
                        msg.innerHTML = "Forma de pago actualizada correctamente";
                    }
                    msg.classList.add("msgSucessTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgSucessTable");
                        msg.style.display="none";
                    }, 3000);
                    
                    break;
                
                case 304:
                    var sectionAddCurrencie = document.getElementById("addSection");
                    sectionAddCurrencie.getElementsByClassName("titleAdd")[0].dataset.id = "";
                    document.getElementById("StatusAdd").value = "";
                    document.getElementById("payMethodsAdd").value= "";
                    document.getElementById("detail1").value = "";
                    document.getElementById("detail3").value = "";
                    document.getElementById("CountryAdd").value = " ";
                    document.getElementById("detail2").value = "";
                    document.getElementById("detail4").value = "";
                    document.getElementById("CurrencieAdd").value = " ";
                    document.getElementById("selectGruop").innerHTML= "";
                    var sectionAddCurrencie = document.getElementById("addSection");
                    sectionAddCurrencie.style.display = "none";
                    msg.innerHTML="No se realizaron cambios en la forma de pago"
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                    
                case 400:
                    msg.innerHTML=response.msg
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                    
                case 401:
                    msg.innerHTML="Sesi\u00F3n expirada o inv\u00E1lida, vuelva a iniciar sesi\u00F3n"
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                        myLogout();
                    }, 3000);
                    break;
                    
                case 403:
                    msg.innerHTML="No posee los privilegios para actualizar Monedas."
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                    
                case 409:
                    msg.innerHTML="Registro duplicado."
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                    
                case 500:
                    msg.innerHTML="Error al actualizar monedas, intente nuevamente."
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                default:
                    msg.innerHTML= response.msg;
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
            }
    }
}

function paintRowsPayMethods(paymethods){
    var pageInPaginator = document.getElementsByClassName("pSelect")[0];
    if(pageInPaginator){
        pageInPaginator = pageInPaginator.innerHTML;
        offSetDelete = (pageInPaginator - 1) * 10;
    }
    var rowCurrencie = document.getElementById("bodyTableCurrencies");
    var filas;
    if (paymethods.numofrecords > 10){
        filas = parseInt(paymethods.numofrecords) - ((parseInt(pageInPaginator) - 1) * 10);
        if(filas > 10){
            filas = 10;
        }
    } else {
        filas = paymethods.numofrecords
    }
    for (i=0; i<filas; i++){
        var divContent= document.createElement("div");
        var labelcheckStatus = document.createElement("label");
        var checkStatus = document.createElement("input");
        var circleCheckStatus = document.createElement("span");
        var inputNameBank= document.createElement("input");
        var inputCountry= document.createElement("input");
        var inputCurrencie= document.createElement("input");
        var p = document.createElement("p");
        var iconEdit= document.createElement("i"); 
        var iconDelete= document.createElement("i"); 
        const index = i;
        
        iconEdit.classList.add("fas");
        iconEdit.classList.add("fa-edit");
        iconEdit.setAttribute("id", "iconEdit"+index);
        var id= paymethods.records[i].symbol;
        if( !(paymethods.privileges.update == false || paymethods.privileges.update == "false")){
            iconEdit.addEventListener("click", function(){
                EditRow("liCurrencie"+index)
            });
        }
        
        
        iconDelete.classList.add("fas");
        iconDelete.classList.add("fa-trash-alt");
        iconDelete.setAttribute("id", "iconDelete"+index);
        if( !(paymethods.privileges.delete == false || paymethods.privileges.delete == "false")){
            iconDelete.addEventListener("click", function(){
                ConfirmDeleteCurrencie("liCurrencie"+index);
            });
        }
        
        p.setAttribute("id", "p"+index);
        p.appendChild(iconEdit);
        p.appendChild(iconDelete);
        p.style.display="inherit";
        
        checkStatus.type="checkbox";
        checkStatus.setAttribute("id", "inputSatus"+index);
        if(paymethods.records[i].status.id == 1){
            checkStatus.checked = true;
        } else {
            checkStatus.checked = false;
        }
        checkStatus.disabled = true;
        circleCheckStatus.classList.add("slider");
        circleCheckStatus.classList.add("round");
        labelcheckStatus.classList.add("switch");
        labelcheckStatus.appendChild(checkStatus);
        labelcheckStatus.appendChild(circleCheckStatus);
        
        inputNameBank.disabled=true;
        inputNameBank.classList.add("inputRowCurrencie");
        inputNameBank.setAttribute("id", "inputNameBank"+index);
        inputNameBank.value = paymethods.records[i].dsc;
        
        inputCountry.disabled=true;
        inputCountry.classList.add("inputRowCurrencie");
        inputCountry.setAttribute("id", "inputCountry"+index);
        inputCountry.dataset.idCountry= paymethods.records[i].country.id;
        inputCountry.value = paymethods.records[i].country.dsc;
        
        inputCurrencie.disabled=true;
        inputCurrencie.classList.add("inputRowCurrencie");
        inputCurrencie.setAttribute("id", "inputCurrencie"+index);
        for(let idx=0; idx<paymethods.records[i].currencies.length; idx++ ){
            if (idx == 0){
                inputCurrencie.value = paymethods.records[i].currencies[idx].symbol;     
            } else {
                inputCurrencie.value = inputCurrencie.value + ", " + paymethods.records[i].currencies[idx].symbol;
            }
            
            /*if(paymethods.records[i].currencies[idx].default == true){
               inputCurrencie.value = paymethods.records[i].currencies[idx].dsc; 
            }*/
        }
        if(inputCurrencie.value == ""){
            inputCurrencie.value = paymethods.records[i].currencies[0].dsc; 
        }
        
        divContent.classList.add("rowCurrencie");
        if(i%2 === 0){
             divContent.classList.add("rowImpar");
        }
        divContent.setAttribute("id", "liCurrencie"+index);
        divContent.dataset.id= paymethods.records[i].id;
        
        /***CREAR SWITCH***/
        var cell,cont,swichBg,swichBal;
        cell = document.createElement("DIV"); cell.classList.add("switchCell");
            cont = document.createElement("DIV"); cont.classList.add("switchCont");
                swichBg = document.createElement("DIV"); swichBg.classList.add("switch");
                swichBg.setAttribute("id", "userStatus"+index);
                swichBal = document.createElement("DIV"); swichBal.classList.add("switchBal");
                if(paymethods.records[i].status.id == 1){
                    swichBg.classList.add("active");
                    swichBal.classList.add("balActive");
                }
                swichBg.appendChild(swichBal);
                swichBg.addEventListener("click", function(){
                    if(this.classList.contains("active")){
                        this.classList.remove("active");
                        this.firstElementChild.classList.remove("balActive");
                    }else{
                        this.classList.add("active");
                        this.firstElementChild.classList.add("balActive");
                    } 
                    entryAccount("liCurrencie"+index);
                });
            cont.appendChild(swichBg);
        cell.appendChild(cont);
        
        divContent.appendChild(cell);
        
        //divContent.appendChild(labelcheckStatus);
        divContent.appendChild(inputNameBank);
        divContent.appendChild(inputCountry);
        divContent.appendChild(inputCurrencie);
        divContent.appendChild(p);
        divContent.style.display = "flex";
        
        rowCurrencie.appendChild(divContent);
        var msgRow = document.createElement("p");
        msgRow.setAttribute("id","msgErrorliPayMet"+index);
        msgRow.classList.add("msgError");
        rowCurrencie.appendChild(msgRow);
    }
    
    for(let j = paymethods.numofrecords; j<10; j++){
        var divContent= document.createElement("div");
        var inputNameBank= document.createElement("input");
        var inputCountry= document.createElement("input");
        var inputCurrencie= document.createElement("select");
        const index = j;
        
        inputNameBank.disabled=true;
        inputNameBank.classList.add("inputRowCurrencie");
        inputNameBank.value = " ";
        
        inputCountry.disabled=true;
        inputCountry.classList.add("inputRowCurrencie");
        inputCountry.value = " ";
        
        inputCurrencie.disabled=true;
        inputCurrencie.classList.add("inputRowCurrencie");
        inputCurrencie.classList.add("selectOrderBy");
        
        divContent.classList.add("rowCurrencie");
        if(j%2 === 0){
             divContent.classList.add("rowImpar");
        }
        divContent.appendChild(inputCountry);
        divContent.appendChild(inputNameBank);
        divContent.appendChild(inputCurrencie);
        divContent.style.display = "flex";
        divContent.style.cursor = "none";
        
        rowCurrencie.appendChild(divContent);
    }
}
function entryAccount(id){
    let i = id.substr(id.length - 1);
    
    var sessionId = sessionStorage.getItem("sessionId");
    req = {};
    req.id = document.getElementById(id).getAttribute("data-id");
    req.sessionid = sessionId;
    callWS("GET", "paymentmethods/entry", req, respuesta);
        function respuesta(status, rsp){
            let respuesta = JSON.parse(rsp);
            var msg = document.getElementById("messageApi")
            switch(status){
                case 200:
                    UpdateStatus(id,respuesta);
                break;
                case 400:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML=respuesta.msg;
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.innerHTML="";
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                    
                case 401:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML="Sesi\u00F3n expirada o inv\u00E1lida, vuelva a iniciar sesi\u00F3n"
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                        myLogout();
                    }, 3000);
                    break;
                    
                case 403:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML="No posee los privilegios para actualizar esta cuenta."
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                    
                case 500:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML="Error al actualizar cuenta, intente nuevamente."
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
                    break;
                default:
                    document.getElementById("dataDelete").innerHTML="";
                    msg.innerHTML= respuesta.msg;
                    msg.classList.add("msgErrorTable");
                    msg.style.display="block";
                    setTimeout(function() {
                        msg.classList.remove("msgErrorTable");
                        msg.style.display="none";
                    }, 3000);
            }
        }
    
}

function LoadServicesSectionAdd(){
    var sessionId = sessionStorage.getItem("sessionId");
    LoadCountries("", 1, 0, 1000, sessionId);
    LoadCurrencies("", 1, 0, 1000, sessionId)
}

function LoadCountries(filter, order, offset, numofrec, sessionid){
    var req = {};
    req.filter = filter;
    req.order = order;
    req.offset = offset;
    req.numofrec = numofrec;
    req.sessionid = sessionid;
    
    callWS("GET", "countries/list", req, respuesta);
    function respuesta(status, rsp){
        let resp = JSON.parse(rsp);
        var countries = document.getElementById("CountryAdd");
        //var msg = document.getElementById("messageApi")
        switch(status){
            case 200:
                for (let i=0; i<resp.records.length; i++){
                    var op = document.createElement("option");
                    if(resp.records.length == 0){
                        op.text= "No hay paises definidos";
                        op.disabled = true;
                        op.value = " ";
                        op.selected = true;
                        countries.appendChild(op);
                    } else {
                        if(resp.records[i].status.id == 1){
                            op.text= resp.records[i].dsc
                            op.value = resp.records[i].id;
                            countries.appendChild(op);
                        }
                    }
                }
                
                
            case 400:
                /*msg.innerHTML=respuesta.msg
                msg.style.color="red";
                msg.style.textAlign="center";
                msg.style.display="block";
                setTimeout(function() {
                    msg.style.display="none";
                }, 3000);*/
                break;
                
            case 401:
                /*msg.innerHTML="Sesi\u00F3n expirada o inv\u00E1lida, vuelva a iniciar sesi\u00F3n"
                msg.style.color="red";
                msg.style.textAlign="center";
                msg.style.display="block";
                setTimeout(function() {
                    msg.style.display="none";
                    myLogout();
                }, 3000);*/
                break;
                
            case 403:
                /*msg.innerHTML="No posee los privilegios para actualizar Monedas."
                msg.style.color="red";
                msg.style.textAlign="center";
                msg.style.display="block";
                setTimeout(function() {
                    msg.style.display="none";
                }, 3000);*/
                break;
                
            case 500:
                /*msg.innerHTML="Error al actualizar monedas, intente nuevamente."
                msg.style.color="red";
                msg.style.textAlign="center";
                msg.style.display="block";
                setTimeout(function() {
                    msg.style.display="none";
                }, 3000);*/
                break;
            default:
                /*msg.innerHTML= respuesta.msg;
                msg.style.color="red";
                msg.style.textAlign="center";
                msg.style.display="block";
                setTimeout(function() {
                    msg.style.display="none";
                }, 3000);*/
        }
    }
}

function LoadCurrencies(filter, order, offset, numofrec, sessionid){
    var req = {};
    req.filter = filter;
    req.order = order;
    req.offset = offset;
    req.numofrec = numofrec;
    req.sessionid = sessionid;
    
    callWS("GET", "currencies/list", req, respuesta);
    function respuesta(status, rsp){
        let resp = JSON.parse(rsp);
        var currencies = document.getElementById("CurrencieAdd");
        //var msg = document.getElementById("messageApi")
        switch(status){
            case 200:
                for (let i=0; i<resp.records.length; i++){
                    var op = document.createElement("option");
                    if(resp.records.length == 0){
                        op.text= "No hay monedas definidas";
                        op.disabled = true;
                        op.value = " ";
                        op.selected = true;
                        currencies.appendChild(op);
                    } else {
                        if(resp.records[i].status.id == 1){
                            op.text= resp.records[i].name + "(" + resp.records[i].symbol + ")";
                            op.value = resp.records[i].id;
                            currencies.appendChild(op);
                        }
                    }
                }
                
                
            case 400:
                /*msg.innerHTML=respuesta.msg
                msg.style.color="red";
                msg.style.textAlign="center";
                msg.style.display="block";
                setTimeout(function() {
                    msg.style.display="none";
                }, 3000);*/
                break;
                
            case 401:
                /*msg.innerHTML="Sesi\u00F3n expirada o inv\u00E1lida, vuelva a iniciar sesi\u00F3n"
                msg.style.color="red";
                msg.style.textAlign="center";
                msg.style.display="block";
                setTimeout(function() {
                    msg.style.display="none";
                    myLogout();
                }, 3000);*/
                break;
                
            case 403:
                /*msg.innerHTML="No posee los privilegios para actualizar Monedas."
                msg.style.color="red";
                msg.style.textAlign="center";
                msg.style.display="block";
                setTimeout(function() {
                    msg.style.display="none";
                }, 3000);*/
                break;
                
            case 500:
                /*msg.innerHTML="Error al actualizar monedas, intente nuevamente."
                msg.style.color="red";
                msg.style.textAlign="center";
                msg.style.display="block";
                setTimeout(function() {
                    msg.style.display="none";
                }, 3000);*/
                break;
            default:
                /*msg.innerHTML= respuesta.msg;
                msg.style.color="red";
                msg.style.textAlign="center";
                msg.style.display="block";
                setTimeout(function() {
                    msg.style.display="none";
                }, 3000);*/
        }
    }
}
function UpdateStatus(id,rsp){
    var sessionId = sessionStorage.getItem("sessionId");
    let i = id.substr(id.length - 1);
    
    req.id = rsp.entry.id;
    req.dsc = rsp.entry.dsc;
    req.details1 = rsp.entry.details1;
    req.details3 = rsp.entry.details3;
    req.details2 = rsp.entry.details2;
    req.details4 = rsp.entry.details4;
    req.countryid = rsp.entry.country.id;
    var status = document.getElementById("userStatus"+i);
    if(status.classList.contains("active"))
        req.status = 1;
    else
        req.status = 0;
        
    var currs = "";
    for(var x=0;x<rsp.entry.currencies.length;x++){
        currs += rsp.entry.currencies[x].id+"-";
    }
    currs = currs.substr(0,currs.length - 1);
    req.currencies = currs;
    req.sessionid = sessionId;
    
    /*if(req.id == "" || req.id == " " || req.status == "" || req.status == " " || req.dsc == "" || req.dsc == " " || req.details1 == "" || req.details1 == " " || req.countryid == "" || req.countryid == " " || req.currencies == ""){
        var msg = document.getElementById("messageApi");
        msg.innerHTML= "Par\u00E1metros obligatorios: estatus, nombre, pa\u00EDs, monedas y primer detalle."
        msg.style.color="red";
        msg.style.textAlign="center";
        msg.style.display="block";
        msg.style.marginLeft="30px";
        setTimeout(function() {
            msg.style.display="none";
        }, 3000);
    } else {*/
    sendApiUpdate(req);
    // }
}
function AceptSectionUpdate(){
    var sectionAddCurrencie = document.getElementById("addSection");
    var id = sectionAddCurrencie.getElementsByClassName("titleAdd")[0].dataset.id;
    var req= {}
    req.sessionid = sessionStorage.getItem("sessionId");
    req.id= id;
    req.status = document.getElementById("StatusAdd").value;
    req.dsc = document.getElementById("payMethodsAdd").value;
    req.details1 = document.getElementById("detail1").value;
    req.details3 = document.getElementById("detail3").value;
    req.countryid = document.getElementById("CountryAdd").value;
    req.details2 = document.getElementById("detail2").value;
    req.details4 = document.getElementById("detail4").value;
    var elChilds = document.getElementById("selectGruop").childElementCount;
    var spanChilds = document.getElementById("selectGruop").getElementsByTagName("span");
    var currencies = "";
    for(let i=0; i< (elChilds * 2); i++){
        if(i%2 === 0 && spanChilds.length > 0){
            if(currencies != ""){
                currencies = currencies + "-" +spanChilds[i].id;
            } else{
                console.log("elChilds", elChilds)
                console.log("spanChilds", spanChilds)
                currencies = spanChilds[i].id;
            }
        }
    }
    req.currencies = currencies;
    console.log("request", req)
    if(req.id === "" || req.id === " "){
            var msg = document.getElementById("messageApi");
            msg.innerHTML= "Error al editar Cuenta interna, intente nuevamente";
            msg.classList.add("msgError");
            msg.style.display="block";
            setTimeout(function() {
                msg.classList.remove("msgError");
                msg.style.display="none";
            }, 5000);
        } else if( req.status === "" || req.status === " "){
            var msgFail = document.getElementById("msgStatus");
            var inputFail = document.getElementById("StatusAdd");
            msgFail.style.display="block";
            inputFail.style.border= "1px solid #D0021B";
            inputFail.style.marginBottom="0px";
            setTimeout(function() {
                msgFail.style.display="none";
                inputFail.style.marginBottom="8px";
                inputFail.style.border= "0.87px solid #D3D2D2";
            }, 3000);
        } else if( req.countryid === "" || req.countryid === " "){
            var msgFail = document.getElementById("msgCountry");
            var inputFail = document.getElementById("CountryAdd");
            msgFail.style.display="block";
            inputFail.style.border= "1px solid #D0021B";
            inputFail.style.marginBottom="0px";
            setTimeout(function() {
                msgFail.style.display="none";
                inputFail.style.marginBottom="8px";
                inputFail.style.border= "0.87px solid #D3D2D2";
            }, 3000);
            
        } else if(req.dsc === "" || req.dsc === " " ){
            var msgFail = document.getElementById("msgPayMethod");
            var inputFail = document.getElementById("payMethodsAdd");
            msgFail.style.display="block";
            inputFail.style.border= "1px solid #D0021B";
            inputFail.style.marginBottom="0px";
            setTimeout(function() {
                msgFail.style.display="none";
                inputFail.style.marginBottom="8px";
                inputFail.style.border= "0.87px solid #D3D2D2";
            }, 3000);
            
        }else if( req.currencies === "" || req.currencies === " "){
            var msgFail = document.getElementById("msgCurrencie");
            var inputFail = document.getElementById("selectGruop");
            msgFail.style.display="block";
            inputFail.style.border= "1px solid #D0021B";
            inputFail.style.marginBottom="0px";
            setTimeout(function() {
                msgFail.style.display="none";
                inputFail.style.marginBottom="8px";
                inputFail.style.border= "0.87px solid #D3D2D2";
            }, 3000);
            
        } else if(req.details1 === "" || req.details1 === " "){
            var msgFail = document.getElementById("msgDet1");
            var inputFail = document.getElementById("detail1");
            msgFail.style.display="block";
            inputFail.style.border= "1px solid #D0021B";
            inputFail.style.marginBottom="0px";
            setTimeout(function() {
                msgFail.style.display="none";
                inputFail.style.marginBottom="8px";
                inputFail.style.border= "0.87px solid #D3D2D2";
            }, 3000);
        }else {
            sendApiUpdate(req);
        }
    
    
    /*if(req.id == "" || req.id == " " || req.status == "" || req.status == " " || req.dsc == "" || req.dsc == " " || req.details1 == "" || req.details1 == " " || req.countryid == "" || req.countryid == " " || elChilds == 0){
        var msg = document.getElementById("messageApi");
        msg.innerHTML= "Par\u00E1metros obligatorios: estatus, descripci\u00F3n, pa\u00EDs, monedas y primer detalle."
        msg.style.color="red";
        msg.style.textAlign="center";
        msg.style.display="block";
        msg.style.marginLeft="30px";
        setTimeout(function() {
            msg.style.display="none";
        }, 3000);
    } else {
        sendApiUpdate(req);
    }*/
}

function RemoveSpan(id){
    var idSpan = id.replace("idCurrencie", "");
    var curren = document.getElementById("CurrencieAdd");
    curren.value = idSpan;
    var idx = curren.selectedIndex;
    curren.options[idx].disabled = false;
    console.log("option disabled", curren.options[idx], "disabled", curren.options[idx].disabled);
    var parent = document.getElementById("selectGruop");
    var spanParent = document.getElementById(idSpan);
    parent.removeChild(spanParent);
    curren.value = "";
}