<?php
// app/api/withdrawals/insert

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","accountid","amount");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables e inicializacion
    $out = new stdClass;
    $sessionid = $_POST["sessionid"];
    $amount = $_POST["amount"];
    $accountid = $_POST["accountid"];
    
    if($amount <= 0){
        badEnd("403", array("msg"=>"Monto no puede ser menor o igual a 0"));
    }
    
    //Debemos validar si es moneda fiat o cripto, no pueden ser ambas
    //Tipo de transaccion: -cripto -fiat
    $withdrawType = "";
    $withdrawId = "";
    if($_POST["paymentaccountid"] != "" && $_POST["paymentwallet"] == ""){
        $withdrawType = "fiat";
        $withdrawId = $_POST["paymentaccountid"];
    }else if($_POST["paymentaccountid"] == "" && $_POST["paymentwallet"] != ""){
        $withdrawType = "cripto";
        $withdrawId = $_POST["paymentwallet"];
    }else{
        badEnd("400", array("msg"=>"Solo puede ser enviado paymentaccountid O paymentwallet, no ambos o ninguno"));
    }
    
    //Validamos la session
    $idUserSession = isSessionValid($db, $sessionid);
    //Validamos el si el usuario puede crear cuentas
    isLevelValid($db, $idUserSession);
    
    //Obtenemos la moneda en la cual se hace el deposito
    $sql = "SELECT * from accounts WHERE id = ".$accountid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $accountdata = $rs->fetch_assoc();
    
    //validamos que exista
    if($accountdata["id"] == null){
        badEnd("500", array("msg"=>"Accountid invalido"));
    }
    
    $sql = "SELECT SUM(amount) as qty FROM `transactions` WHERE accountid = ".$accountid;
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $balance = $res->fetch_assoc();
    
    $sql = "SELECT SUM(amount) AS qty ".
    "       FROM ( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END)AS amount ".
    "           FROM orders ".
    "           WHERE orders.accountid = ".$accountid.
	"           AND orders.canceled IS NULL ".
    "       UNION ALL ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND transactions.accountid = ".$accountid.
	"           AND orders.canceled IS NULL ".
	"           AND transactions.amount < 0".
    "       ) amount";
    if (!$res=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $balanceorder = $res->fetch_assoc();
    
    if(($balance["qty"] - $balanceorder['qty']) <= 0 || ($balance["qty"] - $balanceorder['qty']) < $amount){
        badEnd("403", array("msg"=>"Saldo insuficiente"));
    }
    
    //Obtenemos el nivel de usuario para determinar su fee
    $sql = "SELECT * FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $userdata = $rs->fetch_assoc();
    
    $level = 1;
    
    if($userdata["level"] == 0){
        $level = 1;
    }else{
        $level = $userdata["level"];
    }
    
    //Consultamos la cuenta que tiene la moneda del retiro de AFX
    $sql = "SELECT * FROM accounts WHERE userid = -1".
    "       AND currencyid = ".$accountdata["currencyid"].
    "       AND paymentmethodid = -2";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta AFX
    $afxdata = $rs->fetch_assoc();
    
    //Obtenemos el fee de cada operacion por la moneda de la cuenta
    $sql = "SELECT * FROM cmspreffees WHERE currencyid = ".$accountdata["currencyid"].
    "       AND levelid = ".$level.
    "       AND usertype = ".$userdata["type"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $fee = $rs->fetch_assoc();
    
    /*
    //Validamos que el monto sea mas que el minimo aceptado
    if($fee["minbalance"] > $amount){
        badEnd("403", array("msg"=>"Monto no autorizado"));
    }*/
    
    //Calculamos el monto real quitandole la comision
    if($fee["pctfeewithdrawals"] != null){
        if($fee["pctfeewithdrawals"] == 0){
            $realfee = $amount - ($amount - $fee["nmlfeewithdrawals"]);
            $realamount = $amount - $realfee;
        }else{
            $realfee = ($fee["pctfeewithdrawals"]*$amount)/100;
            $realamount = $amount - $realfee;
        }
    }else{
        $realfee = (2*$amount)/100;
        $realamount = $amount - $realfee;
    }
    
    
    validateOperations($db, $accountid, $userdata["id"], $amount, 2);
    
    if($realamount <= 0){
        badEnd("403", array("msg"=>"Total neto no puede ser menor o igual a 0"));
    }
    
    $validator = getValidator(8);
    
    $db->autocommit(FALSE);
        
    //insertamos la trasaccion del retiro
    $sql = "INSERT INTO transactions".
    "       (datecreated, dsc, ".
    "       amountghost, amount, ".
    "       validthru, ".
    "       accountid, validator, ".
    "       orderid, txid, ".
    "       accountorigin, accountdestination".
    "       )".
    "       VALUES(".
    "       NOW(), 'Retiro', ".
    "       -".abs($realamount).", 0, ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       ".$accountid.", '".$validator."', ".
    "       NULL, NULL, ".
    "       ".$accountid.",".($withdrawType == "fiat" ? $withdrawId : "'".$withdrawId."'" ).
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Guardamos el id de la transaccion de deposito
    $txid = (int)$db->insert_id;
    $out->id = (int)$txid;
    
    //Le colocamos a la primera transferencia el txid
    $sql = "UPDATE transactions SET".
    "       txid = ".$txid.
    "       WHERE id = ".$txid;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos la comision del retiro
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       amount, ".
    "       amountghost, ".
    "       validthru, ".
    "       accountid, validator, ".
    "       orderid, ".
    "       txid, ".
    "       accountorigin, ".
    "       accountdestination".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Retiro', ".
    "       0, ".
    "       -".abs($realfee).", ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       ".$accountid.", '".$validator."', ".
    "       NULL, ".
    "       ".$txid.", ".
    "       ".$accountid.", ".
    "       ".$afxdata["id"].
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos la comision del retiro hacia la cuenta POTE
    $sql = "INSERT INTO transactions".
    "       (".
    "       datecreated, ".
    "       dsc, ".
    "       amount, ".
    "       amountghost, ".
    "       validthru, ".
    "       accountid, ".
    "       validator, ".
    "       orderid, ".
    "       txid, ".
    "       accountorigin, ".
    "       accountdestination".
    "       )".
    "       VALUES(".
    "       NOW(), ".
    "       'Comisión de Retiro', ".
    "       0, ".
    "       ".$realfee.", ".
    "       DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       ".$afxdata["id"].", '".$validator."', ".
    "       NULL, ".
    "       ".$txid.", ".
    "       ".$accountid.", ".
    "       ".$afxdata["id"].
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //insertamos el retiro
    $sql = "INSERT INTO withdrawals".
    "       (".
    "       ".($withdrawType == "fiat" ? "paymentaccountid" :"paymentwallet" ).", ".
    "       createddate, ".
    "       fee, ".
    "       transactionid, ".
    "       valid, ".
    "       amount ".
    "       )".
    "       VALUES(".
    "       ".($withdrawType == "fiat" ? $withdrawId : "'".$withdrawId."'" ).", ".
    "       NOW(), ".
    "       ".$realfee.", ".
    "       ".$txid.", ".
    "       NULL, ".
    "       -".abs($amount).
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    if($withdrawType != "fiat"){
        $out->transacctionid = $txid;
    }
    
    //auditoria
    setAudit($db, "OPERACIONES", $sessionid, "APP", "El usuario ".$userdata["id"]." agrego el retiro ".$out->id);
    
    $db->commit();
    $db->close();
    
    $email = $userdata["usr"];
    $subject = "Código de retiro AFX";
    $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
    $body = "Hola ".strtolower($email).", para completar el retiro de fondos ingrese el codigo a continuaci&oacute;n:<br><br>".
            "<b>".$validator."</b><br><br>".
            "<b>Este c&oacute;digo expirar&aacute; en 10 minutos.</b><br><br>".
            "<br>Gracias de antemano<br>AFX<br>";
            
    enviarCorreo($fromeMail, strtolower($email), $subject, $body);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>