<?php
// cms/api/currencies/update

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","name","symbol","status","decimals");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    $name = $_GET["name"];
    $symbol = $_GET["symbol"];
    $status = $_GET["status"];
    $decimals = $_GET["decimals"];
    $icon = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos el tamano del decimal
    if($decimals < 2 || $decimals > 10){
        badEnd("400", array("msg"=>"Cantidad de decimales minimo 2 y maximo 10"));
    }
    
    //Si el id es igual a 0, se crea, si no se actualiza la moneda
    if($id == 0){
        
        //Validamos que tenga privilegios para crear
        if (!tienePrivilegio($db, $sessionid, 11))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos para verificar que no existe una moneda igual
        $sql = "SELECT count(id) AS qty FROM currencies ".
        "       WHERE name = '".$name."' ".
        "       AND symbol = '".$symbol."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        if($row["qty"] > 0){
            badEnd("402", array("msg"=>"Registro duplicado"));
        }
        
        $labelIcon = "";
        
        //En caso de que el icon sea enviado, se construye el query
        if(isset($_GET["icon"]) && $_GET["icon"] != ""){
            $icon = ", '".$_GET["icon"]."'";
            $labelIcon = ", icon";
        }
        
        $sql = "INSERT INTO currencies(name, symbol, status, decimals".$labelIcon.")".
        "       VALUES ('".$name."', '".$symbol."', ".$status.", ".$decimals."".$icon.")";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        // Retornamos el id que fue insertado
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "MONEDAS", $sessionid, "CMS", "Se incluyo la moneda ".$out->id);
        
    }else{
        
        //Validamos que tenga privilegios para editar/actualizar
        if (!tienePrivilegio($db, $sessionid, 12))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        //Consultamos para validar que el registro exista
        $sql = "SELECT name, status FROM currencies WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        // Retornamos 204 cuando la busqueda no obtiene resutados
        if($row["name"] == null){
            badEnd("204", array("msg"=>"No se encuentra el registro"));
        }
        
        //Consultamos para verificar que no existe una moneda igual
        $sql = "SELECT count(id) AS qty FROM currencies ".
        "       WHERE name = '".$name."' ".
        "       AND symbol = '".$symbol."'".
        "       AND id != ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        if($row["qty"] > 0){
            badEnd("402", array("msg"=>"Registro duplicado"));
        }
        
        //En caso de que el icon sea enviado, se construye el query
        if(isset($_GET["icon"]) && $_GET["icon"] != ""){
            $icon = "icon = '".$_GET["icon"]."',";
        }
        
        $sql = "UPDATE currencies SET".
        "       name = '".$name."', ".
        "       symbol = '".$symbol."', ".
        "       decimals = ".$decimals.", ".
        "       ".$icon.
        "       status = ".$status.
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        //Retornamos 304 si no se actualizo ningun registro
        if ($db->affected_rows == 0)
            badEnd("304", array("msg"=>"No se pudo modificar"));
    
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "MONEDAS", $sessionid, "CMS", "Se actualizo la moneda ".$out->id);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
