<?php
// cms/api/orders/list

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'offset','numofrecords');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    $sessionid = $_GET['sessionid'];
    $offset = $_GET['offset'];
    $numofrecords = $_GET['numofrecords'];
    $order = determinateOrder($_GET['order']);
    $status = "";
    $daterange = "";
    $type = "";
    $pairid = "";
    $filter = "";
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 35))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //En caso de que el filter sea enviado, se construye el query
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        $filterCompany = "AND (users.usr LIKE '".$_GET["filter"]."%' ".
        "                       ".(floatval($_GET['filter']) == 0 ? "" : "OR o.quantity = '".floatval($_GET['filter'])."'").
        "                       ".(floatval($_GET['filter']) == 0 ? "" : "OR o.price = '".floatval($_GET['filter'])."'").
        "                       ".(floatval($_GET['filter']) == 0 ? "" : "OR o.total = '".floatval($_GET['filter'])."'").
        "                       OR usercompanies.name LIKE '".$_GET["filter"]."%')";
        $filterPerson = "AND (users.usr LIKE '".$_GET["filter"]."%' ".
        "                       ".(floatval($_GET['filter']) == 0 ? "" : "OR o.quantity = '".floatval($_GET['filter'])."'").
        "                       ".(floatval($_GET['filter']) == 0 ? "" : "OR o.price = '".floatval($_GET['filter'])."'").
        "                       ".(floatval($_GET['filter']) == 0 ? "" : "OR o.total = '".floatval($_GET['filter'])."'").
        "                       OR userpersons.fname LIKE '".$_GET["filter"]."%')";
        $filter = "AND (users.usr LIKE '".$_GET["filter"]."%' OR ".
        "               userpersons.fname LIKE '".$_GET["filter"]."%' ".
        "                       ".(floatval($_GET['filter']) == 0 ? "" : "OR o.quantity = '".floatval($_GET['filter'])."'").
        "                       ".(floatval($_GET['filter']) == 0 ? "" : "OR o.price = '".floatval($_GET['filter'])."'").
        "                       ".(floatval($_GET['filter']) == 0 ? "" : "OR o.total = '".floatval($_GET['filter'])."'").
        "               OR usercompanies.name LIKE '".$_GET["filter"]."%')";
    }
    
    //En caso de que el status sea enviado, se construye el query
    if(isset($_GET['status']) && $_GET['status'] != ""){
        if($_GET['status'] == 1){
            $status = " AND (CASE ".
            "           WHEN o.canceled IS NOT NULL THEN -1 ".
            "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
            "                  FROM transactions, orders ".
            "                  WHERE orders.id = transactions.orderid ".
            "                  AND orders.id = o.id ".
            "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
            "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
            "                   AND o.canceled IS NULL THEN 1 ".
            "           ELSE 0 END ) = 0";
        }else if($_GET['status'] == 2){
            $status = " AND (CASE ".
            "           WHEN o.canceled IS NOT NULL THEN -1 ".
            "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
            "                  FROM transactions, orders ".
            "                  WHERE orders.id = transactions.orderid ".
            "                  AND orders.id = o.id ".
            "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
            "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
            "                   AND o.canceled IS NULL THEN 1 ".
            "           ELSE 0 END ) = 1";
        }else if($_GET['status'] == 3){
            $status = " AND o.canceled IS NOT NUll";
        }else{
            badEnd('500',array('msg'=>'El parametro status debe ser 1, 2 o 3'));
        }
    }
    
    //En caso de que el daterange sea enviado, se construye el query
    if(isset($_GET['daterange']) && $_GET['daterange'] != ""){
        $daterange = determinateRange($_GET['daterange']);
    }
    
    //En caso de que el type sea enviado, se construye el query
    //Market = 1 | Limit = 2
    if(isset($_GET['type']) && $_GET['type'] != ""){
        $type = ' AND o.type = '.$_GET['type'];
    }
    
     //En caso de que el pairid sea enviado, se construye el query
    if(isset($_GET['pairid']) && $_GET['pairid'] != ""){
        $pairid = ' AND o.pairid = '.$_GET['pairid'];
    }
    
    //Consultamos la cantidad de ordenes
    $sql = "SELECT COUNT(o.id) AS qty".
    "       FROM orders o, accounts, users ".
    "           LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "           LEFT JOIN usercompanies ON usercompanies.usrid = users.id".
    "       WHERE o.accountid = accounts.id ".
    "       AND accounts.userid = users.id ".
    "       ".$filter.
    "       ".$status.
    "       ".$type.
    "       ".$pairid.
    "       ".$type.
    "       ".$daterange;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    
    $row = $rs->fetch_assoc();
    $out->numofrecords = (int)$row['qty'];
    
    //Mira chamo, yo no se cuanto me he fumado para que esto agarre bien, por fin funciona sin importarle nada
    //Ahora me toca arreglar el match, que no se si esta mal pero igual me da miedo
    
    //Consultamos los datos de las ordenes
    $sql = "SELECT o.id AS orderid, ".
    "       o.date AS createddate, ".
    "       o.side AS orderside, ".
    "       o.type AS ordertype, ".
    "       o.quantity AS orderqty, ".
    "       o.price AS orderprice, ".
    "       o.total AS ordertotal, ".
    "       pairs.id AS pairid, ". 
    "       pairs.currencyid AS paircurrency, ".
    "       pairs.refcurrencyid AS pairrefcurrency, ".
    "       IF( ".
    "           (SELECT SUM(ABS(transactions.amount)) ".
    "               FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND orders.id = o.id ".
    "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, ".
    "           (SELECT SUM(ABS(transactions.amount)) ".
    "               FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND orders.id = o.id ".
    "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), ".
    "           0 ".
    "       ) AS totallyfilled, ".
    "       CASE ".
    "           WHEN o.canceled IS NOT NULL THEN -1 ".
    "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
    "                  FROM transactions, orders ".
    "                  WHERE orders.id = transactions.orderid ".
    "                   AND orders.id = o.id ".
    "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
    "                   AND o.canceled IS NULL THEN 1 ".
    "           ELSE 0 ".
    "       END AS statusorder, ".
    "       users.id AS usrid, ".
    "       users.usr AS usr, ".
    "       users.type AS usrtype, ".
    "       usercompanies.name AS name, ".
    "       usercompanies.comercialname AS secondname ".
    "       FROM orders o, users, accounts, usercompanies, pairs ".
    "       WHERE o.accountid = accounts.id ".
    "       AND accounts.userid = users.id ".
    "       AND pairs.id = o.pairid ".
    "       AND usercompanies.usrid = users.id ".
    "       ".$filterCompany.
    "       ".$status.
    "       ".$type.
    "       ".$pairid.
    "       ".$daterange.
    "       UNION ALL ".
    "       SELECT o.id AS orderid, ".
    "       o.date AS createddate, ".
    "       o.side AS orderside, ".
    "       o.type AS ordertype, ".
    "       o.quantity AS orderqty, ".
    "       o.price AS orderprice, ".
    "       o.total AS ordertotal, ".
    "       pairs.id AS pairid, ". 
    "       pairs.currencyid AS paircurrency, ".
    "       pairs.refcurrencyid AS pairrefcurrency, ".
    "       IF( ".
    "           (SELECT SUM(ABS(transactions.amount)) ".
    "               FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND orders.id = o.id ".
    "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, ".
    "           (SELECT SUM(ABS(transactions.amount)) ".
    "               FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND orders.id = o.id ".
    "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), ".
    "           0 ".
    "       ) AS totallyfilled, ".
    "       CASE ".
    "           WHEN o.canceled IS NOT NULL THEN -1 ".
    "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
    "                  FROM transactions, orders ".
    "                  WHERE orders.id = transactions.orderid ".
    "                  AND orders.id = o.id ".
    "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity".
    "                   AND o.canceled IS NULL THEN 1 ".
    "           ELSE 0 ".
    "       END AS statusorder, ".
    "       users.id AS usrid, ".
    "       users.usr AS usr, ".
    "       users.type AS usrtype, ".
    "       CONCAT(userpersons.fname,' ', userpersons.sname) AS name, ".
    "       CONCAT(userpersons.flastname, ' ', userpersons.slastname) AS secondname ".
    "       FROM orders o, users, accounts, userpersons, pairs ".
    "       WHERE o.accountid = accounts.id ".
    "       AND accounts.userid = users.id ".
    "       AND pairs.id = o.pairid ".
    "       AND userpersons.usrid = users.id ".
    "       ".$filterPerson.
    "       ".$status.
    "       ".$type.
    "       ".$pairid.
    "       ".$daterange.
    "       ".$order.
    "       LIMIT ".$offset.", ".$numofrecords;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row['orderid'];
        $record->status = (int)$row['statusorder'];
        
        $record->pair = new stdClass();
        $record->pair->id = (int)$row['pairid'];
        
        $record->date = new stdClass();
        $record->date->cannonical = date("YmdHi", strtotime($row["createddate"]));
        $record->date->formatted = date("d/m/Y h:i a", strtotime($row["createddate"]));
        
        //Consultamos el nombre de la moneda ref
        $sql = "SELECT symbol, decimals FROM currencies WHERE id = ".$row["pairrefcurrency"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $refcurrency = $res->fetch_assoc();
        
        //Consultamos el nombre de la moneda base
        $sql = "SELECT symbol, decimals FROM currencies WHERE id = ".$row["paircurrency"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $currency = $res->fetch_assoc();
        
        $record->pair->dsc = $refcurrency['symbol'].'/'.$currency['symbol'];
        
        //Ordenamos el side
        $record->side = new stdClass();
        $record->side->id = (int)$row['orderside'];
        $record->side->dsc = $record->side->id == 1 ? 'Venta' : 'Compra' ;
        
        //Ordenamos el type
        $record->type = new stdClass();
        $record->type->id = (int)$row['ordertype'];
        $record->type->dsc = $record->type->id == 1 ? 'Market' : 'Limit' ;
        
        //Ordenamos los datos del usuario
        $record->user = new stdClass();
        $record->user->id = (int)$row['usrid'];
        
        if($row['usrtype'] == 2){
            $record->user->fullname = $row['name'].($row['secondname'] == '' ? '' : ' / '.$row['secondname']);
        }else{
            $record->user->fullname = $row['name'].($row['secondname'] == '' ? '' : ' '.$row['secondname']);
        }
        
        $record->user->usr = $row['usr'];
        
        //Ordenamos el porcentaje
        $record->filled = new stdClass();
        //if($record->side->id == 1){
            if($row['orderqty'] != 0){
                $record->filled->number = ($row['totallyfilled']*100)/$row['orderqty'];                
            }
        /*}else{
            if($row['ordertotal'] != 0){
                $record->filled->number = ($row['totallyfilled']*100)/$row['ordertotal'];
            }
            
        }*/
        
        $record->filled->formatted = numberFormatt($record->filled->number, 2).'%';
        
        //Ordenamos el precio de la orden
        $record->price = new stdClass();
        $record->price->number = (float)$row['orderprice']; 
        $record->price->formatted = numberFormatt($record->price->number, $currency['decimals']);
        
        //Ordenamos la cantidad
        $record->qty = new stdClass();
        $record->qty->number =(float)$row['orderqty'];
        $record->qty->formatted = numberFormatt($record->qty->number, $refcurrency['decimals']);
        
        //Ordenamos el total
        $record->total = new stdClass();
        $record->total->number = (float)$row['ordertotal'];
        $record->total->formatted = numberFormatt($record->total->number, $currency['decimals']);
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    /*  Funcion para determinar el orden de los resultados
    *   Esta recibe un parametro que retorna dependiendo del valor:
    *   1 = Fecha de la orden ASCENDENTE
    *   2 = Nombre del usuario de la orden ASCENDENTE
    *   3 = Email del usuario de la orden ASCENDENTE
    *   4 = Moneda de la orden ASCENDENTE
    *   5 = status de la orden ASCENDENTE
    *   6 = Monto(price) de la orden ASCENDENTE
    *   7 = Tipo de la orden(market/limit) ASCENDENTE
    *   -1 = Fecha de la orden DESCENDENTE
    *   -2 = Nombre del usuario de la orden DESCENDENTE
    *   -3 = Email del usuario de la orden DESCENDENTE
    *   -4 = Moneda de la orden DESCENDENTE
    *   -5 = status de la orden DESCENDENTE
    *   -6 = Monto(price) de la orden DESCENDENTE
    *   -7 = Tipo de la orden(market/limit) DESCENDENTE
    */
    function determinateOrder($order){
        $str = "";
        
        switch($order){
            case 1:
                $str = "ORDER BY createddate ASC";
                break;
            case 2:
                $str = "ORDER BY name ASC, secondname ASC";
                break;
            case 3:
                $str = "ORDER BY usr ASC";
                break;
            case 4:
                $str = "ORDER BY paircurrency ASC";
                break;
            case 5:
                $str = "ORDER BY statusorder ASC";
                break;
            case 6:
                $str = "ORDER BY ordertotal ASC";
                break;
            case 7:
                $str = "ORDER BY ordertype ASC";
                break;
            case -1:
                $str = "ORDER BY createddate DESC";
                break;
            case -2:
                $str = "ORDER BY name DESC, secondname DESC";
                break;
            case -3:
                $str = "ORDER BY usr DESC";
                break;
            case -4:
                $str = "ORDER BY paircurrency DESC";
                break;
            case -5:
                $str = "ORDER BY statusorder DESC";
                break;
            case -6:
                $str = "ORDER BY ordertotal DESC";
                break;
            case -7:
                $str = "ORDER BY ordertype DESC";
                break;
            default:
                $str = "ORDER BY createddate DESC";
                break;
        }
        
        return $str;
    }
    
    /*  Funcion para determinar el orden de los resultados
    *   Esta recibe un parametro que retorna dependiendo del valor:
    *   1 = Hoy
    *   2 = Ultimos 7 Dias
    *   3 = Ultimos 30 dias
    *   4 = Ultimos 3 meses
    *   5 = Ultimos 6 meses
    */
    function determinateRange($range){
        $str = "";
        
        switch($range){
            case 1:
                $str = " AND o.date >= DATE_ADD(NOW(), INTERVAL -1 DAY)";
                break;
            case 2:
                $str = " AND o.date >= DATE_ADD(NOW(), INTERVAL -7 DAY)";
                break;
            case 3:
                $str = " AND o.date >= DATE_ADD(NOW(), INTERVAL -30 DAY)";
                break;
            case 4:
                $str = " AND o.date >= DATE_ADD(NOW(), INTERVAL -90 DAY)";
                break;
            case 5:
                $str = " AND o.date >= DATE_ADD(NOW(), INTERVAL -6 MONTH)";
                break;
            default: 
                badEnd("500", array("msg"=>"El parametro fecha solo puede ser 0, 1, 2, 3, 4 o 5"));
                break;
        }
        
        return $str;
    }
?>
