<?php
// cms/api/users/entry

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 18))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    
    //Consultamos los registros que sean type = 0(usuarios)
    $sql = "SELECT * FROM cmsusers".
    "       WHERE type = 0 AND id = ".$id;
    if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
    //Ordenamos los valores
    $row = $rs->fetch_assoc();
    
    //Si el dato no existe retornamos 204
    if($row["name"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    $out->entry = new stdClass();
    $out->entry->id = (int)$row["id"];
    $out->entry->name = $row["name"];
    $out->entry->email = $row["usr"];
        
    $out->entry->status = new stdClass();
    $out->entry->status->id = (int)$row["status"];
    $out->entry->status->dsc =  $out->entry->status->id == 1 ? "Activo" : "Inactivo";
        
    $out->entry->rol = $row["rolid"] == 0 ? null : new stdClass();
        
    //Si el rol es distinto a null, consultamos sus datos
    if($out->entry->rol != null){
        $sql = "SELECT * FROM cmsusers WHERE type = 1 AND id =".$row["rolid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
                
        $rowrol = $res->fetch_assoc();
            
        $out->entry->rol->id = (int)$rowrol["id"];
        $out->entry->rol->name = $rowrol["name"];
        
        // Verificamos que coindidan los privilegios del usuario a los del rol
        $rolmodified = false;
        if ($row["rolid"]){
            // Calculamos rol
            $sql2 = "SELECT SUM(privilegeid) suma, COUNT(*) qty " . 
            "       FROM   userprivileges " .
            "       WHERE  userid=" . $row["rolid"];
            if (!$rs2 = $db->query($sql2))
                badEnd("500", array("msg"=>$db->error));
                
            $suma = 0;
            $qty = 0;
            if ($row2 = $rs2->fetch_assoc()){
                $suma = $row2["suma"];
                $qty = $row2["qty"];
            }
                
            // Calculamos usuario
            $sql2 = "SELECT SUM(privilegeid) suma, COUNT(*) qty " . 
            "       FROM   userprivileges " .
            "       WHERE  userid=" . $row["id"];
            if (!$rs2 = $db->query($sql2))
                badEnd("500", array("msg"=>$db->error));
                    
                
            $rolmodified = false;
                
            //Si la cantidad es distinta fue modificado
            if ($row2 = $rs2->fetch_assoc()){
                $rolmodified =  !($suma == $row2["suma"] && $qty == $row2["qty"]);
            }
        }
            
        $out->entry->rol->rolmodified = (boolean) $rolmodified;
        
    }
        
    //Formateamos la fecha quitandole las horas
    $out->entry->datecreated = date("Y-m-d", strtotime($row["datecreated"]));
    
    //Retornamos los privilegios del usuario en este modulo
    $access = new stdClass;
    $access->create = tienePrivilegio($db, $sessionid, 15);
    $access->read =   tienePrivilegio($db, $sessionid, 18);
    $access->update = tienePrivilegio($db, $sessionid, 16);
    $access->delete = tienePrivilegio($db, $sessionid, 17);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
