<?php
// app/api/orders/insert

    header("Content-Type:application/json");
    include_once("../dbconn.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","pairid","qty","type","side");
    if (!parametrosValidos($_POST, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass();
    $sessionid = $_POST["sessionid"];
    $pairid = $_POST["pairid"];
    $qty = $_POST["qty"];
    $type = $_POST["type"];
    $side = $_POST["side"];
    $price = 0;
    
    //Validamos la session
    $userid = isSessionValid($db, $sessionid);
    
    //Validamos el si el usuario puede hacer operaciones
    isLevelValid($db, $userid);
    
    if($qty == 0){
        badEnd("403", array("msg"=>"La cantidad debe ser mayor a 0"));
    }
    
    //SI el precio es enviado, guardamos el valor
    if($type == 2){
        if(isset($_POST["price"]) && $_POST["price"] != ""){
            if($_POST['price'] == 0){
                badEnd("403", array("msg"=>"El precio debe ser mayor a 0"));
            }
            $price = $_POST["price"];
        }else{
            badEnd("400", array("msg"=>"Si la operacion es limit el precio es requerido"));
        }
    }
    
    
    //Consultamos los datos del par
    $sql = "SELECT * FROM pairs WHERE id = ".$pairid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $pairdata = $rs->fetch_assoc();
    
    //Validamos que el usuario posea cuentas con las monedas del par
    $sql = "SELECT COUNT(accounts.id) AS qty FROM accounts ".
    "       WHERE accounts.userid = ". $userid.
    "       AND accounts.paymentmethodid = -1 ".
    "       AND (accounts.currencyid = ".$pairdata['refcurrencyid'].
    "       OR accounts.currencyid = ".$pairdata['currencyid'].")";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
    
    //Si la cantidad es menor a 2, retornamos error 403-Usuario no posee una cuenta
    if($row['qty'] < 2){
        badEnd('403', array('msg'=>'Usuario no posee una cuenta para realizar la operación'));
    }
    
    validateBalance($userid, $db, $side, $pairdata, $qty, $price);
    
    //Obtenemos los datos de la cuenta del usuario para account
    $sql = "SELECT * FROM accounts".
    "       WHERE userid = ".$userid.
    "       AND accounts.paymentmethodid = -1".
    "       AND accounts.currencyid = ".$pairdata["refcurrencyid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $accountdata = $rs->fetch_assoc();
    
    //Obtenemos los datos de la cuenta del usuario para paymentaccount
    $sql = "SELECT * FROM accounts".
    "       WHERE userid = ".$userid.
    "       AND accounts.paymentmethodid = -1".
    "       AND accounts.currencyid = ".$pairdata["currencyid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $paymentaccountdata = $rs->fetch_assoc();
    
    //SI la operacion es del tipo market, consultamos la mejor oferta dependiendo de si es compra o venta
    if($side == 1 && $type == 1){
        
        //Consultamos que exista una venta
        $sql = "SELECT COUNT(o.id) as qty FROM orders o 
               WHERE o.side = 2 AND o.pairid = ".$pairid."
               AND (SELECT SUM(ord.quantity - (
                       IF( 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), 
                       0 
                   ))) FROM orders ord 
                   WHERE (CASE 
                           WHEN ord.canceled IS NOT NULL THEN -1 
                           WHEN (SELECT SUM(ABS(transactions.amount)) 
                               FROM transactions, orders 
                               WHERE orders.id = transactions.orderid 
                               AND orders.id = ord.id 
                               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) 
                               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity 
                               AND ord.canceled IS NULL THEN 1 
                           ELSE 0 
                           END) = 0 
                   AND ord.pairid = ".$pairid."
                   AND ord.side = 2 ) >= ".$qty."
               AND (CASE 
                       WHEN o.canceled IS NOT NULL THEN -1 
                       WHEN (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity 
                           AND o.canceled IS NULL THEN 1 
                       ELSE 0 
                   END) = 0";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        if($row['qty'] == 0){
            $sql = "SELECT (SELECT SUM(ord.quantity - (
                       IF( 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), 
                       0 
                   ))) FROM orders ord 
                   WHERE (CASE 
                           WHEN ord.canceled IS NOT NULL THEN -1 
                           WHEN (SELECT SUM(ABS(transactions.amount)) 
                               FROM transactions, orders 
                               WHERE orders.id = transactions.orderid 
                               AND orders.id = ord.id 
                               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) 
                               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity 
                               AND ord.canceled IS NULL THEN 1 
                           ELSE 0 
                           END) = 0 
                   AND ord.pairid = ".$pairid."
                  AND ord.side = 2 ) as qty FROM orders o 
               WHERE o.side = 2 AND o.pairid = ".$pairid."
              AND (CASE 
                      WHEN o.canceled IS NOT NULL THEN -1 
                       WHEN (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity 
                           AND o.canceled IS NULL THEN 1 
                       ELSE 0 
                   END) = 0";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                $row = $rs->fetch_assoc();
                
                if($row['qty'] == 0){
                    badEnd('406', array('msg'=>'No hay liquidez, espere o coloque una orden tipo lmite'));
                }else{
                    badEnd('402',array('msg'=>'Liquidez insuficiente','avaliable'=>(float)$row['qty']));
                }
        }
        
        //Consultamos el mejor precio de venta
        $sql = "SELECT o.id, o.price FROM orders o ".
        "       WHERE o.side = 2 AND o.pairid = ".$pairid.
        "       AND (CASE ".
        "               WHEN o.canceled IS NOT NULL THEN -1 ".
        "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "                   FROM transactions, orders ".
        "                   WHERE orders.id = transactions.orderid ".
        "                   AND orders.id = o.id ".
        "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "                   AND o.canceled IS NULL THEN 1 ".
        "               ELSE 0 ".
        "           END) = 0 ".
        "       ORDER BY o.price DESC";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        $price = $row["price"];
        
        validateBalance($userid, $db, $side, $pairdata, $qty, $price);
    }else if($side == 2 && $type == 1){
        // Consultamos que exista una venta
        $sql = "SELECT COUNT(o.id) as qty FROM orders o 
               WHERE o.side = 1 AND o.pairid = ".$pairid."
               AND (SELECT SUM(ord.quantity - (
                       IF( 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), 
                       0 
                   ))) FROM orders ord 
                   WHERE (CASE 
                           WHEN ord.canceled IS NOT NULL THEN -1 
                           WHEN (SELECT SUM(ABS(transactions.amount)) 
                               FROM transactions, orders 
                               WHERE orders.id = transactions.orderid 
                               AND orders.id = ord.id 
                               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) 
                               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity 
                               AND ord.canceled IS NULL THEN 1 
                           ELSE 0 
                           END) = 0 
                   AND ord.pairid = ".$pairid."
                   AND ord.side = 1 ) >= ".$qty."
               AND (CASE 
                       WHEN o.canceled IS NOT NULL THEN -1 
                       WHEN (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity 
                           AND o.canceled IS NULL THEN 1 
                       ELSE 0 
                   END) = 0";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        if($row['qty'] == 0){
            $sql = "SELECT (SELECT SUM(ord.quantity - (
                       IF( 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), 
                       0 
                   ))) FROM orders ord 
                   WHERE (CASE 
                           WHEN ord.canceled IS NOT NULL THEN -1 
                           WHEN (SELECT SUM(ABS(transactions.amount)) 
                               FROM transactions, orders 
                               WHERE orders.id = transactions.orderid 
                               AND orders.id = ord.id 
                               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) 
                               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity 
                               AND ord.canceled IS NULL THEN 1 
                           ELSE 0 
                           END) = 0 
                   AND ord.pairid = ".$pairid."
                  AND ord.side = 1 ) as qty FROM orders o 
               WHERE o.side = 1 AND o.pairid = ".$pairid."
              AND (CASE 
                      WHEN o.canceled IS NOT NULL THEN -1 
                       WHEN (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity 
                           AND o.canceled IS NULL THEN 1 
                       ELSE 0 
                   END) = 0";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                $row = $rs->fetch_assoc();
                
                if($row['qty'] == 0){
                    badEnd('406', array('msg'=>'No hay liquidez, espere o coloque una orden tipo lmite'));
                }else{
                    badEnd('402',array('msg'=>'Liquidez insuficiente','avaliable'=>(float)$row['qty']));
                }
        }
        
        //Consultamos el mejor precio de compra
        $sql = "SELECT o.id, o.price FROM orders o".
        "       WHERE o.side = 1 AND o.pairid = ".$pairid.
        "       AND (CASE ".
        "               WHEN o.canceled IS NOT NULL THEN -1 ".
        "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "                   FROM transactions, orders ".
        "                   WHERE orders.id = transactions.orderid ".
        "                   AND orders.id = o.id ".
        "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "                   AND o.canceled IS NULL THEN 1 ".
        "               ELSE 0 ".
        "           END) = 0 ".
        "       ORDER BY o.price ASC";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        $price = $row["price"];
        validateBalance($userid, $db, $side, $pairdata, $qty, $price);
    }
    
    
    //SI la operacion es del tipo limit, verificamos el precio para cambiarlo o dejarlo
    if($side == 1 && $type == 2){
        //Consultamos el mejor precio de venta
        $sql = "SELECT o.id, o.price FROM orders o ".
        "       WHERE o.side = 2 AND o.pairid = ".$pairid.
        "       AND o.price >= ".$price.
        "       AND (CASE ".
        "               WHEN o.canceled IS NOT NULL THEN -1 ".
        "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "                   FROM transactions, orders ".
        "                   WHERE orders.id = transactions.orderid ".
        "                   AND orders.id = o.id ".
        "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "                   AND o.canceled IS NULL THEN 1 ".
        "               ELSE 0 ".
        "           END) = 0 ".
        "       ORDER BY o.price DESC".
        "       LIMIT 1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        if($price >= $row['price'] && $row['price'] != null){
            
            //Consultamos que exista una venta
            $sql = "SELECT COUNT(o.id) AS qty FROM orders o ".
            "       WHERE o.side = 2 AND o.pairid = ".$pairid.
            "       AND (SELECT SUM(ord.quantity) FROM orders ord ".
            "           WHERE (CASE ".
            "                   WHEN ord.canceled IS NOT NULL THEN -1 ".
            "                   WHEN (SELECT SUM(ABS(transactions.amount)) ".
            "                       FROM transactions, orders ".
            "                       WHERE orders.id = transactions.orderid ".
            "                       AND orders.id = ord.id ".
            "                       AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) ".
            "                       AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity ".
            "                       AND ord.canceled IS NULL THEN 1 ".
            "                   ELSE 0 ".
            "                   END) = 0 ".
            "           AND ord.pairid = ".$pairid.
            "           AND ord.side = 2 ) >= ".$qty.
            "       AND (CASE ".
            "               WHEN o.canceled IS NOT NULL THEN -1 ".
            "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
            "                   FROM transactions, orders ".
            "                   WHERE orders.id = transactions.orderid ".
            "                   AND orders.id = o.id ".
            "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
            "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
            "                   AND o.canceled IS NULL THEN 1 ".
            "               ELSE 0 ".
            "           END) = 0 ";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $row = $rs->fetch_assoc();
            
            if($row['qty'] == 0){
                $sql = "SELECT (SELECT SUM(ord.quantity - (
                       IF( 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), 
                       0 
                   ))) FROM orders ord 
                   WHERE (CASE 
                           WHEN ord.canceled IS NOT NULL THEN -1 
                           WHEN (SELECT SUM(ABS(transactions.amount)) 
                               FROM transactions, orders 
                               WHERE orders.id = transactions.orderid 
                               AND orders.id = ord.id 
                               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) 
                               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity 
                               AND ord.canceled IS NULL THEN 1 
                           ELSE 0 
                           END) = 0 
                   AND ord.pairid = ".$pairid."
                  AND ord.side = 2 ) as qty FROM orders o 
               WHERE o.side = 2 AND o.pairid = ".$pairid."
              AND (CASE 
                      WHEN o.canceled IS NOT NULL THEN -1 
                       WHEN (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity 
                           AND o.canceled IS NULL THEN 1 
                       ELSE 0 
                   END) = 0";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                $row = $rs->fetch_assoc();
                
                if($row['qty'] == 0){
                    badEnd('406', array('msg'=>'No hay liquidez, espere o coloque una orden tipo lmite'));
                }else{
                    badEnd('402',array('msg'=>'Liquidez insuficiente','avaliable'=>(float)$row['qty']));
                }
            }
            
            //Consultamos el mejor precio de venta
            $sql = "SELECT o.id, o.price FROM orders o ".
            "       WHERE o.side = 2 AND o.pairid = ".$pairid.
            "       AND (CASE ".
            "               WHEN o.canceled IS NOT NULL THEN -1 ".
            "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
            "                   FROM transactions, orders ".
            "                   WHERE orders.id = transactions.orderid ".
            "                   AND orders.id = o.id ".
            "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
            "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
            "                   AND o.canceled IS NULL THEN 1 ".
            "               ELSE 0 ".
            "           END) = 0 ".
            "       ORDER BY o.price DESC";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $row = $rs->fetch_assoc();
            
            $price = $row["price"];
            $type = 1;
            validateBalance($userid, $db, $side, $pairdata, $qty, $price);
        }
    }else if($side == 2 && $type == 2){
        //Consultamos el mejor precio de compra
        $sql = "SELECT o.id, o.price FROM orders o ".
        "       WHERE o.side = 1 AND o.pairid = ".$pairid.
        "       AND o.price <= ".$price.
        "       AND (CASE ".
        "               WHEN o.canceled IS NOT NULL THEN -1 ".
        "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
        "                   FROM transactions, orders ".
        "                   WHERE orders.id = transactions.orderid ".
        "                   AND orders.id = o.id ".
        "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
        "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
        "                   AND o.canceled IS NULL THEN 1 ".
        "               ELSE 0 ".
        "           END) = 0 ".
        "       ORDER BY o.price ASC".
        "       LIMIT 1";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        if($price <= $row['price'] && $row['price'] != null){
             // Consultamos que exista una venta
            $sql = "SELECT  COUNT(o.id) AS qty FROM orders o".
            "       WHERE o.side = 1 AND o.pairid = ".$pairid.
            "       AND (SELECT SUM(ord.quantity) FROM orders ord ".
            "           WHERE (CASE ".
            "                   WHEN ord.canceled IS NOT NULL THEN -1 ".
            "                   WHEN (SELECT SUM(ABS(transactions.amount)) ".
            "                       FROM transactions, orders ".
            "                       WHERE orders.id = transactions.orderid ".
            "                       AND orders.id = ord.id ".
            "                       AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) ".
            "                       AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity ".
            "                       AND ord.canceled IS NULL THEN 1 ".
            "                   ELSE 0 ".
            "                   END) = 0 ".
            "           AND ord.pairid = ".$pairid.
            "           AND ord.side = 1 ) >= ".$qty.
            "       AND (CASE ".
            "               WHEN o.canceled IS NOT NULL THEN -1 ".
            "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
            "                   FROM transactions, orders ".
            "                   WHERE orders.id = transactions.orderid ".
            "                   AND orders.id = o.id ".
            "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
            "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
            "                   AND o.canceled IS NULL THEN 1 ".
            "               ELSE 0 ".
            "           END) = 0 ";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $row = $rs->fetch_assoc();
        
            if($row['qty'] == 0){
                $sql = "SELECT (SELECT SUM(ord.quantity - (
                       IF( 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, 
                       (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), 
                       0 
                   ))) FROM orders ord 
                   WHERE (CASE 
                           WHEN ord.canceled IS NOT NULL THEN -1 
                           WHEN (SELECT SUM(ABS(transactions.amount)) 
                               FROM transactions, orders 
                               WHERE orders.id = transactions.orderid 
                               AND orders.id = ord.id 
                               AND IF(ord.side = 2, transactions.amount > 0, transactions.amount < 0) 
                               AND transactions.accountid = (CASE WHEN ord.side = 1 THEN ord.accountid ELSE ord.paymentid END)) >= ord.quantity 
                               AND ord.canceled IS NULL THEN 1 
                           ELSE 0 
                           END) = 0 
                   AND ord.pairid = ".$pairid."
                  AND ord.side = 1 ) as qty FROM orders o 
               WHERE o.side = 1 AND o.pairid = ".$pairid."
              AND (CASE 
                      WHEN o.canceled IS NOT NULL THEN -1 
                       WHEN (SELECT SUM(ABS(transactions.amount)) 
                           FROM transactions, orders 
                           WHERE orders.id = transactions.orderid 
                           AND orders.id = o.id 
                           AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) 
                           AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity 
                           AND o.canceled IS NULL THEN 1 
                       ELSE 0 
                   END) = 0";
                if (!$rs=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                
                $row = $rs->fetch_assoc();
                
                if($row['qty'] == 0){
                    badEnd('406', array('msg'=>'No hay liquidez, espere o coloque una orden tipo lmite'));
                }else{
                    badEnd('402',array('msg'=>'Liquidez insuficiente','avaliable'=>(float)$row['qty']));
                }
            }
        
            //Consultamos el mejor precio de compra
            $sql = "SELECT o.id, o.price FROM orders o".
            "       WHERE o.side = 1 AND o.pairid = ".$pairid.
            "       AND (CASE ".
            "               WHEN o.canceled IS NOT NULL THEN -1 ".
            "               WHEN (SELECT SUM(ABS(transactions.amount)) ".
            "                   FROM transactions, orders ".
            "                   WHERE orders.id = transactions.orderid ".
            "                   AND orders.id = o.id ".
            "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
            "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
            "                   AND o.canceled IS NULL THEN 1 ".
            "               ELSE 0 ".
            "           END) = 0 ".
            "       ORDER BY o.price ASC";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $row = $rs->fetch_assoc();
        
            $price = $row["price"];
            $type = 1;
            validateBalance($userid, $db, $side, $pairdata, $qty, $price);
        }
    }
    
    //Insertamos la orden
    $db->autocommit(FALSE);
    
    $sql = "INSERT INTO orders ".
    "       ( pairid, ".
    "       quantity, side, ".
    "       type, price, ".
    "       total, ".
    "       date, accountid, ".
    "       paymentid, canceled )".
    "       VALUES (".
    "       ".$pairid.", ".
    "       ".$qty.", ".$side.", ".
    "       ".$type.", ".$price.", ".
    "       ".($qty * $price).", ".
    "       NOW(), ".($side == 1 ? $accountdata['id'] : $paymentaccountdata['id']).", ".
    "       ".($side == 2 ? $accountdata['id'] : $paymentaccountdata['id']).", NULL".
    "       )";
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    //Guardamos el id de la transaccion de deposito
    $out->id = (int)$db->insert_id;
    
    //auditoria
    setAudit($db, "ORDENES", $sessionid, "APP", "El usuario ".$userid." creo la orden ".$out->id);
    
    $db->commit();
    
    if($type == 1){
        $db->autocommit(TRUE);
        require("../exchanges/match.php");
    }else{
        $db->close();
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function validateBalance($userid, $db, $side, $pairdata, $qty, $price){
        //Validar cantidad o monto dependiendo del side
        if($side == 1){
            //Al ser una venta, validamos que el usuario posea la cantidad indicada de la moneda ref del par
            //Consultamos el balance total del usuario actual
            $sql = "SELECT SUM(transactions.amount) as qty ".
            "       FROM accounts, transactions".
	        "       WHERE accounts.id = transactions.accountid AND accounts.userid = ".$userid.
	        "       AND accounts.paymentmethodid = -1".
	        "       AND accounts.currencyid = ".$pairdata["refcurrencyid"];
	        if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        
            $row = $rs->fetch_assoc();
        
            //Consultamos el balance por sus ordenes
            $sql = "SELECT SUM(amount) AS qty ".
            "       FROM ( ".
            "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
            "           FROM orders, accounts ".
            "           WHERE accounts.id = orders.accountid ".
	        "           AND orders.canceled IS NULL ".
	        "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
	        "           AND accounts.userid = ".$userid.
	        "           AND accounts.paymentmethodid = -1 ".
            "       UNION ALL ".
            "           SELECT SUM(transactions.amount) AS amount ".
            "           FROM transactions, orders, accounts ".
            "           WHERE orders.id = transactions.orderid ".
            "           AND accounts.id = transactions.accountid ".
	        "           AND orders.canceled IS NULL ".
	        "           AND accounts.currencyid = ".$pairdata["refcurrencyid"].
	        "           AND accounts.userid = ".$userid.
	        "           AND accounts.paymentmethodid = -1".
	        "           AND transactions.amount < 0".
            "       ) amount";
	        if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        
            $roworders = $rs->fetch_assoc();
    
            //Si el saldo es menor a cantidad*precio retornamos error 403-saldo insuficiente
            if(($row["qty"] - $roworders["qty"]) < $qty){
                badEnd('403', array('msg'=>'Cantidad insuficiente'));
            }
        }else if($side == 2){
            //Al ser una compra, validamos que el usuario posea la cantidad*precio de la moneda base
            //Consultamos el balance total del usuario actual
            $sql = "SELECT SUM(transactions.amount) as qty ".
            "       FROM accounts, transactions".
	        "       WHERE accounts.id = transactions.accountid AND accounts.userid = ".$userid.
	        "       AND accounts.paymentmethodid = -1".
	        "       AND accounts.currencyid = ".$pairdata["currencyid"];
	        if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        
            $row = $rs->fetch_assoc();
        
            //Consultamos el balance por sus ordenes
            $sql = "SELECT SUM(amount) AS qty ".
            "       FROM ( ".
            "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
            "           FROM orders, accounts ".
            "           WHERE accounts.id = orders.accountid ".
	        "           AND orders.canceled IS NULL ".
	        "           AND accounts.currencyid = ".$pairdata["currencyid"].
	        "           AND accounts.userid = ".$userid.
	        "           AND accounts.paymentmethodid = -1 ".
            "       UNION ALL ".
            "           SELECT SUM(transactions.amount) AS amount ".
            "           FROM transactions, orders, accounts ".
            "           WHERE orders.id = transactions.orderid ".
            "           AND accounts.id = transactions.accountid ".
	        "           AND orders.canceled IS NULL ".
	        "           AND accounts.currencyid = ".$pairdata["currencyid"].
	        "           AND accounts.userid = ".$userid.
	        "           AND accounts.paymentmethodid = -1".
	        "           AND transactions.amount < 0".
            "       ) amount";
	        if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        
            $roworders = $rs->fetch_assoc();
    
            //Si el saldo es menor a cantidad*precio retornamos error 403-saldo insuficiente
            if(($row["qty"] - $roworders["qty"]) < ($price * $qty)){
                badEnd('403', array('msg'=>'Saldo insuficiente'));
            }
        
        }else{
            badEnd('500',array('msg'=>'El parametro side debe ser 1(venta) o 2(compra)'));
        }
    }
?>