<?php
// app/api/transactions/accept

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id","validator");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass;
    $sessionid = $_GET["sessionid"];
    $validator = $_GET["validator"];
    $id = $_GET["id"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Consultamos los datos de la transaccion
    $sql = "SELECT * FROM transactions WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $txdata = $rs->fetch_assoc();
    
    if($txdata["validator"] != $validator){
        badEnd("402", array("msg"=>"Código invalido"));
    }
    
    // Validamos que el codigo no este vencido
    $sql = "SELECT COUNT(id) AS qty FROM transactions ".
    "       WHERE id = ".$id.
    "       AND validthru > NOW()";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $txdata = $rs->fetch_assoc();
    
    if($txdata["qty"] == 0){
        badEnd("403", array("msg"=>"Código expirado"));
    }
    
    $db->autocommit(FALSE);

    //Actualizamos la transaccion
    $sql = "UPDATE transactions SET".
    "       amount = amount + amountghost, ".
    "       validthru = NULL, ".
    "       amountghost = 0, ".
    "       validator = NULL ".
    "       WHERE txid = ".$id.
    "       AND validthru > NOW()".
    "       AND validator = ".$validator;
    if (!$db->query($sql)){
        $error = $db->error;
        $db->rollback();
        $db->close();
        badEnd("500", array("msg"=>$error));
    }
    
    $db->commit();
    $db->close();
    
    $out->id = (int)$id;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>