<?php
// app/api/accounts/portafolio

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","parid");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(",", $parmsob)));
    }
    
    //Definicion de variables y almacenamiento de valores enviados por GET
    $out = new stdClass;
    $sessionid = $_GET["sessionid"];
    $parid = $_GET["parid"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Obtenemos el id del usuario
    $sql = "SELECT id, usr FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    $userid = $row["id"];
    
    //Obtenemos los datos del par para buscar las monedas
    $sql = "SELECT * FROM pairs WHERE id = ".$parid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Guardamos los datos
    $pairdata = $rs->fetch_assoc();
    
    //Consultamos la cantidad de registros que existen
    $sql = "SELECT count(id) AS qty FROM accounts WHERE userid = ".$userid.
    "       AND (currencyid = ".$pairdata["refcurrencyid"].
    "       OR currencyid = ".$pairdata["currencyid"].")".
    "       AND paymentmethodid = -1".
    "       ".$limit;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Retornamos el total de registros
    $row = $rs->fetch_assoc();
    $out->numofrecords = (int)$row["qty"];
    
    //Consultamos el balance total del usuario actual
    //Por sus movimientos
    $sql = "SELECT SUM(transactions.amount) as qty ".
    "       FROM accounts, transactions".
	"       WHERE accounts.id = transactions.accountid ".
	"       AND (accounts.currencyid = ".$pairdata["refcurrencyid"].
    "       OR accounts.currencyid = ".$pairdata["currencyid"].")".
	"       AND accounts.userid = ".$userid.
	"       AND accounts.paymentmethodid = -1";
	if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $rowtx = $rs->fetch_assoc();
    
    //Consultamos el balance por sus ordenes
    $sql = "SELECT SUM(amount) AS qty ".
    "       FROM ( ".
    "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
    "           FROM orders, accounts ".
    "           WHERE accounts.id = orders.accountid ".
	"           AND orders.canceled IS NULL ".
	"           AND (accounts.currencyid = ".$pairdata["refcurrencyid"].
    "           OR accounts.currencyid = ".$pairdata["currencyid"].")".
	"           AND accounts.userid = ".$userid.
	"           AND accounts.paymentmethodid = -1 ".
    "       UNION ALL ".
    "           SELECT SUM(transactions.amount) AS amount ".
    "           FROM transactions, orders, accounts ".
    "           WHERE orders.id = transactions.orderid ".
    "           AND accounts.id = transactions.accountid ".
	"           AND orders.canceled IS NULL ".
	"           AND (accounts.currencyid = ".$pairdata["refcurrencyid"].
    "           OR accounts.currencyid = ".$pairdata["currencyid"].")".
	"           AND accounts.userid = ".$userid.
	"           AND accounts.paymentmethodid = -1".
	"           AND transactions.amount < 0".
    "       ) amount";
	if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $roworders = $rs->fetch_assoc();
    
    //Guardamos el valor
    $out->total = new stdClass();
	$out->total->number = (float)($rowtx["qty"] - $roworders["qty"]);
	$out->total->formatted = numberFormatt($out->total->number,2);
    
    //Consultamos los datos requeridos
    $sql = "SELECT * FROM accounts WHERE userid = ".$userid.
    "       AND paymentmethodid = -1".
    "       AND (currencyid = ".$pairdata["refcurrencyid"].
    "       OR currencyid = ".$pairdata["currencyid"].") ".
    "       ".$limit;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        //Guardamos el id de la cuenta
        $record->id = (int)$row["id"];
        
        //Metodo de pago
        $record->paymentmethod = new stdClass();
        $record->paymentmethod->id = (int)$row["paymentmethodid"];
        
        //Consultamos el nombre del metodo de pago
        $sql = "SELECT dsc ".
        "       FROM paymentmethods ".
        "       WHERE id = ".$row["paymentmethodid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $payment = $res->fetch_assoc();
        //Guardamos el nombre del metodo de pago
        $record->paymentmethod->dsc = $payment["dsc"];

        //Moneda de la cuenta
        $record->currency = new stdClass();
        $record->currency->id = (int)$row["currencyid"];
        
        //Consultamos los datos de la moneda
        $sql = "SELECT * FROM currencies WHERE id = ".$row["currencyid"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $currency = $res->fetch_assoc();
        //Guardamos los detalles de la moneda
        $record->currency->dsc = $currency["name"];
        $record->currency->symbol = $currency["symbol"];
        $record->currency->decimals = (int)$currency["decimals"];
        
        $sql = "SELECT SUM(amount) as qty FROM transactions WHERE accountid = ".$record->id;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $balancetx = $res->fetch_assoc();
        
        $sql = "SELECT SUM(amount) AS qty ".
        "       FROM ( ".
        "           SELECT SUM(CASE WHEN orders.side = 1 THEN orders.quantity ELSE orders.total END) AS amount ".
        "           FROM orders ".
        "           WHERE orders.accountid = ".$record->id.
	    "           AND orders.canceled IS NULL ".
        "       UNION ALL ".
        "           SELECT SUM(transactions.amount) AS amount ".
        "           FROM transactions, orders ".
        "           WHERE orders.id = transactions.orderid ".
        "           AND transactions.accountid = ".$record->id.
	    "           AND orders.canceled IS NULL ".
	    "           AND transactions.amount < 0".
        "       ) amount";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $balanceorder = $res->fetch_assoc();
        
        //Balance a partir de las transacciones
        $record->balance = new stdClass();
        $record->balance->number = (float)($balancetx["qty"] - $balanceorder["qty"]);
        $record->balance->formatted = numberFormatt($record->balance->number,$currency["decimals"]);
        
        //Porcentaje que representa
        $record->pct = new stdClass();
        $record->pct->number = $record->balance->number < 1 || $out->total->number < 1 ? null : round($record->balance->number / ($out->total->number / 100),2);
        $record->pct->formatted = $record->balance->number < 1 || $out->total->number< 1 ? null : $record->pct->number."%";
        
        //Datos de la cuenta
        $record->status = (int)$row["status"];
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
