<?php
// cms/api/appusers/validate

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //ARREGLO CON CAMPOS DE CADA PASO PERSON
    $questionperson = array(
        "1"=>"fname,sname,flastname,slastname,doc,doctype,doccountryid,docissue,docexpiry,gender,maritalstatus,birthdate,birthcountryid,phone,american,venezuelan",
        "2"=>"countryid,regionid,cityid,street,domicile,postalcode",
        "3"=>"ocupation,economicactivity,politicallyexposed,independentdealer,company,anualincome,patrimony,profession,affiliationbody,positionheld,pepcountryid,peprelatedid",
        "5"=>"qtymonthlyop,prefertypeop,amountmonthlyop,economicrelation"
    );
    $uploadsperson = array("4"=>"1,2,3,8,9");
    $maxstepperson = 7;
    
    //ARREGLO CON CAMPOS DE CADA PASO COMPANY
    $questioncompany = array(
        "1"=>"ctype,doc,name,comercialname,creationdate,doccountryid,docregionid,doccityid,postalcode,phone,website,partners,venezuelan",
        "3"=>"countryid,regionid,cityid,street,domicile,branchoffices",
        "4"=>"economicactivity,anualincome,patrimony,politicallyexposed",
        "6"=>"qtymonthlyop,prefertypeop,amountmontlyop,economicrelation"
    );
    $uploadscompany = array("5"=>"4,5,6,7,9,10");
    $questionpartners = array("2"=>"name,doc,phone,politicallyexposed,affiliationbody,positionheld,pepcountryid,peprelatedid");
    $maxstepcompany = 8;
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 27))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    //Consultamos si el usuario existe
    $sql = "SELECT id, type FROM users".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $userdata = $rs->fetch_assoc();
    
    if($userdata["id"] == null){
        badEnd("204", array("msg"=>"Registro no encontrado"));
    }
    
    //Arreglo con los id de imagenes que tenemos
    $arruploadids = array();
    
    //Si recibimos los id de los archivos aprobados, ejecutamos el query
    if(isset($_GET["approveduploadids"]) && $_GET["approveduploadids"] != ""){
        $approveduploads = explode("-",$_GET["approveduploadids"]);
        
        //A cada id se le coloca a validated el valor 1
        foreach($approveduploads as $approvedupload){
            $sql = "UPDATE useruploads SET".
            "       validated = 1 ".
            "       WHERE prefuploadid = ".$approvedupload.
            "       AND userid = ".$id;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            array_push($arruploadids, $approvedupload);
        }
    }
    
    //Si recibimos los id de los archivos rechazados, ejecutamos el query
    if(isset($_GET["rejecteduploadids"]) && $_GET["rejecteduploadids"] != ""){
        $rejecteduploads = explode("-",$_GET["rejecteduploadids"]);
        
        //Validamos el tipo de usuario para determinar el paso
        foreach($rejecteduploads as $rejectedupload){
            if($userdata["type"] == 1){
                foreach($uploadsperson as $index => $uploadperson){
                    $uploadidsperson = explode(",",$uploadperson);
                    foreach($uploadidsperson as $uploadid){
                        if($rejectedupload == $uploadid){
                            $maxstepperson = $index;
                        }
                    }
                }
            }else if($userdata["type"] == 2){
                foreach($uploadscompany as $index => $uploadcompany){
                    $uploadidscompany = explode(",",$uploadcompany);
                    foreach($uploadidscompany as $uploadid){
                        if($rejectedupload == $uploadid){
                            $maxstepcompany = $index;
                        }
                    }
                }
            }
            
            $sql = "UPDATE useruploads SET".
            "       validated = -1 ".
            "       WHERE prefuploadid = ".$rejectedupload.
            "       AND userid = ".$id;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            array_push($arruploadids, $rejectedupload);
        }
    }
    
    //Consultamos todos los id del usuario
    $sql = "SELECT * FROM useruploads".
    "       WHERE userid = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    while($row = $rs->fetch_assoc()){
        $isNot = false;
        
        foreach($arruploadids as $uploadid){
            if($uploadid == $row["prefuploadid"]){
                $isNot = true;
            }
        }
        
        if(!$isNot){
            $sql = "UPDATE useruploads SET".
            "       validated = 0 ".
            "       WHERE prefuploadid = ".$row["prefuploadid"].
            "       AND userid = ".$id;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        }
    }
    
    //Si recibimos los campos aprobados de la persona, guardamos la cadena completa
    if(isset($_GET["approved"])){
        
        if($userdata["type"] == 1){
            
            $sql = "UPDATE userpersons SET".
            "       approved = '".$_GET["approved"]."'".
            "       WHERE usrid = ".$id;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
        }else if($userdata["type"] == 2){
            
            $sql = "UPDATE usercompanies SET".
            "       approved = '".$_GET["approved"]."'".
            "       WHERE usrid = ".$id;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
        }
    }
    
    if(isset($_GET["rejected"])){
        
        if($userdata["type"] == 1){
            
            foreach($questionperson as $index => $questionlabel){
                $questionlabelarr = explode(",",$questionlabel);
                $rejectedfields = explode(",",$_GET["rejected"]);
                
                foreach($rejectedfields as $fieldreject){
                    foreach($questionlabelarr as $labelquestion){
                        if(!empty($fieldreject)){
                            if(strpos($fieldreject, $labelquestion) !== false && $maxstepperson > $index){
                                $maxstepperson = $index;
                            }
                        }
                    }
                }
            }
            
            $sql = "UPDATE userpersons SET".
            "       rejected = '".$_GET["rejected"]."',".
            "       step = ".$maxstepperson." ".
            "       WHERE usrid = ".$id;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
    
        }else if($userdata["type"] == 2){
            
            foreach($questioncompany as $index => $questionlabel){
                $questionlabelarr = explode(",",$questionlabel);
                $rejectedfields = explode(",",$_GET["rejected"]);
                
                foreach($rejectedfields as $fieldreject){
                    foreach($questionlabelarr as $labelquestion){
                        if(!empty($fieldreject)){
                            if(strpos($fieldreject, $labelquestion) !== false && $maxstepcompany > $index){
                                $maxstepcompany = $index;
                            }
                        }
                    }
                }
            }
            
            $sql = "UPDATE usercompanies SET".
            "       rejected = '".$_GET["rejected"]."',".
            "       step = ".$maxstepcompany." ".
            "       WHERE usrid = ".$id;
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));

        }
        
    }
    
    //Si recibimos los id de las cuentas, ejecutamos el query
    if(isset($_GET["accountids"]) && $_GET["accountids"] != ""){
        $accountids = explode("-",$_GET["accountids"]);
        $approved = "";
        $rejected = "";
        foreach($accountids as $indexprin => $accountid){
            if(isset($_GET["account".($indexprin + 1)]) && $_GET["account".($indexprin + 1)] != ""){
                $validRejected = explode("|", $_GET["account".($indexprin + 1)]);
                foreach($validRejected as $indexsecu => $field){
                    $fields = explode(",", $field);
                    if($indexsecu == 0){
                        $approved = "";
                        foreach($fields as $validatedField){
                            if($validatedField != ""){
                                $approved .= "".$validatedField.",";
                            }
                        }
                    }else if($indexsecu == 1){
                        $rejected = "";
                        foreach($fields as $rejectedField){
                            if($rejectedField != ""){
                                $rejected .= "".$rejectedField.",";
                            }
                        }
                    }
                }
                
                //Actualizamos los datos de la cuenta
                $sql = "UPDATE accounts SET ".
                "       approved = ".($approved == "" ? "NULL" : "'".(substr($approved, 0, -1))."'").", ".
                "       rejected = ".($rejected == "" ? "NULL" : "'".(substr($rejected, 0, -1))."'")." ".
                "       WHERE id = ".$accountid;
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
            }
        }
    }
    
    //Si recibimos los id de los socios, ejecutamos el query
    if(isset($_GET["partnerids"]) && $_GET["partnerids"] != ""){
        $partnerids = explode("-",$_GET["partnerids"]);
        $approved = "";
        $rejected = "";
        foreach($partnerids as $indexprin => $partnerid){
            if(isset($_GET["partner".($indexprin + 1)]) && $_GET["partner".($indexprin + 1)] != ""){
                $validRejected = explode("|", $_GET["partner".($indexprin + 1)]);
                foreach($validRejected as $indexsecu => $field){
                    $fields = explode(",", $field);
                    if($indexsecu == 0){
                        $approved = "";
                        foreach($fields as $validatedField){
                            if($validatedField != ""){
                                $approved .= "".$validatedField.",";
                            }
                        }
                    }else if($indexsecu == 1){
                        $rejected = "";
                        foreach($fields as $rejectedField){
                            if($rejectedField != ""){
                                $rejected .= "".$rejectedField.",";
                            }
                        }
                    }
                }
                
                //Actualizamos los datos de la cuenta
                $sql = "UPDATE usercompanypartners SET ".
                "       approved = ".($approved == "" ? "NULL" : "'".(substr($approved, 0, -1))."'").", ".
                "       rejected = ".($rejected == "" ? "NULL" : "'".(substr($rejected, 0, -1))."'")." ".
                "       WHERE id = ".$partnerid;
                if (!$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
            }
        }
    }
    
    $out->id = (int)$id;
    
    // Obtenemos el correo del usuario para el mensaje
    $sql = "SELECT usr FROM users WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $userdata = $rs->fetch_assoc(); 
    
    //auditoria
    setAudit($db, "USUARIOS APP", $sessionid, "CMS", "Se validaron datos del usuario ".$userdata['usr']);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
