<?php
// api/exchanges/list

    header("Content-Type:application/json");
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    if (isset($_SERVER['HTTP_TOKENID']) && $_SERVER['HTTP_TOKENID'] == '')
        badEnd("400", array("msg"=>"Parametros obligatorios tokenid"));
        
    // parametros obligatorios
    $parmsob = array('offset','numofrec','parid');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out = new stdClass();
    // Obtener sessionid
    $sessionid = $_SERVER['HTTP_TOKENID'];
    $pairid = $_GET['parid'];
    $offset = $_GET['offset'];
    $numofrecords = $_GET['numofrec'];
    
    // Validamos la session
    isSessionValidAPI($db, $sessionid);
    
    // Consultamos si el par existe primero
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM pairs ".
    "       WHERE id = ".$pairid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    // Si es 0, significa que no existe el par
    if($row['qty'] == 0){
        badEnd('204','Registro no encontrado');
    }
    
    // Consultamos la cantidad de intercambios
    $sql = "SELECT SUM(num) AS qty FROM (".
    "   SELECT COUNT(orders.id) AS num ".
    "       FROM orders, accounts, users, userpersons, transactions t ".
    "           LEFT JOIN transactions tx ".
    "               ON t.orderid = tx.orderid ".
    "               AND t.txid = tx.txid ".
    "               AND tx.amount < 0 ".
    "               AND tx.dsc NOT LIKE 'Comisi%' ".
    "           LEFT JOIN transactions txother ".
    "               ON t.orderid != txother.orderid ".
    "               AND t.txid = txother.txid ".
    "               AND txother.amount > 0 ".
    "               AND txother.dsc NOT LIKE 'Comisi%' ".
    "       WHERE t.orderid IS NOT NULL ".
    "       AND orders.id = txother.orderid ".
    "       AND t.id = t.txid ".
    "       AND t.dsc NOT LIKE 'Comisi%' ".
    "       AND accounts.id = orders.accountid ".
    "       AND accounts.userid = users.id ".
    "       AND userpersons.usrid = users.id ".
    "".
    "           UNION ALL ".
    "".
    "   SELECT COUNT(orders.id) AS num ".
    "       FROM orders, accounts, users, usercompanies, transactions t ".
    "           LEFT JOIN transactions tx ".
    "               ON t.orderid = tx.orderid ".
    "               AND t.txid = tx.txid ".
    "               AND tx.amount < 0 ".
    "               AND tx.dsc NOT LIKE 'Comisi%'".
    "           LEFT JOIN transactions txother ".
    "               ON t.orderid != txother.orderid ".
    "               AND t.txid = txother.txid ".
    "               AND txother.amount > 0 ".
    "               AND txother.dsc NOT LIKE 'Comisi%'".
    "       WHERE t.orderid IS NOT NULL ".
    "       AND orders.id = txother.orderid ".
    "       AND t.id = t.txid ".
    "       AND t.dsc NOT LIKE 'Comisi%'".
    "       AND accounts.id = orders.accountid ".
    "       AND accounts.userid = users.id ".
    "       AND usercompanies.usrid = users.id ".
    "       ) num";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    // Retornamos la cantidad de registros que existen
    $out->numofrecords = (int)$row['qty'];
    
    //Consultamos los detalles requeridos
    $sql = "SELECT orders.id AS orderid, ".
    "       orders.quantity AS orderqty, ".
    "       IF(orders.type = 1, orders.side, IF(orders.side = 1, 2, 1)) AS orderside, ".
    "       (SELECT ord.price FROM orders ord ".
    "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS orderprice, ".
    "       orders.type AS ordertype, ".
    "       orders.pairid AS orderpair, ".
    "       orders.total AS ordertotal, ".
    "       t.id AS txid, ".
    "       t.txid AS exchangeid, ".
    "       t.orderid AS txotherorderid, ".
    "       t.datecreated AS datecreated, ".
    "       ABS(IF(orders.side = 2, t.amount, tx.amount)) AS qty, ".
    "       (IF(orders.side = 2, t.amount, tx.amount) * orders.price) AS totally, ".
    "       users.id AS usrid, ".
    "       users.usr AS usr, ".
    "       users.type AS usertype, ".
    "       CONCAT(userpersons.fname,' ', userpersons.sname) AS name, ".
    "       CONCAT(userpersons.flastname, ' ', userpersons.slastname) AS secondname ".
    "       FROM orders, accounts, users, userpersons, transactions t ".
    "           LEFT JOIN transactions tx ".
    "               ON t.orderid = tx.orderid ".
    "               AND t.txid = tx.txid ".
    "               AND tx.amount < 0 ".
    "               AND tx.dsc NOT LIKE 'Comisi%'".
    "           LEFT JOIN transactions txother ".
    "               ON t.orderid != txother.orderid ".
    "               AND t.txid = txother.txid ".
    "               AND txother.amount > 0 ".
    "               AND txother.dsc NOT LIKE 'Comisi%'".
    "       WHERE t.orderid IS NOT NULL ".
    "       AND orders.id = txother.orderid ".
    "       AND t.id = t.txid ".
    "       AND t.dsc NOT LIKE 'Comisi%'".
    "       AND accounts.id = orders.accountid ".
    "       AND accounts.userid = users.id ".
    "       AND userpersons.usrid = users.id ".
    "       GROUP BY t.txid".
    "".
    "           UNION ALL ".
    "".
    "       SELECT orders.id AS orderid, ".
    "       orders.quantity AS orderqty, ".
    "       IF(orders.type = 1, orders.side, IF(orders.side = 1, 2, 1)) AS orderside, ".
    "       (SELECT ord.price FROM orders ord ".
    "       WHERE ord.type = 2 AND (ord.id = t.orderid OR ord.id = txother.orderid)) AS orderprice, ".
    "       orders.type AS ordertype, ".
    "       orders.pairid AS orderpair, ".
    "       orders.total AS ordertotal, ".
    "       t.id AS txid, ".
    "       t.txid AS exchangeid, ".
    "       t.orderid AS txotherorderid, ".
    "       t.datecreated AS datecreated, ".
    "       ABS(IF(orders.side = 2, t.amount, tx.amount)) AS qty, ".
    "       (IF(orders.side = 2, t.amount, tx.amount) * orders.price) AS totally, ".
    "       users.id AS usrid, ".
    "       users.usr AS usr, ".
    "       users.type AS usertype, ".
    "       usercompanies.name AS name, ".
    "       usercompanies.comercialname AS secondname ".
    "       FROM orders, accounts, users, usercompanies, transactions t ".
    "           LEFT JOIN transactions tx ".
    "               ON t.orderid = tx.orderid ".
    "               AND t.txid = tx.txid ".
    "               AND tx.amount < 0 ".
    "               AND tx.dsc NOT LIKE 'Comisi%'".
    "           LEFT JOIN transactions txother ".
    "               ON t.orderid != txother.orderid ".
    "               AND t.txid = txother.txid ".
    "               AND txother.amount > 0 ".
    "               AND txother.dsc NOT LIKE 'Comisi%'".
    "       WHERE t.orderid IS NOT NULL ".
    "       AND orders.id = txother.orderid ".
    "       AND t.id = t.txid ".
    "       AND t.dsc NOT LIKE 'Comisi%'".
    "       AND accounts.id = orders.accountid ".
    "       AND accounts.userid = users.id ".
    "       AND usercompanies.usrid = users.id ".
    "       GROUP BY t.txid".
    "       LIMIT ".$offset.", ".$numofrecords;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row['exchangeid'];
            
        $record->date = new stdClass();
        $record->date->cannonical = date("Y-m-d H:i:s", strtotime($row['datecreated']));
        $record->date->formatted = date("d/m/Y H:i", strtotime($row['datecreated']));
            
        $record->orderbuy = $row['ordertype'] == 1 && $row['orderside'] == 1 ? (int)$row['orderid'] : (int)$row['txotherorderid'];
        $record->ordersell = $row['orderid'] != $record->orderbuy ? (int)$row['orderid'] : (int)$row['txotherorderid'];
            
        $record->side = new stdClass();
        $record->side->id = (int)$row['orderside'];
        $record->side->dsc = $record->side->id == 1 ? 'Venta' : 'Compra';
        
        //Consultamos el nombre de la moneda ref
        $sql = "SELECT currencies.symbol AS symbol ".
        "       FROM currencies, pairs ".
        "       WHERE pairs.id = ".$row["orderpair"].
        "       AND pairs.refcurrencyid = currencies.id ".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $refcurrency = $res->fetch_assoc();
    
        //Consultamos el nombre de la moneda base
        $sql = "SELECT currencies.symbol AS symbol ".
        "       FROM currencies, pairs ".
        "       WHERE pairs.id = ".$row['orderpair'].
        "       AND pairs.currencyid = currencies.id ".
        "       LIMIT 1";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $currency = $res->fetch_assoc();
        
        //Obtenemos los datos del par para obtener los decimales base
        $sql = "SELECT pairs.refcurrencyid AS pairscurrency, ".
        "       currencies.decimals AS currencydecimals ".
        "       FROM pairs, currencies ".
        "       WHERE pairs.id AND".
        "       pairs.status = 1 AND ".
        "       pairs.id = ".$row['orderpair']." AND ".
        "       currencies.id = pairs.currencyid ".
        "       GROUP BY pairs.id";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $currencydata = $res->fetch_assoc();
        
        //Obtenemos los datos del par para obtener los decimales ref
        $sql = "SELECT pairs.refcurrencyid AS pairscurrency, ".
        "       currencies.decimals AS currencydecimals ".
        "       FROM pairs, currencies ".
        "       WHERE pairs.id AND".
        "       pairs.status = 1 AND ".
        "       pairs.id = ".$row['orderpair']." AND ".
        "       currencies.id = pairs.refcurrencyid ".
        "       GROUP BY pairs.id";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $refcurrencydata = $res->fetch_assoc();
        
        $record->price = new stdClass();
        $record->price->number = (float)$row['orderprice'];
        $record->price->formatted = number_format($record->price->number,$currencydata['currencydecimals'],",",".");
        
        $record->qty = new stdClass();
        $record->qty->number = (float)abs($row['qty']);
        $record->qty->formatted = number_format($record->qty->number,$refcurrencydata['currencydecimals'],",",".");
        
        //$record->testing = $row;
        $record->total = new stdClass();
        $record->total->number = (float) $record->qty->number * $record->price->number;
        $record->total->formatted = number_format($record->total->number,$currencydata['currencydecimals'],",",".");
        
        $exchanges [] = $record;
    }
        
    $out->records = $exchanges;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
