<?php
// api/orders/list

    header("Content-Type:application/json");
    header('Access-Control-Allow-Origin: *');
    header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    if (isset($_SERVER['HTTP_TOKENID']) && $_SERVER['HTTP_TOKENID'] == '')
        badEnd("400", array("msg"=>"Parametros obligatorios tokenid"));
    
    // parametros obligatorios
    $parmsob = array('offset','numofrec','type','parid');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass();
    // Obtener sessionid
    $sessionid = $_SERVER['HTTP_TOKENID'];
    $offset = $_GET['offset'];
    $numofrecords = $_GET['numofrec'];
    $pairid = ' AND o.pairid = '.$_GET['parid'];
    //Compra = 1 | Venta = 2
    $type = ' AND o.side = '.$_GET['type'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidAPI($db, $sessionid);
    
    //Consultamos la cantidad de ordenes
    $sql = "SELECT COUNT(o.id) AS qty".
    "       FROM orders o, accounts, users ".
    "           LEFT JOIN userpersons ON userpersons.usrid = users.id ".
    "           LEFT JOIN usercompanies ON usercompanies.usrid = users.id".
    "       WHERE o.accountid = accounts.id ".
    "       AND accounts.userid = users.id ".
    "       ".$type.
    "       ".$pairid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    // Retornamos el total de ordenes
    $out->numofrecords = (int)$row['qty'];
    
    //Consultamos los datos de las ordenes
    $sql = "SELECT o.id AS orderid, ".
    "       o.date AS createddate, ".
    "       o.side AS orderside, ".
    "       o.type AS ordertype, ".
    "       o.quantity AS orderqty, ".
    "       o.price AS orderprice, ".
    "       o.total AS ordertotal, ".
    "       pairs.id AS pairid, ". 
    "       pairs.currencyid AS paircurrency, ".
    "       pairs.refcurrencyid AS pairrefcurrency, ".
    "       IF( ".
    "           (SELECT SUM(ABS(transactions.amount)) ".
    "               FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND orders.id = o.id ".
    "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, ".
    "           (SELECT SUM(ABS(transactions.amount)) ".
    "               FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND orders.id = o.id ".
    "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), ".
    "           0 ".
    "       ) AS totallyfilled, ".
    "       CASE ".
    "           WHEN o.canceled IS NOT NULL THEN -1 ".
    "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
    "                  FROM transactions, orders ".
    "                  WHERE orders.id = transactions.orderid ".
    "                   AND orders.id = o.id ".
    "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity ".
    "                   AND o.canceled IS NULL THEN 1 ".
    "           ELSE 0 ".
    "       END AS statusorder, ".
    "       users.id AS usrid, ".
    "       users.usr AS usr, ".
    "       users.type AS usrtype, ".
    "       usercompanies.name AS name, ".
    "       usercompanies.comercialname AS secondname ".
    "       FROM orders o, users, accounts, usercompanies, pairs ".
    "       WHERE o.accountid = accounts.id ".
    "       AND accounts.userid = users.id ".
    "       AND pairs.id = o.pairid ".
    "       AND usercompanies.usrid = users.id ".
    "       ".$type.
    "       ".$pairid.
    "       UNION ALL ".
    "       SELECT o.id AS orderid, ".
    "       o.date AS createddate, ".
    "       o.side AS orderside, ".
    "       o.type AS ordertype, ".
    "       o.quantity AS orderqty, ".
    "       o.price AS orderprice, ".
    "       o.total AS ordertotal, ".
    "       pairs.id AS pairid, ". 
    "       pairs.currencyid AS paircurrency, ".
    "       pairs.refcurrencyid AS pairrefcurrency, ".
    "       IF( ".
    "           (SELECT SUM(ABS(transactions.amount)) ".
    "               FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND orders.id = o.id ".
    "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) IS NOT NULL, ".
    "           (SELECT SUM(ABS(transactions.amount)) ".
    "               FROM transactions, orders ".
    "               WHERE orders.id = transactions.orderid ".
    "               AND orders.id = o.id ".
    "               AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "               AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)), ".
    "           0 ".
    "       ) AS totallyfilled, ".
    "       CASE ".
    "           WHEN o.canceled IS NOT NULL THEN -1 ".
    "           WHEN (SELECT SUM(ABS(transactions.amount)) ".
    "                  FROM transactions, orders ".
    "                  WHERE orders.id = transactions.orderid ".
    "                  AND orders.id = o.id ".
    "                   AND IF(o.side = 2, transactions.amount > 0, transactions.amount < 0) ".
    "                   AND transactions.accountid = (CASE WHEN o.side = 1 THEN o.accountid ELSE o.paymentid END)) >= o.quantity".
    "                   AND o.canceled IS NULL THEN 1 ".
    "           ELSE 0 ".
    "       END AS statusorder, ".
    "       users.id AS usrid, ".
    "       users.usr AS usr, ".
    "       users.type AS usrtype, ".
    "       CONCAT(userpersons.fname,' ', userpersons.sname) AS name, ".
    "       CONCAT(userpersons.flastname, ' ', userpersons.slastname) AS secondname ".
    "       FROM orders o, users, accounts, userpersons, pairs ".
    "       WHERE o.accountid = accounts.id ".
    "       AND accounts.userid = users.id ".
    "       AND pairs.id = o.pairid ".
    "       AND userpersons.usrid = users.id ".
    "       ".$type.
    "       ".$pairid.
    "       LIMIT ".$offset.", ".$numofrecords;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = (int)$row['orderid'];
        $record->status = (int)$row['statusorder'];
        
        $record->datecreated = new stdClass();
        $record->datecreated->date = date("Y-m-d H:i:s", strtotime($row["createddate"]));
        $record->datecreated->formatted = date("d/m/Y - h:i a", strtotime($row["createddate"]));
        
        //Consultamos el nombre de la moneda ref
        $sql = "SELECT id, name, symbol, decimals FROM currencies WHERE id = ".$row["pairrefcurrency"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $refcurrency = $res->fetch_assoc();
        
        // Moneda referencial
        $record->refcurrency = new stdClass();
        $record->refcurrency->id = (int)$refcurrency['id'];
        $record->refcurrency->dsc = $refcurrency['name'];
        $record->refcurrency->symbol = $refcurrency['symbol'];
        
        //Consultamos el nombre de la moneda base
        $sql = "SELECT id, name, symbol, decimals FROM currencies WHERE id = ".$row["paircurrency"];
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $currency = $res->fetch_assoc();
        
        // Moneda base
        $record->basecurrency = new stdClass();
        $record->basecurrency->id = (int)$currency['id'];
        $record->basecurrency->dsc = $currency['name'];
        $record->basecurrency->symbol = $currency['symbol'];
        
        //Ordenamos el side
        $record->side = new stdClass();
        $record->side->id = (int)$row['orderside'];
        $record->side->dsc = $record->side->id == 1 ? 'Venta' : 'Compra' ;
        
        //Ordenamos el type
        $record->type = new stdClass();
        $record->type->id = (int)$row['ordertype'];
        $record->type->dsc = $record->type->id == 1 ? 'Market' : 'Limit' ;
        
        //Ordenamos los datos del usuario
        $record->user = new stdClass();
        $record->user->id = (int)$row['usrid'];
        
        if($row['usrtype'] == 2){
            $record->user->name = $row['name'].($row['secondname'] == '' ? '' : ' / '.$row['secondname']);
        }else{
            $record->user->name = $row['name'].($row['secondname'] == '' ? '' : ' '.$row['secondname']);
        }
        
        $record->user->usr = $row['usr'];
        
        //Ordenamos el porcentaje
        $record->filled = new stdClass();
        
        if($row['orderqty'] != 0){
            $record->filled->number = ($row['totallyfilled']*100)/$row['orderqty'];                
        }
        
        $record->filled->formatted = numberFormatt($record->filled->number, 2).'%';
        
        //Ordenamos el precio de la orden
        $record->price = new stdClass();
        $record->price->number = (float)$row['orderprice']; 
        $record->price->formatted = numberFormatt($record->price->number, $currency['decimals']);
        
        //Ordenamos la cantidad
        $record->quantity = new stdClass();
        $record->quantity->number =(float)$row['orderqty'];
        $record->quantity->formatted = numberFormatt($record->quantity->number, $refcurrency['decimals']);
        
        //Ordenamos el total
        $record->total = new stdClass();
        $record->total->number = (float)$row['ordertotal'];
        $record->total->formatted = numberFormatt($record->total->number, $currency['decimals']);
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
