<?php
// app/api/transactions/validation

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    require '../../hooks/PHPMailer5/PHPMailerAutoload.php';
    date_default_timezone_set('Etc/UTC');
    
    // parametros obligatorios
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos la session
    isSessionValid($db, $sessionid);
    
    //Obtenemos el lenguaje del usuario
    $lang = updateLang($db,$sessionid);
    
    //Validamos que exista el registro
    $sql = "SELECT t.id AS id, CASE ".
    "           WHEN t.dsc LIKE '%comis%' THEN 'Comisi��n' ".
    "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 1 THEN 'Ajuste' ".
    "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 8 THEN 'Intercambio' ".
    "           WHEN (SELECT COUNT(de.transactionid) FROM deposits de WHERE de.transactionid = t.txid) = 1 THEN 'Depósito' ".
    "           WHEN (SELECT COUNT(withdraw.transactionid) FROM withdrawals withdraw WHERE withdraw.transactionid = t.txid) = 1 THEN 'Retiro' ".
    "           WHEN (SELECT COUNT(tx.id) FROM transactions tx WHERE tx.txid = t.txid) = 4 THEN 'Transferencia' END AS type ".
    "       FROM transactions t WHERE t.id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 404 cuando la busqueda no obtiene resutados
    if($row["id"] == null){
        badEnd("404", array("msg"=>determinateMsgFail(array(
            "esp"=>"No se encuentra el registro",
            "eng"=>"Cannot find the record"), $lang, "No se encuentra el registro")));
    }
    
    //Creamos el validador
    $validator = getValidator(8);
    
    //Actualizamos el validator
    $sql = "UPDATE transactions SET".
    "       validthru = DATE_ADD(NOW(), INTERVAL 10 MINUTE), ".
    "       validator = ".$validator.
    "       WHERE txid = ".$id;
    if (!$db->query($sql)){
        badEnd("500", array("msg"=>$db->error));
    }
    
    //Retornamos 304 si no se elimino ningun registro
    if ($db->affected_rows == 0){
        badEnd("403", array("msg"=>determinateMsgFail(array(
            "esp"=>"No se pudo modificar",
            "eng"=>"Cannot modify"), $lang, "No se pudo modificar")));
    }
    
    $out->id = (int)$id;
    
    //Obtenemos el correo del usuario para envio de codigo
    $sql = "SELECT * FROM users WHERE sessionid = '".$sessionid."'";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Guardamos la data de la cuenta
    $userdata = $rs->fetch_assoc();
    
    $email = $userdata["usr"];
    $subject = ($row['type'] == 'Retiro' ? ($userdata['lang'] == 'esp' ? "Código de retiro AFX" : 'Withdrawal code AFX') : ($userdata['lang'] == 'esp' ? "Código de Transferencia AFX" : 'Transfer Code AFX'));
    $subject = '=?UTF-8?B?'.base64_encode($subject).'?=';
    $body = "<html>".
            "   <head>".
            "       <title></title>".
            "       <link href='https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;700&display=swap' rel='stylesheet'>".
            "       <link href='https://fonts.googleapis.com/css2?family=Roboto&display=swap' rel='stylesheet'>".
            "       <style>".
            "           .goodText {".
            "               font-family: 'Open Sans', sans-serif;".
            "           }".
            "           .code {".
            "               font-family: Helvetica, sans-serif".
            "           }".
            "           .copy {".
            "               font-family: 'Roboto', sans-serif;".
            "               font-weight: 400;".
            "               font-size: 12px;".
            "           }".
            "       </style>".
            "   </head>".
            "   <body>".
            "       <div style='background-color: #F8F8FA;padding: 20px;'>".
            "           <img style='margin: auto; display: block;margin-bottom:10px;' width='110' height='110' src='".$homeurl."/img/afx-logo-email.png'/>".
            "           <div style='margin: auto; display: block;background-color: #FFF;border-radius: 22px;width: 60%;padding:30px;'>".
            "               <img style='margin: auto; display: block;margin-bottom:20px;' width='160' height='130' src='".$homeurl."/img/img_transfer.png'/>".
            "               <h1 class='goodText' style='color:#474C58;text-align:center;font-size: 20px;font-weight: bold;'>".($userdata['lang'] == "esp" ? "Hola" : "Hello")." ".strtolower($email)."</h1>".
            "               <p class='goodText' style='font-size: 18px;color: #474C58;text-align:center;margin-bottom:30px;margin-left:20px;margin-right:20px;'>".($userdata['lang'] == "esp" ? "Para completar ".($row['type'] == 'Retiro' ? 'el retiro' : 'la transferencia')." de fondos ingrese el c&oacute;digo a continuaci&oacute;n" : 
                                "To complete the ".($row['type'] == 'Retiro' ? 'withdrawal' : 'transfer')." of funds enter the code below")."</p>".
            "               <div style='margin: auto; display: block;background-color: #4287CE;border-radius: 8px;width: 200px; height: 57px;text-align:center;'>".
            "                   <p style='margin: auto; display: block;color: #FFF;font-size: 18px;text-align:center;line-height: 58px;font-weight:bold;letter-spacing: 10px;'>".$validator."</p>".
            "               </div>".
            "               <p class='goodText' style='text-align:center;font-size:12px;color: #474C58;'>".($userdata['lang'] == "esp" ? "Este c&oacute;digo expirar&aacute; en 10 minutos" : "This code will expire in 10 minutes").".</p>".
            "           </div>".
            "           <p class='copy' style='margin-top:40px; color: #767E93;text-align:center;'>".$footerEmails."</p>".
            "       </div>".
            "   </body>".
            "</html>";
            
    enviarCorreo2($fromeMail, strtolower($email), $subject, $body);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>