WS_waitscreen = true;

window.onload = function(){
    
    // Go back
    document.getElementById('previous-button').addEventListener("click", function(){
        gotoPage('step','main',"")
    });
    
    // Go step 3
    document.getElementById('next-button').addEventListener("click", function(){
        verifyNextButton()
    });
    
    // Go to messages
    document.getElementById('message').addEventListener("click", function(){
        gotoPage('messages','messages',"")
    });
    
    // Go to messages
    document.getElementById('message').addEventListener("click", function(){
        gotoPage('messages','messages',"")
    });
    
    // Go back R
    document.getElementById('previous-buttonR').addEventListener("click", function(){
        gotoPage('step','main',"")
    });
    
    // Go step 3 R
    document.getElementById('next-buttonR').addEventListener("click", function(){
        verifyNextButton()
    });
    
    // Step
    document.getElementById('floatButton').addEventListener("click",function(){
        var popup = document.getElementById("floatButton").children[0].children[0];
        if(popup.classList.contains('show')){
            gotoPage('dashboard','home',"")
        }else{
            popup.classList.toggle("show");
        }
    })

    document.getElementById('floatClose').addEventListener("click",function(event){
        var popup = document.getElementById("floatButton").children[0].children[0];
        popup.classList.remove("show")
        event.stopPropagation()
    })
    
    // Session Update
    document.getElementById('expSessionButton').addEventListener("click",function(){
        var req = {
            'sessionid': sessionStorage.getItem('sessionid')
        }
        sessionUpdate(req)
    })
    
    // Go to preferences
    document.getElementById('preferences').addEventListener("click", function(){
        gotoPage('preferences','main',"")
    });
    
    // Go to preferences
    document.getElementById('preferencesR').addEventListener("click", function(){
        gotoPage('preferences','main',"")
    });
    
    // Go to balance
    document.getElementById('balance').addEventListener("click", function(){
        gotoPage('balance','balance',"")
    });
    
    // Go to balance
    document.getElementById('balanceR').addEventListener("click", function(){
        gotoPage('balance','balance',"")
    });
    
    document.getElementById('example-element-toggle2').checked = false;
    
    // Bar
    document.getElementById('togglebar').addEventListener("click", function(){
        var el = document.getElementById('addView2')
        document.getElementById('addView2').style.display = 'block'
        setTimeout(function(){ 
            document.getElementById('example-element-toggle2').checked = !document.getElementById('example-element-toggle2').checked;
        }, 15);   
        
    });
    
    // Logout
    document.getElementById('logouticon').addEventListener("click", function(){
        logout();
    });
    
    // Logout
    document.getElementById('logouticon2').addEventListener("click", function(){
        logout();
    });
    
    init();
    
    //Mostrar HTML cargado
    esconderHTML(false);
    
    var waitScreen = document.getElementById("waitScreen");
    document.body.removeChild(waitScreen);
    WS_waitscreen = false;
    document.getElementsByClassName('pageCnt')[0].style.visibility="visible"

    
}

function expiredSession(){
    document.getElementsByClassName('expired')[0].style.display = "table"
    WS_waitscreen = false;
    var seconds = 30;
    var countdown = setInterval(countDown, 1000);
    
    function countDown(){
        seconds--;
        if(seconds == 0){
            if(document.getElementsByClassName('expired')[0].style.display == "table"){
                gotoPage('login','main','');
                clearInterval(countdown);
            }
        }
        if(document.getElementsByClassName('expired')[0].style.display == "none"){
            clearInterval(countdown)
        }
    }
}

function sessionUpdate(req){
    callWS('GET', 'session/update', req, response);
    function response(status, rsp){
        console.log('session/update')
        console.log(JSON.parse(rsp));
        console.log(status) 
        switch(status){
            case 200:
                document.getElementsByClassName('expired')[0].style.display = "none";
                if(document.getElementById('table').children[0].style.display == 'none'){
                    init()
                }
                break;
            case 400:
                break;
            case 401:
                gotoPage('login','main','');
                break;
            case 402:
                break;
            case 403:
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

function transactionsCurrencies(req){
    callWS('GET', 'transactions/currencies', req, response);
    function response(status, rsp){
        console.log('transactions/currencies')
        console.log(JSON.parse(rsp));
        console.log(status) 
        switch(status){
            case 200:
                loaadCryptocurrencies(JSON.parse(rsp))
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 402:
                break;
            case 403:
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

function accountsPortfolio(req){
    callWS('GET', 'accounts/portfolio', req, response);
    function response(status, rsp){
        console.log('accounts/portfolio')
        console.log(JSON.parse(rsp));
        console.log(status) 
        switch(status){
            case 200:
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 402:
                break;
            case 403:
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

function init(){
    setLang()
}

function getEntry(sessionid){
    callWS("GET", "users/entry", { 'sessionid' : sessionid}, response);
        
    function response(status, rsp){
        switch(status){
            case 200:
                if(JSON.parse(rsp).notifications > 0){
                    document.getElementById('messageNotification').style.display = "table"
                    document.getElementById('messageNotification').children[0].innerHTML = JSON.parse(rsp).notifications
                }else{
                    document.getElementById('messageNotification').style.display = "none"
                    document.getElementById('messageNotification').children[0].innerHTML = ""
                }
                entrydata = (JSON.parse(rsp).entry)
                putName(entrydata);
                var req = {
                    'sessionid': sessionStorage.getItem('sessionid')
                }
                transactionsCurrencies(req)
                break;
            case 204:
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                break;
            default:
                break;
        }
    }    
}

function putName(entrydata){
    var name;
    if(entrydata.company){
        if(entrydata.company.name.value=="" || entrydata.company.name.value== null){
            name = entrydata.usr
        }else{
            name = entrydata.company.name.value
        }
    }
    else if(entrydata.person){
        if(entrydata.person.firstname.value=="" || entrydata.person.firstname.value==null){
            name = entrydata.usr
        }else{
            name = entrydata.person.firstname.value + ' '+ entrydata.person.firstlastname.value
        }
    }
    document.getElementById('name').innerHTML = name
    document.getElementById('name2').innerHTML = name
}


function loaadCryptocurrencies(list){
    var tbl;
    var node;
    tbl = document.getElementById('table');
    var node = tbl.children[0].cloneNode(true);
    tbl.innerHTML = "";
    var tmp = null; tmp = node.cloneNode(true);
    if(list.numofrecords == 0){
        var ele = null;
        ele = tmp.cloneNode(true);
        ele.style.display = "none";
        tbl.appendChild(ele);
    }else{
        for (var i = 0; i < list.records.length; i++){
            if(list.records[i].interface == 4 || list.records[i].interface == 5){
                var ele = null;
                ele = tmp.cloneNode(true);
                ele.style.display = "table";
                ele.children[0].children[0].innerHTML = list.records[i].name
                ele.children[1].children[0].children[0].innerHTML = lang == "esp" ? "SELECCIONAR" : "SELECT"
                ele.children[1].children[0].children[0].setAttribute('idC',list.records[i].id)
                
                if(tbl.children.length % 2 == 0){
                    ele.classList.add('oddRow')
                }
                tbl.appendChild(ele);
                        
            }
        }
        buttonsEffect()
    }
}

function buttonsEffect(){
    var buttons = document.getElementsByClassName('crypto');  
    for (i = 0; i < buttons.length; i++) {
        buttons[i].addEventListener("click", function(evt){
            document.getElementById('error').style.display = 'none'
            var buttons = document.getElementsByClassName('crypto'); 
            for (i = 0; i < buttons.length; i++){
                buttons[i].classList.remove('blueButton')
                buttons[i].classList.add('whiteButton')
                buttons[i].classList.remove('accept-button')
                buttons[i].classList.add('cancel-button')
                buttons[i].classList.remove('selectCrypto')
            }
            evt.srcElement.classList.add('blueButton')
            evt.srcElement.classList.remove('whiteButton')
            evt.srcElement.classList.add('accept-button')
            evt.srcElement.classList.remove('cancel-button')
            evt.srcElement.classList.add('selectCrypto')
        });
    }
}

function verifyNextButton(){
    if(document.getElementsByClassName('selectCrypto').length == 0){
        document.getElementById('error').innerHTML = lang == "esp" ? 'Seleccione una criptomoneda.' : "Select a cryptocurrency."
        document.getElementById('error').style.display = 'block'
    }else{
        gotoPage('step','buyCryptoCur',{ 'cid' : document.getElementsByClassName('selectCrypto')[0].getAttribute('idC') })       
    }
}

function logout(){
    var sessionid = sessionStorage.getItem('sessionid')
    var req ={
        'sessionid': sessionid,
    }
    callWS('GET', 'login/logout', req, response);

    function response(status, rsp){
        console.log(JSON.parse(rsp));
        console.log(status)
        switch(status){
            case 200:
                sessionStorage.removeItem('sessionid')
                gotoPage('login','main','')
                break;
            case 400:
                break;
            case 401:
                expiredSession();
                break;
            case 500:
                break;
            default:
                break;
        }
    }   
}

function setLang(){
    
    addFooter()
    
    lang = localStorage.getItem('lang');
    
    /* inner HTML */
    setWordLanginnerHTML('home','home');
    setWordLanginnerHTML('balance','balance');
    setWordLanginnerHTML('preferences','preferences');
    setWordLanginnerHTML('homeR','home');
    setWordLanginnerHTML('balanceR','balance');
    setWordLanginnerHTML('preferencesR','preferences');
    setWordLanginnerHTML('langIcon','langIcon');
    
    
    setWordLanginnerHTML('titlePage','titlePage');
    setWordLanginnerHTML('step1','step1');
    setWordLanginnerHTML('step2','step2');
    setWordLanginnerHTML('step3','step3');
    setWordLanginnerHTML('step4','step4');
    setWordLanginnerHTML('step5','step5');
    setWordLanginnerHTML('t1','t1');
    setWordLanginnerHTML('t2','t2');
    setWordLanginnerHTML('t3','t3');
    
    setWordLanginnerHTML('previous-button','RETURN');
    setWordLanginnerHTML('next-button','continue');
    setWordLanginnerHTML('previous-buttonR','RETURN');
    setWordLanginnerHTML('next-buttonR','continue');
    
    
    setWordLanginnerHTML('buttonAdv','ADVANCEDMODE');
    setWordLanginnerHTML('question','question');
    setWordLanginnerHTML('expired1','expired1');
    setWordLanginnerHTML('expired2','expired2');
    setWordLanginnerHTML('expSessionButton','continue');
    setWordLanginnerHTML('ts','ts');

    
    document.getElementById('floatClose').addEventListener("click",function(event){
        var popup = document.getElementById("floatButton").children[0].children[0];
        popup.classList.remove("show")
        event.stopPropagation()
    })
    
    getEntry(sessionStorage.getItem('sessionid'));

}
