<?php
// cms/api/privileges/loadrolprivileges

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid","rolid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $rolid = $_GET["rolid"];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que tenga privilegios para ver
    if (!tienePrivilegio($db, $sessionid, 10))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    
    //Consultamos el usuario para validar que existe
    $sql = "SELECT name, type FROM cmsusers WHERE type = 1 AND id = ".$rolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    //Si el dato no existe retornamos 204
    if($row["name"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    //Consultamos los registros
    $sql = "SELECT * FROM userprivileges WHERE userid = ".$rolid.
    "       ORDER BY privilegeid";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Ordenamos los resultados
    while($row = $rs->fetch_assoc()){
        $privilege = new stdClass();
        $privilege->id = (int)$row["privilegeid"];
        
        
        //Consultamos los detalles del privilegio
        $sql = "SELECT * FROM privileges WHERE id = ".$privilege->id;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $rowprivi = $res->fetch_assoc();
        
        $privilege->grp = ucfirst(strtolower($rowprivi["grp"]));
        $privilege->dsc = $rowprivi["dsc"];
        
        $privileges [] = $privilege;
    }
            
    $out->usrid = (int)$rolid;
    
    $out->privileges = $privileges;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
