<?php
// cms/api/users/delete

    header("Content-Type:application/json");
    include("../../../settings/dbconn.php");
    include("../../../settings/utils.php");
    
    // parametros obligatorios 
    $parmsob = array("sessionid","id");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET["id"];
    
    //Validamos que la session del usuario sea valida para continuar
    $currentid = isSessionValidCMS($db, $sessionid);
    
    //Validamos que tenga privilegios para eliminar
    if (!tienePrivilegio($db, $sessionid, 17))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    if($currentid == $id){
        badEnd("400", array("msg"=>"El usuario no puede ser eliminado"));
    }
    //Validamos que exista el registro
    $sql = "SELECT id, usr, name, status FROM cmsusers WHERE id = ".$id." AND type = 0";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
            
    $row = $rs->fetch_assoc();
        
    // Retornamos 204 cuando la busqueda no obtiene resutados
    if($row["name"] == null){
        badEnd("204", array("msg"=>"No se encuentra el registro"));
    }
    
    $sql = "DELETE FROM cmsusers WHERE id = ".$id." AND type = 0";
    if (!$db->query($sql)){
        if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar este Usuario"));
        else
            badEnd("500",array("msg"=>$db->error));
    }
        
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>"No se pudo modificar"));
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "USUARIOS", $sessionid, "CMS", "Se eliminó el usuario ".$row["name"]);
        
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
