<?php 
    //cms/api/ocupations/entry

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id'); 
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    
    //Validamos la session
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 65))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Consultamos que el registro exista
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM ocupations ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    //Si la cantidad es igual a 0, no existe
    if($row['qty'] == 0){
        badEnd('204',array('msg'=>'No se encuentra el registro'));
    }
    
    // Consultamos los detalles de los registros
    $sql = "SELECT * FROM ocupations ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $row = $rs->fetch_assoc();
    $out->entry = new stdClass();
    
    $out->entry->id = (int)$row['id'];
    $out->entry->dsc = $row['dsc'];
    
    //Privilegios del usuario actual CMS
    $access = new stdClass;
    $access->read = tienePrivilegio($db, $sessionid, 65);
    $access->update = tienePrivilegio($db, $sessionid, 63);
    $access->delete = tienePrivilegio($db, $sessionid, 64);
    $access->create = tienePrivilegio($db, $sessionid, 62);
    $out->privileges = $access;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>