<?php
// app/api/login/login.php

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("usr","pwd",'lang');
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    $out= new stdClass;
    $usr = strtoupper($_GET["usr"]);
    $pwd = $_GET["pwd"];
    $lang = $_GET['lang'];
    
    $sessid = randomString(32);
    
    //Primero validamos que el usuario exista
    $sql = "SELECT id, pwd FROM users".
    "       WHERE  UPPER(usr)=UPPER('".$usr."') ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    if($row["id"] == null){
        badEnd("404", array("msg"=>determinateMsgFail(array(
            "esp"=>"Usuario no existe",
            "eng"=>"User doesn't exist"), $lang, "Usuario no existe")));
    }
    
    // Validamos que su pwd no sea null
    if($row['pwd'] == null){
        badEnd('405', array("msg"=>determinateMsgFail(array(
            "esp"=>"Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave",
            "eng"=>"Your password has expired, please go through the password recovery process"), $lang, "Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave")));
    }
    
    // SI todo es exacto, validamos que exista
    $sql = "SELECT COUNT(id) AS qty FROM users ".
    "       WHERE  UPPER(usr)=UPPER('".$usr."') ".
    "       AND    pwd='".$pwd."' " .
    "       AND    status<>0";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    if ($row['qty'] == 0){
        // se incrementa los reintentos y se desactiva la cuenta en caso de llegar al maxfails
        $sql =  "UPDATE users " .
                "       SET fails = " .
                "               CASE WHEN fails < maxfails THEN ".
                "                   fails + 1 ".
                "               ELSE ".
                "                   fails ".
                "               END, ".
                "           status = ".
                "               CASE WHEN fails >= maxfails THEN ".
                "                   0 ".
                "               ELSE ".
                "                   status ".
                "               END, ".
                "           blockedthru = ".
                "               CASE WHEN fails >= maxfails THEN ".
                "                   NOW() ".
                "               ELSE ".
                "                   null ".
                "               END ".
                "   WHERE  UPPER(usr)=UPPER('".$usr."') ".
                "   AND    fails < maxfails";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $sql = "SELECT status FROM users WHERE UPPER(usr)=UPPER('".$usr."') ";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $row = $rs->fetch_assoc();
        
        if($row["status"] == "0")
            badEnd("402",array("msg"=>determinateMsgFail(array(
            "esp"=>"Usuario bloqueado",
            "eng"=>"User blocked"), $lang, "Usuario bloqueado")));
            
        if($row["status"] == null){
            badEnd("404", array("msg"=>determinateMsgFail(array(
            "esp"=>"Usuario no existe",
            "eng"=>"User doesn't exist"), $lang, "Usuario no existe")));
        }else{
            badEnd("401", array("msg"=>determinateMsgFail(array(
            "esp"=>"Usuario/Clave Inválidos",
            "eng"=>"Invalid Username / Password"), $lang, "Usuario/Clave Inválidos")));
        }
    }
    
    //Validamos si el usuario tiene una session activa o no
    $sql = "SELECT id, sessionexpires, ".
    "       IF(sessionid IS NOT NULL, 1, 0) AS isSessionActive, ".
    "       IF(sessionexpires < NOW() OR sessionexpires IS NULL, 1, 0) AS isSessionExpiry ".
    "       FROM users ".
    "       WHERE  UPPER(usr)=UPPER('".$usr."') ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    //Si la fecha de expiracion es mayor a la actual y es nula, existe otra session activa
    if($row["isSessionActive"] == 1 && $row["isSessionExpiry"] == 0){
        // Colocamos para que la session expire y pueda loguearse
        if($row["sessionexpires"] != null){
            $sql =  "UPDATE users " .
            "SET    sessionexpires = DATE_ADD(NOW(), INTERVAL 3 MINUTE) ".
            "WHERE  UPPER(usr)=UPPER('".$usr."') ".
            "       AND sessionexpires > DATE_ADD(NOW(), INTERVAL 5 MINUTE)";
            if (!$db->query($sql)){
                badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
            }
        }
        
        badEnd("403", array("msg"=>determinateMsgFail(array(
            "esp"=>"Hemos detectado que exíste otra conexión activa en este momento y por su seguridad no podemos permitir el ingreso. Le recordamos que solo puede mantener una sesión activa con su usuario de AFX, intente nuevamente en 3 minutos",
            "eng"=>"We have detected that there is another active connection at this time and for your security we cannot allow the entry. We remind you that you can only maintain an active session with your AFX user, try again in 3 minutes"), $lang, "Hemos detectado que exíste otra conexión activa en este momento y por su seguridad no podemos permitir el ingreso. Le recordamos que solo puede mantener una sesión activa con su usuario de AFX, intente nuevamente en 3 minutos")));
    }
    
    
    //Validamos que la pwd no este vencida
    $sql = "SELECT IF(pwdexpiration IS NULL OR pwdexpiration < NOW(), 1, 0) AS pwdExpirated FROM users ".
    "       WHERE UPPER(usr)=UPPER('".$usr."') ".
    "       AND pwd='".$pwd."' " .
    "       AND status<>0";
    if (!$rs = $db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    $row = $rs->fetch_assoc();
    
    if($row['pwdExpirated'] == 1){
        badEnd('405', array("msg"=>determinateMsgFail(array(
            "esp"=>"Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave",
            "eng"=>"Your password has expired, please go through the password recovery process"), $lang, "Su contraseña se encuentra vencida, por favor realice el proceso de recuperación de clave")));
    }
    
    
    // destruir cualquier session anterior existente
    $sql =  "UPDATE users " .
            "SET    sessionid = '" . $sessid . "', ".
            "       validthru = DATE_ADD(NOW(), INTERVAL 1 DAY),".
            "       lastsession =  NOW(),".
            "       lang = '".$lang."', ".
            "       fails = 0, ".
            "       sessionexpires = DATE_ADD(NOW(), INTERVAL 15 MINUTE) ".
            "WHERE  UPPER(usr)=UPPER('".$usr."') ".
            "AND    pwd='".$pwd."' " .
            "AND    status<>0";
    if (!$db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
        
    $sql =  "SELECT  id, sessionid,  DATE_FORMAT(validthru, '%Y%m%d%H%i%s') vt, usr ".
            "FROM    users ".
            "WHERE   UPPER(usr)='".$usr."' ".
           "AND     pwd='".$pwd."'";
    if (!$rs = $db->query($sql)){
        badEnd("500", array("sql"=>$sql,"msg"=>$db->error));
    }
    
    $row = $rs->fetch_assoc();
    
    $out->id =(int)$row["id"];
    $out->sessionid = $row["sessionid"];
    $out->validthru = $row["vt"];
    $out->name = $row["usr"];
 
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
