<?php
// cms/api/economicact/delete

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    //Declaramos e inicializamos nuestras variables
    $out= new stdClass;
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    
    //Validamos que la session del usuario sea valida para continuar
    isSessionValidCMS($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 68))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
        
    // Consultamos la cantidad registros
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM economicactivities ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    // Si es 0, no se encontro registro
    if($row['qty'] == 0){
        badEnd('204',array('msg'=>'Registro no encontrado'));
    }
    
    // Obtenemos el nombre para la auditoria
    $sql = "SELECT * FROM economicactivities WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    $row = $rs->fetch_assoc();
    
    // Eliminamos el registro
    // Eliminamos la ocupacion    
    $sql = "DELETE FROM economicactivities WHERE id = ".$id;
    if (!$db->query($sql)){
        if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar esta Actividad económica"));
        else
            badEnd("500",array("msg"=>$db->error));
    }
        
    //Retornamos 304 si no se actualizo ningun registro
    if ($db->affected_rows == 0)
        badEnd("304", array("msg"=>"No se pudo modificar"));
    
    $out->id = (int)$id;
    
    //auditoria
    setAudit($db, "ACT. ECONÓMICAS", $sessionid, "CMS", "Se eliminó la actividad económica ".$row['dsc']);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>