<?php 
    //cms/api/ocupations/update

    header("Content-Type:application/json");
    include("../dbconn.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("sessionid",'id','dsc'); 
    if (!parametrosValidos($_GET, $parmsob)){
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    }
    
    //Declaracion de variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $id = $_GET['id'];
    $dsc = $_GET['dsc'];
    
    //Validamos la session
    isSessionValidCMS($db, $sessionid);
    
    // Si el id es 0, creamos el registro, si no actualizamos
    if($id == 0){
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 62))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        // Validamos que no se inserte la misma actividad'
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM ocupations WHERE dsc = '".$dsc."'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $rs->fetch_assoc();
        //Si la cantidad es igual a 0, no existe
        if($row['qty'] > 0){
            badEnd('402',array('msg'=>'Registro duplicado'));
        }
            
        // Insertamos la ocupacion
        $sql = "INSERT INTO ocupations(dsc) ".
        "       VALUES('".$dsc."')";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $out->id = (int)$db->insert_id;
        
        //auditoria
        setAudit($db, "OCUPACIONES", $sessionid, "CMS", "Se agregó la ocupación ".$dsc);
        
    }else{
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 63))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
            
        // Validamos que no se inserte la misma actividad'
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM ocupations WHERE dsc = '".$dsc."'".
        "       AND id != ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $rs->fetch_assoc();
        //Si la cantidad es igual a 0, no existe
        if($row['qty'] > 0){
            badEnd('402',array('msg'=>'Registro duplicado'));
        }
            
        // Consultamos que el registro exista
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM ocupations ".
        "       WHERE id = ".$id;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $row = $rs->fetch_assoc();
        //Si la cantidad es igual a 0, no existe
        if($row['qty'] == 0){
            badEnd('204',array('msg'=>'No se encuentra el registro'));
        }
        
        // Actualizamos el registro
        $sql = "UPDATE ocupations SET ".
        "       dsc = '".$dsc."' ".
        "       WHERE id = ".$id;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
        
        $out->id = (int)$id;
        
        //auditoria
        setAudit($db, "OCUPACIONES", $sessionid, "CMS", "Se actualizó la ocupación ".$dsc);
        
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>